/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.win32.OS;

public final class Color
extends Resource {
    public int handle;

    Color() {
    }

    public Color(Device device, int n2, int n3, int n4) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, n2, n3, n4);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Color(Device device, RGB rGB) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (rGB == null) {
            SWT.error(4);
        }
        this.init(device, rGB.red, rGB.green, rGB.blue);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        int n2;
        int[] nArray;
        if (this.handle == -1) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        int n3 = this.device.hPalette;
        if (n3 != 0 && (nArray = this.device.colorRefCount)[n2 = OS.GetNearestPaletteIndex(n3, this.handle)] > 0) {
            int n4 = n2;
            nArray[n4] = nArray[n4] - 1;
        }
        this.handle = -1;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Color)) {
            return false;
        }
        Color color = (Color)object;
        return this.device == color.device && (this.handle & 0xFFFFFF) == (color.handle & 0xFFFFFF);
    }

    public int getBlue() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF0000) >> 16;
    }

    public int getGreen() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return (this.handle & 0xFF00) >> 8;
    }

    public int getRed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return this.handle & 0xFF;
    }

    public RGB getRGB() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new RGB(this.handle & 0xFF, (this.handle & 0xFF00) >> 8, (this.handle & 0xFF0000) >> 16);
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int n2, int n3, int n4) {
        if (n2 > 255 || n2 < 0 || n3 > 255 || n3 < 0 || n4 > 255 || n4 < 0) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = n2 & 0xFF | (n3 & 0xFF) << 8 | (n4 & 0xFF) << 16;
        int n5 = device.hPalette;
        if (n5 == 0) {
            return;
        }
        int[] nArray = device.colorRefCount;
        int n6 = OS.GetNearestPaletteIndex(n5, this.handle);
        byte[] byArray = new byte[4];
        OS.GetPaletteEntries(n5, n6, 1, byArray);
        if (byArray[0] == (byte)n2 && byArray[1] == (byte)n3 && byArray[2] == (byte)n4) {
            int n7 = n6;
            nArray[n7] = nArray[n7] + 1;
            return;
        }
        int n8 = 0;
        while (n8 < nArray.length) {
            if (nArray[n8] == 0) {
                n6 = n8;
                break;
            }
            ++n8;
        }
        if (n8 == nArray.length) {
            this.handle = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8 | (byArray[2] & 0xFF) << 16;
        } else {
            byte[] byArray2 = new byte[4];
            byArray2[0] = (byte)(n2 & 0xFF);
            byArray2[1] = (byte)(n3 & 0xFF);
            byArray2[2] = (byte)(n4 & 0xFF);
            byArray = byArray2;
            OS.SetPaletteEntries(n5, n6, 1, byArray);
        }
        int n9 = n6;
        nArray[n9] = nArray[n9] + 1;
    }

    public boolean isDisposed() {
        return this.handle == -1;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Color {*DISPOSED*}";
        }
        return "Color {" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + "}";
    }

    public static Color win32_new(Device device, int n2) {
        if (device == null) {
            device = Device.getDevice();
        }
        Color color = new Color();
        color.handle = n2;
        color.device = device;
        return color;
    }
}

