/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;
import org.eclipse.swt.internal.image.PngChunk;
import org.eclipse.swt.internal.image.PngChunkReader;
import org.eclipse.swt.internal.image.PngDecodingDataStream;
import org.eclipse.swt.internal.image.PngEncoder;
import org.eclipse.swt.internal.image.PngIdatChunk;
import org.eclipse.swt.internal.image.PngIhdrChunk;
import org.eclipse.swt.internal.image.PngInputStream;
import org.eclipse.swt.internal.image.PngPlteChunk;
import org.eclipse.swt.internal.image.PngTrnsChunk;

final class PNGFileFormat
extends FileFormat {
    static final int SIGNATURE_LENGTH = 8;
    static final int PRIME = 65521;
    PngIhdrChunk headerChunk;
    PngPlteChunk paletteChunk;
    ImageData imageData;
    byte[] data;
    byte[] alphaPalette;
    byte headerByte1;
    byte headerByte2;
    int adler;

    PNGFileFormat() {
    }

    void readSignature() throws IOException {
        byte[] byArray = new byte[8];
        this.inputStream.read(byArray);
    }

    ImageData[] loadFromByteStream() {
        try {
            this.readSignature();
            PngChunkReader pngChunkReader = new PngChunkReader(this.inputStream);
            this.headerChunk = pngChunkReader.getIhdrChunk();
            int n2 = this.headerChunk.getWidth();
            int n3 = this.headerChunk.getHeight();
            if (n2 <= 0 || n3 <= 0) {
                SWT.error(40);
            }
            int n4 = this.getAlignedBytesPerRow() * n3;
            this.data = new byte[n4];
            this.imageData = ImageData.internal_new(n2, n3, this.headerChunk.getSwtBitsPerPixel(), new PaletteData(0, 0, 0), 4, this.data, 0, null, null, -1, -1, 5, 0, 0, 0, 0);
            if (this.headerChunk.usesDirectColor()) {
                this.imageData.palette = this.headerChunk.getPaletteData();
            }
            while (pngChunkReader.hasMoreChunks()) {
                this.readNextChunk(pngChunkReader);
            }
            return new ImageData[]{this.imageData};
        }
        catch (IOException iOException) {
            SWT.error(40);
            return null;
        }
    }

    void readNextChunk(PngChunkReader pngChunkReader) throws IOException {
        PngChunk pngChunk = pngChunkReader.readNextChunk();
        switch (pngChunk.getChunkType()) {
            case 3: {
                break;
            }
            case 1: {
                if (this.headerChunk.usesDirectColor()) break;
                this.paletteChunk = (PngPlteChunk)pngChunk;
                this.imageData.palette = this.paletteChunk.getPaletteData();
                break;
            }
            case 5: {
                PngTrnsChunk pngTrnsChunk = (PngTrnsChunk)pngChunk;
                if (pngTrnsChunk.getTransparencyType(this.headerChunk) == 0) {
                    this.imageData.transparentPixel = pngTrnsChunk.getSwtTransparentPixel(this.headerChunk);
                    break;
                }
                this.alphaPalette = pngTrnsChunk.getAlphaValues(this.headerChunk, this.paletteChunk);
                int n2 = 0;
                int n3 = -1;
                int n4 = 0;
                while (n4 < this.alphaPalette.length) {
                    if ((this.alphaPalette[n4] & 0xFF) != 255) {
                        ++n2;
                        n3 = n4;
                    }
                    ++n4;
                }
                if (n2 == 0) {
                    this.alphaPalette = null;
                    break;
                }
                if (n2 != true || this.alphaPalette[n3] != 0) break;
                this.alphaPalette = null;
                this.imageData.transparentPixel = n3;
                break;
            }
            case 2: {
                if (pngChunkReader.readPixelData()) {
                    SWT.error(40);
                    break;
                }
                PngIdatChunk pngIdatChunk = (PngIdatChunk)pngChunk;
                this.readPixelData(pngIdatChunk, pngChunkReader);
                break;
            }
            default: {
                if (!pngChunk.isCritical()) break;
                SWT.error(20);
            }
        }
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        PngEncoder pngEncoder = new PngEncoder(imageLoader);
        pngEncoder.encode(this.outputStream);
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        byte[] byArray;
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    try {
                                        byArray = new byte[8];
                                        lEDataInputStream.read(byArray);
                                        lEDataInputStream.unread(byArray);
                                        if ((byArray[0] & 0xFF) == 137) break block9;
                                        return false;
                                    }
                                    catch (Exception exception) {
                                        return false;
                                    }
                                }
                                if ((byArray[1] & 0xFF) == 80) break block10;
                                return false;
                            }
                            if ((byArray[2] & 0xFF) == 78) break block11;
                            return false;
                        }
                        if ((byArray[3] & 0xFF) == 71) break block12;
                        return false;
                    }
                    if ((byArray[4] & 0xFF) == 13) break block13;
                    return false;
                }
                if ((byArray[5] & 0xFF) == 10) break block14;
                return false;
            }
            if ((byArray[6] & 0xFF) == 26) break block15;
            return false;
        }
        return (byArray[7] & 0xFF) == 10;
    }

    byte[] validateBitDepth(byte[] byArray) {
        if (this.headerChunk.getBitDepth() > 8) {
            byte[] byArray2 = new byte[byArray.length / 2];
            PNGFileFormat.compress16BitDepthTo8BitDepth(byArray, 0, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    void setPixelData(byte[] byArray, ImageData imageData) {
        switch (this.headerChunk.getColorType()) {
            case 4: {
                int n2 = imageData.width;
                int n3 = imageData.height;
                int n4 = imageData.bytesPerLine;
                int n5 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n5 /= 2;
                }
                byte[] byArray2 = new byte[n4 * n3];
                byte[] byArray3 = new byte[n2 * n3];
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = n5 * n6;
                    int n8 = n4 * n6;
                    int n9 = n2 * n6;
                    int n10 = 0;
                    while (n10 < n2) {
                        byte by2 = byArray[n7];
                        byte by3 = byArray[n7 + 1];
                        byArray2[n8 + 0] = by2;
                        byArray2[n8 + 1] = by2;
                        byArray2[n8 + 2] = by2;
                        byArray3[n9] = by3;
                        n7 += 2;
                        n8 += 3;
                        ++n9;
                        ++n10;
                    }
                    ++n6;
                }
                imageData.data = byArray2;
                imageData.alphaData = byArray3;
                break;
            }
            case 6: {
                int n11 = imageData.width;
                int n12 = imageData.height;
                int n13 = imageData.bytesPerLine;
                int n14 = this.getAlignedBytesPerRow();
                if (this.headerChunk.getBitDepth() > 8) {
                    n14 /= 2;
                }
                byte[] byArray4 = new byte[n13 * n12];
                byte[] byArray5 = new byte[n11 * n12];
                int n15 = 0;
                while (n15 < n12) {
                    int n16 = n14 * n15;
                    int n17 = n13 * n15;
                    int n18 = n11 * n15;
                    int n19 = 0;
                    while (n19 < n11) {
                        byArray4[n17 + 0] = byArray[n16 + 0];
                        byArray4[n17 + 1] = byArray[n16 + 1];
                        byArray4[n17 + 2] = byArray[n16 + 2];
                        byArray5[n18] = byArray[n16 + 3];
                        n16 += 4;
                        n17 += 3;
                        ++n18;
                        ++n19;
                    }
                    ++n15;
                }
                imageData.data = byArray4;
                imageData.alphaData = byArray5;
                break;
            }
            case 2: {
                imageData.data = byArray;
                break;
            }
            case 3: {
                imageData.data = byArray;
                if (this.alphaPalette == null) break;
                int n20 = imageData.width * imageData.height;
                byte[] byArray6 = new byte[n20];
                byte[] byArray7 = new byte[n20];
                imageData.getPixels(0, 0, n20, byArray7, 0);
                int n21 = 0;
                while (n21 < byArray7.length) {
                    byArray6[n21] = this.alphaPalette[byArray7[n21] & 0xFF];
                    ++n21;
                }
                imageData.alphaData = byArray6;
                break;
            }
            default: {
                imageData.data = byArray;
            }
        }
    }

    void setImageDataValues(byte[] byArray, ImageData imageData) {
        byte[] byArray2 = this.validateBitDepth(byArray);
        this.setPixelData(byArray2, imageData);
    }

    void readPixelData(PngIdatChunk pngIdatChunk, PngChunkReader pngChunkReader) throws IOException {
        InputStream inputStream = new PngInputStream(pngIdatChunk, pngChunkReader);
        boolean bl2 = System.getProperty("org.eclipse.swt.internal.image.PNGFileFormat_3.2") != null;
        InputStream inputStream2 = bl2 ? null : Compatibility.newInflaterInputStream(inputStream);
        inputStream = inputStream2 != null ? new BufferedInputStream(inputStream2) : new PngDecodingDataStream(inputStream);
        byte by2 = this.headerChunk.getInterlaceMethod();
        if (by2 == 0) {
            this.readNonInterlacedImage(inputStream);
        } else {
            this.readInterlacedImage(inputStream);
        }
        while (inputStream.available() > 0) {
            inputStream.read();
        }
        inputStream.close();
    }

    int getAlignedBytesPerRow() {
        return (this.getBytesPerRow(this.headerChunk.getWidth()) + 3) / 4 * 4;
    }

    int getBytesPerRow() {
        return this.getBytesPerRow(this.headerChunk.getWidth());
    }

    int getBytesPerPixel() {
        int n2 = this.headerChunk.getBitsPerPixel();
        return (n2 + 7) / 8;
    }

    int getBytesPerRow(int n2) {
        int n3 = this.headerChunk.getBitsPerPixel();
        int n4 = n3 * n2;
        int n5 = 8;
        return (n4 + (n5 - 1)) / n5;
    }

    void readInterlaceFrame(InputStream inputStream, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7 = this.headerChunk.getWidth();
        int n8 = this.getAlignedBytesPerRow();
        int n9 = this.headerChunk.getHeight();
        if (n4 >= n9 || n5 >= n7) {
            return;
        }
        int n10 = (n7 - n5 + n3 - 1) / n3;
        int n11 = this.getBytesPerRow(n10);
        byte[] byArray = new byte[n11];
        byte[] byArray2 = new byte[n11];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n12 = n4;
        while (n12 < n9) {
            int n13;
            int n14;
            int n15;
            int n16;
            byte by2 = (byte)inputStream.read();
            int n17 = 0;
            while (n17 != n11) {
                n17 += inputStream.read(byArray3, n17, n11 - n17);
            }
            this.filterRow(byArray3, byArray4, by2);
            if (this.headerChunk.getBitDepth() >= 8) {
                n16 = this.getBytesPerPixel();
                n15 = n12 * n8 + n5 * n16;
                n14 = 0;
                while (n14 < byArray3.length) {
                    n13 = 0;
                    while (n13 < n16) {
                        this.data[n15 + n13] = byArray3[n14 + n13];
                        ++n13;
                    }
                    n15 += n3 * n16;
                    n14 += n16;
                }
            } else {
                n16 = this.headerChunk.getBitDepth();
                n15 = 8 / n16;
                n14 = n5;
                n13 = n12 * n8;
                int n18 = 0;
                int n19 = 0;
                while (n19 < n16) {
                    n18 <<= 1;
                    n18 |= 1;
                    ++n19;
                }
                n19 = 8 - n16;
                int n20 = 0;
                while (n20 < byArray3.length) {
                    int n21 = n19;
                    while (n21 >= 0) {
                        if (n14 < n7) {
                            int n22 = n13 + n14 * n16 / 8;
                            int n23 = byArray3[n20] >> n21 & n18;
                            int n24 = n19 - n16 * (n14 % n15);
                            int n25 = n22;
                            this.data[n25] = (byte)(this.data[n25] | n23 << n24);
                        }
                        n14 += n3;
                        n21 -= n16;
                    }
                    ++n20;
                }
            }
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
            n12 += n2;
        }
        this.setImageDataValues(this.data, this.imageData);
        this.fireInterlacedFrameEvent(n6);
    }

    void readInterlacedImage(InputStream inputStream) throws IOException {
        this.readInterlaceFrame(inputStream, 8, 8, 0, 0, 0);
        this.readInterlaceFrame(inputStream, 8, 8, 0, 4, 1);
        this.readInterlaceFrame(inputStream, 8, 4, 4, 0, 2);
        this.readInterlaceFrame(inputStream, 4, 4, 0, 2, 3);
        this.readInterlaceFrame(inputStream, 4, 2, 2, 0, 4);
        this.readInterlaceFrame(inputStream, 2, 2, 0, 1, 5);
        this.readInterlaceFrame(inputStream, 2, 1, 1, 0, 6);
    }

    void fireInterlacedFrameEvent(int n2) {
        if (this.loader.hasListeners()) {
            ImageData imageData = (ImageData)this.imageData.clone();
            boolean bl2 = n2 == 6;
            this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n2, bl2));
        }
    }

    void readNonInterlacedImage(InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = this.getAlignedBytesPerRow();
        int n4 = this.getBytesPerRow();
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = byArray;
        byte[] byArray4 = byArray2;
        int n5 = this.headerChunk.getHeight();
        int n6 = 0;
        while (n6 < n5) {
            byte by2 = (byte)inputStream.read();
            int n7 = 0;
            while (n7 != n4) {
                n7 += inputStream.read(byArray3, n7, n4 - n7);
            }
            this.filterRow(byArray3, byArray4, by2);
            System.arraycopy(byArray3, 0, this.data, n2, n4);
            n2 += n3;
            byArray3 = byArray3 == byArray ? byArray2 : byArray;
            byArray4 = byArray4 == byArray ? byArray2 : byArray;
            ++n6;
        }
        this.setImageDataValues(this.data, this.imageData);
    }

    static void compress16BitDepthTo8BitDepth(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n4) {
            byte by2;
            int n6 = n2 + 2 * n5;
            int n7 = n3 + n5;
            byArray2[n7] = by2 = byArray[n6];
            ++n5;
        }
    }

    static int compress16BitDepthTo8BitDepth(int n2) {
        return n2 >> 8;
    }

    void filterRow(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = this.headerChunk.getFilterByteOffset();
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                int n4 = n3;
                while (n4 < byArray.length) {
                    int n5 = byArray[n4] & 0xFF;
                    int n6 = byArray[n4 - n3] & 0xFF;
                    byArray[n4] = (byte)(n5 + n6 & 0xFF);
                    ++n4;
                }
                break;
            }
            case 2: {
                int n7 = 0;
                while (n7 < byArray.length) {
                    int n8 = byArray[n7] & 0xFF;
                    int n9 = byArray2[n7] & 0xFF;
                    byArray[n7] = (byte)(n8 + n9 & 0xFF);
                    ++n7;
                }
                break;
            }
            case 3: {
                int n10 = 0;
                while (n10 < byArray.length) {
                    int n11 = n10 < n3 ? 0 : byArray[n10 - n3] & 0xFF;
                    int n12 = byArray2[n10] & 0xFF;
                    int n13 = byArray[n10] & 0xFF;
                    byArray[n10] = (byte)(n13 + (n11 + n12) / 2 & 0xFF);
                    ++n10;
                }
                break;
            }
            case 4: {
                int n14 = 0;
                while (n14 < byArray.length) {
                    int n15 = n14 < n3 ? 0 : byArray[n14 - n3] & 0xFF;
                    int n16 = n14 < n3 ? 0 : byArray2[n14 - n3] & 0xFF;
                    int n17 = byArray2[n14] & 0xFF;
                    int n18 = Math.abs(n17 - n16);
                    int n19 = Math.abs(n15 - n16);
                    int n20 = Math.abs(n15 - n16 + n17 - n16);
                    int n21 = 0;
                    n21 = n18 <= n19 && n18 <= n20 ? n15 : (n19 <= n20 ? n17 : n16);
                    int n22 = byArray[n14] & 0xFF;
                    byArray[n14] = (byte)(n22 + n21 & 0xFF);
                    ++n14;
                }
                break;
            }
        }
    }
}

