/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IOleInPlaceActiveObject;
import org.eclipse.swt.internal.win32.GUITHREADINFO;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleClientSite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public final class OleFrame
extends Composite {
    private COMObject iUnknown;
    private COMObject iOleInPlaceFrame;
    private IOleInPlaceActiveObject objIOleInPlaceActiveObject;
    private OleClientSite currentdoc;
    private int refCount = 0;
    private MenuItem[] fileMenuItems;
    private MenuItem[] containerMenuItems;
    private MenuItem[] windowMenuItems;
    private Listener listener;
    private static String CHECK_FOCUS = "OLE_CHECK_FOCUS";
    private static String HHOOK = "OLE_HHOOK";
    private static String HHOOKMSG = "OLE_HHOOK_MSG";
    private static boolean ignoreNextKey;
    private static final short[] ACCENTS;
    private static final String CONSUME_KEY = "org.eclipse.swt.OleFrame.ConsumeKey";
    static /* synthetic */ Class class$0;

    static {
        ACCENTS = new short[]{126, 96, 39, 94, 34};
    }

    public OleFrame(Composite composite, int n2) {
        super(composite, n2);
        this.createCOMInterfaces();
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 26: {
                        OleFrame.this.onActivate(event);
                        break;
                    }
                    case 27: {
                        OleFrame.this.onDeactivate(event);
                        break;
                    }
                    case 12: {
                        OleFrame.this.onDispose(event);
                        break;
                    }
                    case 10: 
                    case 11: {
                        OleFrame.this.onResize(event);
                        break;
                    }
                    default: {
                        OLE.error(20);
                    }
                }
            }
        };
        this.addListener(26, this.listener);
        this.addListener(27, this.listener);
        this.addListener(12, this.listener);
        this.addListener(11, this.listener);
        this.addListener(10, this.listener);
        this.AddRef();
        Display display = this.getDisplay();
        OleFrame.initCheckFocus(display);
        OleFrame.initMsgHook(display);
    }

    private static void initCheckFocus(final Display display) {
        if (display.getData(CHECK_FOCUS) != null) {
            return;
        }
        display.setData(CHECK_FOCUS, CHECK_FOCUS);
        final Runnable[] runnableArray = new Runnable[1];
        final Control[] controlArray = new Control[1];
        runnableArray[0] = new Runnable(){

            public void run() {
                if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                    int n2 = OS.GetFocus();
                    while (n2 != 0) {
                        int n3 = OS.GetWindow(n2, 4);
                        if (n3 != 0) {
                            display.timerExec(50, runnableArray[0]);
                            return;
                        }
                        n2 = OS.GetParent(n2);
                    }
                }
                if (controlArray[0] == null || controlArray[0].isDisposed() || !controlArray[0].isFocusControl()) {
                    Control control = display.getFocusControl();
                    if (control instanceof OleFrame) {
                        OleFrame oleFrame = (OleFrame)control;
                        control = oleFrame.getCurrentDocument();
                    }
                    if (controlArray[0] != control) {
                        Event event = new Event();
                        if (controlArray[0] instanceof OleClientSite && !controlArray[0].isDisposed()) {
                            controlArray[0].notifyListeners(16, event);
                        }
                        if (control instanceof OleClientSite && !control.isDisposed()) {
                            control.notifyListeners(15, event);
                        }
                    }
                    controlArray[0] = control;
                }
                display.timerExec(50, runnableArray[0]);
            }
        };
        display.timerExec(50, runnableArray[0]);
    }

    private static void initMsgHook(Display display) {
        int n2;
        int n3;
        Callback callback;
        int n4;
        if (display.getData(HHOOK) != null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.ole.win32.OleFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((n4 = (callback = new Callback(clazz, "getMsgProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((n3 = OS.SetWindowsHookEx(3, n4, 0, n2 = OS.GetCurrentThreadId())) == 0) {
            callback.dispose();
            return;
        }
        display.setData(HHOOK, new Integer(n3));
        display.setData(HHOOKMSG, new MSG());
        display.disposeExec(new Runnable(){

            public void run() {
                if (n3 != 0) {
                    OS.UnhookWindowsHookEx(n3);
                }
                if (callback != null) {
                    callback.dispose();
                }
            }
        });
    }

    static int getMsgProc(int n2, int n3, int n4) {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0;
        }
        Integer n5 = (Integer)display.getData(HHOOK);
        if (n5 == null) {
            return 0;
        }
        if (n2 < 0) {
            return OS.CallNextHookEx(n5, n2, n3, n4);
        }
        MSG mSG = (MSG)display.getData(HHOOKMSG);
        OS.MoveMemory(mSG, n4, MSG.sizeof);
        int n6 = mSG.message;
        if (256 <= n6 && n6 <= 264 && display != null) {
            Widget widget = null;
            int n7 = mSG.hwnd;
            while (n7 != 0) {
                widget = display.findWidget(n7);
                if (widget != null) break;
                n7 = OS.GetParent(n7);
            }
            if (widget != null && widget instanceof OleClientSite) {
                OleClientSite oleClientSite = (OleClientSite)widget;
                if (oleClientSite.handle == n7) {
                    int n8;
                    boolean bl2 = false;
                    int n9 = OS.GetWindowThreadProcessId(mSG.hwnd, null);
                    GUITHREADINFO gUITHREADINFO = new GUITHREADINFO();
                    gUITHREADINFO.cbSize = GUITHREADINFO.sizeof;
                    boolean bl3 = OS.GetGUIThreadInfo(n9, gUITHREADINFO);
                    int n10 = 30;
                    if (!bl3 || (gUITHREADINFO.flags & n10) == 0) {
                        OleFrame oleFrame = oleClientSite.frame;
                        oleFrame.setData(CONSUME_KEY, null);
                        bl2 = oleFrame.translateOleAccelerator(mSG);
                        if (oleFrame.getData(CONSUME_KEY) != null) {
                            bl2 = false;
                        }
                        oleFrame.setData(CONSUME_KEY, null);
                    }
                    boolean bl4 = false;
                    block0 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block0;
                                }
                            }
                            n8 = OS.MapVirtualKey(mSG.wParam, 2);
                            if (n8 == 0) break;
                            boolean bl5 = bl4 = (n8 & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0;
                            if (bl4) break;
                            int n11 = 0;
                            while (n11 < ACCENTS.length) {
                                short s2 = OS.VkKeyScan(ACCENTS[n11]);
                                if (s2 != -1 && (s2 & 0xFF) == mSG.wParam) {
                                    int n12 = s2 >> 8;
                                    if (OS.GetKeyState(16) < 0 == ((n12 & 1) != 0) && OS.GetKeyState(17) < 0 == ((n12 & 2) != 0) && OS.GetKeyState(18) < 0 == ((n12 & 4) != 0)) {
                                        if ((n12 & 7) == 0) break block0;
                                        bl4 = true;
                                        break block0;
                                    }
                                }
                                ++n11;
                            }
                            break;
                        }
                    }
                    if (!(bl2 || bl4 || ignoreNextKey)) {
                        n8 = mSG.hwnd;
                        mSG.hwnd = oleClientSite.handle;
                        bl2 = OS.DispatchMessage(mSG) == 1;
                        mSG.hwnd = n8;
                    }
                    block6 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block6;
                                }
                            }
                            ignoreNextKey = bl4;
                        }
                    }
                    if (bl2) {
                        mSG.message = 0;
                        mSG.lParam = 0;
                        mSG.wParam = 0;
                        OS.MoveMemory(n4, mSG, MSG.sizeof);
                        return 0;
                    }
                }
            }
        }
        return OS.CallNextHookEx(n5, n2, n3, n4);
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private int ContextSensitiveHelp(int n2) {
        return 0;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.iUnknown = new COMObject(nArray){

            public int method0(int[] nArray) {
                return OleFrame.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleFrame.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleFrame.this.Release();
            }
        };
        int[] nArray2 = new int[15];
        nArray2[0] = 2;
        nArray2[3] = 1;
        nArray2[4] = 1;
        nArray2[5] = 1;
        nArray2[6] = 1;
        nArray2[7] = 1;
        nArray2[8] = 2;
        nArray2[9] = 2;
        nArray2[10] = 3;
        nArray2[11] = 1;
        nArray2[12] = 1;
        nArray2[13] = 1;
        nArray2[14] = 2;
        this.iOleInPlaceFrame = new COMObject(nArray2){

            public int method0(int[] nArray) {
                return OleFrame.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return OleFrame.this.AddRef();
            }

            public int method2(int[] nArray) {
                return OleFrame.this.Release();
            }

            public int method3(int[] nArray) {
                return OleFrame.this.GetWindow(nArray[0]);
            }

            public int method4(int[] nArray) {
                return OleFrame.this.ContextSensitiveHelp(nArray[0]);
            }

            public int method5(int[] nArray) {
                return OleFrame.this.GetBorder(nArray[0]);
            }

            public int method6(int[] nArray) {
                return OleFrame.this.RequestBorderSpace(nArray[0]);
            }

            public int method7(int[] nArray) {
                return OleFrame.this.SetBorderSpace(nArray[0]);
            }

            public int method8(int[] nArray) {
                return OleFrame.this.SetActiveObject(nArray[0], nArray[1]);
            }

            public int method9(int[] nArray) {
                return OleFrame.this.InsertMenus(nArray[0], nArray[1]);
            }

            public int method10(int[] nArray) {
                return OleFrame.this.SetMenu(nArray[0], nArray[1], nArray[2]);
            }

            public int method11(int[] nArray) {
                return OleFrame.this.RemoveMenus(nArray[0]);
            }

            public int method14(int[] nArray) {
                return OleFrame.this.TranslateAccelerator(nArray[0], nArray[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iUnknown != null) {
            this.iUnknown.dispose();
        }
        this.iUnknown = null;
        if (this.iOleInPlaceFrame != null) {
            this.iOleInPlaceFrame.dispose();
        }
        this.iOleInPlaceFrame = null;
    }

    private int GetBorder(int n2) {
        if (n2 == 0) {
            return -2147024809;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        OS.MoveMemory(n2, rECT, RECT.sizeof);
        return 0;
    }

    public MenuItem[] getContainerMenus() {
        return this.containerMenuItems;
    }

    public MenuItem[] getFileMenus() {
        return this.fileMenuItems;
    }

    int getIOleInPlaceFrame() {
        return this.iOleInPlaceFrame.getAddress();
    }

    private int getMenuItemID(int n2, int n3) {
        int n4 = 0;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 7;
        OS.GetMenuItemInfo(n2, n3, true, mENUITEMINFO);
        n4 = (mENUITEMINFO.fState & 0x10) == 16 ? mENUITEMINFO.hSubMenu : mENUITEMINFO.wID;
        return n4;
    }

    private int GetWindow(int n2) {
        if (n2 != 0) {
            COM.MoveMemory(n2, new int[]{this.handle}, 4);
        }
        return 0;
    }

    public MenuItem[] getWindowMenus() {
        return this.windowMenuItems;
    }

    private int InsertMenus(int n2, int n3) {
        int n4;
        int n5;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            COM.MoveMemory(n3, new int[1], 4);
            return 0;
        }
        int n6 = menu.handle;
        MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
        int n7 = OS.GetProcessHeap();
        int n8 = 128;
        int n9 = n8 * TCHAR.sizeof;
        int n10 = OS.HeapAlloc(n7, 8, n9);
        mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
        mENUITEMINFO.fMask = 55;
        mENUITEMINFO.dwTypeData = n10;
        mENUITEMINFO.cch = n8;
        int n11 = 0;
        int n12 = 0;
        if (this.fileMenuItems != null) {
            n5 = 0;
            while (n5 < this.fileMenuItems.length) {
                MenuItem menuItem = this.fileMenuItems[n5];
                if (menuItem != null) {
                    n4 = menuItem.getParent().indexOf(menuItem);
                    mENUITEMINFO.cch = n8;
                    if (OS.GetMenuItemInfo(n6, n4, true, mENUITEMINFO) && OS.InsertMenuItem(n2, n12, true, mENUITEMINFO)) {
                        ++n11;
                        ++n12;
                    }
                }
                ++n5;
            }
        }
        COM.MoveMemory(n3, new int[]{n11}, 4);
        n5 = 0;
        if (this.containerMenuItems != null) {
            int n13 = 0;
            while (n13 < this.containerMenuItems.length) {
                MenuItem menuItem = this.containerMenuItems[n13];
                if (menuItem != null) {
                    int n14 = menuItem.getParent().indexOf(menuItem);
                    mENUITEMINFO.cch = n8;
                    if (OS.GetMenuItemInfo(n6, n14, true, mENUITEMINFO) && OS.InsertMenuItem(n2, n12, true, mENUITEMINFO)) {
                        ++n5;
                        ++n12;
                    }
                }
                ++n13;
            }
        }
        COM.MoveMemory(n3 + 8, new int[]{n5}, 4);
        int n15 = 0;
        if (this.windowMenuItems != null) {
            n4 = 0;
            while (n4 < this.windowMenuItems.length) {
                MenuItem menuItem = this.windowMenuItems[n4];
                if (menuItem != null) {
                    int n16 = menuItem.getParent().indexOf(menuItem);
                    mENUITEMINFO.cch = n8;
                    if (OS.GetMenuItemInfo(n6, n16, true, mENUITEMINFO) && OS.InsertMenuItem(n2, n12, true, mENUITEMINFO)) {
                        ++n15;
                        ++n12;
                    }
                }
                ++n4;
            }
        }
        COM.MoveMemory(n3 + 16, new int[]{n15}, 4);
        if (n10 != 0) {
            OS.HeapFree(n7, 0, n10);
        }
        return 0;
    }

    void onActivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(true);
        }
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnDocWindowActivate(true);
        }
    }

    void onDeactivate(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnFrameWindowActivate(false);
        }
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.OnDocWindowActivate(false);
        }
    }

    private void onDispose(Event event) {
        this.releaseObjectInterfaces();
        this.currentdoc = null;
        this.Release();
        this.removeListener(26, this.listener);
        this.removeListener(27, this.listener);
        this.removeListener(12, this.listener);
        this.removeListener(11, this.listener);
        this.removeListener(10, this.listener);
    }

    private void onResize(Event event) {
        if (this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIOleInPlaceFrame)) {
            COM.MoveMemory(n3, new int[]{this.iOleInPlaceFrame.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        COM.MoveMemory(n3, new int[1], 4);
        return -2147467262;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    private void releaseObjectInterfaces() {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
        }
        this.objIOleInPlaceActiveObject = null;
    }

    private int RemoveMenus(int n2) {
        int n3;
        int n4;
        MenuItem menuItem;
        int n5;
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed()) {
            return 1;
        }
        int n6 = menu.handle;
        Vector<Integer> vector = new Vector<Integer>();
        if (this.fileMenuItems != null) {
            n5 = 0;
            while (n5 < this.fileMenuItems.length) {
                menuItem = this.fileMenuItems[n5];
                if (menuItem != null && !menuItem.isDisposed()) {
                    n4 = menuItem.getParent().indexOf(menuItem);
                    n3 = this.getMenuItemID(n6, n4);
                    vector.addElement(new Integer(n3));
                }
                ++n5;
            }
        }
        if (this.containerMenuItems != null) {
            n5 = 0;
            while (n5 < this.containerMenuItems.length) {
                menuItem = this.containerMenuItems[n5];
                if (menuItem != null && !menuItem.isDisposed()) {
                    n4 = menuItem.getParent().indexOf(menuItem);
                    n3 = this.getMenuItemID(n6, n4);
                    vector.addElement(new Integer(n3));
                }
                ++n5;
            }
        }
        if (this.windowMenuItems != null) {
            n5 = 0;
            while (n5 < this.windowMenuItems.length) {
                menuItem = this.windowMenuItems[n5];
                if (menuItem != null && !menuItem.isDisposed()) {
                    n4 = menuItem.getParent().indexOf(menuItem);
                    n3 = this.getMenuItemID(n6, n4);
                    vector.addElement(new Integer(n3));
                }
                ++n5;
            }
        }
        int n7 = n5 = OS.GetMenuItemCount(n2) - 1;
        while (n7 >= 0) {
            n4 = this.getMenuItemID(n2, n7);
            if (vector.contains(new Integer(n4))) {
                OS.RemoveMenu(n2, n7, 1024);
            }
            --n7;
        }
        return 0;
    }

    private int RequestBorderSpace(int n2) {
        return 0;
    }

    int SetActiveObject(int n2, int n3) {
        if (this.objIOleInPlaceActiveObject != null) {
            this.objIOleInPlaceActiveObject.Release();
            this.objIOleInPlaceActiveObject = null;
        }
        if (n2 != 0) {
            this.objIOleInPlaceActiveObject = new IOleInPlaceActiveObject(n2);
            this.objIOleInPlaceActiveObject.AddRef();
        }
        return 0;
    }

    private int SetBorderSpace(int n2) {
        if (this.objIOleInPlaceActiveObject == null) {
            return 0;
        }
        RECT rECT = new RECT();
        if (n2 == 0 || this.currentdoc == null) {
            return 0;
        }
        COM.MoveMemory(rECT, n2, RECT.sizeof);
        this.currentdoc.setBorderSpace(rECT);
        return 0;
    }

    public void setContainerMenus(MenuItem[] menuItemArray) {
        this.containerMenuItems = menuItemArray;
    }

    OleClientSite getCurrentDocument() {
        return this.currentdoc;
    }

    void setCurrentDocument(OleClientSite oleClientSite) {
        this.currentdoc = oleClientSite;
        if (this.currentdoc != null && this.objIOleInPlaceActiveObject != null) {
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            this.objIOleInPlaceActiveObject.ResizeBorder(rECT, this.iOleInPlaceFrame.getAddress(), true);
        }
    }

    public void setFileMenus(MenuItem[] menuItemArray) {
        this.fileMenuItems = menuItemArray;
    }

    private int SetMenu(int n2, int n3, int n4) {
        Menu menu;
        int n5 = 0;
        if (this.objIOleInPlaceActiveObject != null) {
            n5 = this.objIOleInPlaceActiveObject.getAddress();
        }
        if ((menu = this.getShell().getMenuBar()) == null || menu.isDisposed()) {
            return COM.OleSetMenuDescriptor(0, this.getShell().handle, n4, this.iOleInPlaceFrame.getAddress(), n5);
        }
        int n6 = menu.getShell().handle;
        if (n2 == 0 && n3 == 0) {
            n2 = menu.handle;
        }
        if (n2 == 0) {
            return -2147467259;
        }
        OS.SetMenu(n6, n2);
        OS.DrawMenuBar(n6);
        return COM.OleSetMenuDescriptor(n3, n6, n4, this.iOleInPlaceFrame.getAddress(), n5);
    }

    public void setWindowMenus(MenuItem[] menuItemArray) {
        this.windowMenuItems = menuItemArray;
    }

    private boolean translateOleAccelerator(MSG mSG) {
        if (this.objIOleInPlaceActiveObject == null) {
            return false;
        }
        int n2 = this.objIOleInPlaceActiveObject.TranslateAccelerator(mSG);
        return n2 != 1 && n2 != -2147467263;
    }

    private int TranslateAccelerator(int n2, int n3) {
        Menu menu = this.getShell().getMenuBar();
        if (menu == null || menu.isDisposed() || !menu.isEnabled()) {
            return 1;
        }
        if (n3 < 0) {
            return 1;
        }
        Shell shell = menu.getShell();
        int n4 = shell.handle;
        int n5 = OS.SendMessage(n4, 32769, 0, 0);
        if (n5 == 0) {
            return 1;
        }
        MSG mSG = new MSG();
        OS.MoveMemory(mSG, n2, MSG.sizeof);
        int n6 = OS.TranslateAccelerator(n4, n5, mSG);
        return n6 == 0 ? 1 : 0;
    }
}

