/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.win32.INITCOMMONCONTROLSEX;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SYSTEMTIME;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    static final int DateTimeProc;
    static final TCHAR DateTimeClass;
    static final int CalendarProc;
    static final TCHAR CalendarClass;
    static final int MARGIN = 4;
    static final int MAX_DIGIT = 9;
    static final int MAX_DAY = 31;
    static final int MAX_12HOUR = 12;
    static final int MAX_24HOUR = 24;
    static final int MAX_MINUTE = 60;
    static final int MONTH_DAY_YEAR = 0;
    static final int DAY_MONTH_YEAR = 1;
    static final int YEAR_MONTH_DAY = 2;
    static final char SINGLE_QUOTE = '\'';
    static final char DAY_FORMAT_CONSTANT = 'd';
    static final char MONTH_FORMAT_CONSTANT = 'M';
    static final char YEAR_FORMAT_CONSTANT = 'y';
    static final char HOURS_FORMAT_CONSTANT = 'h';
    static final char MINUTES_FORMAT_CONSTANT = 'm';
    static final char SECONDS_FORMAT_CONSTANT = 's';
    static final char AMPM_FORMAT_CONSTANT = 't';
    static final int[] MONTH_NAMES;

    static {
        DateTimeClass = new TCHAR(0, "SysDateTimePick32", true);
        CalendarClass = new TCHAR(0, "SysMonthCal32", true);
        INITCOMMONCONTROLSEX iNITCOMMONCONTROLSEX = new INITCOMMONCONTROLSEX();
        iNITCOMMONCONTROLSEX.dwSize = INITCOMMONCONTROLSEX.sizeof;
        iNITCOMMONCONTROLSEX.dwICC = 256;
        OS.InitCommonControlsEx(iNITCOMMONCONTROLSEX);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, DateTimeClass, wNDCLASS);
        DateTimeProc = wNDCLASS.lpfnWndProc;
        OS.GetClassInfo(0, CalendarClass, wNDCLASS);
        CalendarProc = wNDCLASS.lpfnWndProc;
        MONTH_NAMES = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67};
    }

    public DateTime(Composite composite, int n2) {
        super(composite, DateTime.checkStyle(n2));
        if ((this.style & 0x8000) != 0) {
            String string = (this.style & 0x20) != 0 ? this.getCustomShortDateFormat() : this.getCustomShortTimeFormat();
            TCHAR tCHAR = new TCHAR(0, string, true);
            OS.SendMessage(this.handle, OS.DTM_SETFORMAT, 0, tCHAR);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.CallWindowProc(this.windowProc(), n2, n3, n4, n5);
    }

    static int checkStyle(int n2) {
        n2 &= 0xFFFFFCFF;
        n2 = DateTime.checkBits(n2, 32, 128, 1024, 0, 0, 0);
        return DateTime.checkBits(n2, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n2, int n3, boolean bl2) {
        this.checkWidget();
        int n4 = 0;
        int n5 = 0;
        if (n2 == -1 || n3 == -1) {
            Object object;
            if ((this.style & 0x400) != 0) {
                object = new RECT();
                OS.SendMessage(this.handle, 4105, 0, (RECT)object);
                n4 = ((RECT)object).right;
                n5 = ((RECT)object).bottom;
            } else {
                int n6;
                int n7;
                object = new TCHAR(this.getCodePage(), 128);
                int n8 = 0;
                int n9 = OS.GetDC(this.handle);
                int n10 = OS.SendMessage(this.handle, 49, 0, 0);
                if (n10 != 0) {
                    n8 = OS.SelectObject(n9, n10);
                }
                RECT rECT = new RECT();
                int n11 = 11264;
                SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
                if ((this.style & 0x20) != 0) {
                    int n12;
                    int n13;
                    sYSTEMTIME.wMonth = 1;
                    sYSTEMTIME.wDay = 1;
                    n7 = 0;
                    n6 = 0;
                    int n14 = 0;
                    int n15 = 0;
                    while (n15 <= 9) {
                        sYSTEMTIME.wYear = (short)(2000 + n15);
                        n13 = OS.GetDateFormat(1024, 1, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n13 == 0) {
                            object = new TCHAR(this.getCodePage(), n13);
                            OS.GetDateFormat(1024, 1, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n9, (TCHAR)object, n13, rECT, n11);
                        if (rECT.right - rECT.left >= n4) {
                            n4 = rECT.right - rECT.left;
                            n14 = n6;
                            n6 = n7;
                            n7 = n15;
                        }
                        n5 = Math.max(n5, rECT.bottom - rECT.top);
                        ++n15;
                    }
                    n7 = n7 > 1 ? n7 * 1000 + n7 * 100 + n7 * 10 + n7 : (n6 > 1 ? n6 * 1000 + n7 * 100 + n7 * 10 + n7 : n14 * 1000 + n7 * 100 + n7 * 10 + n7);
                    sYSTEMTIME.wYear = (short)n7;
                    n7 = 0;
                    n4 = 0;
                    n15 = 0;
                    while (n15 < MONTH_NAMES.length) {
                        n13 = MONTH_NAMES[n15];
                        n12 = OS.GetLocaleInfo(1024, n13, (TCHAR)object, ((TCHAR)object).length());
                        if (n12 == 0) {
                            object = new TCHAR(this.getCodePage(), n12);
                            OS.GetLocaleInfo(1024, n13, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n9, (TCHAR)object, n12, rECT, n11);
                        if (rECT.right - rECT.left > n4) {
                            n4 = rECT.right - rECT.left;
                            n7 = n15;
                        }
                        n5 = Math.max(n5, rECT.bottom - rECT.top);
                        n15 = (short)(n15 + 1);
                    }
                    sYSTEMTIME.wMonth = (short)(n7 + 1);
                    n15 = (this.style & 0x10000) != 0 ? 1 : ((this.style & 0x8000) != 0 ? 8 : 2);
                    n4 = 0;
                    n13 = 1;
                    while (n13 <= 31) {
                        sYSTEMTIME.wDay = (short)n13;
                        n12 = OS.GetDateFormat(1024, n15, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n12 == 0) {
                            object = new TCHAR(this.getCodePage(), n12);
                            OS.GetDateFormat(1024, n15, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n9, (TCHAR)object, n12, rECT, n11);
                        n4 = Math.max(n4, rECT.right - rECT.left);
                        n5 = Math.max(n5, rECT.bottom - rECT.top);
                        if ((this.style & 0x8000) == 0) {
                            n13 = (short)(n13 + 1);
                            continue;
                        }
                        break;
                    }
                } else if ((this.style & 0x80) != 0) {
                    int n16;
                    n7 = (this.style & 0x8000) != 0 ? 2 : 0;
                    n6 = 0;
                    int n17 = this.is24HourTime() ? 24 : 12;
                    int n18 = 0;
                    while (n18 < n17) {
                        sYSTEMTIME.wHour = (short)n18;
                        n16 = OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n16 == 0) {
                            object = new TCHAR(this.getCodePage(), n16);
                            OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n9, (TCHAR)object, n16, rECT, n11);
                        if (rECT.right - rECT.left > n4) {
                            n4 = rECT.right - rECT.left;
                            n6 = n18;
                        }
                        n5 = Math.max(n5, rECT.bottom - rECT.top);
                        n18 = (short)(n18 + 1);
                    }
                    sYSTEMTIME.wHour = (short)n6;
                    n6 = 0;
                    n4 = 0;
                    n18 = 0;
                    while (n18 < 60) {
                        sYSTEMTIME.wMinute = (short)n18;
                        n16 = OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        if (n16 == 0) {
                            object = new TCHAR(this.getCodePage(), n16);
                            OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                        }
                        rECT.bottom = 0;
                        rECT.right = 0;
                        rECT.top = 0;
                        rECT.left = 0;
                        OS.DrawText(n9, (TCHAR)object, n16, rECT, n11);
                        if (rECT.right - rECT.left > n4) {
                            n4 = rECT.right - rECT.left;
                            n6 = n18;
                        }
                        n5 = Math.max(n5, rECT.bottom - rECT.top);
                        n18 = (short)(n18 + 1);
                    }
                    sYSTEMTIME.wMinute = (short)n6;
                    sYSTEMTIME.wSecond = (short)n6;
                    n18 = OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                    if (n18 == 0) {
                        object = new TCHAR(this.getCodePage(), n18);
                        OS.GetTimeFormat(1024, n7, sYSTEMTIME, null, (TCHAR)object, ((TCHAR)object).length());
                    }
                    rECT.bottom = 0;
                    rECT.right = 0;
                    rECT.top = 0;
                    rECT.left = 0;
                    OS.DrawText(n9, (TCHAR)object, n18, rECT, n11);
                    n4 = rECT.right - rECT.left;
                    n5 = Math.max(n5, rECT.bottom - rECT.top);
                }
                if (n10 != 0) {
                    OS.SelectObject(n9, n8);
                }
                OS.ReleaseDC(this.handle, n9);
                n7 = OS.GetSystemMetrics(2);
                n4 += n7 + 4;
                n6 = OS.GetSystemMetrics(20);
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
                    n6 += 7;
                }
                n5 = Math.max(n5, n6);
            }
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n5 == 0) {
            n5 = 64;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n3 != -1) {
            n5 = n3;
        }
        int n19 = this.getBorderWidth();
        return new Point(n4 += n19 * 2, n5 += n19 * 2);
    }

    void createHandle() {
        super.createHandle();
        this.state &= 0xFFFFFEFD;
    }

    int defaultBackground() {
        return OS.GetSysColor(OS.COLOR_WINDOW);
    }

    String getComputeSizeString() {
        if ((this.style & 0x20) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortDateFormat();
            }
            if ((this.style & 0x10000) != 0) {
                return this.getShortDateFormat();
            }
            if ((this.style & 0x10000000) != 0) {
                return this.getLongDateFormat();
            }
        }
        if ((this.style & 0x80) != 0) {
            if ((this.style & 0x8000) != 0) {
                return this.getCustomShortTimeFormat();
            }
            return this.getTimeFormat();
        }
        return "";
    }

    String getCustomShortDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 4102, tCHAR, 80);
        return n2 != 0 ? tCHAR.toString(0, n2 - 1) : "M/yyyy";
    }

    String getCustomShortTimeFormat() {
        StringBuffer stringBuffer = new StringBuffer(this.getTimeFormat());
        int n2 = stringBuffer.length();
        boolean bl2 = false;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            char c2 = stringBuffer.charAt(n3);
            if (c2 == '\'') {
                bl2 = !bl2;
            } else if (c2 == 's' && !bl2) {
                n4 = n3 + 1;
                while (n4 < n2 && stringBuffer.charAt(n4) == 's') {
                    ++n4;
                }
                while (n3 > 0 && stringBuffer.charAt(n3) != 'm') {
                    --n3;
                }
                ++n3;
                break;
            }
            ++n3;
        }
        if (n3 < n4) {
            stringBuffer.delete(n3, n4);
        }
        return stringBuffer.toString();
    }

    String getLongDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 32, tCHAR, 80);
        return n2 > 0 ? tCHAR.toString(0, n2 - 1) : "dddd, MMMM dd, yyyy";
    }

    String getShortDateFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 31, tCHAR, 80);
        return n2 > 0 ? tCHAR.toString(0, n2 - 1) : "M/d/yyyy";
    }

    int getShortDateFormatOrdering() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n2 = OS.GetLocaleInfo(1024, 33, tCHAR, 4);
        if (n2 > 0) {
            String string = tCHAR.toString(0, n2 - 1);
            return Integer.parseInt(string);
        }
        return 0;
    }

    String getTimeFormat() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 80);
        int n2 = OS.GetLocaleInfo(1024, 4099, tCHAR, 80);
        return n2 > 0 ? tCHAR.toString(0, n2 - 1) : "h:mm:ss tt";
    }

    boolean is24HourTime() {
        TCHAR tCHAR = new TCHAR(this.getCodePage(), 4);
        int n2 = OS.GetLocaleInfo(1024, 35, tCHAR, 4);
        if (n2 > 0) {
            String string = tCHAR.toString(0, n2 - 1);
            return Integer.parseInt(string) != 0;
        }
        return true;
    }

    public int getDay() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wDay;
    }

    public int getHours() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wHour;
    }

    public int getMinutes() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wMinute;
    }

    public int getMonth() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wMonth - 1;
    }

    String getNameText() {
        return "DateTime";
    }

    public int getSeconds() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wSecond;
    }

    public int getYear() {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n2 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n2, 0, sYSTEMTIME);
        return sYSTEMTIME.wYear;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setDay(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wDay = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    public void setHours(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wHour = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    public void setMinutes(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMinute = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    public void setMonth(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wMonth = (short)(n2 + 1);
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    public void setSeconds(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wSecond = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    public void setYear(int n2) {
        this.checkWidget();
        SYSTEMTIME sYSTEMTIME = new SYSTEMTIME();
        int n3 = (this.style & 0x400) != 0 ? 4097 : 4097;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
        n3 = (this.style & 0x400) != 0 ? 4098 : 4098;
        sYSTEMTIME.wYear = (short)n2;
        OS.SendMessage(this.handle, n3, 0, sYSTEMTIME);
    }

    int widgetStyle() {
        int n2 = super.widgetStyle() | 0x10000;
        if ((this.style & 0x400) != 0) {
            return n2 | 0x10;
        }
        n2 &= 0xFDFFFFFF;
        if ((this.style & 0x80) != 0) {
            n2 |= 9;
        }
        if ((this.style & 0x20) != 0) {
            n2 |= ((this.style & 0x10000) != 0 ? 12 : 4) | 1;
        }
        return n2;
    }

    TCHAR windowClass() {
        return (this.style & 0x400) != 0 ? CalendarClass : DateTimeClass;
    }

    int windowProc() {
        return (this.style & 0x400) != 0 ? CalendarProc : DateTimeProc;
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n2, int n3) {
        switch (nMHDR.code) {
            case -759: 
            case -749: {
                this.sendEvent(13);
            }
        }
        return super.wmNotifyChild(nMHDR, n2, n3);
    }
}

