/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    int increment;
    int pageIncrement;

    ScrollBar(Scrollable scrollable, int n2) {
        super(scrollable, ScrollBar.checkStyle(n2));
        this.parent = scrollable;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ScrollBar.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.increment = 1;
        this.pageIncrement = 10;
    }

    void destroyWidget() {
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 3;
            sCROLLINFO.nPage = 101;
            sCROLLINFO.nMax = 100;
            sCROLLINFO.nMin = 0;
            OS.SetScrollInfo(n2, n3, sCROLLINFO, true);
        } else {
            OS.ShowScrollBar(n2, n3, false);
        }
        this.releaseHandle();
    }

    Rectangle getBounds() {
        int n2;
        int n3;
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        int n4 = 0;
        int n5 = 0;
        if ((this.style & 0x100) != 0) {
            n5 = rECT.bottom - rECT.top;
            n3 = rECT.right - rECT.left;
            n2 = OS.GetSystemMetrics(3);
        } else {
            n4 = rECT.right - rECT.left;
            n3 = OS.GetSystemMetrics(2);
            n2 = rECT.bottom - rECT.top;
        }
        return new Rectangle(n4, n5, n3, n2);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 8) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        return this.increment;
    }

    public int getMaximum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nMax;
    }

    public int getMinimum() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 1;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nMin;
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.pageIncrement;
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 4;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        return sCROLLINFO.nPos;
    }

    public Point getSize() {
        int n2;
        int n3;
        this.checkWidget();
        this.parent.forceResize();
        RECT rECT = new RECT();
        OS.GetClientRect(this.parent.scrolledHandle(), rECT);
        if ((this.style & 0x100) != 0) {
            n3 = rECT.right - rECT.left;
            n2 = OS.GetSystemMetrics(3);
        } else {
            n3 = OS.GetSystemMetrics(2);
            n2 = rECT.bottom - rECT.top;
        }
        return new Point(n3, n2);
    }

    public int getThumb() {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 2;
        int n2 = this.hwndScrollBar();
        int n3 = this.scrollBarType();
        OS.GetScrollInfo(n2, n3, sCROLLINFO);
        if (sCROLLINFO.nPage != 0) {
            --sCROLLINFO.nPage;
        }
        return sCROLLINFO.nPage;
    }

    public boolean getVisible() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    int hwndScrollBar() {
        return this.parent.scrolledHandle();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    int scrollBarType() {
        return (this.style & 0x200) != 0 ? 1 : 0;
    }

    public void setEnabled(boolean bl2) {
        this.checkWidget();
        if (!OS.IsWinCE) {
            int n2 = this.hwndScrollBar();
            int n3 = this.scrollBarType();
            int n4 = bl2 ? 0 : 3;
            OS.EnableScrollBar(n2, n3, n4);
            this.state = bl2 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
        }
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.increment = n2;
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        if (n2 - sCROLLINFO.nMin - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMax = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 9;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        if (sCROLLINFO.nMax - n2 - sCROLLINFO.nPage < 1) {
            return;
        }
        sCROLLINFO.nMin = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.pageIncrement = n2;
    }

    boolean SetScrollInfo(int n2, int n3, SCROLLINFO sCROLLINFO, boolean bl2) {
        if ((this.state & 0x18) != 0) {
            bl2 = false;
        }
        boolean bl3 = OS.SetScrollInfo(n2, n3, sCROLLINFO, bl2);
        if ((this.state & 0x10) != 0 && !OS.IsWinCE) {
            ScrollBar scrollBar = null;
            switch (n3) {
                case 0: {
                    scrollBar = this.parent.getVerticalBar();
                    break;
                }
                case 1: {
                    scrollBar = this.parent.getHorizontalBar();
                }
            }
            boolean bl4 = scrollBar != null && !scrollBar.getVisible();
            OS.ShowScrollBar(n2, bl4 ? 3 : n3, false);
        }
        if ((this.state & 8) != 0 && !OS.IsWinCE) {
            OS.EnableScrollBar(n2, n3, 3);
        }
        return bl3;
    }

    public void setSelection(int n2) {
        this.checkWidget();
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 4;
        sCROLLINFO.nPos = n2;
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        int n3 = this.hwndScrollBar();
        int n4 = this.scrollBarType();
        sCROLLINFO.fMask = 11;
        OS.GetScrollInfo(n3, n4, sCROLLINFO);
        sCROLLINFO.nPage = n2;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        this.SetScrollInfo(n3, n4, sCROLLINFO, true);
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.increment = n6;
        this.pageIncrement = n7;
        SCROLLINFO sCROLLINFO = new SCROLLINFO();
        sCROLLINFO.cbSize = SCROLLINFO.sizeof;
        sCROLLINFO.fMask = 15;
        sCROLLINFO.nPos = n2;
        sCROLLINFO.nMin = n3;
        sCROLLINFO.nMax = n4;
        sCROLLINFO.nPage = n5;
        if (sCROLLINFO.nPage != 0) {
            ++sCROLLINFO.nPage;
        }
        int n8 = this.hwndScrollBar();
        int n9 = this.scrollBarType();
        this.SetScrollInfo(n8, n9, sCROLLINFO, true);
    }

    public void setVisible(boolean bl2) {
        int n2;
        boolean bl3;
        this.checkWidget();
        boolean bl4 = bl3 = (this.state & 0x10) == 0;
        if (bl3 == bl2) {
            return;
        }
        if (OS.IsWinCE) {
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            int n3 = this.hwndScrollBar();
            int n4 = this.scrollBarType();
            sCROLLINFO.fMask = 3;
            if (bl2) {
                sCROLLINFO.fMask |= 8;
            }
            OS.GetScrollInfo(n3, n4, sCROLLINFO);
            if (sCROLLINFO.nPage == sCROLLINFO.nMax - sCROLLINFO.nMin + 1) {
                int n5 = sCROLLINFO.nMax++;
                OS.SetScrollInfo(n3, n4, sCROLLINFO, false);
                sCROLLINFO.nMax = n5;
                OS.SetScrollInfo(n3, n4, sCROLLINFO, true);
            }
            return;
        }
        this.state = bl2 ? this.state & 0xFFFFFFEF : this.state | 0x10;
        int n6 = this.hwndScrollBar();
        if (OS.ShowScrollBar(n6, n2 = this.scrollBarType(), bl2)) {
            if ((this.state & 8) == 0) {
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 3;
                OS.GetScrollInfo(n6, n2, sCROLLINFO);
                if (sCROLLINFO.nMax - sCROLLINFO.nMin - sCROLLINFO.nPage >= 0) {
                    OS.EnableScrollBar(n6, n2, 0);
                }
            }
            this.sendEvent(bl2 ? 22 : 23);
        }
    }

    LRESULT wmScrollChild(int n2, int n3) {
        int n4 = n2 & 0xFFFF;
        if (n4 == 8) {
            return null;
        }
        Event event = new Event();
        switch (n4) {
            case 4: {
                event.detail = 0;
                break;
            }
            case 5: {
                event.detail = 1;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                break;
            }
            case 7: {
                event.detail = 0x1000008;
                break;
            }
            case 1: {
                event.detail = 0x1000002;
                break;
            }
            case 0: {
                event.detail = 0x1000001;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
                break;
            }
            case 2: {
                event.detail = 0x1000005;
            }
        }
        this.sendEvent(13, event);
        return null;
    }
}

