/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ActionMapUIResource;

class SynthInternalFrameTitlePane
extends JComponent
implements SynthUI {
    protected JButton minimizeButton;
    protected JButton maximizeButton;
    protected JButton closeButton;
    protected JPopupMenu systemPopupMenu;
    protected JButton menuButton;
    protected JInternalFrame frame;
    protected Icon maximizeIcon;
    protected Icon restoreIcon;
    protected Icon minimizeIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    protected static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    protected static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private String closeButtonToolTip;
    private String minimizeButtonToolTip;
    private String restoreButtonToolTip;
    private String maximizeButtonToolTip;
    private SynthStyle style;

    protected void addSubComponents() {
        this.add(this.menuButton);
        this.add(this.minimizeButton);
        this.add(this.maximizeButton);
        this.add(this.closeButton);
    }

    protected void assembleSystemMenu() {
        this.systemPopupMenu = new JPopupMenu();
        this.addSystemMenuItems(this.systemPopupMenu);
        this.enableActions();
        this.menuButton = this.createNoFocusButton();
        this.menuButton.setIcon(this.frame.getFrameIcon());
        this.menuButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                Dimension dimension = new Dimension();
                Border border = SynthInternalFrameTitlePane.this.frame.getBorder();
                if (border != null) {
                    dimension.width += border.getBorderInsets((Component)SynthInternalFrameTitlePane.this.frame).left + border.getBorderInsets((Component)SynthInternalFrameTitlePane.this.frame).right;
                    dimension.height += border.getBorderInsets((Component)SynthInternalFrameTitlePane.this.frame).bottom + border.getBorderInsets((Component)SynthInternalFrameTitlePane.this.frame).top;
                }
                if (!SynthInternalFrameTitlePane.this.frame.isIcon()) {
                    SynthInternalFrameTitlePane.this.systemPopupMenu.show(mouseEvent.getComponent(), SynthInternalFrameTitlePane.this.getX() - dimension.width, SynthInternalFrameTitlePane.this.getY() + SynthInternalFrameTitlePane.this.getHeight() - dimension.height);
                } else {
                    SynthInternalFrameTitlePane.this.systemPopupMenu.show(mouseEvent.getComponent(), SynthInternalFrameTitlePane.this.getX() - dimension.width, SynthInternalFrameTitlePane.this.getY() - SynthInternalFrameTitlePane.this.systemPopupMenu.getPreferredSize().height - dimension.height);
                }
            }
        });
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    protected void createButtons() {
        this.minimizeButton = this.createNoFocusButton();
        this.minimizeButton.addActionListener(this.iconifyAction);
        if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
            this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
        }
        this.maximizeButton = this.createNoFocusButton();
        this.maximizeButton.addActionListener(this.maximizeAction);
        this.closeButton = this.createNoFocusButton();
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonIcons();
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    protected void installDefaults() {
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.minimizeButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maximizeButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            if (this.restoreIcon != null) {
                this.minimizeButton.setIcon(this.restoreIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.restoreButtonToolTip);
            }
            if (this.maximizeIcon != null) {
                this.maximizeButton.setIcon(this.maximizeIcon);
            }
            if (this.maximizeButtonToolTip != null && this.maximizeButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.maximizeButtonToolTip);
            }
        } else if (this.frame.isMaximum()) {
            if (this.minimizeIcon != null) {
                this.minimizeButton.setIcon(this.minimizeIcon);
            }
            if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
            }
            if (this.restoreIcon != null) {
                this.maximizeButton.setIcon(this.restoreIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            if (this.minimizeIcon != null) {
                this.minimizeButton.setIcon(this.minimizeIcon);
            }
            if (this.minimizeButtonToolTip != null && this.minimizeButtonToolTip.length() != 0) {
                this.minimizeButton.setToolTipText(this.minimizeButtonToolTip);
            }
            if (this.maximizeIcon != null) {
                this.maximizeButton.setIcon(this.maximizeIcon);
            }
            if (this.maximizeButtonToolTip != null && this.maximizeButtonToolTip.length() != 0) {
                this.maximizeButton.setToolTipText(this.maximizeButtonToolTip);
            }
        }
        if (this.closeIcon != null) {
            this.closeButton.setIcon(this.closeIcon);
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void paintComponent(Graphics graphics) {
        SynthContext synthContext = this.getContext(this);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.dispose();
    }

    protected LayoutManager createLayout() {
        SynthContext synthContext = this.getContext(this);
        LayoutManager layoutManager = (LayoutManager)this.style.get(synthContext, "InternalFrameTitlePane.titlePaneLayout");
        synthContext.dispose();
        return layoutManager != null ? layoutManager : new TitlePaneLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public String getUIClassID() {
        return "InternalFrameTitlePaneUI";
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("showSystemMenu", new ShowSystemMenuAction(true));
        actionMapUIResource.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return actionMapUIResource;
    }

    private JButton createNoFocusButton() {
        JButton jButton = new JButton();
        jButton.setFocusable(false);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        return jButton;
    }

    private int getComponentState(JComponent jComponent) {
        if (this.frame != null && this.frame.isSelected()) {
            return 512;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(this, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            this.maximizeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.maximizeIcon");
            this.restoreIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.restoreIcon");
            this.minimizeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.iconifyIcon");
            this.closeIcon = this.style.getIcon(synthContext, "InternalFrameTitlePane.closeIcon");
        }
        synthContext.dispose();
    }

    public SynthInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        this.fetchStyle(this);
        this.frame = jInternalFrame;
        this.installTitlePane();
        this.menuButton.setName("InternalFrameTitlePane.menuButton");
        this.minimizeButton.setName("InternalFrameTitlePane.iconifyButton");
        this.maximizeButton.setName("InternalFrameTitlePane.maximizeButton");
        this.closeButton.setName("InternalFrameTitlePane.closeButton");
    }

    protected void postClosingEvent(JInternalFrame jInternalFrame) {
        InternalFrameEvent internalFrameEvent = new InternalFrameEvent(jInternalFrame, 25550);
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(internalFrameEvent);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        jInternalFrame.dispatchEvent(internalFrameEvent);
    }

    protected void addSystemMenuItems(JPopupMenu jPopupMenu) {
        JMenuItem jMenuItem = jPopupMenu.add(this.restoreAction);
        jMenuItem.setMnemonic('R');
        jMenuItem = jPopupMenu.add(this.moveAction);
        jMenuItem.setMnemonic('M');
        jMenuItem = jPopupMenu.add(this.sizeAction);
        jMenuItem.setMnemonic('S');
        jMenuItem = jPopupMenu.add(this.iconifyAction);
        jMenuItem.setMnemonic('n');
        jMenuItem = jPopupMenu.add(this.maximizeAction);
        jMenuItem.setMnemonic('x');
        jPopupMenu.add(new JSeparator());
        jMenuItem = jPopupMenu.add(this.closeAction);
        jMenuItem.setMnemonic('C');
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(CLOSE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                SynthInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(ICONIFY_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!SynthInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        SynthInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        SynthInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(MAXIMIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (!SynthInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        SynthInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        SynthInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class MoveAction
    extends AbstractAction {
        public MoveAction() {
            super(MOVE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthInternalFrameTitlePane.this.fetchStyle(SynthInternalFrameTitlePane.this);
            }
            if ("selected".equals(string)) {
                SynthInternalFrameTitlePane.this.repaint();
                return;
            }
            if ("icon".equals(string) || "maximum".equals(string)) {
                SynthInternalFrameTitlePane.this.setButtonIcons();
                SynthInternalFrameTitlePane.this.enableActions();
                return;
            }
            if (string.equals("closable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    SynthInternalFrameTitlePane.this.add(SynthInternalFrameTitlePane.this.closeButton);
                } else {
                    SynthInternalFrameTitlePane.this.remove(SynthInternalFrameTitlePane.this.closeButton);
                }
            } else if (string.equals("maximizable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    SynthInternalFrameTitlePane.this.add(SynthInternalFrameTitlePane.this.maximizeButton);
                } else {
                    SynthInternalFrameTitlePane.this.remove(SynthInternalFrameTitlePane.this.maximizeButton);
                }
            } else if (string.equals("iconable")) {
                if ((Boolean)propertyChangeEvent.getNewValue() == Boolean.TRUE) {
                    SynthInternalFrameTitlePane.this.add(SynthInternalFrameTitlePane.this.minimizeButton);
                } else {
                    SynthInternalFrameTitlePane.this.remove(SynthInternalFrameTitlePane.this.minimizeButton);
                }
            }
            SynthInternalFrameTitlePane.this.enableActions();
            SynthInternalFrameTitlePane.this.revalidate();
            SynthInternalFrameTitlePane.this.repaint();
        }
    }

    class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(RESTORE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable() && SynthInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    SynthInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else if (SynthInternalFrameTitlePane.this.frame.isIconifiable() && SynthInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    SynthInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean bl2) {
            this.show = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.show) {
                SynthInternalFrameTitlePane.this.systemPopupMenu.setVisible(false);
            }
        }
    }

    class SizeAction
    extends AbstractAction {
        public SizeAction() {
            super(SIZE_CMD);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class TitlePaneLayout
    implements LayoutManager {
        TitlePaneLayout() {
        }

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            Icon icon;
            int n2;
            boolean bl2 = SynthLookAndFeel.isLeftToRight(SynthInternalFrameTitlePane.this.frame);
            int n3 = SynthInternalFrameTitlePane.this.getWidth();
            int n4 = SynthInternalFrameTitlePane.this.getHeight();
            Icon icon2 = SynthInternalFrameTitlePane.this.closeButton.getIcon();
            int n5 = n2 = icon2 != null ? icon2.getIconHeight() : 12;
            if (n2 == 0) {
                n2 = 12;
            }
            int n6 = (icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon()) != null ? icon.getIconHeight() : n2;
            Insets insets = SynthInternalFrameTitlePane.this.frame.getInsets();
            int n7 = bl2 ? insets.left : n3 - 16 - insets.right;
            SynthInternalFrameTitlePane.this.menuButton.setBounds(n7, (n4 - n6) / 2, 16, 14);
            int n8 = n7 = bl2 ? n3 - 16 - insets.right : insets.left;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                SynthInternalFrameTitlePane.this.closeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                SynthInternalFrameTitlePane.this.maximizeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
                n7 += bl2 ? -18 : 18;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                SynthInternalFrameTitlePane.this.minimizeButton.setBounds(n7, (n4 - n2) / 2, 16, 14);
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            int n3;
            int n4 = 22;
            if (SynthInternalFrameTitlePane.this.frame.isClosable()) {
                n4 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isMaximizable()) {
                n4 += 19;
            }
            if (SynthInternalFrameTitlePane.this.frame.isIconifiable()) {
                n4 += 19;
            }
            FontMetrics fontMetrics = SynthInternalFrameTitlePane.this.getFontMetrics(SynthInternalFrameTitlePane.this.getFont());
            String string = SynthInternalFrameTitlePane.this.frame.getTitle();
            int n5 = string != null ? fontMetrics.stringWidth(string) : 0;
            int n6 = n3 = string != null ? string.length() : 0;
            n4 = n3 > 3 ? (n4 += n5 < (n2 = fontMetrics.stringWidth(string.substring(0, 3) + "...")) ? n5 : n2) : (n4 += n5);
            Icon icon = SynthInternalFrameTitlePane.this.frame.getFrameIcon();
            int n7 = fontMetrics.getHeight();
            n7 += 2;
            int n8 = 0;
            if (icon != null) {
                n8 = Math.min(icon.getIconHeight(), 16);
            }
            int n9 = Math.max(n7, n8 += 2);
            Dimension dimension = new Dimension(n4, n9);
            if (SynthInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = SynthInternalFrameTitlePane.this.getBorder().getBorderInsets(container);
                dimension.height += insets.top + insets.bottom;
                dimension.width += insets.left + insets.right;
            }
            return dimension;
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }
}

