/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.DefaultMenuLayout;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.UIResource;

class SynthMenuBarUI
extends MenuBarUI
implements SynthUI {
    protected JMenuBar menuBar = null;
    protected ContainerListener containerListener;
    protected ChangeListener changeListener;
    private PropertyChangeListener propertyChangeListener;
    private SynthStyle style;

    SynthMenuBarUI() {
    }

    protected void installDefaults() {
        if (this.menuBar.getLayout() == null || this.menuBar.getLayout() instanceof UIResource) {
            this.menuBar.setLayout(new DefaultMenuLayout(this.menuBar, 2));
        }
        this.fetchStyle(this.menuBar);
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, inputMap);
        LazyActionMap.installLazyActionMap(this.menuBar, SynthMenuBarUI.class, "MenuBar.actionMap");
    }

    protected void installListeners() {
        this.containerListener = this.createContainerListener();
        this.changeListener = this.createChangeListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().addChangeListener(this.changeListener);
        }
        this.menuBar.addContainerListener(this.containerListener);
        this.menuBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.menuBar, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuBar, 2, null);
        SwingUtilities.replaceUIActionMap(this.menuBar, null);
    }

    protected void uninstallListeners() {
        this.menuBar.removeContainerListener(this.containerListener);
        this.menuBar.removePropertyChangeListener(this.propertyChangeListener);
        for (int i2 = 0; i2 < this.menuBar.getMenuCount(); ++i2) {
            JMenu jMenu = this.menuBar.getMenu(i2);
            if (jMenu == null) continue;
            jMenu.getModel().removeChangeListener(this.changeListener);
        }
        this.containerListener = null;
        this.changeListener = null;
        this.propertyChangeListener = null;
    }

    protected ContainerListener createContainerListener() {
        return new ContainerHandler();
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("takeFocus", new TakeFocus());
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            SynthContext synthContext = this.getContext(this.menuBar, 1);
            Object[] objectArray = (Object[])synthContext.getStyle().get(synthContext, "MenuBar.windowBindings");
            ComponentInputMap componentInputMap = objectArray != null ? LookAndFeel.makeComponentInputMap(this.menuBar, objectArray) : null;
            synthContext.dispose();
            return componentInputMap;
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.menuBar = null;
    }

    private void fetchStyle(JMenuBar jMenuBar) {
        SynthContext synthContext = this.getContext(jMenuBar, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler();
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthMenuBarUI();
    }

    private class ChangeHandler
    implements ChangeListener {
        private ChangeHandler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2 = SynthMenuBarUI.this.menuBar.getMenuCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                JMenu jMenu = SynthMenuBarUI.this.menuBar.getMenu(i2);
                if (jMenu == null || !jMenu.isSelected()) continue;
                SynthMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(i2);
                break;
            }
        }
    }

    private class ContainerHandler
    implements ContainerListener {
        private ContainerHandler() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().addChangeListener(SynthMenuBarUI.this.changeListener);
            }
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (component instanceof JMenu) {
                ((JMenu)component).getModel().removeChangeListener(SynthMenuBarUI.this.changeListener);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthMenuBarUI.this.fetchStyle((JMenuBar)propertyChangeEvent.getSource());
            }
            if (string.equals("componentOrientation") && SynthMenuBarUI.this.menuBar.getLayout() instanceof UIResource) {
                SynthMenuBarUI.this.menuBar.setLayout(new DefaultMenuLayout(SynthMenuBarUI.this.menuBar, 2));
            }
        }
    }

    private static class TakeFocus
    extends AbstractAction {
        TakeFocus() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JMenuBar jMenuBar = (JMenuBar)actionEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            JMenu jMenu = jMenuBar.getMenu(0);
            if (jMenu != null) {
                MenuElement[] menuElementArray = new MenuElement[]{jMenuBar, jMenu, jMenu.getPopupMenu()};
                menuSelectionManager.setSelectedPath(menuElementArray);
            }
        }
    }
}

