/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;
import javax.swing.plaf.UIResource;

class SynthSeparatorUI
extends SeparatorUI
implements PropertyChangeListener,
SynthUI {
    private SynthStyle style;

    SynthSeparatorUI() {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.fetchStyle((JSeparator)propertyChangeEvent.getSource());
        }
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults((JSeparator)jComponent);
        this.installListeners((JSeparator)jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults((JSeparator)jComponent);
        this.uninstallListeners((JSeparator)jComponent);
    }

    private void fetchStyle(JSeparator jSeparator) {
        Dimension dimension;
        SynthContext synthContext = this.getContext(jSeparator, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle && jSeparator instanceof JToolBar.Separator && ((dimension = ((JToolBar.Separator)jSeparator).getSeparatorSize()) == null || dimension instanceof UIResource)) {
            dimension = (Dimension)this.style.get(synthContext, "ToolBar.separatorSize");
            ((JToolBar.Separator)jSeparator).setSeparatorSize(dimension);
        }
        synthContext.dispose();
    }

    public void installDefaults(JSeparator jSeparator) {
        this.fetchStyle(jSeparator);
    }

    public void installListeners(JSeparator jSeparator) {
        jSeparator.addPropertyChangeListener(this);
    }

    public void uninstallDefaults(JSeparator jSeparator) {
        SynthContext synthContext = this.getContext(jSeparator, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    public void uninstallListeners(JSeparator jSeparator) {
        jSeparator.removePropertyChangeListener(this);
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        int n2 = (Integer)synthContext.getStyle().get(synthContext, "Separator.thickness");
        Insets insets = jComponent.getInsets();
        Dimension dimension = ((JSeparator)jComponent).getOrientation() == 1 ? new Dimension(insets.left + insets.right + n2, insets.top + insets.bottom) : new Dimension(insets.left + insets.right, insets.top + insets.bottom + n2);
        synthContext.dispose();
        return dimension;
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        SynthLookAndFeel.paintForeground(synthContext, graphics, null);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSeparatorUI();
    }
}

