/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AiffFileFormat;
import com.sun.media.sound.SunFileReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AiffFileReader
extends SunFileReader {
    private static final int MAX_READ_LENGTH = 8;
    public static final AudioFileFormat.Type[] types = new AudioFileFormat.Type[]{AudioFileFormat.Type.AIFF};

    private double read_ieee_extended(DataInputStream dataInputStream) throws IOException {
        double d2 = 0.0;
        int n2 = 0;
        long l2 = 0L;
        long l3 = 0L;
        double d3 = 3.4028234663852886E38;
        n2 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        long l5 = dataInputStream.readUnsignedShort();
        l2 = l4 << 16 | l5;
        l4 = dataInputStream.readUnsignedShort();
        l5 = dataInputStream.readUnsignedShort();
        l3 = l4 << 16 | l5;
        if (n2 == 0 && l2 == 0L && l3 == 0L) {
            d2 = 0.0;
        } else if (n2 == Short.MAX_VALUE) {
            d2 = d3;
        } else {
            n2 -= 16383;
            d2 = (double)l2 * Math.pow(2.0, n2 -= 31);
            d2 += (double)l3 * Math.pow(2.0, n2 -= 32);
        }
        return d2;
    }

    private void write_ieee_extended(DataOutputStream dataOutputStream, double d2) throws IOException {
        int n2 = 16398;
        double d3 = d2;
        while (d3 < 44000.0) {
            d3 *= 2.0;
            --n2;
        }
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeInt((int)d3 << 16);
        dataOutputStream.writeInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            audioFileFormat = this.getCOMM(fileInputStream, false);
        }
        finally {
            fileInputStream.close();
        }
        return audioFileFormat;
    }

    public AudioFileFormat getAudioFileFormat(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getCOMM(inputStream, true);
        inputStream.reset();
        return audioFileFormat;
    }

    private AudioFileFormat getCOMM(InputStream inputStream, boolean bl2) throws UnsupportedAudioFileException, IOException {
        int n2;
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (bl2) {
            dataInputStream.mark(8);
        }
        int n3 = 0;
        int n4 = 0;
        AudioFormat audioFormat = null;
        int n5 = dataInputStream.readInt();
        if (n5 != 1179603533) {
            if (bl2) {
                dataInputStream.reset();
            }
            throw new UnsupportedAudioFileException("not an AIFF file");
        }
        int n6 = dataInputStream.readInt();
        int n7 = dataInputStream.readInt();
        n3 += 12;
        if (n6 <= 0) {
            n6 = -1;
            n2 = -1;
        } else {
            n2 = n6 + 8;
        }
        boolean bl3 = false;
        if (n7 == 1095321155) {
            bl3 = true;
        }
        boolean bl4 = false;
        while (!bl4) {
            int n8;
            int n9 = dataInputStream.readInt();
            int n10 = dataInputStream.readInt();
            n3 += 8;
            int n11 = 0;
            switch (n9) {
                case 1180058962: {
                    break;
                }
                case 1129270605: {
                    int n12;
                    if (!bl3 && n10 < 18 || bl3 && n10 < 22) {
                        throw new UnsupportedAudioFileException("Invalid AIFF/COMM chunksize");
                    }
                    n8 = dataInputStream.readShort();
                    dataInputStream.readInt();
                    int n13 = dataInputStream.readShort();
                    float f2 = (float)this.read_ieee_extended(dataInputStream);
                    n11 += 18;
                    AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
                    if (bl3) {
                        n12 = dataInputStream.readInt();
                        n11 += 4;
                        switch (n12) {
                            case 1313820229: {
                                encoding = AudioFormat.Encoding.PCM_SIGNED;
                                break;
                            }
                            case 1970037111: {
                                encoding = AudioFormat.Encoding.ULAW;
                                n13 = 8;
                                break;
                            }
                            default: {
                                throw new UnsupportedAudioFileException("Invalid AIFF encoding");
                            }
                        }
                    }
                    n12 = n13 / 8 * n8;
                    audioFormat = new AudioFormat(encoding, f2, n13, n8, n12, f2, true);
                    break;
                }
                case 1397968452: {
                    int n14 = dataInputStream.readInt();
                    int n15 = dataInputStream.readInt();
                    n4 = n10 < n6 ? n10 - n11 : n6 - (n3 + (n11 += 8));
                    bl4 = true;
                }
            }
            n3 += n11;
            if (bl4 || (n8 = n10 - n11) <= 0) continue;
            n3 += dataInputStream.skipBytes(n8);
        }
        if (audioFormat == null) {
            throw new UnsupportedAudioFileException("missing COMM chunk");
        }
        AudioFileFormat.Type type = bl3 ? AudioFileFormat.Type.AIFC : AudioFileFormat.Type.AIFF;
        return new AiffFileFormat(type, n2, audioFormat, n4 / audioFormat.getFrameSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioFileFormat getAudioFileFormat(URL uRL) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = null;
        InputStream inputStream = uRL.openStream();
        try {
            audioFileFormat = this.getCOMM(inputStream, false);
        }
        finally {
            inputStream.close();
        }
        return audioFileFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getCOMM(fileInputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                fileInputStream.close();
            }
        }
        return new AudioInputStream(fileInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    public AudioInputStream getAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        AudioFileFormat audioFileFormat = this.getCOMM(inputStream, true);
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AudioInputStream getAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = uRL.openStream();
        AudioFileFormat audioFileFormat = null;
        try {
            audioFileFormat = this.getCOMM(inputStream, false);
        }
        finally {
            if (audioFileFormat == null) {
                inputStream.close();
            }
        }
        return new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }
}

