/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.EventQueue;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.MenuComponent;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuItemPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;

public class MenuItem
extends MenuComponent
implements Accessible {
    boolean enabled = true;
    String label;
    String actionCommand;
    long eventMask;
    transient ActionListener actionListener;
    private MenuShortcut shortcut = null;
    private static final String base = "menuitem";
    private static int nameCounter;
    private static final long serialVersionUID = -21757335363267194L;
    private int menuItemSerializedDataVersion = 1;

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuItem.initIDs();
        }
        nameCounter = 0;
    }

    public MenuItem() throws HeadlessException {
        this("", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuItem(this);
            }
        }
    }

    public void deleteShortcut() {
        this.shortcut = null;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    public synchronized void disable() {
        this.enabled = false;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.disable();
        }
    }

    public synchronized void enable() {
        this.enabled = true;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.enable();
        }
    }

    private static native void initIDs();

    public boolean isEnabled() {
        return this.enabled;
    }

    protected final void disableEvents(long l2) {
        this.eventMask &= l2 ^ 0xFFFFFFFFFFFFFFFFL;
    }

    protected final void enableEvents(long l2) {
        this.eventMask |= l2;
        this.newEventsOnly = true;
    }

    void doMenuEvent(long l2, int n2) {
        Toolkit.getEventQueue().postEvent(new ActionEvent(this, 1001, this.getActionCommand(), l2, n2));
    }

    public void enable(boolean bl2) {
        if (bl2) {
            this.enable();
        } else {
            this.disable();
        }
    }

    public synchronized void setEnabled(boolean bl2) {
        this.enable(bl2);
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
        }
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public MenuShortcut getShortcut() {
        return this.shortcut;
    }

    void deleteShortcut(MenuShortcut menuShortcut) {
        if (menuShortcut.equals(this.shortcut)) {
            this.shortcut = null;
            MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
            if (menuItemPeer != null) {
                menuItemPeer.setLabel(this.label);
            }
        }
    }

    public void setShortcut(MenuShortcut menuShortcut) {
        this.shortcut = menuShortcut;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(this.label);
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        ActionListener actionListener = this.actionListener;
        if (actionListener != null) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        MenuShortcut menuShortcut = new MenuShortcut(keyEvent.getKeyCode(), (keyEvent.getModifiers() & 1) > 0);
        if (menuShortcut.equals(this.shortcut) && this.enabled) {
            if (keyEvent.getID() == 401) {
                this.doMenuEvent(keyEvent.getWhen(), keyEvent.getModifiers());
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("actionL" == string) {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public String getActionCommand() {
        return this.actionCommand == null ? this.label : this.actionCommand;
    }

    public String getLabel() {
        return this.label;
    }

    public String paramString() {
        String string = ",label=" + this.label;
        if (this.shortcut != null) {
            string = string + ",shortcut=" + this.shortcut;
        }
        return super.paramString() + string;
    }

    public MenuItem(String string) throws HeadlessException {
        this(string, null);
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        MenuItemPeer menuItemPeer = (MenuItemPeer)this.peer;
        if (menuItemPeer != null) {
            menuItemPeer.setLabel(string);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuItem();
        }
        return this.accessibleContext;
    }

    MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        return menuShortcut.equals(this.shortcut) ? this : null;
    }

    public MenuItem(String string, MenuShortcut menuShortcut) throws HeadlessException {
        this.label = string;
        this.shortcut = menuShortcut;
    }

    public EventListener[] getListeners(Class clazz) {
        ActionListener actionListener = null;
        if (clazz == ActionListener.class) {
            actionListener = this.actionListener;
        }
        return AWTEventMulticaster.getListeners(actionListener, clazz);
    }

    protected class AccessibleAWTMenuItem
    extends MenuComponent.AccessibleAWTMenuComponent
    implements AccessibleAction,
    AccessibleValue {
        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                Toolkit.getEventQueue().postEvent(new ActionEvent(MenuItem.this, 1001, MenuItem.this.getActionCommand(), EventQueue.getMostRecentEventTime(), 0));
                return true;
            }
            return false;
        }

        protected AccessibleAWTMenuItem() {
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(0);
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(0);
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (MenuItem.this.getLabel() == null) {
                return super.getAccessibleName();
            }
            return MenuItem.this.getLabel();
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return new String("click");
            }
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }
    }
}

