/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.font.CharArrayIterator;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.font.TextMeasurer;
import java.text.AttributedCharacterIterator;
import java.text.BreakIterator;

public final class LineBreakMeasurer {
    private BreakIterator breakIter;
    private int start;
    private int pos;
    private int limit;
    private TextMeasurer measurer;
    private CharArrayIterator charIter;

    public int getPosition() {
        return this.pos;
    }

    public int nextOffset(float f2) {
        return this.nextOffset(f2, this.limit, false);
    }

    public int nextOffset(float f2, int n2, boolean bl2) {
        int n3 = this.pos;
        if (this.pos < this.limit) {
            if (n2 <= this.pos) {
                throw new IllegalArgumentException("offsetLimit must be after current position");
            }
            int n4 = this.measurer.getLineBreakIndex(this.pos, f2);
            if (n4 == this.limit) {
                n3 = this.limit;
            } else if (Character.isWhitespace(this.measurer.getChars()[n4 - this.start])) {
                n3 = this.breakIter.following(n4);
            } else {
                int n5 = n4 + 1;
                if (n5 == this.limit) {
                    this.breakIter.last();
                    n3 = this.breakIter.previous();
                } else {
                    n3 = this.breakIter.preceding(n5);
                }
                if (n3 <= this.pos) {
                    n3 = bl2 ? this.pos : Math.max(this.pos + 1, n4);
                }
            }
        }
        if (n3 > n2) {
            n3 = n2;
        }
        return n3;
    }

    public void setPosition(int n2) {
        if (n2 < this.start || n2 > this.limit) {
            throw new IllegalArgumentException("position is out of range");
        }
        this.pos = n2;
    }

    public TextLayout nextLayout(float f2) {
        return this.nextLayout(f2, this.limit, false);
    }

    public TextLayout nextLayout(float f2, int n2, boolean bl2) {
        if (this.pos < this.limit) {
            int n3 = this.nextOffset(f2, n2, bl2);
            if (n3 == this.pos) {
                return null;
            }
            TextLayout textLayout = this.measurer.getLayout(this.pos, n3);
            this.pos = n3;
            return textLayout;
        }
        return null;
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n2) {
        this.measurer.deleteChar(attributedCharacterIterator, n2);
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
        this.charIter.reset(this.measurer.getChars(), this.start);
        this.breakIter.setText(this.charIter);
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n2) {
        this.measurer.insertChar(attributedCharacterIterator, n2);
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
        this.charIter.reset(this.measurer.getChars(), attributedCharacterIterator.getBeginIndex());
        this.breakIter.setText(this.charIter);
    }

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this(attributedCharacterIterator, BreakIterator.getLineInstance(), fontRenderContext);
    }

    public LineBreakMeasurer(AttributedCharacterIterator attributedCharacterIterator, BreakIterator breakIterator, FontRenderContext fontRenderContext) {
        if (attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex() < 1) {
            throw new IllegalArgumentException("Text must contain at least one character.");
        }
        this.breakIter = breakIterator;
        this.measurer = new TextMeasurer(attributedCharacterIterator, fontRenderContext);
        this.limit = attributedCharacterIterator.getEndIndex();
        this.pos = this.start = attributedCharacterIterator.getBeginIndex();
        this.charIter = new CharArrayIterator(this.measurer.getChars(), this.start);
        this.breakIter.setText(this.charIter);
    }
}

