/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import sun.security.action.GetPropertyAction;

public class BufferedWriter
extends Writer {
    private Writer out;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static int defaultCharBufferSize = 8192;
    private String lineSeparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flushBuffer();
            this.out.close();
            this.out = null;
            this.cb = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flushBuffer();
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushBuffer() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar == 0) {
                return;
            }
            this.out.write(this.cb, 0, this.nextChar);
            this.nextChar = 0;
        }
    }

    public void newLine() throws IOException {
        this.write(this.lineSeparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (this.nextChar >= this.nChars) {
                this.flushBuffer();
            }
            this.cb[this.nextChar++] = (char)n2;
        }
    }

    private int min(int n2, int n3) {
        if (n2 < n3) {
            return n2;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(char[] cArray, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n3 == 0) {
                return;
            }
            if (n3 >= this.nChars) {
                this.flushBuffer();
                this.out.write(cArray, n2, n3);
                return;
            }
            int n4 = n2;
            int n5 = n2 + n3;
            while (n4 < n5) {
                int n6 = this.min(this.nChars - this.nextChar, n5 - n4);
                System.arraycopy(cArray, n4, this.cb, this.nextChar, n6);
                n4 += n6;
                this.nextChar += n6;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }

    public BufferedWriter(Writer writer) {
        this(writer, defaultCharBufferSize);
    }

    public BufferedWriter(Writer writer, int n2) {
        super(writer);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.out = writer;
        this.cb = new char[n2];
        this.nChars = n2;
        this.nextChar = 0;
        this.lineSeparator = (String)AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n2, int n3) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            int n4 = n2;
            int n5 = n2 + n3;
            while (n4 < n5) {
                int n6 = this.min(this.nChars - this.nextChar, n5 - n4);
                string.getChars(n4, n4 + n6, this.cb, this.nextChar);
                n4 += n6;
                this.nextChar += n6;
                if (this.nextChar < this.nChars) continue;
                this.flushBuffer();
            }
        }
    }
}

