/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;

abstract class FileSystem {
    public static final int BA_EXISTS = 1;
    public static final int BA_REGULAR = 2;
    public static final int BA_DIRECTORY = 4;
    public static final int BA_HIDDEN = 8;
    static boolean useCanonCaches = true;
    static boolean useCanonPrefixCache = true;

    public abstract char getPathSeparator();

    public abstract char getSeparator();

    static {
        useCanonCaches = FileSystem.getBooleanProperty("sun.io.useCanonCaches", useCanonCaches);
        useCanonPrefixCache = FileSystem.getBooleanProperty("sun.io.useCanonPrefixCache", useCanonPrefixCache);
    }

    FileSystem() {
    }

    public abstract File[] listRoots();

    public abstract int getBooleanAttributes(File var1);

    public abstract int hashCode(File var1);

    public abstract long getLastModifiedTime(File var1);

    public abstract long getLength(File var1);

    public abstract boolean createDirectory(File var1);

    public abstract boolean delete(File var1);

    public abstract boolean deleteOnExit(File var1);

    public abstract boolean isAbsolute(File var1);

    public abstract boolean setReadOnly(File var1);

    public abstract boolean setLastModifiedTime(File var1, long var2);

    public abstract boolean checkAccess(File var1, boolean var2);

    public static native FileSystem getFileSystem();

    public abstract String getDefaultParent();

    public abstract int prefixLength(String var1);

    public abstract boolean createFileExclusively(String var1) throws IOException;

    private static boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = System.getProperty("sun.io.useCanonCaches");
        if (string2 == null) {
            return bl2;
        }
        return string2.equalsIgnoreCase("true");
    }

    public abstract int compare(File var1, File var2);

    public abstract boolean rename(File var1, File var2);

    public abstract String resolve(File var1);

    public abstract String[] list(File var1);

    public abstract String canonicalize(String var1) throws IOException;

    public abstract String fromURIPath(String var1);

    public abstract String normalize(String var1);

    public abstract String resolve(String var1, String var2);
}

