/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.SocketPermissionCollection;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.StringTokenizer;
import sun.net.www.URLConnection;
import sun.security.action.GetBooleanAction;
import sun.security.util.Debug;

public final class SocketPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -7204263841984476862L;
    private static final int CONNECT = 1;
    private static final int LISTEN = 2;
    private static final int ACCEPT = 4;
    private static final int RESOLVE = 8;
    private static final int NONE = 0;
    private static final int ALL = 15;
    private static final int PORT_MIN = 0;
    private static final int PORT_MAX = 65535;
    private static final int PRIV_PORT_MAX = 1023;
    private transient int mask;
    private String actions;
    private transient String hostname;
    private transient String cname;
    private transient InetAddress[] addresses;
    private transient boolean wildcard;
    private transient boolean init_with_ip;
    private transient boolean invalid;
    private transient int[] portrange;
    private transient boolean defaultDeny = false;
    private transient boolean untrusted;
    private static boolean trustProxy;
    private static boolean trustNameService;
    private static Debug debug;
    private static boolean debugInit;

    int getMask() {
        return this.mask;
    }

    public int hashCode() {
        if (this.init_with_ip || this.wildcard) {
            return this.getName().hashCode();
        }
        try {
            this.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (this.invalid || this.cname == null) {
            return this.getName().hashCode();
        }
        return this.cname.hashCode();
    }

    static {
        debug = null;
        debugInit = false;
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("trustProxy"));
        trustProxy = bl2;
        bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.net.trustNameService"));
        trustNameService = bl2;
    }

    void getCanonName() throws UnknownHostException {
        if (this.cname != null || this.invalid || this.untrusted) {
            return;
        }
        try {
            if (this.addresses == null) {
                this.getIP();
            }
            if (this.init_with_ip) {
                this.cname = this.addresses[0].getHostName(false).toLowerCase();
            } else {
                this.cname = InetAddress.getByName(this.addresses[0].getHostAddress()).getHostName(false).toLowerCase();
                if (!(trustNameService || !URLConnection.isProxiedHost(this.hostname) || this.match(this.cname, this.hostname) || !this.defaultDeny && this.cname.equals(this.addresses[0].getHostAddress()) || this.authorized(this.hostname, this.addresses[0].getAddress()))) {
                    this.untrusted = true;
                    Debug debug = SocketPermission.getDebug();
                    if (debug != null && Debug.isOn("failure")) {
                        debug.println("socket access restriction: proxied host (" + this.addresses[0] + ")" + " does not match " + this.cname + " from reverse lookup");
                    }
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
    }

    void getIP() throws UnknownHostException {
        if (this.addresses != null || this.wildcard || this.invalid) {
            return;
        }
        try {
            int n2;
            String string = this.getName().charAt(0) == '[' ? this.getName().substring(1, this.getName().indexOf(93)) : ((n2 = this.getName().indexOf(":")) == -1 ? this.getName() : this.getName().substring(0, n2));
            this.addresses = new InetAddress[]{InetAddress.getAllByName0(string, false)[0]};
        }
        catch (UnknownHostException unknownHostException) {
            this.invalid = true;
            throw unknownHostException;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.invalid = true;
            throw new UnknownHostException(this.getName());
        }
    }

    private void setDeny() {
        this.defaultDeny = true;
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName(), SocketPermission.getMask(this.actions));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)object;
        if (this.mask != socketPermission.mask) {
            return false;
        }
        if ((socketPermission.mask & 8) != socketPermission.mask && (this.portrange[0] != socketPermission.portrange[0] || this.portrange[1] != socketPermission.portrange[1])) {
            return false;
        }
        if (this.getName().equalsIgnoreCase(socketPermission.getName())) {
            return true;
        }
        try {
            this.getCanonName();
            socketPermission.getCanonName();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.invalid || socketPermission.invalid) {
            return false;
        }
        if (this.cname != null) {
            return this.cname.equalsIgnoreCase(socketPermission.cname);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            this.actions = SocketPermission.getActions(this.mask);
        }
        return this.actions;
    }

    private static String getActions(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
            stringBuffer.append("connect");
        }
        if ((n2 & 2) == 2) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("listen");
        }
        if ((n2 & 4) == 4) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("accept");
        }
        if ((n2 & 8) == 8) {
            if (bl2) {
                stringBuffer.append(',');
            } else {
                bl2 = true;
            }
            stringBuffer.append("resolve");
        }
        return stringBuffer.toString();
    }

    private static int getMask(String string) {
        if (string == null) {
            throw new NullPointerException("action can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("action can't be empty");
        }
        int n2 = 0;
        if (string == "resolve") {
            return 8;
        }
        if (string == "connect") {
            return 1;
        }
        if (string == "listen") {
            return 2;
        }
        if (string == "accept") {
            return 4;
        }
        if (string == "connect,accept") {
            return 5;
        }
        char[] cArray = string.toCharArray();
        int n3 = cArray.length - 1;
        if (n3 < 0) {
            return n2;
        }
        while (n3 != -1) {
            int n4;
            char c2;
            while (n3 != -1 && ((c2 = cArray[n3]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --n3;
            }
            if (!(n3 < 6 || cArray[n3 - 6] != 'c' && cArray[n3 - 6] != 'C' || cArray[n3 - 5] != 'o' && cArray[n3 - 5] != 'O' || cArray[n3 - 4] != 'n' && cArray[n3 - 4] != 'N' || cArray[n3 - 3] != 'n' && cArray[n3 - 3] != 'N' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'c' && cArray[n3 - 1] != 'C' || cArray[n3] != 't' && cArray[n3] != 'T')) {
                n4 = 7;
                n2 |= 1;
            } else if (!(n3 < 6 || cArray[n3 - 6] != 'r' && cArray[n3 - 6] != 'R' || cArray[n3 - 5] != 'e' && cArray[n3 - 5] != 'E' || cArray[n3 - 4] != 's' && cArray[n3 - 4] != 'S' || cArray[n3 - 3] != 'o' && cArray[n3 - 3] != 'O' || cArray[n3 - 2] != 'l' && cArray[n3 - 2] != 'L' || cArray[n3 - 1] != 'v' && cArray[n3 - 1] != 'V' || cArray[n3] != 'e' && cArray[n3] != 'E')) {
                n4 = 7;
                n2 |= 8;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'l' && cArray[n3 - 5] != 'L' || cArray[n3 - 4] != 'i' && cArray[n3 - 4] != 'I' || cArray[n3 - 3] != 's' && cArray[n3 - 3] != 'S' || cArray[n3 - 2] != 't' && cArray[n3 - 2] != 'T' || cArray[n3 - 1] != 'e' && cArray[n3 - 1] != 'E' || cArray[n3] != 'n' && cArray[n3] != 'N')) {
                n4 = 6;
                n2 |= 2;
            } else if (!(n3 < 5 || cArray[n3 - 5] != 'a' && cArray[n3 - 5] != 'A' || cArray[n3 - 4] != 'c' && cArray[n3 - 4] != 'C' || cArray[n3 - 3] != 'c' && cArray[n3 - 3] != 'C' || cArray[n3 - 2] != 'e' && cArray[n3 - 2] != 'E' || cArray[n3 - 1] != 'p' && cArray[n3 - 1] != 'P' || cArray[n3] != 't' && cArray[n3] != 'T')) {
                n4 = 6;
                n2 |= 4;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl2 = false;
            while (n3 >= n4 && !bl2) {
                switch (cArray[n3 - n4]) {
                    case ',': {
                        bl2 = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n3;
            }
            n3 -= n4;
        }
        return n2;
    }

    private int[] parsePort(String string) throws Exception {
        if (string == null || string.equals("") || string.equals("*")) {
            return new int[]{0, 65535};
        }
        int n2 = string.indexOf(45);
        if (n2 == -1) {
            int n3 = Integer.parseInt(string);
            return new int[]{n3, n3};
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1);
        int n4 = string2.equals("") ? 0 : Integer.parseInt(string2);
        int n5 = string3.equals("") ? 65535 : Integer.parseInt(string3);
        if (n4 < 0 || n5 < 0 || n5 < n4) {
            throw new IllegalArgumentException("invalid port range");
        }
        return new int[]{n4, n5};
    }

    SocketPermission(String string, int n2) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), n2);
    }

    private void init(String string, int n2) {
        char c2;
        if ((n2 & 0xF) != n2) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.mask = n2 | 8;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        String string2 = string;
        if (string.charAt(0) == '[') {
            n4 = 1;
            n3 = string.indexOf(93);
            if (n3 == -1) {
                throw new IllegalArgumentException("invalid host/port: " + string);
            }
            string = string.substring(n4, n3);
            n6 = string2.indexOf(58, n3 + 1);
        } else {
            n4 = 0;
            n5 = n6 = string.indexOf(58, n3);
            if (n6 != -1) {
                string = string.substring(n4, n5);
            }
        }
        if (n6 != -1) {
            String string3 = string2.substring(n6 + 1);
            try {
                this.portrange = this.parsePort(string3);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("invalid port range: " + string3);
            }
        } else {
            this.portrange = new int[]{0, 65535};
        }
        this.hostname = string;
        if (string.lastIndexOf(42) > 0) {
            throw new IllegalArgumentException("invalid host wildcard specification");
        }
        if (string.startsWith("*")) {
            this.wildcard = true;
            if (string.equals("*")) {
                this.cname = "";
            } else if (string.startsWith("*.")) {
                this.cname = string.substring(1).toLowerCase();
            } else {
                throw new IllegalArgumentException("invalid host wildcard specification");
            }
            return;
        }
        if (string.length() > 0 && ((c2 = string.charAt(0)) == ':' || Character.digit(c2, 16) != -1)) {
            byte[] byArray = Inet4Address.textToNumericFormat(string);
            if (byArray == null) {
                byArray = Inet6Address.textToNumericFormat(string);
            }
            if (byArray != null) {
                try {
                    this.addresses = new InetAddress[]{InetAddress.getByAddress(byArray)};
                    this.init_with_ip = true;
                }
                catch (UnknownHostException unknownHostException) {
                    this.invalid = true;
                }
            }
        }
    }

    private boolean authorized(String string, byte[] byArray) {
        if (byArray.length == 4) {
            return this.authorizedIPv4(string, byArray);
        }
        if (byArray.length == 16) {
            return this.authorizedIPv6(string, byArray);
        }
        return false;
    }

    private boolean authorizedIPv4(String string, byte[] byArray) {
        String string2 = "";
        try {
            string2 = "auth." + (byArray[3] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[0] & 0xFF) + ".in-addr.arpa";
            string2 = this.hostname + '.' + string2;
            InetAddress inetAddress = InetAddress.getAllByName0(string2, false)[0];
            if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                return true;
            }
            Debug debug = SocketPermission.getDebug();
            if (debug != null && Debug.isOn("failure")) {
                debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
            }
        }
        catch (UnknownHostException unknownHostException) {
            Debug debug = SocketPermission.getDebug();
            if (debug != null && Debug.isOn("failure")) {
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private boolean authorizedIPv6(String string, byte[] byArray) {
        String string2 = "";
        try {
            StringBuffer stringBuffer = new StringBuffer(39);
            for (int i2 = 15; i2 >= 0; --i2) {
                stringBuffer.append(Integer.toHexString(byArray[i2] & 0xF));
                stringBuffer.append('.');
                stringBuffer.append(Integer.toHexString(byArray[i2] >> 4 & 0xF));
                stringBuffer.append('.');
            }
            string2 = "auth." + stringBuffer.toString() + "IP6.ARPA";
            string2 = this.hostname + '.' + string2;
            InetAddress inetAddress = InetAddress.getAllByName0(string2, false)[0];
            if (inetAddress.equals(InetAddress.getByAddress(byArray))) {
                return true;
            }
            Debug debug = SocketPermission.getDebug();
            if (debug != null && Debug.isOn("failure")) {
                debug.println("socket access restriction: IP address of " + inetAddress + " != " + InetAddress.getByAddress(byArray));
            }
        }
        catch (UnknownHostException unknownHostException) {
            Debug debug = SocketPermission.getDebug();
            if (debug != null && Debug.isOn("failure")) {
                debug.println("socket access restriction: forward lookup failed for " + string2);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    boolean impliesIgnoreMask(SocketPermission socketPermission) {
        block21: {
            if ((socketPermission.mask & 8) != socketPermission.mask && (socketPermission.portrange[0] < this.portrange[0] || socketPermission.portrange[1] > this.portrange[1])) {
                return false;
            }
            if (this.wildcard && "".equals(this.cname)) {
                return true;
            }
            if (this.invalid || socketPermission.invalid) {
                return trustProxy ? this.inProxyWeTrust(socketPermission) : false;
            }
            try {
                if (this.init_with_ip) {
                    if (socketPermission.wildcard) {
                        return false;
                    }
                    if (socketPermission.init_with_ip) {
                        return this.addresses[0].equals(socketPermission.addresses[0]);
                    }
                    if (socketPermission.addresses == null) {
                        socketPermission.getIP();
                    }
                    for (int i2 = 0; i2 < socketPermission.addresses.length; ++i2) {
                        if (!this.addresses[0].equals(socketPermission.addresses[i2])) continue;
                        return true;
                    }
                    return false;
                }
                if (this.wildcard || socketPermission.wildcard) {
                    if (this.wildcard && socketPermission.wildcard) {
                        return socketPermission.cname.endsWith(this.cname);
                    }
                    if (socketPermission.wildcard) {
                        return false;
                    }
                    if (socketPermission.cname == null) {
                        socketPermission.getCanonName();
                    }
                    return socketPermission.cname.endsWith(this.cname);
                }
                if (this.cname == null) {
                    this.getCanonName();
                }
                if (this.addresses == null) {
                    this.getIP();
                }
                if (socketPermission.addresses == null) {
                    socketPermission.getIP();
                }
                if (!socketPermission.init_with_ip || !this.untrusted) {
                    for (int i3 = 0; i3 < this.addresses.length; ++i3) {
                        for (int i4 = 0; i4 < socketPermission.addresses.length; ++i4) {
                            if (!this.addresses[i3].equals(socketPermission.addresses[i4])) continue;
                            return true;
                        }
                    }
                    if (socketPermission.cname == null) {
                        socketPermission.getCanonName();
                    }
                    return this.cname.equalsIgnoreCase(socketPermission.cname);
                }
            }
            catch (UnknownHostException unknownHostException) {
                if (!trustProxy) break block21;
                return this.inProxyWeTrust(socketPermission);
            }
        }
        return false;
    }

    private boolean inProxyWeTrust(SocketPermission socketPermission) {
        String string = this.hostname;
        String string2 = socketPermission.hostname;
        if (string == null) {
            return false;
        }
        return string.equalsIgnoreCase(string2);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof SocketPermission)) {
            return false;
        }
        SocketPermission socketPermission = (SocketPermission)permission;
        return (this.mask & socketPermission.mask) == socketPermission.mask && this.impliesIgnoreMask(socketPermission);
    }

    public PermissionCollection newPermissionCollection() {
        return new SocketPermissionCollection();
    }

    private static synchronized Debug getDebug() {
        if (!debugInit) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    private String fragment(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        if (n2 == 0) {
            return "";
        }
        if (n2 == string.length() - 1) {
            string = string.substring(0, string.length() - 1);
            n2 = string.lastIndexOf(46);
        }
        if (n2 < 1) {
            return "";
        }
        int n3 = string.lastIndexOf(46, n2 - 1);
        if (n3 == -1) {
            return string;
        }
        if (string.length() - n2 <= 3 && n2 - n3 <= 4 && n3 > 0) {
            String string2;
            if (!(n2 - n3 != 4 || (string2 = string.substring(n3 + 1, n2)).equals("com") || string2.equals("org") || string2.equals("edu"))) {
                return string.substring(n3 + 1);
            }
            int n4 = string.lastIndexOf(46, n3 - 1);
            if (n4 == -1) {
                return string.substring(n3 + 1);
            }
            return string.substring(n4 + 1);
        }
        return string.substring(n3 + 1);
    }

    private static String getHost(String string) {
        int n2;
        if (string.equals("")) {
            return "localhost";
        }
        if (string.charAt(0) != '[' && (n2 = string.indexOf(58)) != string.lastIndexOf(58)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            int n3 = stringTokenizer.countTokens();
            if (n3 == 9) {
                n2 = string.lastIndexOf(58);
                string = "[" + string.substring(0, n2) + "]" + string.substring(n2);
            } else if (n3 == 8 && string.indexOf("::") == -1) {
                string = "[" + string + "]";
            } else {
                throw new IllegalArgumentException("Ambiguous hostport part");
            }
        }
        return string;
    }

    public SocketPermission(String string, String string2) {
        super(SocketPermission.getHost(string));
        this.init(this.getName(), SocketPermission.getMask(string2));
    }

    private boolean match(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.startsWith(string3 = string2.toLowerCase()) && (string4.length() == string3.length() || string4.charAt(string3.length()) == '.')) {
            return true;
        }
        if (string3.endsWith(".akamai.net") || string3.endsWith(".akamai.com")) {
            return true;
        }
        String string5 = this.fragment(string4);
        String string6 = this.fragment(string3);
        return string5.length() != 0 && string6.length() != 0 && this.fragment(string4).equals(this.fragment(string3));
    }
}

