/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public class URLEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    static {
        int n2;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (n2 = 97; n2 <= 122; ++n2) {
            dontNeedEncoding.set(n2);
        }
        for (n2 = 65; n2 <= 90; ++n2) {
            dontNeedEncoding.set(n2);
        }
        for (n2 = 48; n2 <= 57; ++n2) {
            dontNeedEncoding.set(n2);
        }
        dontNeedEncoding.set(32);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
        dfltEncName = (String)AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }

    private URLEncoder() {
    }

    public static String encode(String string) {
        String string2 = null;
        try {
            string2 = URLEncoder.encode(string, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string2;
    }

    public static String encode(String string, String string2) throws UnsupportedEncodingException {
        Charset charset;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        if (string2 == null) {
            throw new NullPointerException("charsetName");
        }
        try {
            charset = Charset.forName(string2);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            throw new UnsupportedEncodingException(string2);
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            throw new UnsupportedEncodingException(string2);
        }
        int n2 = 0;
        while (n2 < string.length()) {
            char c2;
            int n3 = string.charAt(n2);
            if (dontNeedEncoding.get(n3)) {
                if (n3 == 32) {
                    n3 = 43;
                    bl2 = true;
                }
                stringBuffer.append((char)n3);
                ++n2;
                continue;
            }
            do {
                char c3;
                charArrayWriter.write(n3);
                if (n3 >= 55296 && n3 <= 56319 && n2 + 1 < string.length() && (c3 = string.charAt(n2 + 1)) >= '\udc00' && c3 <= '\udfff') {
                    charArrayWriter.write(c3);
                    ++n2;
                }
                if (++n2 >= string.length()) break;
                c2 = string.charAt(n2);
                n3 = c2;
            } while (!dontNeedEncoding.get(c2));
            charArrayWriter.flush();
            String string3 = new String(charArrayWriter.toCharArray());
            byte[] byArray = string3.getBytes(charset.name());
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append('%');
                char c4 = Character.forDigit(byArray[i2] >> 4 & 0xF, 16);
                if (Character.isLetter(c4)) {
                    c4 = (char)(c4 - 32);
                }
                stringBuffer.append(c4);
                c4 = Character.forDigit(byArray[i2] & 0xF, 16);
                if (Character.isLetter(c4)) {
                    c4 = (char)(c4 - 32);
                }
                stringBuffer.append(c4);
            }
            charArrayWriter.reset();
            bl2 = true;
        }
        return bl2 ? stringBuffer.toString() : string;
    }
}

