/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    private static final String uiClassID = "TextPaneUI";

    public JTextPane() {
        this.setEditorKit(this.createDefaultEditorKit());
    }

    public void insertComponent(Component component) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setComponent(mutableAttributeSet, component);
        this.replaceSelection(" ", mutableAttributeSet.copyAttributes());
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        return super.paramString();
    }

    public void removeStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.removeStyle(string);
    }

    public void replaceSelection(String string) {
        this.replaceSelection(string, null);
    }

    public void insertIcon(Icon icon) {
        MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        StyleConstants.setIcon(mutableAttributeSet, icon);
        this.replaceSelection(" ", mutableAttributeSet.copyAttributes());
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getCharacterElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument styledDocument = this.getStyledDocument();
        Element element = styledDocument.getParagraphElement(this.getCaretPosition());
        if (element != null) {
            return element.getAttributes();
        }
        return null;
    }

    public void setCharacterAttributes(AttributeSet attributeSet, boolean bl2) {
        int n2;
        int n3 = this.getSelectionStart();
        if (n3 != (n2 = this.getSelectionEnd())) {
            StyledDocument styledDocument = this.getStyledDocument();
            styledDocument.setCharacterAttributes(n3, n2 - n3, attributeSet, bl2);
        } else {
            MutableAttributeSet mutableAttributeSet = this.getInputAttributes();
            if (bl2) {
                mutableAttributeSet.removeAttributes(mutableAttributeSet);
            }
            mutableAttributeSet.addAttributes(attributeSet);
        }
    }

    public void setParagraphAttributes(AttributeSet attributeSet, boolean bl2) {
        int n2 = this.getSelectionStart();
        int n3 = this.getSelectionEnd();
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setParagraphAttributes(n2, n3 - n2, attributeSet, bl2);
    }

    public void setDocument(Document document) {
        if (!(document instanceof StyledDocument)) {
            throw new IllegalArgumentException("Model must be StyledDocument");
        }
        super.setDocument(document);
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit editorKit) {
        if (!(editorKit instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("Must be StyledEditorKit");
        }
        super.setEditorKit(editorKit);
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    public Style getLogicalStyle() {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getLogicalStyle(this.getCaretPosition());
    }

    public void setLogicalStyle(Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        styledDocument.setLogicalStyle(this.getCaretPosition(), style);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)this.getDocument();
    }

    public JTextPane(StyledDocument styledDocument) {
        this();
        this.setStyledDocument(styledDocument);
    }

    public void setStyledDocument(StyledDocument styledDocument) {
        super.setDocument(styledDocument);
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    private void replaceSelection(String string, AttributeSet attributeSet) {
        if (!this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        StyledDocument styledDocument = this.getStyledDocument();
        if (styledDocument != null) {
            try {
                Caret caret = this.getCaret();
                int n2 = Math.min(caret.getDot(), caret.getMark());
                int n3 = Math.max(caret.getDot(), caret.getMark());
                if (styledDocument instanceof AbstractDocument) {
                    ((AbstractDocument)((Object)styledDocument)).replace(n2, n3 - n2, string, attributeSet != null ? attributeSet : this.getInputAttributes());
                } else {
                    if (n2 != n3) {
                        styledDocument.remove(n2, n3 - n2);
                    }
                    if (string != null && string.length() > 0) {
                        styledDocument.insertString(n2, string, attributeSet != null ? attributeSet : this.getInputAttributes());
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        }
    }

    public Style getStyle(String string) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.getStyle(string);
    }

    public Style addStyle(String string, Style style) {
        StyledDocument styledDocument = this.getStyledDocument();
        return styledDocument.addStyle(string, style);
    }
}

