/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

class SmartGridLayout
implements LayoutManager,
Serializable {
    int rows = 2;
    int columns = 2;
    int xGap = 2;
    int yGap = 2;
    int componentCount = 0;
    Component[][] layoutGrid;

    private int computeColumnWidth(int n2) {
        int n3 = 1;
        for (int i2 = 0; i2 < this.rows; ++i2) {
            int n4 = this.layoutGrid[n2][i2].getPreferredSize().width;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    private int computeRowHeight(int n2) {
        int n3 = 1;
        for (int i2 = 0; i2 < this.columns; ++i2) {
            int n4 = this.layoutGrid[i2][n2].getPreferredSize().height;
            if (n4 <= n3) continue;
            n3 = n4;
        }
        return n3;
    }

    public SmartGridLayout(int n2, int n3) {
        this.rows = n3;
        this.columns = n2;
        this.layoutGrid = new Component[n2][n3];
    }

    public void removeLayoutComponent(Component component) {
    }

    private void buildLayoutGrid(Container container) {
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            int n2 = 0;
            int n3 = 0;
            if (i2 != 0) {
                n3 = i2 % this.columns;
                n2 = (i2 - n3) / this.columns;
            }
            this.layoutGrid[n3][n2] = componentArray[i2];
        }
    }

    public void layoutContainer(Container container) {
        int n2;
        this.buildLayoutGrid(container);
        int[] nArray = new int[this.rows];
        int[] nArray2 = new int[this.columns];
        for (n2 = 0; n2 < this.rows; ++n2) {
            nArray[n2] = this.computeRowHeight(n2);
        }
        for (n2 = 0; n2 < this.columns; ++n2) {
            nArray2[n2] = this.computeColumnWidth(n2);
        }
        Insets insets = container.getInsets();
        if (container.getComponentOrientation().isLeftToRight()) {
            int n3 = insets.left;
            for (int i2 = 0; i2 < this.columns; ++i2) {
                int n4 = insets.top;
                for (int i3 = 0; i3 < this.rows; ++i3) {
                    Component component = this.layoutGrid[i2][i3];
                    component.setBounds(n3, n4, nArray2[i2], nArray[i3]);
                    n4 += nArray[i3] + this.yGap;
                }
                n3 += nArray2[i2] + this.xGap;
            }
        } else {
            int n5 = container.getWidth() - insets.right;
            for (int i4 = 0; i4 < this.columns; ++i4) {
                int n6 = insets.top;
                n5 -= nArray2[i4];
                for (int i5 = 0; i5 < this.rows; ++i5) {
                    Component component = this.layoutGrid[i4][i5];
                    component.setBounds(n5, n6, nArray2[i4], nArray[i5]);
                    n6 += nArray[i5] + this.yGap;
                }
                n5 -= this.xGap;
            }
        }
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        int n2;
        this.buildLayoutGrid(container);
        Insets insets = container.getInsets();
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.rows; ++n2) {
            n3 += this.computeRowHeight(n2);
        }
        for (n2 = 0; n2 < this.columns; ++n2) {
            n4 += this.computeColumnWidth(n2);
        }
        return new Dimension(n4 += this.xGap * (this.columns - 1) + insets.right + insets.left, n3 += this.yGap * (this.rows - 1) + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }
}

