/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalSplitPaneDivider
extends BasicSplitPaneDivider {
    private MetalBumps bumps = new MetalBumps(10, 10, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow(), MetalLookAndFeel.getControl());
    private MetalBumps focusBumps = new MetalBumps(10, 10, MetalLookAndFeel.getPrimaryControlHighlight(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControl());
    private int inset = 2;
    private Color controlColor = MetalLookAndFeel.getControl();
    private Color primaryControlColor = MetalLookAndFeel.getPrimaryControl();

    int getOneTouchOffsetFromSuper() {
        return 2;
    }

    int getOneTouchSizeFromSuper() {
        return 6;
    }

    int getOrientationFromSuper() {
        return this.orientation;
    }

    public void paint(Graphics graphics) {
        MetalBumps metalBumps;
        if (this.splitPane.hasFocus()) {
            metalBumps = this.focusBumps;
            graphics.setColor(this.primaryControlColor);
        } else {
            metalBumps = this.bumps;
            graphics.setColor(this.controlColor);
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getInsets();
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        Dimension dimension = this.getSize();
        dimension.width -= this.inset * 2;
        dimension.height -= this.inset * 2;
        int n2 = this.inset;
        int n3 = this.inset;
        if (insets != null) {
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            n2 += insets.left;
            n3 += insets.top;
        }
        metalBumps.setBumpArea(dimension);
        metalBumps.paintIcon(this, graphics, n2, n3);
        super.paint(graphics);
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){
            int[][] buffer = new int[][]{{0, 0, 0, 2, 2, 0, 0, 0, 0}, {0, 0, 2, 1, 1, 1, 0, 0, 0}, {0, 2, 1, 1, 1, 1, 1, 0, 0}, {2, 1, 1, 1, 1, 1, 1, 1, 0}, {0, 3, 3, 3, 3, 3, 3, 3, 3}};

            public boolean isFocusTraversable() {
                return false;
            }

            public void paint(Graphics graphics) {
                block7: {
                    JSplitPane jSplitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (jSplitPane == null) break block7;
                    int n2 = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n3 = MetalSplitPaneDivider.this.getOrientationFromSuper();
                    int n4 = Math.min(MetalSplitPaneDivider.this.getDividerSize(), n2);
                    Color[] colorArray = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colorArray[1] = colorArray[2];
                    }
                    if (n3 == 0) {
                        for (int i2 = 1; i2 <= this.buffer[0].length; ++i2) {
                            for (int i3 = 1; i3 < n4; ++i3) {
                                if (this.buffer[i3 - 1][i2 - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[i3 - 1][i2 - 1]]);
                                graphics.drawLine(i2, i3, i2, i3);
                            }
                        }
                    } else {
                        for (int i4 = 1; i4 <= this.buffer[0].length; ++i4) {
                            for (int i5 = 1; i5 < n4; ++i5) {
                                if (this.buffer[i5 - 1][i4 - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[i5 - 1][i4 - 1]]);
                                graphics.drawLine(i5, i4, i5, i4);
                            }
                        }
                    }
                }
            }

            public void setBorder(Border border) {
            }
        };
        jButton.setRequestFocusEnabled(false);
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){
            int[][] buffer = new int[][]{{2, 2, 2, 2, 2, 2, 2, 2}, {0, 1, 1, 1, 1, 1, 1, 3}, {0, 0, 1, 1, 1, 1, 3, 0}, {0, 0, 0, 1, 1, 3, 0, 0}, {0, 0, 0, 0, 3, 0, 0, 0}};

            public boolean isFocusTraversable() {
                return false;
            }

            public void paint(Graphics graphics) {
                block7: {
                    JSplitPane jSplitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
                    if (jSplitPane == null) break block7;
                    int n2 = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
                    int n3 = MetalSplitPaneDivider.this.getOrientationFromSuper();
                    int n4 = Math.min(MetalSplitPaneDivider.this.getDividerSize(), n2);
                    Color[] colorArray = new Color[]{this.getBackground(), MetalLookAndFeel.getPrimaryControlDarkShadow(), MetalLookAndFeel.getPrimaryControlInfo(), MetalLookAndFeel.getPrimaryControlHighlight()};
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.getModel().isPressed()) {
                        colorArray[1] = colorArray[2];
                    }
                    if (n3 == 0) {
                        for (int i2 = 1; i2 <= this.buffer[0].length; ++i2) {
                            for (int i3 = 1; i3 < n4; ++i3) {
                                if (this.buffer[i3 - 1][i2 - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[i3 - 1][i2 - 1]]);
                                graphics.drawLine(i2, i3, i2, i3);
                            }
                        }
                    } else {
                        for (int i4 = 1; i4 <= this.buffer[0].length; ++i4) {
                            for (int i5 = 1; i5 < n4; ++i5) {
                                if (this.buffer[i5 - 1][i4 - 1] == 0) continue;
                                graphics.setColor(colorArray[this.buffer[i5 - 1][i4 - 1]]);
                                graphics.drawLine(i5, i4, i5, i4);
                            }
                        }
                    }
                }
            }

            public void setBorder(Border border) {
            }
        };
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    JButton getLeftButtonFromSuper() {
        return this.leftButton;
    }

    JButton getRightButtonFromSuper() {
        return this.rightButton;
    }

    JSplitPane getSplitPaneFromSuper() {
        return this.splitPane;
    }

    public MetalSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
        this.setLayout(new MetalDividerLayout());
    }

    public class MetalDividerLayout
    implements LayoutManager {
        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            JButton jButton = MetalSplitPaneDivider.this.getLeftButtonFromSuper();
            JButton jButton2 = MetalSplitPaneDivider.this.getRightButtonFromSuper();
            JSplitPane jSplitPane = MetalSplitPaneDivider.this.getSplitPaneFromSuper();
            int n2 = MetalSplitPaneDivider.this.getOrientationFromSuper();
            int n3 = MetalSplitPaneDivider.this.getOneTouchSizeFromSuper();
            int n4 = MetalSplitPaneDivider.this.getOneTouchOffsetFromSuper();
            Insets insets = MetalSplitPaneDivider.this.getInsets();
            if (jButton != null && jButton2 != null && container == MetalSplitPaneDivider.this) {
                if (jSplitPane.isOneTouchExpandable()) {
                    if (n2 == 0) {
                        int n5 = insets != null ? insets.top : 0;
                        int n6 = MetalSplitPaneDivider.this.getDividerSize();
                        if (insets != null) {
                            n6 -= insets.top + insets.bottom;
                        }
                        n6 = Math.min(n6, n3);
                        jButton.setBounds(n4, n5, n6 * 2, n6);
                        jButton2.setBounds(n4 + n3 * 2, n5, n6 * 2, n6);
                    } else {
                        int n7;
                        int n8 = MetalSplitPaneDivider.this.getDividerSize();
                        int n9 = n7 = insets != null ? insets.left : 0;
                        if (insets != null) {
                            n8 -= insets.left + insets.right;
                        }
                        n8 = Math.min(n8, n3);
                        jButton.setBounds(n7, n4, n8, n8 * 2);
                        jButton2.setBounds(n7, n4 + n3 * 2, n8, n8 * 2);
                    }
                } else {
                    jButton.setBounds(-5, -5, 1, 1);
                    jButton2.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(0, 0);
        }
    }
}

