/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class InlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;
    private float longestWordSpan = -1.0f;

    float calculateLongestWordSpan() {
        float f2 = 0.0f;
        Document document = this.getDocument();
        String string = "multiByte";
        f2 = document != null && Boolean.TRUE.equals(document.getProperty(string)) ? this.calculateLongestWordSpanUseBreakIterator() : this.calculateLongestWordSpanUseWhitespace();
        return f2;
    }

    float calculateLongestWordSpanUseBreakIterator() {
        float f2 = 0.0f;
        Document document = this.getDocument();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n3 > n2) {
            try {
                FontMetrics fontMetrics = this.getFontMetrics();
                Segment segment = new Segment();
                document.getText(n2, n3 - n2, segment);
                Container container = this.getContainer();
                BreakIterator breakIterator = container != null ? BreakIterator.getLineInstance(container.getLocale()) : BreakIterator.getLineInstance();
                breakIterator.setText(segment);
                int n4 = breakIterator.first();
                int n5 = breakIterator.next();
                while (n5 != -1) {
                    if (n5 > n4) {
                        f2 = Math.max(f2, (float)fontMetrics.charsWidth(segment.array, n4, n5 - n4));
                    }
                    n4 = n5;
                    n5 = breakIterator.next();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return f2;
    }

    float calculateLongestWordSpanUseWhitespace() {
        float f2 = 0.0f;
        Document document = this.getDocument();
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        if (n3 > n2) {
            try {
                int n4;
                Segment segment = new Segment();
                document.getText(n2, n3 - n2, segment);
                boolean bl2 = false;
                int n5 = n4 = segment.offset;
                FontMetrics fontMetrics = this.getFontMetrics();
                int n6 = segment.offset + segment.count - 1;
                for (int i2 = segment.offset; i2 <= n6; ++i2) {
                    boolean bl3 = false;
                    if (Character.isWhitespace(segment.array[i2])) {
                        if (!bl2) {
                            bl3 = true;
                            bl2 = true;
                        }
                    } else {
                        if (bl2) {
                            n5 = n4 = i2;
                            bl2 = false;
                        } else {
                            n5 = i2;
                        }
                        if (i2 == n6) {
                            bl3 = true;
                        }
                    }
                    if (!bl3 || n5 <= n4) continue;
                    f2 = Math.max(f2, (float)fontMetrics.charsWidth(segment.array, n4, n5 - n4 + 1));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return f2;
    }

    float getLongestWordSpan() {
        if (this.longestWordSpan < 0.0f) {
            this.longestWordSpan = this.calculateLongestWordSpan();
        }
        return this.longestWordSpan;
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet attributeSet = this.getAttributes();
        Object object = attributeSet.getAttribute(CSS.Attribute.TEXT_DECORATION);
        boolean bl2 = object != null ? object.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(bl2);
        boolean bl3 = object != null ? object.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(bl3);
        Object object2 = attributeSet.getAttribute(CSS.Attribute.VERTICAL_ALIGN);
        bl3 = object2 != null ? object2.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(bl3);
        bl3 = object2 != null ? object2.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(bl3);
        Object object3 = attributeSet.getAttribute(CSS.Attribute.WHITE_SPACE);
        this.nowrap = object3 != null && object3.equals("nowrap");
    }

    public int getBreakWeight(int n2, float f2, float f3) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(n2, f2, f3);
    }

    public AttributeSet getAttributes() {
        return this.attr;
    }

    public InlineView(Element element) {
        super(element);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        return hTMLDocument.getStyleSheet();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        super.changedUpdate(documentEvent, shape, viewFactory);
        StyleSheet styleSheet = this.getStyleSheet();
        this.attr = styleSheet.getViewAttributes(this);
        this.preferenceChanged(null, true, true);
    }
}

