/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Stack;
import javax.swing.event.TreeModelEvent;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class FixedHeightLayoutCache
extends AbstractLayoutCache {
    private FHTreeStateNode root;
    private int rowCount;
    private Rectangle boundsBuffer;
    private Hashtable treePathMapping;
    private SearchInfo info;
    private Stack tempStacks = new Stack();

    public int getRowCount() {
        return this.rowCount;
    }

    public FixedHeightLayoutCache() {
        this.boundsBuffer = new Rectangle();
        this.treePathMapping = new Hashtable();
        this.info = new SearchInfo();
        this.setRowHeight(1);
    }

    public void invalidateSizes() {
        this.visibleNodesChanged();
    }

    private void visibleNodesChanged() {
    }

    private int getRowContainingYLocation(int n2) {
        if (this.getRowCount() == 0) {
            return -1;
        }
        return Math.max(0, Math.min(this.getRowCount() - 1, n2 / this.getRowHeight()));
    }

    private void adjustRowCountBy(int n2) {
        this.rowCount += n2;
    }

    public void setRowHeight(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("FixedHeightLayoutCache only supports row heights greater than 0");
        }
        if (this.getRowHeight() != n2) {
            super.setRowHeight(n2);
            this.visibleNodesChanged();
        }
    }

    private void rebuild(boolean bl2) {
        Object object;
        this.treePathMapping.clear();
        if (this.treeModel != null && (object = this.treeModel.getRoot()) != null) {
            this.root = this.createNodeForValue(object, 0);
            this.root.path = new TreePath(object);
            this.addMapping(this.root);
            if (this.isRootVisible()) {
                this.rowCount = 1;
                this.root.row = 0;
            } else {
                this.rowCount = 0;
                this.root.row = -1;
            }
            this.root.expand();
        } else {
            this.root = null;
            this.rowCount = 0;
        }
        if (bl2 && this.treeSelectionModel != null) {
            this.treeSelectionModel.clearSelection();
        }
        this.visibleNodesChanged();
    }

    public void setRootVisible(boolean bl2) {
        if (this.isRootVisible() != bl2) {
            super.setRootVisible(bl2);
            if (this.root != null) {
                if (bl2) {
                    ++this.rowCount;
                    this.root.adjustRowBy(1);
                } else {
                    --this.rowCount;
                    this.root.adjustRowBy(-1);
                }
                this.visibleNodesChanged();
            }
        }
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null) {
                int n2;
                if (nArray != null && (n2 = nArray.length) > 0) {
                    Object object = fHTreeStateNode.getUserObject();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode.getChildAtModelIndex(nArray[i2]);
                        if (fHTreeStateNode2 == null) continue;
                        fHTreeStateNode2.setUserObject(this.treeModel.getChild(object, nArray[i2]));
                    }
                    if (fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                        this.visibleNodesChanged();
                    }
                } else if (fHTreeStateNode == this.root && fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n2;
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treeModelEvent.getTreePath(), false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n2 = nArray.length) > 0) {
                boolean bl2 = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                for (int i2 = 0; i2 < n2; ++i2) {
                    fHTreeStateNode.childInsertedAtModelIndex(nArray[i2], bl2);
                }
                if (bl2 && this.treeSelectionModel != null) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            int n2;
            TreePath treePath = treeModelEvent.getTreePath();
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            int[] nArray = treeModelEvent.getChildIndices();
            if (fHTreeStateNode != null && nArray != null && (n2 = nArray.length) > 0) {
                Object[] objectArray = treeModelEvent.getChildren();
                boolean bl2 = fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded();
                for (int i2 = n2 - 1; i2 >= 0; --i2) {
                    fHTreeStateNode.removeChildAtModelIndex(nArray[i2], bl2);
                }
                if (bl2) {
                    if (this.treeSelectionModel != null) {
                        this.treeSelectionModel.resetRowSelection();
                    }
                    if (this.treeModel.getChildCount(fHTreeStateNode.getUserObject()) == 0 && fHTreeStateNode.isLeaf()) {
                        fHTreeStateNode.collapse(false);
                    }
                    this.visibleNodesChanged();
                } else if (fHTreeStateNode.isVisible()) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        if (treeModelEvent != null) {
            TreePath treePath = treeModelEvent.getTreePath();
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, false, false);
            if (fHTreeStateNode == this.root || fHTreeStateNode == null && (treePath == null && this.treeModel != null && this.treeModel.getRoot() == null || treePath != null && treePath.getPathCount() <= 1)) {
                this.rebuild(true);
            } else if (fHTreeStateNode != null) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getParent();
                boolean bl2 = fHTreeStateNode.isExpanded();
                boolean bl3 = fHTreeStateNode.isVisible();
                int n2 = fHTreeStateNode2.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                fHTreeStateNode2.remove(n2);
                if (bl3 && bl2) {
                    int n3 = fHTreeStateNode.getRow();
                    fHTreeStateNode2.resetChildrenRowsFrom(n3, n2, fHTreeStateNode.getChildIndex());
                    fHTreeStateNode = this.getNodeForPath(treePath, false, true);
                    fHTreeStateNode.expand();
                }
                if (this.treeSelectionModel != null && bl3 && bl2) {
                    this.treeSelectionModel.resetRowSelection();
                }
                if (bl3) {
                    this.visibleNodesChanged();
                }
            }
        }
    }

    private void addMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.put(fHTreeStateNode.getTreePath(), fHTreeStateNode);
    }

    private void removeMapping(FHTreeStateNode fHTreeStateNode) {
        this.treePathMapping.remove(fHTreeStateNode.getTreePath());
    }

    public void setModel(TreeModel treeModel) {
        super.setModel(treeModel);
        this.rebuild(false);
    }

    public TreePath getPathForRow(int n2) {
        if (n2 >= 0 && n2 < this.getRowCount() && this.root.getPathForRow(n2, this.getRowCount(), this.info)) {
            return this.info.getPath();
        }
        return null;
    }

    public TreePath getPathClosestTo(int n2, int n3) {
        if (this.getRowCount() == 0) {
            return null;
        }
        int n4 = this.getRowContainingYLocation(n3);
        return this.getPathForRow(n4);
    }

    public int getRowForPath(TreePath treePath) {
        if (treePath == null || this.root == null) {
            return -1;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return fHTreeStateNode.getRow();
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return fHTreeStateNode.getRowToModelIndex(this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return -1;
    }

    public int getVisibleChildCount(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode == null) {
            return 0;
        }
        return fHTreeStateNode.getTotalChildCount();
    }

    public void invalidatePathBounds(TreePath treePath) {
    }

    public boolean getExpandedState(TreePath treePath) {
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        return fHTreeStateNode != null ? fHTreeStateNode.isVisible() && fHTreeStateNode.isExpanded() : false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
            return fHTreeStateNode != null && fHTreeStateNode.isExpanded();
        }
        return false;
    }

    public void setExpandedState(TreePath treePath, boolean bl2) {
        if (bl2) {
            this.ensurePathIsExpanded(treePath, true);
        } else if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null && (fHTreeStateNode = this.getNodeForPath(treePath2, false, true)) != null) {
                fHTreeStateNode.makeVisible();
            }
            if ((fHTreeStateNode = this.getNodeForPath(treePath, true, false)) != null) {
                fHTreeStateNode.collapse(true);
            }
        }
    }

    private boolean ensurePathIsExpanded(TreePath treePath, boolean bl2) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode;
            if (this.treeModel.isLeaf(treePath.getLastPathComponent())) {
                treePath = treePath.getParentPath();
                bl2 = true;
            }
            if (treePath != null && (fHTreeStateNode = this.getNodeForPath(treePath, false, true)) != null) {
                fHTreeStateNode.makeVisible();
                if (bl2) {
                    fHTreeStateNode.expand();
                }
                return true;
            }
        }
        return false;
    }

    public Enumeration getVisiblePathsFrom(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
            return new VisibleFHTreeStateNodeEnumeration(fHTreeStateNode, this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent()));
        }
        return null;
    }

    private FHTreeStateNode createNodeForValue(Object object, int n2) {
        return new FHTreeStateNode(object, n2, -1);
    }

    private FHTreeStateNode getMapping(TreePath treePath) {
        return (FHTreeStateNode)this.treePathMapping.get(treePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FHTreeStateNode getNodeForPath(TreePath treePath, boolean bl2, boolean bl3) {
        if (treePath != null) {
            FHTreeStateNode fHTreeStateNode = this.getMapping(treePath);
            if (fHTreeStateNode != null) {
                if (bl2 && !fHTreeStateNode.isVisible()) {
                    return null;
                }
                return fHTreeStateNode;
            }
            if (bl2) {
                return null;
            }
            Stack stack = this.tempStacks.size() == 0 ? new Stack() : (Stack)this.tempStacks.pop();
            try {
                stack.push(treePath);
                fHTreeStateNode = null;
                for (treePath = treePath.getParentPath(); treePath != null; treePath = treePath.getParentPath()) {
                    fHTreeStateNode = this.getMapping(treePath);
                    if (fHTreeStateNode != null) {
                        while (fHTreeStateNode != null && stack.size() > 0) {
                            treePath = (TreePath)stack.pop();
                            fHTreeStateNode = fHTreeStateNode.createChildFor(treePath.getLastPathComponent());
                        }
                        FHTreeStateNode fHTreeStateNode2 = fHTreeStateNode;
                        return fHTreeStateNode2;
                    }
                    stack.push(treePath);
                }
            }
            finally {
                stack.removeAllElements();
                this.tempStacks.push(stack);
            }
            return null;
        }
        return null;
    }

    private Rectangle getBounds(FHTreeStateNode fHTreeStateNode, int n2, Rectangle rectangle) {
        int n3;
        boolean bl2;
        Object object;
        int n4;
        if (n2 == -1) {
            n4 = fHTreeStateNode.getRow();
            object = fHTreeStateNode.getUserObject();
            bl2 = fHTreeStateNode.isExpanded();
            n3 = fHTreeStateNode.getLevel();
        } else {
            n4 = fHTreeStateNode.getRowToModelIndex(n2);
            object = this.treeModel.getChild(fHTreeStateNode.getUserObject(), n2);
            bl2 = false;
            n3 = fHTreeStateNode.getLevel() + 1;
        }
        Rectangle rectangle2 = this.getNodeDimensions(object, n4, n3, bl2, this.boundsBuffer);
        if (rectangle2 == null) {
            return null;
        }
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = rectangle2.x;
        rectangle.height = this.getRowHeight();
        rectangle.y = n4 * rectangle.height;
        rectangle.width = rectangle2.width;
        return rectangle;
    }

    public Rectangle getBounds(TreePath treePath, Rectangle rectangle) {
        int n2;
        if (treePath == null) {
            return null;
        }
        FHTreeStateNode fHTreeStateNode = this.getNodeForPath(treePath, true, false);
        if (fHTreeStateNode != null) {
            return this.getBounds(fHTreeStateNode, -1, rectangle);
        }
        TreePath treePath2 = treePath.getParentPath();
        fHTreeStateNode = this.getNodeForPath(treePath2, true, false);
        if (fHTreeStateNode != null && (n2 = this.treeModel.getIndexOfChild(treePath2.getLastPathComponent(), treePath.getLastPathComponent())) != -1) {
            return this.getBounds(fHTreeStateNode, n2, rectangle);
        }
        return null;
    }

    private class FHTreeStateNode
    extends DefaultMutableTreeNode {
        protected boolean isExpanded;
        protected int childIndex;
        protected int childCount;
        protected int row;
        protected TreePath path;

        public int getChildIndex() {
            return this.childIndex;
        }

        public int getRow() {
            return this.row;
        }

        public int getTotalChildCount() {
            if (this.isExpanded()) {
                int n2;
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null && (n2 = fHTreeStateNode.getIndex(this)) + 1 < fHTreeStateNode.getChildCount()) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)fHTreeStateNode.getChildAt(n2 + 1);
                    return fHTreeStateNode2.row - this.row - (fHTreeStateNode2.childIndex - this.childIndex);
                }
                int n3 = this.childCount;
                for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                    n3 += ((FHTreeStateNode)this.getChildAt(i2)).getTotalChildCount();
                }
                return n3;
            }
            return 0;
        }

        public int getVisibleLevel() {
            if (FixedHeightLayoutCache.this.isRootVisible()) {
                return this.getLevel();
            }
            return this.getLevel() - 1;
        }

        protected void didAdjustTree() {
        }

        protected void didExpand() {
            int n2 = this.setRowAndChildren(this.row);
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            int n3 = n2 - this.row - 1;
            if (fHTreeStateNode != null) {
                fHTreeStateNode.adjustRowBy(n3, fHTreeStateNode.getIndex(this) + 1);
            }
            FixedHeightLayoutCache.this.adjustRowCountBy(n3);
        }

        protected void expand() {
            if (!this.isExpanded && !this.isLeaf()) {
                boolean bl2 = this.isVisible();
                this.isExpanded = true;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.getUserObject());
                if (bl2) {
                    this.didExpand();
                }
                if (bl2 && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        protected void expandParentAndReceiver() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
            this.expand();
        }

        protected void makeVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.expandParentAndReceiver();
            }
        }

        protected void removeFromMapping() {
            if (this.path != null) {
                FixedHeightLayoutCache.this.removeMapping(this);
                for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                    ((FHTreeStateNode)this.getChildAt(i2)).removeFromMapping();
                }
            }
        }

        public boolean isExpanded() {
            return this.isExpanded;
        }

        public boolean isLeaf() {
            TreeModel treeModel = FixedHeightLayoutCache.this.getModel();
            return treeModel != null ? treeModel.isLeaf(this.getUserObject()) : true;
        }

        public boolean isVisible() {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode == null) {
                return true;
            }
            return fHTreeStateNode.isExpanded() && fHTreeStateNode.isVisible();
        }

        protected int getCountTo(int n2) {
            int n3 = n2 + 1;
            int n4 = this.getChildCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                if (fHTreeStateNode.childIndex >= n2) {
                    i2 = n4;
                    continue;
                }
                n3 += fHTreeStateNode.getTotalChildCount();
            }
            if (this.parent != null) {
                return n3 + ((FHTreeStateNode)this.getParent()).getCountTo(this.childIndex);
            }
            if (!FixedHeightLayoutCache.this.isRootVisible()) {
                return n3 - 1;
            }
            return n3;
        }

        protected int getNumExpandedChildrenTo(int n2) {
            int n3 = n2;
            int n4 = this.getChildCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                if (fHTreeStateNode.childIndex >= n2) {
                    return n3;
                }
                n3 += fHTreeStateNode.getTotalChildCount();
            }
            return n3;
        }

        public int getRowToModelIndex(int n2) {
            int n3;
            int n4 = n3 = this.getRow() + 1;
            int n5 = this.getChildCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                if (fHTreeStateNode.childIndex < n2) continue;
                if (fHTreeStateNode.childIndex == n2) {
                    return fHTreeStateNode.row;
                }
                if (i2 == 0) {
                    return this.getRow() + 1 + n2;
                }
                return fHTreeStateNode.row - (fHTreeStateNode.childIndex - n2);
            }
            return this.getRow() + 1 + this.getTotalChildCount() - (this.childCount - n2);
        }

        protected int setRowAndChildren(int n2) {
            this.row = n2;
            if (!this.isExpanded()) {
                return this.row + 1;
            }
            int n3 = this.row + 1;
            int n4 = 0;
            int n5 = this.getChildCount();
            for (int i2 = 0; i2 < n5; ++i2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                n3 += fHTreeStateNode.childIndex - n4;
                n4 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n3 = fHTreeStateNode.setRowAndChildren(n3);
                    continue;
                }
                fHTreeStateNode.row = n3++;
            }
            return n3 + this.childCount - n4;
        }

        protected void adjustRowBy(int n2) {
            this.row += n2;
            if (this.isExpanded) {
                for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                    ((FHTreeStateNode)this.getChildAt(i2)).adjustRowBy(n2);
                }
            }
        }

        public void remove(int n2) {
            FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(n2);
            fHTreeStateNode.removeFromMapping();
            super.remove(n2);
        }

        protected void adjustChildIndexs(int n2, int n3) {
            int n4 = this.getChildCount();
            for (int i2 = n2; i2 < n4; ++i2) {
                ((FHTreeStateNode)this.getChildAt((int)i2)).childIndex += n3;
            }
        }

        protected void adjustRowBy(int n2, int n3) {
            FHTreeStateNode fHTreeStateNode;
            if (this.isExpanded) {
                for (int i2 = this.getChildCount() - 1; i2 >= n3; --i2) {
                    ((FHTreeStateNode)this.getChildAt(i2)).adjustRowBy(n2);
                }
            }
            if ((fHTreeStateNode = (FHTreeStateNode)this.getParent()) != null) {
                fHTreeStateNode.adjustRowBy(n2, fHTreeStateNode.getIndex(this) + 1);
            }
        }

        protected void resetChildrenRowsFrom(int n2, int n3, int n4) {
            FHTreeStateNode fHTreeStateNode;
            int n5 = n2;
            int n6 = n4;
            int n7 = this.getChildCount();
            for (int i2 = n3; i2 < n7; ++i2) {
                fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                n5 += fHTreeStateNode.childIndex - n6;
                n6 = fHTreeStateNode.childIndex + 1;
                if (fHTreeStateNode.isExpanded) {
                    n5 = fHTreeStateNode.setRowAndChildren(n5);
                    continue;
                }
                fHTreeStateNode.row = n5++;
            }
            n5 += this.childCount - n6;
            fHTreeStateNode = (FHTreeStateNode)this.getParent();
            if (fHTreeStateNode != null) {
                fHTreeStateNode.resetChildrenRowsFrom(n5, fHTreeStateNode.getIndex(this) + 1, this.childIndex + 1);
            } else {
                FixedHeightLayoutCache.this.rowCount = n5;
            }
        }

        protected void childInsertedAtModelIndex(int n2, boolean bl2) {
            int n3 = this.getChildCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getChildAt(i2);
                if (fHTreeStateNode.childIndex < n2) continue;
                if (bl2) {
                    this.adjustRowBy(1, i2);
                    FixedHeightLayoutCache.this.adjustRowCountBy(1);
                }
                while (i2 < n3) {
                    ++((FHTreeStateNode)this.getChildAt((int)i2)).childIndex;
                    ++i2;
                }
                ++this.childCount;
                return;
            }
            if (bl2) {
                this.adjustRowBy(1, n3);
                FixedHeightLayoutCache.this.adjustRowCountBy(1);
            }
            ++this.childCount;
        }

        protected void removeChildAtModelIndex(int n2, boolean bl2) {
            FHTreeStateNode fHTreeStateNode = this.getChildAtModelIndex(n2);
            if (fHTreeStateNode != null) {
                int n3 = fHTreeStateNode.getRow();
                int n4 = this.getIndex(fHTreeStateNode);
                fHTreeStateNode.collapse(false);
                this.remove(n4);
                this.adjustChildIndexs(n4, -1);
                --this.childCount;
                if (bl2) {
                    this.resetChildrenRowsFrom(n3, n4, n2);
                }
            } else {
                int n5 = this.getChildCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(i2);
                    if (fHTreeStateNode2.childIndex < n2) continue;
                    if (bl2) {
                        this.adjustRowBy(-1, i2);
                        FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                    }
                    while (i2 < n5) {
                        --((FHTreeStateNode)this.getChildAt((int)i2)).childIndex;
                        ++i2;
                    }
                    --this.childCount;
                    return;
                }
                if (bl2) {
                    this.adjustRowBy(-1, n5);
                    FixedHeightLayoutCache.this.adjustRowCountBy(-1);
                }
                --this.childCount;
            }
        }

        protected void collapse(boolean bl2) {
            if (this.isExpanded) {
                if (this.isVisible() && bl2) {
                    int n2 = this.getTotalChildCount();
                    this.isExpanded = false;
                    FixedHeightLayoutCache.this.adjustRowCountBy(-n2);
                    this.adjustRowBy(-n2, 0);
                } else {
                    this.isExpanded = false;
                }
                if (bl2 && this.isVisible() && FixedHeightLayoutCache.this.treeSelectionModel != null) {
                    FixedHeightLayoutCache.this.treeSelectionModel.resetRowSelection();
                }
            }
        }

        public void setUserObject(Object object) {
            super.setUserObject(object);
            if (this.path != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.getParent();
                if (fHTreeStateNode != null) {
                    this.resetChildrenPaths(fHTreeStateNode.getTreePath());
                } else {
                    this.resetChildrenPaths(null);
                }
            }
        }

        public FHTreeStateNode getChildAtModelIndex(int n2) {
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                if (((FHTreeStateNode)this.getChildAt((int)i2)).childIndex != n2) continue;
                return (FHTreeStateNode)this.getChildAt(i2);
            }
            return null;
        }

        protected void addNode(FHTreeStateNode fHTreeStateNode) {
            boolean bl2 = false;
            int n2 = fHTreeStateNode.getChildIndex();
            int n3 = this.getChildCount();
            for (int i2 = 0; i2 < n3; ++i2) {
                if (((FHTreeStateNode)this.getChildAt(i2)).getChildIndex() <= n2) continue;
                bl2 = true;
                this.insert(fHTreeStateNode, i2);
                i2 = n3;
            }
            if (!bl2) {
                this.add(fHTreeStateNode);
            }
        }

        protected boolean getPathForRow(int n2, int n3, SearchInfo searchInfo) {
            int n4;
            if (this.row == n2) {
                searchInfo.node = this;
                searchInfo.isNodeParentNode = false;
                searchInfo.childIndex = this.childIndex;
                return true;
            }
            FHTreeStateNode fHTreeStateNode = null;
            int n5 = this.getChildCount();
            for (n4 = 0; n4 < n5; ++n4) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(n4);
                if (fHTreeStateNode2.row > n2) {
                    if (n4 == 0) {
                        searchInfo.node = this;
                        searchInfo.isNodeParentNode = true;
                        searchInfo.childIndex = n2 - this.row - 1;
                        return true;
                    }
                    int n6 = 1 + fHTreeStateNode2.row - (fHTreeStateNode2.childIndex - fHTreeStateNode.childIndex);
                    if (n2 < n6) {
                        return fHTreeStateNode.getPathForRow(n2, n6, searchInfo);
                    }
                    searchInfo.node = this;
                    searchInfo.isNodeParentNode = true;
                    searchInfo.childIndex = n2 - n6 + fHTreeStateNode.childIndex + 1;
                    return true;
                }
                fHTreeStateNode = fHTreeStateNode2;
            }
            if (fHTreeStateNode != null) {
                n4 = n3 - (this.childCount - fHTreeStateNode.childIndex) + 1;
                if (n2 < n4) {
                    return fHTreeStateNode.getPathForRow(n2, n4, searchInfo);
                }
                searchInfo.node = this;
                searchInfo.isNodeParentNode = true;
                searchInfo.childIndex = n2 - n4 + fHTreeStateNode.childIndex + 1;
                return true;
            }
            n4 = n2 - this.row - 1;
            if (n4 >= this.childCount) {
                return false;
            }
            searchInfo.node = this;
            searchInfo.isNodeParentNode = true;
            searchInfo.childIndex = n4;
            return true;
        }

        public void setParent(MutableTreeNode mutableTreeNode) {
            super.setParent(mutableTreeNode);
            if (mutableTreeNode != null) {
                this.path = ((FHTreeStateNode)mutableTreeNode).getTreePath().pathByAddingChild(this.getUserObject());
                FixedHeightLayoutCache.this.addMapping(this);
            }
        }

        public TreePath getTreePath() {
            return this.path;
        }

        protected void resetChildrenPaths(TreePath treePath) {
            FixedHeightLayoutCache.this.removeMapping(this);
            this.path = treePath == null ? new TreePath(this.getUserObject()) : treePath.pathByAddingChild(this.getUserObject());
            FixedHeightLayoutCache.this.addMapping(this);
            for (int i2 = this.getChildCount() - 1; i2 >= 0; --i2) {
                ((FHTreeStateNode)this.getChildAt(i2)).resetChildrenPaths(this.path);
            }
        }

        public FHTreeStateNode(Object object, int n2, int n3) {
            super(object);
            this.childIndex = n2;
            this.row = n3;
        }

        protected FHTreeStateNode createChildFor(Object object) {
            int n2 = FixedHeightLayoutCache.this.treeModel.getIndexOfChild(this.getUserObject(), object);
            if (n2 < 0) {
                return null;
            }
            FHTreeStateNode fHTreeStateNode = FixedHeightLayoutCache.this.createNodeForValue(object, n2);
            int n3 = this.isVisible() ? this.getRowToModelIndex(n2) : -1;
            fHTreeStateNode.row = n3;
            int n4 = this.getChildCount();
            for (int i2 = 0; i2 < n4; ++i2) {
                FHTreeStateNode fHTreeStateNode2 = (FHTreeStateNode)this.getChildAt(i2);
                if (fHTreeStateNode2.childIndex <= n2) continue;
                this.insert(fHTreeStateNode, i2);
                return fHTreeStateNode;
            }
            this.add(fHTreeStateNode);
            return fHTreeStateNode;
        }
    }

    private class SearchInfo {
        protected FHTreeStateNode node;
        protected boolean isNodeParentNode;
        protected int childIndex;

        private SearchInfo() {
        }

        protected TreePath getPath() {
            if (this.node == null) {
                return null;
            }
            if (this.isNodeParentNode) {
                return this.node.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.node.getUserObject(), this.childIndex));
            }
            return this.node.path;
        }
    }

    private class VisibleFHTreeStateNodeEnumeration
    implements Enumeration {
        protected FHTreeStateNode parent;
        protected int nextIndex;
        protected int childCount;

        protected void updateNextObject() {
            if (!this.updateNextIndex()) {
                this.findNextValidParent();
            }
        }

        protected boolean findNextValidParent() {
            if (this.parent == FixedHeightLayoutCache.this.root) {
                this.parent = null;
                return false;
            }
            while (this.parent != null) {
                FHTreeStateNode fHTreeStateNode = (FHTreeStateNode)this.parent.getParent();
                if (fHTreeStateNode != null) {
                    this.nextIndex = this.parent.childIndex;
                    this.parent = fHTreeStateNode;
                    this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
                    if (!this.updateNextIndex()) continue;
                    return true;
                }
                this.parent = null;
            }
            return false;
        }

        public boolean hasMoreElements() {
            return this.parent != null;
        }

        protected boolean updateNextIndex() {
            if (this.nextIndex == -1 && !this.parent.isExpanded()) {
                return false;
            }
            if (this.childCount == 0) {
                return false;
            }
            if (++this.nextIndex >= this.childCount) {
                return false;
            }
            FHTreeStateNode fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex);
            if (fHTreeStateNode != null && fHTreeStateNode.isExpanded()) {
                this.parent = fHTreeStateNode;
                this.nextIndex = -1;
                this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(fHTreeStateNode.getUserObject());
            }
            return true;
        }

        public Object nextElement() {
            FHTreeStateNode fHTreeStateNode;
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException("No more visible paths");
            }
            TreePath treePath = this.nextIndex == -1 ? this.parent.getTreePath() : ((fHTreeStateNode = this.parent.getChildAtModelIndex(this.nextIndex)) == null ? this.parent.getTreePath().pathByAddingChild(FixedHeightLayoutCache.this.treeModel.getChild(this.parent.getUserObject(), this.nextIndex)) : fHTreeStateNode.getTreePath());
            this.updateNextObject();
            return treePath;
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode) {
            this(fHTreeStateNode, -1);
        }

        protected VisibleFHTreeStateNodeEnumeration(FHTreeStateNode fHTreeStateNode, int n2) {
            this.parent = fHTreeStateNode;
            this.nextIndex = n2;
            this.childCount = FixedHeightLayoutCache.this.treeModel.getChildCount(this.parent.getUserObject());
        }
    }
}

