/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.res;

import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class XSLMessages {
    private Locale fLocale = Locale.getDefault();
    private static ListResourceBundle XSLTBundle = null;
    private static ListResourceBundle XPATHBundle = null;
    private static final String XSLT_ERROR_RESOURCES = "org.apache.xalan.res.XSLTErrorResources";
    private static final String XPATH_ERROR_RESOURCES = "org.apache.xpath.res.XPATHErrorResources";
    private static String BAD_CODE = "BAD_CODE";
    private static String FORMAT_FAILED = "FORMAT_FAILED";

    public Locale getLocale() {
        return this.fLocale;
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    private static final String getResourceSuffix(Locale locale) {
        String string = "_" + locale.getLanguage();
        String string2 = locale.getCountry();
        if (string2.equals("TW")) {
            string = string + "_" + string2;
        }
        return string;
    }

    public static final ListResourceBundle loadResourceBundle(String string) throws MissingResourceException {
        Locale locale = Locale.getDefault();
        try {
            return (ListResourceBundle)ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                return (ListResourceBundle)ResourceBundle.getBundle(XSLT_ERROR_RESOURCES, new Locale("en", "US"));
            }
            catch (MissingResourceException missingResourceException2) {
                throw new MissingResourceException("Could not load any resource bundles." + string, string, "");
            }
        }
    }

    public static final String createMessage(String string, Object[] objectArray) {
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if (XSLTBundle != null) {
            return XSLMessages.createMsg(XSLTBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createWarning(String string, Object[] objectArray) {
        if (XSLTBundle == null) {
            XSLTBundle = XSLMessages.loadResourceBundle(XSLT_ERROR_RESOURCES);
        }
        if (XSLTBundle != null) {
            return XSLMessages.createMsg(XSLTBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHMessage(String string, Object[] objectArray) {
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if (XPATHBundle != null) {
            return XSLMessages.createXPATHMsg(XPATHBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createXPATHWarning(String string, Object[] objectArray) {
        if (XPATHBundle == null) {
            XPATHBundle = XSLMessages.loadResourceBundle(XPATH_ERROR_RESOURCES);
        }
        if (XPATHBundle != null) {
            return XSLMessages.createXPATHMsg(XPATHBundle, string, objectArray);
        }
        return "Could not load any resource bundles.";
    }

    public static final String createMsg(ListResourceBundle listResourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        boolean bl2 = false;
        String string3 = null;
        if (string != null) {
            string3 = listResourceBundle.getString(string);
        }
        if (string3 == null) {
            string3 = listResourceBundle.getString(BAD_CODE);
            bl2 = true;
        }
        if (objectArray != null) {
            try {
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (null != objectArray[i2]) continue;
                    objectArray[i2] = "";
                }
                string2 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string2 = listResourceBundle.getString(FORMAT_FAILED);
                string2 = string2 + " " + string3;
            }
        } else {
            string2 = string3;
        }
        if (bl2) {
            throw new RuntimeException(string2);
        }
        return string2;
    }

    public static final String createXPATHMsg(ListResourceBundle listResourceBundle, String string, Object[] objectArray) {
        String string2 = null;
        boolean bl2 = false;
        String string3 = null;
        if (string != null) {
            string3 = listResourceBundle.getString(string);
        }
        if (string3 == null) {
            string3 = listResourceBundle.getString("BAD_CODE");
            bl2 = true;
        }
        if (objectArray != null) {
            try {
                int n2 = objectArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (null != objectArray[i2]) continue;
                    objectArray[i2] = "";
                }
                string2 = MessageFormat.format(string3, objectArray);
            }
            catch (Exception exception) {
                string2 = listResourceBundle.getString("FORMAT_FAILED");
                string2 = string2 + " " + string3;
            }
        } else {
            string2 = string3;
        }
        if (bl2) {
            throw new RuntimeException(string2);
        }
        return string2;
    }
}

