/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.List;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.Win32ShellFolderManager;

final class Win32ShellFolder
extends ShellFolder {
    public static final int DESKTOP = 0;
    public static final int INTERNET = 1;
    public static final int PROGRAMS = 2;
    public static final int CONTROLS = 3;
    public static final int PRINTERS = 4;
    public static final int PERSONAL = 5;
    public static final int FAVORITES = 6;
    public static final int STARTUP = 7;
    public static final int RECENT = 8;
    public static final int SENDTO = 9;
    public static final int BITBUCKET = 10;
    public static final int STARTMENU = 11;
    public static final int DESKTOPDIRECTORY = 16;
    public static final int DRIVES = 17;
    public static final int NETWORK = 18;
    public static final int NETHOOD = 19;
    public static final int FONTS = 20;
    public static final int TEMPLATES = 21;
    public static final int COMMON_STARTMENU = 22;
    public static final int COMMON_PROGRAMS = 23;
    public static final int COMMON_STARTUP = 24;
    public static final int COMMON_DESKTOPDIRECTORY = 25;
    public static final int APPDATA = 26;
    public static final int PRINTHOOD = 27;
    public static final int ALTSTARTUP = 29;
    public static final int COMMON_ALTSTARTUP = 30;
    public static final int COMMON_FAVORITES = 31;
    public static final int INTERNET_CACHE = 32;
    public static final int COOKIES = 33;
    public static final int HISTORY = 34;
    public static final int ATTRIB_CANCOPY = 1;
    public static final int ATTRIB_CANMOVE = 2;
    public static final int ATTRIB_CANLINK = 4;
    public static final int ATTRIB_CANRENAME = 16;
    public static final int ATTRIB_CANDELETE = 32;
    public static final int ATTRIB_HASPROPSHEET = 64;
    public static final int ATTRIB_DROPTARGET = 256;
    public static final int ATTRIB_LINK = 65536;
    public static final int ATTRIB_SHARE = 131072;
    public static final int ATTRIB_READONLY = 262144;
    public static final int ATTRIB_GHOSTED = 524288;
    public static final int ATTRIB_HIDDEN = 524288;
    public static final int ATTRIB_FILESYSANCESTOR = 0x10000000;
    public static final int ATTRIB_FOLDER = 0x20000000;
    public static final int ATTRIB_FILESYSTEM = 0x40000000;
    public static final int ATTRIB_HASSUBFOLDER = Integer.MIN_VALUE;
    public static final int ATTRIB_VALIDATE = 0x1000000;
    public static final int ATTRIB_REMOVABLE = 0x2000000;
    public static final int ATTRIB_COMPRESSED = 0x4000000;
    public static final int ATTRIB_BROWSABLE = 0x8000000;
    public static final int ATTRIB_NONENUMERATED = 0x100000;
    public static final int ATTRIB_NEWCONTENT = 0x200000;
    private long pIShellFolder = 0L;
    private long relativePIDL = 0L;
    private long pIDL = 0L;
    private long attributes = -1L;
    private String folderType = null;
    private String displayName = null;
    private Image smallIcon = null;
    private Image largeIcon = null;
    static int[] fileChooserBitmapBits;
    static Image[] fileChooserIcons;
    private List topFolderList = null;

    public long getDesktopIShellFolder() {
        return this.getDesktop().getIShellFolder();
    }

    public long getIShellFolder() {
        return this.pIShellFolder;
    }

    public long getPIDL() {
        return this.pIDL;
    }

    public long getParentIShellFolder() {
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)this.getParentFile();
        if (win32ShellFolder == null) {
            if (this.equals(this.getDesktop())) {
                return this.getIShellFolder();
            }
            return 0L;
        }
        return win32ShellFolder.getIShellFolder();
    }

    public long getRelativePIDL() {
        if (this.relativePIDL == 0L) {
            this.relativePIDL = this.getRelativePIDL(this.getParentIShellFolder(), this.getIShellFolder());
        }
        return this.relativePIDL;
    }

    static {
        Win32ShellFolder.initIDs();
        fileChooserBitmapBits = null;
        fileChooserIcons = new Image[47];
    }

    protected void finalize() throws Throwable {
        if (this.pIDL != 0L && this.pIShellFolder == 0L) {
            this.releasePIDL(this.pIDL);
            this.pIDL = 0L;
            if (this.relativePIDL != 0L) {
                this.releasePIDL(this.relativePIDL);
                this.relativePIDL = 0L;
            }
        } else {
            this.pIShellFolder = 0L;
        }
    }

    private native void initDesktop();

    private static native void initIDs();

    public boolean isDirectory() {
        return this.hasAttribute(Integer.MIN_VALUE) || this.isFileSystem() && super.isDirectory();
    }

    public boolean isFileSystem() {
        return this.getPIDL() != 0L || !this.getPath().startsWith("ShellFolder: ");
    }

    public boolean isHidden() {
        return this.hasAttribute(524288);
    }

    public boolean isLink() {
        return this.hasAttribute(65536);
    }

    public static native int[] getFileChooserBitmapBits();

    public boolean hasAttribute(int n2) {
        boolean bl2 = false;
        if (this.getPIDL() != 0L) {
            if (this.attributes == -1L) {
                this.initAttributes(this.getPIDL());
            }
            boolean bl3 = bl2 = (this.attributes & (long)n2) != 0L;
        }
        if (this.pIShellFolder != 0L) {
            bl2 = bl2 || this.hasAttribute(this.getParentIShellFolder(), this.getRelativePIDL(), n2);
        }
        return bl2;
    }

    private native long getNextChild(long var1);

    private native void disposeIcon(long var1);

    private native void initAttributes(long var1);

    private native void releaseEnumObjects(long var1);

    private native void releasePIDL(long var1);

    private native void initSpecial(long var1, int var3);

    private native int[] getIconBits(long var1, int var3);

    private native long bindToObject(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getRelativePIDL(long l2, long l3) {
        if (l2 == 0L || l3 == 0L) {
            return 0L;
        }
        long l4 = this.getEnumObjects(l2, true);
        if (l4 == 0L) {
            return 0L;
        }
        try {
            long l5 = 0L;
            do {
                if ((l5 = this.getNextChild(l4)) == 0L) continue;
                long l6 = this.bindToObject(l2, l5);
                if (l6 == l3) {
                    long l7 = l5;
                    return l7;
                }
                this.releasePIDL(l5);
            } while (l5 != 0L);
        }
        finally {
            this.releaseEnumObjects(l4);
        }
        return 0L;
    }

    private boolean behavesLikeFileSystem(long l2, long l3) {
        return this.hasAttribute(l2, l3, 0x40000000);
    }

    private native boolean hasAttribute(long var1, long var3, int var5);

    private native long getIcon(long var1, long var3, boolean var5);

    private long getEnumObjects(long l2, boolean bl2) {
        boolean bl3 = l2 == this.getDesktopIShellFolder();
        return this.getEnumObjects(l2, bl3, bl2);
    }

    private native long getIcon(long var1, boolean var3);

    private native long getEnumObjects(long var1, boolean var3, boolean var4);

    private int[] getIconBits(boolean bl2) {
        long l2 = 0L;
        l2 = this.getPIDL() != 0L ? this.getIcon(this.getPIDL(), bl2) : this.getIcon(this.getParentIShellFolder(), this.getRelativePIDL(), bl2);
        if (l2 == 0L) {
            return null;
        }
        int[] nArray = this.getIconBits(l2, bl2 ? 32 : 16);
        this.disposeIcon(l2);
        return nArray;
    }

    static Image getFileChooserIcon(int n2) {
        if (fileChooserIcons[n2] != null) {
            return fileChooserIcons[n2];
        }
        if (fileChooserBitmapBits == null) {
            fileChooserBitmapBits = Win32ShellFolder.getFileChooserBitmapBits();
        }
        if (fileChooserBitmapBits != null) {
            int n3 = fileChooserBitmapBits.length / 256;
            int[] nArray = new int[256];
            for (int i2 = 0; i2 < 16; ++i2) {
                for (int i3 = 0; i3 < 16; ++i3) {
                    nArray[i2 * 16 + i3] = fileChooserBitmapBits[i2 * (n3 * 16) + n2 * 16 + i3];
                }
            }
            BufferedImage bufferedImage = new BufferedImage(16, 16, 2);
            bufferedImage.setRGB(0, 0, 16, 16, nArray, 0, 16);
            Win32ShellFolder.fileChooserIcons[n2] = bufferedImage;
        }
        return fileChooserIcons[n2];
    }

    public Image getIcon(boolean bl2) {
        Image image;
        Image image2 = image = bl2 ? this.largeIcon : this.smallIcon;
        if (image == null) {
            int n2 = bl2 ? 32 : 16;
            int[] nArray = this.getIconBits(bl2);
            if (nArray == null) {
                return super.getIcon(bl2);
            }
            BufferedImage bufferedImage = new BufferedImage(n2, n2, 2);
            bufferedImage.setRGB(0, 0, n2, n2, nArray, 0, n2);
            image = bl2 ? (this.largeIcon = bufferedImage) : (this.smallIcon = bufferedImage);
        }
        return image;
    }

    public File getCanonicalFile() throws IOException {
        if (this.getPIDL() != 0L) {
            return new Win32ShellFolder(this.parent, super.getCanonicalPath());
        }
        return this;
    }

    public File getParentFile() {
        if (this.parent == null && this.getPIDL() != 0L) {
            String string = this.getParent();
            if (string == null) {
                String string2 = this.getAbsolutePath();
                this.parent = string2.startsWith("\\") ? Win32ShellFolderManager.getNetwork() : Win32ShellFolderManager.getDrives();
            } else if (Win32ShellFolder.isNetworkRoot(string)) {
                this.parent = Win32ShellFolderManager.getNetwork();
            } else {
                try {
                    this.parent = new Win32ShellFolder(null, super.getParentFile());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        return this.parent;
    }

    public int compareTo(File file) {
        if (file == null || !(file instanceof Win32ShellFolder) || file instanceof Win32ShellFolder && ((Win32ShellFolder)file).getPIDL() != 0L) {
            if (this.getPIDL() != 0L) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.getPIDL() != 0L) {
            return 1;
        }
        if (this.topFolderList == null) {
            this.topFolderList = new ArrayList();
            this.topFolderList.add(Win32ShellFolderManager.getPersonal());
            this.topFolderList.add(Win32ShellFolderManager.getDesktop());
            this.topFolderList.add(Win32ShellFolderManager.getDrives());
            this.topFolderList.add(Win32ShellFolderManager.getNetwork());
        }
        int n2 = this.topFolderList.indexOf(this);
        int n3 = this.topFolderList.indexOf(file);
        if (n2 >= 0 && n3 >= 0) {
            return n2 - n3;
        }
        if (n2 >= 0) {
            return -1;
        }
        if (n3 >= 0) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public File[] listFiles(boolean bl2) {
        long l2;
        ArrayList arrayList;
        block12: {
            long l3;
            Win32ShellFolder win32ShellFolder;
            Win32ShellFolder win32ShellFolder2;
            block13: {
                int n2;
                File[] fileArray;
                File[] fileArray2;
                block11: {
                    block10: {
                        win32ShellFolder2 = Win32ShellFolderManager.getDesktop();
                        win32ShellFolder = Win32ShellFolderManager.getPersonal();
                        fileArray2 = null;
                        if (this.getPIDL() == 0L) break block10;
                        fileArray = super.listFiles(bl2);
                        if (fileArray == null) return fileArray2;
                        fileArray2 = new File[fileArray.length];
                        n2 = 0;
                        break block11;
                    }
                    arrayList = new ArrayList();
                    l3 = this.getIShellFolder();
                    if (l3 == 0L) return fileArray2;
                    l2 = this.getEnumObjects(l3, bl2);
                    if (l2 == 0L) break block12;
                    break block13;
                }
                for (int i2 = 0; i2 < fileArray.length && !Thread.currentThread().isInterrupted(); ++i2) {
                    try {
                        Win32ShellFolder win32ShellFolder3 = new Win32ShellFolder((ShellFolder)this, fileArray[i2]);
                        fileArray2[n2++] = win32ShellFolder3;
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (n2 >= fileArray.length) return fileArray2;
                fileArray = new File[n2];
                System.arraycopy(fileArray2, 0, fileArray, 0, n2);
                return fileArray;
            }
            long l4 = 0L;
            do {
                Win32ShellFolder win32ShellFolder4;
                block9: {
                    block14: {
                        if ((l4 = this.getNextChild(l2)) == 0L) continue;
                        win32ShellFolder4 = null;
                        if (!this.hasAttribute(l3, l4, 0x40000000)) break block14;
                        String string = Win32ShellFolder.getFileSystemPath(l3, l4);
                        if (string == null || !new File(string).isAbsolute()) continue;
                        if (this == win32ShellFolder2 && win32ShellFolder != null && string.equalsIgnoreCase(win32ShellFolder.getAbsolutePath())) {
                            win32ShellFolder4 = win32ShellFolder;
                            break block9;
                        } else {
                            try {
                                win32ShellFolder4 = new Win32ShellFolder((ShellFolder)this, string);
                                break block9;
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                continue;
                            }
                        }
                    }
                    if (this.hasAttribute(l3, l4, 0x10000000)) {
                        long l5 = this.bindToObject(l3, l4);
                        win32ShellFolder4 = new Win32ShellFolder(this, l5, l4, null);
                    }
                }
                if (win32ShellFolder4 == null) continue;
                arrayList.add(win32ShellFolder4);
            } while (l4 != 0L);
        }
        this.releaseEnumObjects(l2);
        return (ShellFolder[])arrayList.toArray(new ShellFolder[arrayList.size()]);
    }

    protected Object writeReplace() throws ObjectStreamException {
        File[] fileArray;
        if (this.isFileSystem()) {
            return new File(this.getPath());
        }
        Win32ShellFolder win32ShellFolder = Win32ShellFolderManager.getDrives();
        if (win32ShellFolder != null && (fileArray = win32ShellFolder.listFiles()) != null) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                Win32ShellFolder win32ShellFolder2;
                if (!(fileArray[i2] instanceof Win32ShellFolder) || !(win32ShellFolder2 = (Win32ShellFolder)fileArray[i2]).isFileSystem() || win32ShellFolder2.hasAttribute(0x2000000)) continue;
                return new File(win32ShellFolder2.getPath());
            }
        }
        return new File("C:\\");
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Win32ShellFolder)) {
            if (this.getPIDL() != 0L) {
                return super.equals(object);
            }
            return false;
        }
        Win32ShellFolder win32ShellFolder = (Win32ShellFolder)object;
        ShellFolder shellFolder = (ShellFolder)this.getParentFile();
        if (shellFolder != null && !shellFolder.equals(win32ShellFolder.getParentFile())) {
            return false;
        }
        if (this.isFileSystem()) {
            return this.getAbsolutePath().equals(win32ShellFolder.getAbsolutePath());
        }
        return this.getIShellFolder() == win32ShellFolder.getIShellFolder();
    }

    public String getDisplayName() {
        if (this.displayName == null && this.getPIDL() == 0L) {
            this.displayName = this.getDisplayName(this.getParentIShellFolder(), this.getRelativePIDL());
        }
        return this.displayName;
    }

    public String getExecutableType() {
        if (!this.isFileSystem()) {
            return null;
        }
        return this.getExecutableType(this.getAbsolutePath().getBytes());
    }

    public String getFolderType() {
        if (this.folderType == null && this.getPIDL() == 0L) {
            this.folderType = this.getFolderType(this.getRelativePIDL());
        }
        return this.folderType;
    }

    static native String getFileSystemPath(int var0) throws IOException;

    private native String getFolderType(long var1);

    private native String getDisplayName(long var1, long var3);

    static native String getFileSystemPath(long var0, long var2);

    private native String getLinkLocation(long var1, long var3);

    private native long initFile(long var1, String var3, boolean var4) throws IOException;

    private static boolean isNetworkRoot(String string) {
        return string.equals("\\\\") || string.equals("\\") || string.equals("//") || string.equals("/");
    }

    private native String getExecutableType(byte[] var1);

    public ShellFolder getLinkLocation() throws FileNotFoundException {
        if (!this.isLink()) {
            return null;
        }
        String string = null;
        string = this.getPIDL() != 0L ? this.getLinkLocation(this.getDesktopIShellFolder(), this.getPIDL()) : this.getLinkLocation(this.getParentIShellFolder(), this.getRelativePIDL());
        if (string == null) {
            return null;
        }
        return new Win32ShellFolder(null, string);
    }

    Win32ShellFolder(ShellFolder shellFolder, int n2) throws IOException {
        super(shellFolder, Win32ShellFolder.getFileSystemPath(n2) == null ? "ShellFolder: 0x" + Integer.toHexString(n2) : Win32ShellFolder.getFileSystemPath(n2));
        if (n2 == 0) {
            this.initDesktop();
        } else {
            this.initSpecial(this.getDesktop().getIShellFolder(), n2);
        }
    }

    public Win32ShellFolder getDesktop() {
        return Win32ShellFolderManager.getDesktop();
    }

    public Win32ShellFolder(ShellFolder shellFolder, File file) throws FileNotFoundException {
        this(shellFolder, file.getAbsolutePath());
    }

    public Win32ShellFolder(ShellFolder shellFolder, String string) throws FileNotFoundException {
        super(shellFolder, string);
        try {
            boolean bl2 = true;
            if (string.length() == 3 && string.endsWith(":\\")) {
                bl2 = false;
            }
            this.pIDL = this.initFile(this.getDesktopIShellFolder(), string, bl2);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(string + " (" + iOException.getMessage() + ")");
        }
    }

    Win32ShellFolder(Win32ShellFolder win32ShellFolder, long l2, long l3, String string) {
        super(win32ShellFolder, string != null ? string : "ShellFolder: ");
        this.pIShellFolder = l2;
        this.relativePIDL = l3;
    }

    Win32ShellFolder getChildByPath(String string) {
        long l2 = this.getIShellFolder();
        long l3 = this.getEnumObjects(l2, true);
        Win32ShellFolder win32ShellFolder = null;
        long l4 = 0L;
        while ((l4 = this.getNextChild(l3)) != 0L) {
            String string2;
            if (!this.hasAttribute(l2, l4, 0x40000000) || (string2 = Win32ShellFolder.getFileSystemPath(l2, l4)) == null || !string2.equalsIgnoreCase(string)) continue;
            long l5 = this.bindToObject(l2, l4);
            win32ShellFolder = new Win32ShellFolder(this, l5, l4, string2);
            break;
        }
        this.releaseEnumObjects(l3);
        return win32ShellFolder;
    }
}

