/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.BufImgSurfaceData;
import sun.java2d.SurfaceData;
import sun.java2d.loops.Blit;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.XORComposite;

public class SunCompositeContext
implements CompositeContext {
    ColorModel srcCM;
    ColorModel dstCM;
    Composite composite;
    CompositeType comptype;

    public void dispose() {
    }

    public SunCompositeContext(AlphaComposite alphaComposite, ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == null) {
            throw new NullPointerException("Source color model cannot be null");
        }
        if (colorModel2 == null) {
            throw new NullPointerException("Destination color model cannot be null");
        }
        this.srcCM = colorModel;
        this.dstCM = colorModel2;
        this.composite = alphaComposite;
        this.comptype = CompositeType.forAlphaComposite(alphaComposite);
    }

    public SunCompositeContext(XORComposite xORComposite, ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel == null) {
            throw new NullPointerException("Source color model cannot be null");
        }
        if (colorModel2 == null) {
            throw new NullPointerException("Destination color model cannot be null");
        }
        this.srcCM = colorModel;
        this.dstCM = colorModel2;
        this.composite = xORComposite;
        this.comptype = CompositeType.Xor;
    }

    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        WritableRaster writableRaster2;
        if (raster2 != writableRaster) {
            writableRaster.setDataElements(0, 0, raster2);
        }
        if (raster instanceof WritableRaster) {
            writableRaster2 = (WritableRaster)raster;
        } else {
            writableRaster2 = raster.createCompatibleWritableRaster();
            writableRaster2.setDataElements(0, 0, raster);
        }
        int n2 = Math.min(writableRaster2.getWidth(), raster2.getWidth());
        int n3 = Math.min(writableRaster2.getHeight(), raster2.getHeight());
        BufferedImage bufferedImage = new BufferedImage(this.srcCM, writableRaster2, this.srcCM.isAlphaPremultiplied(), null);
        BufferedImage bufferedImage2 = new BufferedImage(this.dstCM, writableRaster, this.dstCM.isAlphaPremultiplied(), null);
        SurfaceData surfaceData = BufImgSurfaceData.createData(bufferedImage);
        SurfaceData surfaceData2 = BufImgSurfaceData.createData(bufferedImage2);
        Blit blit = Blit.getFromCache(surfaceData.getSurfaceType(), this.comptype, surfaceData2.getSurfaceType());
        blit.Blit(surfaceData, surfaceData2, this.composite, null, 0, 0, 0, 0, n2, n3);
    }
}

