/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.jar;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.Handler;
import sun.net.www.protocol.jar.JarFileFactory;

public class JarURLConnection
extends java.net.JarURLConnection {
    private static final boolean debug = false;
    private static JarFileFactory factory = new JarFileFactory();
    private URL jarFileURL = this.getJarFileURL();
    private Permission permission;
    private URLConnection jarFileURLConnection = this.jarFileURL.openConnection();
    private String entryName = this.getEntryName();
    private JarEntry jarEntry;
    private JarFile jarFile;
    private String contentType;

    public int getContentLength() {
        int n2 = -1;
        try {
            this.connect();
            n2 = this.jarEntry == null ? this.jarFileURLConnection.getContentLength() : (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n2;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.jarFile = factory.get(this.getJarFileURL(), this.getUseCaches());
            if (this.getUseCaches()) {
                this.jarFileURLConnection = factory.getConnection(this.jarFile);
            }
            if (this.entryName != null) {
                this.jarEntry = (JarEntry)this.jarFile.getEntry(this.entryName);
                if (this.jarEntry == null) {
                    throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
                }
            }
            this.connected = true;
        }
    }

    public boolean getAllowUserInteraction() {
        return this.jarFileURLConnection.getAllowUserInteraction();
    }

    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    public void setIfModifiedSince(long l2) {
        this.jarFileURLConnection.setIfModifiedSince(l2);
    }

    public void setAllowUserInteraction(boolean bl2) {
        this.jarFileURLConnection.setAllowUserInteraction(bl2);
    }

    public void setDefaultUseCaches(boolean bl2) {
        this.jarFileURLConnection.setDefaultUseCaches(bl2);
    }

    public void setUseCaches(boolean bl2) {
        this.jarFileURLConnection.setUseCaches(bl2);
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        JarURLInputStream jarURLInputStream = null;
        if (this.entryName == null) {
            throw new IOException("no entry name specified");
        }
        if (this.jarEntry == null) {
            throw new FileNotFoundException("JAR entry " + this.entryName + " not found in " + this.jarFile.getName());
        }
        jarURLInputStream = new JarURLInputStream(this.jarFile.getInputStream(this.jarEntry));
        return jarURLInputStream;
    }

    public Object getContent() throws IOException {
        Object object = null;
        this.connect();
        object = this.entryName == null ? this.jarFile : super.getContent();
        return object;
    }

    public String getContentType() {
        if (this.contentType == null) {
            if (this.entryName == null) {
                this.contentType = "x-java/jar";
            } else {
                try {
                    this.connect();
                    InputStream inputStream = this.jarFile.getInputStream(this.jarEntry);
                    this.contentType = JarURLConnection.guessContentTypeFromStream(new BufferedInputStream(inputStream));
                    inputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.contentType == null) {
                this.contentType = JarURLConnection.guessContentTypeFromName(this.entryName);
            }
            if (this.contentType == null) {
                this.contentType = "content/unknown";
            }
        }
        return this.contentType;
    }

    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    public String getHeaderField(String string) {
        return this.jarFileURLConnection.getHeaderField(string);
    }

    public String getRequestProperty(String string) {
        return this.jarFileURLConnection.getRequestProperty(string);
    }

    public void setRequestProperty(String string, String string2) {
        this.jarFileURLConnection.setRequestProperty(string, string2);
    }

    public JarURLConnection(URL uRL, Handler handler) throws MalformedURLException, IOException {
        super(uRL);
    }

    class JarURLInputStream
    extends FilterInputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void close() throws IOException {
            try {
                super.close();
                Object var2_1 = null;
                if (JarURLConnection.this.getUseCaches()) return;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (JarURLConnection.this.getUseCaches()) throw throwable;
                JarURLConnection.this.jarFile.close();
                throw throwable;
            }
            JarURLConnection.this.jarFile.close();
        }

        JarURLInputStream(InputStream inputStream) {
            super(inputStream);
        }
    }
}

