/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import sun.rmi.transport.Channel;
import sun.rmi.transport.ConnectionInputStream;
import sun.rmi.transport.ConnectionOutputStream;
import sun.rmi.transport.DGCClient;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.ObjectTable;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPEndpoint;

public class LiveRef
implements Cloneable {
    private final Endpoint ep;
    private final ObjID id;
    private transient Channel ch;
    private final boolean isLocal;

    public int getPort() {
        return ((TCPEndpoint)this.ep).getPort();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public LiveRef(int n2) {
        this(new ObjID(), n2);
    }

    public void write(ObjectOutput objectOutput, boolean bl2) throws IOException {
        ConnectionOutputStream connectionOutputStream;
        boolean bl3 = false;
        if (objectOutput instanceof ConnectionOutputStream && (bl3 = (connectionOutputStream = (ConnectionOutputStream)objectOutput).isResultStream())) {
            if (this.isLocal) {
                Remote remote;
                Target target = ObjectTable.getTarget(this.id);
                if (target != null && (remote = target.getImpl()) != null) {
                    connectionOutputStream.saveObject(remote);
                }
            } else {
                connectionOutputStream.saveObject(this);
            }
        }
        if (bl2) {
            ((TCPEndpoint)this.ep).write(objectOutput);
        } else {
            ((TCPEndpoint)this.ep).writeHostPortFormat(objectOutput);
        }
        this.id.write(objectOutput);
        objectOutput.writeBoolean(bl3);
    }

    public Object clone() {
        try {
            LiveRef liveRef = (LiveRef)super.clone();
            return liveRef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            return this.ep.equals(liveRef.ep) && this.id.equals(liveRef.id) && this.isLocal == liveRef.isLocal;
        }
        return false;
    }

    public boolean remoteEquals(Object object) {
        if (object != null && object instanceof LiveRef) {
            LiveRef liveRef = (LiveRef)object;
            TCPEndpoint tCPEndpoint = (TCPEndpoint)this.ep;
            TCPEndpoint tCPEndpoint2 = (TCPEndpoint)liveRef.ep;
            RMIClientSocketFactory rMIClientSocketFactory = tCPEndpoint.getClientSocketFactory();
            RMIClientSocketFactory rMIClientSocketFactory2 = tCPEndpoint2.getClientSocketFactory();
            if (tCPEndpoint.getPort() != tCPEndpoint2.getPort() || !tCPEndpoint.getHost().equals(tCPEndpoint2.getHost())) {
                return false;
            }
            if (rMIClientSocketFactory == null ^ rMIClientSocketFactory2 == null) {
                return false;
            }
            if (!(rMIClientSocketFactory == null || rMIClientSocketFactory.getClass() == rMIClientSocketFactory2.getClass() && rMIClientSocketFactory.equals(rMIClientSocketFactory2))) {
                return false;
            }
            return this.id.equals(liveRef.id);
        }
        return false;
    }

    public String toString() {
        String string = this.isLocal ? "local" : "remote";
        return "[endpoint:" + this.ep + "(" + string + ")," + "objID:" + this.id + "]";
    }

    public ObjID getObjID() {
        return this.id;
    }

    public LiveRef(ObjID objID, int n2) {
        this(objID, TCPEndpoint.getLocalEndpoint(n2), true);
    }

    public RMIClientSocketFactory getClientSocketFactory() {
        return ((TCPEndpoint)this.ep).getClientSocketFactory();
    }

    public RMIServerSocketFactory getServerSocketFactory() {
        return ((TCPEndpoint)this.ep).getServerSocketFactory();
    }

    public Channel getChannel() throws RemoteException {
        if (this.ch == null) {
            this.ch = this.ep.getChannel();
        }
        return this.ch;
    }

    Endpoint getEndpoint() {
        return this.ep;
    }

    public void exportObject(Target target) throws RemoteException {
        this.ep.exportObject(target);
    }

    public LiveRef(int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this(new ObjID(), n2, rMIClientSocketFactory, rMIServerSocketFactory);
    }

    public LiveRef(ObjID objID, Endpoint endpoint, boolean bl2) {
        this.ep = endpoint;
        this.id = objID;
        this.isLocal = bl2;
    }

    public static LiveRef read(ObjectInput objectInput, boolean bl2) throws IOException, ClassNotFoundException {
        TCPEndpoint tCPEndpoint = bl2 ? TCPEndpoint.read(objectInput) : TCPEndpoint.readHostPortFormat(objectInput);
        ObjID objID = ObjID.read(objectInput);
        boolean bl3 = objectInput.readBoolean();
        LiveRef liveRef = new LiveRef(objID, tCPEndpoint, false);
        if (objectInput instanceof ConnectionInputStream) {
            ConnectionInputStream connectionInputStream = (ConnectionInputStream)objectInput;
            connectionInputStream.saveRef(liveRef);
            if (bl3) {
                connectionInputStream.setAckNeeded();
            }
        } else {
            DGCClient.registerRefs(tCPEndpoint, Arrays.asList(new LiveRef[]{liveRef}));
        }
        return liveRef;
    }

    public LiveRef(ObjID objID, int n2, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory) {
        this(objID, TCPEndpoint.getLocalEndpoint(n2, rMIClientSocketFactory, rMIServerSocketFactory), true);
    }
}

