/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.security.Permission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import sun.security.util.ResourcesMgr;

class SelfPermission
extends Permission {
    private String type;
    private String name;
    private String actions;
    private Certificate[] certs;

    public int hashCode() {
        int n2 = this.type.hashCode();
        if (this.name != null) {
            n2 ^= this.name.hashCode();
        }
        if (this.actions != null) {
            n2 ^= this.actions.hashCode();
        }
        return n2;
    }

    public boolean equals(Object object) {
        int n2;
        boolean bl2;
        int n3;
        if (object == this) {
            return true;
        }
        if (!(object instanceof SelfPermission)) {
            return false;
        }
        SelfPermission selfPermission = (SelfPermission)object;
        if (!(this.type.equals(selfPermission.type) && this.name.equals(selfPermission.name) && this.actions.equals(selfPermission.actions))) {
            return false;
        }
        if (this.certs.length != selfPermission.certs.length) {
            return false;
        }
        for (n3 = 0; n3 < this.certs.length; ++n3) {
            bl2 = false;
            for (n2 = 0; n2 < selfPermission.certs.length; ++n2) {
                if (!this.certs[n3].equals(selfPermission.certs[n2])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        for (n3 = 0; n3 < selfPermission.certs.length; ++n3) {
            bl2 = false;
            for (n2 = 0; n2 < this.certs.length; ++n2) {
                if (!selfPermission.certs[n3].equals(this.certs[n2])) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public String getActions() {
        return "";
    }

    public String getSelfActions() {
        return this.actions;
    }

    public String getSelfName() {
        return this.name;
    }

    public String getSelfType() {
        return this.type;
    }

    public String toString() {
        return "(SelfPermission " + this.type + " " + this.name + " " + this.actions + ")";
    }

    public boolean implies(Permission permission) {
        return false;
    }

    public Certificate[] getCerts() {
        return this.certs;
    }

    public SelfPermission(String string, String string2, String string3, Certificate[] certificateArray) {
        super(string);
        if (string == null) {
            throw new NullPointerException(ResourcesMgr.getString("type can't be null"));
        }
        this.type = string;
        this.name = string2;
        this.actions = string3;
        if (certificateArray != null) {
            int n2;
            for (n2 = 0; n2 < certificateArray.length; ++n2) {
                if (certificateArray[n2] instanceof X509Certificate) continue;
                this.certs = (Certificate[])certificateArray.clone();
                break;
            }
            if (this.certs == null) {
                int n3 = 0;
                for (n2 = 0; n2 < certificateArray.length; ++n2) {
                    ++n3;
                    while (n2 + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n2]).getIssuerDN()).equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                        ++n2;
                    }
                }
                if (n3 == certificateArray.length) {
                    this.certs = (Certificate[])certificateArray.clone();
                }
                if (this.certs == null) {
                    ArrayList arrayList = new ArrayList();
                    for (n2 = 0; n2 < certificateArray.length; ++n2) {
                        arrayList.add(certificateArray[n2]);
                        while (n2 + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n2]).getIssuerDN()).equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                            ++n2;
                        }
                    }
                    this.certs = new Certificate[arrayList.size()];
                    arrayList.toArray(this.certs);
                }
            }
        }
    }
}

