import bpy
import os
import addon_utils
#

#addon Info
bl_info = {  
 "name": "KHAOS: Procedural Explosion System",  
 "author": "Bradford Hamilton, Carlos Barreto",  
 "version": (1, 0), 
 "blender": (3, 0, 1),  
 "location": "View3D > Tool Shelf > KHAOS",  
 "description": "Controls for Khaos Simulation addon",  
 "warning": "",  
 "wiki_url": "",  
 "tracker_url": "",  
 "category": "Append"} 




global ACTIVE_OBJ #check if ubject changed
global LAST_OBJ #check if ubject changed
global UPT_HNDLR #check if handler is updating
LAST_OBJ = None
UPT_HNDLR = 0


from bpy.props import (StringProperty,
                       BoolProperty,
                       IntProperty,
                       FloatProperty,
                       FloatVectorProperty,
                       EnumProperty,
                       PointerProperty,
                       )
from bpy.types import (Panel,
                       Operator,
                       AddonPreferences,
                       PropertyGroup,
                       )






#
def toggle_expand(context, state):
    area = next(a for a in context.screen.areas if a.type == 'OUTLINER')
    bpy.ops.outliner.show_hierarchy({'area': area}, 'INVOKE_DEFAULT')
    for i in range(state):
        bpy.ops.outliner.expanded_toggle({'area': area})
    area.tag_redraw()
###############################
######### Handlers (it updates the panel based on what is on the object option)
###############################
def my_handler(scene):

    # khaos_tool_prop = scene.khaos_tool
    # khaos_tool_prop.sk_mesh_collision = bpy.context.active_object.rigid_body.collision_shape
    # khaos_tool_prop.sk_collision_margin = bpy.context.active_object.rigid_body.use_margin
    # khaos_tool_prop.sk_bool_conv_coll_margin = bpy.context.active_object.rigid_body.collision_margin
    
    global ACTIVE_OBJ #check if ubject changed
    global LAST_OBJ #check if ubject changed

    UPT_HNDLR = 0

    if bpy.context.active_object is not None:
        ACTIVE_OBJ = bpy.context.active_object.name
        if ACTIVE_OBJ != None and ACTIVE_OBJ != LAST_OBJ : #check id its a new object
            print('actual obj:', ACTIVE_OBJ)
            LAST_OBJ = ACTIVE_OBJ

            # obj = bpy.context.object
            # obj = bpy.context.active_object
            # meshobj = bpy.context.active_object.rigid_body.collision_shape
            # coll_margin = bpy.context.active_object.rigid_body.use_margin
            # bool_coll_margin = bpy.context.active_object.rigid_body.collision_margin
            # print('active: ',obj.name, 'mehs: ',meshobj,' coll_margin: ',coll_margin, ' bool_coll: ', bool_coll_margin)

            khaos_tool_prop = scene.khaos_tool
    
            if bpy.context.active_object.rigid_body != None: #check if the obj has rigid body
                #### change mesh type
                khaos_tool_prop.sk_mesh_collision = bpy.context.active_object.rigid_body.collision_shape
                khaos_tool_prop.sk_collision_margin = bpy.context.active_object.rigid_body.collision_margin
                khaos_tool_prop.sk_bool_conv_coll_margin = bpy.context.active_object.rigid_body.use_margin

            if bpy.context.active_object.name.startswith('Constraint') and bpy.context.active_object.type == 'EMPTY':
            ########## constraint update
                khaos_tool_prop.sk_ctr_breakable_rb = bpy.context.active_object.rigid_body_constraint.use_breaking
                khaos_tool_prop.sk_ctr_brk_threshold = bpy.context.active_object.rigid_body_constraint.breaking_threshold
            UPT_HNDLR = 1
    

    # if bpy.context.active_object.rigid_body != None: #check if the obj has rigid body
        # khaos_tool_prop = scene.khaos_tool
        # #### change mesh type
        # khaos_tool_prop.sk_mesh_collision = bpy.context.active_object.rigid_body.collision_shape
        # khaos_tool_prop.sk_collision_margin = bpy.context.active_object.rigid_body.use_margin
        # khaos_tool_prop.sk_bool_conv_coll_margin = bpy.context.active_object.rigid_body.collision_margin

        # scene.coll_margin = 

# bpy.app.handlers.frame_change_pre.append(my_handler)
pre_handlers = bpy.app.handlers.depsgraph_update_pre
[pre_handlers.remove(h) for h in pre_handlers if h.__name__ == "my_handler"]
pre_handlers.append(my_handler)


###
# teste setter getter
# def get_float(self):
#     return self.get("coll_margin", 0.0)

# def set_float(self, value):
#     self["coll_margin"] = value

#### Update classes fro panels
def upt_mesh_colision(self,context):
    global UPT_HNDLR

    if UPT_HNDLR == 0 and bpy.context.object.rigid_body != None:
        mesh_collision = context.scene.khaos_tool.sk_mesh_collision
        #### change mesh type
        bpy.ops.rigidbody.shape_change(type=mesh_collision)

def upt_calc_mass(self,context):
    calc_mass = context.scene.khaos_tool.sk_calc_mass
    result = calc_mass.split('|')
    print('calc_mass: --',calc_mass)
    bpy.ops.rigidbody.mass_calculate(material=result[0], density=int(result[1]))




#################
## Helper Class: created to put reusable codes, this makes easier to fix troubles and make the code smaller.
### actually the helper class is used only on the new codes, the destruction and constraint functions. But I (carlos) wanted to go deep and put more functions here, in the helper function.
#################
class Helper(object):

    def coll_name_ctr(context,id_ctr):
        dropb_itens = my_settings_callback(bpy.context.scene,context) #get the list in the dropbox
        for dbi in dropb_itens:
            # all_coll_frac.append([dbi[0],dbi[1]]) #get the order and id of the dropbox options
            if dbi[0] == id_ctr:
                coll_name = dbi[1] #based on the selected colection, get its name
        return coll_name

    def coll_name_frac(context,id_frac):
        dropb_itens = my_settings_frac_callback(bpy.context.scene,context) #get the list in the dropbox
        for dbi in dropb_itens:
            # all_coll_frac.append([dbi[0],dbi[1]]) #get the order and id of the dropbox options
            if dbi[0] == id_frac:
                coll_name = dbi[1] #based on the selected colection, get its name
        return coll_name


    def ShowMessageBox(message = "", title = "Message Box", icon = 'INFO'):
        def draw(self, context):
            self.layout.label(text=message)
        bpy.context.window_manager.popup_menu(draw, title = title, icon = icon)
        """
        #Shows a message box with a specific message 
        ShowMessageBox("This is a message") 
        #Shows a message box with a message and custom title
        ShowMessageBox("This is a message", "This is a custom title")
        #Shows a message box with a message, custom title, and a specific icon
        ShowMessageBox("This is a message", "This is a custom title", 'ERROR')
        """
    def ShowMessageBoxMultiLines(message = "", title = "Message Box", icon = 'INFO'):
        myLines=message
        def draw(self, context):
            for n in myLines:
                self.layout.label(text=n)
        bpy.context.window_manager.popup_menu(draw, title = title, icon = icon)
        """
        #Usage example
        lines = ('linha1','linha2')
        ShowMessageBoxMultiLines(lines)
        """
        
    def material_set(mat_num):
        active_obj = bpy.context.active_object
        mat_final=0
        print('qtd material: ',len(active_obj.material_slots))
        if len(active_obj.material_slots) <2:
            if len(active_obj.material_slots) == 1:
                print('create inside material')
                mat_in = 'KHAOS_in_frac_mat'
                if mat_in in bpy.data.materials:
                    print('mat_in existis, just add to obj')
                    active_obj.data.materials.append(bpy.data.materials[mat_in]) #insert the material on the object
                else:
                    print('Create mat_in, AND add to obj')
                    new_mat = bpy.data.materials.new(mat_in)
                    new_mat.diffuse_color = (0.06,0.06,0.06,1.0)
                    active_obj.data.materials.append(new_mat) #insert the material on the object
            else:
                print('create mat inside and outside')
                ###### Outside material
                mat_out = 'KHAOS_out_frac_mat'
                if mat_out in bpy.data.materials:
                    print('mat_out existis, just add to obj')
                    active_obj.data.materials.append(bpy.data.materials[mat_out]) #insert the material on the object
                else:
                    print('Create mat_out, AND add to obj')
                    new_mat = bpy.data.materials.new(mat_out)
                    new_mat.diffuse_color = (1,1,1,1.0)
                    active_obj.data.materials.append(new_mat) #insert the material on the object
                ######inside material
                mat_in = 'KHAOS_in_frac_mat'
                if mat_in in bpy.data.materials:
                    print('mat_in existis, just add to obj')
                    active_obj.data.materials.append(bpy.data.materials[mat_in]) #insert the material on the object
                else:
                    print('Create mat_in, AND add to obj')
                    new_mat = bpy.data.materials.new(mat_in)
                    new_mat.diffuse_color = (0.06,0.06,0.06,1.0)
                    active_obj.data.materials.append(new_mat) #insert the material on the object
            mat_final = 1
        else:
            print('escolher material index',mat_num)
            mat_final = mat_num
            if len(active_obj.material_slots)-1 < mat_num:
                mat_final = 1
        return mat_final 
    
    def create_collection(name):
        collectionFound = False
        print("START **************")
        #
        for myCol in bpy.data.collections:
            print(myCol.name)
            if myCol.name == name:
                collectionFound = True
                print ("Collection found in scene")
                break
         #       
        if collectionFound == False:
            myCol = bpy.data.collections.new(name)
            bpy.context.scene.collection.children.link(myCol) #Creates a new collection
            print("created")
        else:
            print("exists already")
        return myCol
    
    def select(name):
        #get the name of collection from the menu
        
        # desselect all the objects
        bpy.ops.object.select_all(action='DESELECT')
        
        #select obj in colletion
        for obj in bpy.data.collections[name].all_objects:
            obj.select_set(True)
            
        #put the first obj as active
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0] #select the first object
        
    def select_excep_ctr(id): #execpt constraints
        #get the name of collection from the menu
        
        # desselect all the objects
        bpy.ops.object.select_all(action='DESELECT')

        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        for dp in dropb_itens:
            if id == dp[0]:
                name = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu
    
                #select obj in colletion
                for obj in bpy.data.collections[name].all_objects:
                    if not obj.name.startswith('Constraint'):
                        obj.select_set(True)
            
        #put the first obj as active
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0] #select the first object

    def select_ctr(self,context):
        name = context.scene.khaos_tool.sk_frac_name_collection
        # Helper.reorganize_ctr()
        ctr_collection = context.scene.khaos_tool.sk_ctr_collection#attention with this order
        
        dropb_itens_ctr = my_settings_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        for dbi in dropb_itens_ctr:
            if dbi[0] == ctr_collection:
                coll_name = dbi[1]
                if dbi[0] != '0':
                    Helper.select(coll_name)
        Helper.updt_qty_ctr(context)


    def select_frac(self,context):
        name = context.scene.khaos_tool.sk_frac_name_collection
        Helper.reorganize_frac()
        # idx, qty_frac = Helper.reorganize_frac()
        
        frac_collection = context.scene.khaos_tool.sk_frac_collection #get frac collection ID
                
        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        if frac_collection != '0':
            for dbi in dropb_itens:
                if dbi[0] == frac_collection:
                    coll_name = dbi[1]
                    Helper.select(coll_name)
        Helper.updt_qty_frac()


    def reorganize_ctr():

        # name = bpy.context.scene.khaos_tool.sk_frac_name_collection

        ######
        #get the fracture collection in use
        frac_collection = bpy.context.scene.khaos_tool.sk_frac_collection #get frac collection ID
        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        for dp in dropb_itens:
            if frac_collection == dp[0]:
                name_frac = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu
                name_ctr = name_frac+'.'+'Constraint'
                len_name_start_ctr = len(name_frac)


        #nome padrao
        count = 0
        all_coll_ctr = []
        # name_frac = name+'-'
        coll = bpy.data.collections
        #get all constraints and keep to reference and organize
        
        dropb_itens = my_settings_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        
        for dbi in dropb_itens:
            if dbi[1][len_name_start_ctr:].startswith('.Constraint'): #check if there is any constraint created in that fracture collection
                all_coll_ctr.append([dbi[0],dbi[1],'']) #get the order and id of the dropbox options, and added one more column to add the end result name
        
        # idx =1     
        #look if all the constraint collections are ordered, if not, order
        len_colls = len(all_coll_ctr)
        if len_colls >= 1 and all_coll_ctr[0][0] != '0':
            # for idx,ctr in enumerate(all_coll_frac):
            idx=0
            for x in range(len(all_coll_ctr)-1,-1,-1):
                col_number_desc = len_colls-(idx) #descending order
                col_number_asc = len_colls-(len_colls-(idx+1)) #ascending order
                all_coll_ctr[x][2] = name_ctr+'{:03}'.format(col_number_asc)
                # print('idx: ',idx,'   asc: ',col_number_asc,' desc: ',col_number_desc, ' --- ', all_coll_frac[x])
                
                if all_coll_ctr[x][1] != all_coll_ctr[x][2]:
                    coll[all_coll_ctr[x][1]].name = all_coll_ctr[x][2]

                # if ctr != name_frac+'{:03}'.format(col_number) and col_number >0: #set ascending order
                # if ctr[1] != name_frac+'{:03}'.format(col_number) and col_number >0: #set ascending order
                #     print ('orig:'+ctr[1]+' should be: '+name_frac+'{:03}'.format(col_number))
                #     coll[ctr[1]].name = name_frac+'{:03}'.format(col_number) 

                idx+=1
            # idx=1
        # else:
            # idx = 0
        
        #get updated information
        dropb_itens = my_settings_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        idx = dropb_itens[0][0]
        print('idx: ',idx)

        return idx,len(all_coll_ctr) 
       

    def reorganize_frac():
        name = bpy.context.scene.khaos_tool.sk_frac_name_collection
        #nome padrao
        count = 0
        all_coll_frac = []
        name_frac = name+'-'
        coll = bpy.data.collections
        #get all constraints and keep to reference and organize
        
        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        
        for dbi in dropb_itens:
            all_coll_frac.append([dbi[0],dbi[1],'']) #get the order and id of the dropbox options, and added one more column to add the end result name
        
        # idx =1     
        #look if all the constraint collections are ordered, if not, order
        len_colls = len(all_coll_frac)
        if len_colls >= 1 and all_coll_frac[0][0] != '0':
            # for idx,ctr in enumerate(all_coll_frac):
            idx=0
            for x in range(len(all_coll_frac)-1,-1,-1):
                col_number_desc = len_colls-(idx) #descending order
                col_number_asc = len_colls-(len_colls-(idx+1)) #ascending order
                all_coll_frac[x][2] = name_frac+'{:03}'.format(col_number_asc)
                # print('idx: ',idx,'   asc: ',col_number_asc,' desc: ',col_number_desc, ' --- ', all_coll_frac[x])
                
                if all_coll_frac[x][1] != all_coll_frac[x][2]:
                    coll[all_coll_frac[x][1]].name = all_coll_frac[x][2]

                # if ctr != name_frac+'{:03}'.format(col_number) and col_number >0: #set ascending order
                # if ctr[1] != name_frac+'{:03}'.format(col_number) and col_number >0: #set ascending order
                #     print ('orig:'+ctr[1]+' should be: '+name_frac+'{:03}'.format(col_number))
                #     coll[ctr[1]].name = name_frac+'{:03}'.format(col_number) 

                idx+=1
            # idx=1
        # else:
            # idx = 0
        
        #get updated information
        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        idx = dropb_itens[0][0]
        print('idx: ',idx)

        return idx,len(all_coll_frac)  #value used as referece of the last collection
   

    def updt_qty_ctr(context):
    # def updt_qty_ctr():
        # name = bpy.context.scene.khaos_tool.sk_frac_name_collection

        ctr_collection = bpy.context.scene.khaos_tool.sk_ctr_collection #get frac collection ID
        if ctr_collection != '0':
            dropb_itens = my_settings_callback(context.scene,context) #get the list in the dropbox
            # dropb_itens = my_settings_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
            for dp in dropb_itens:
                if ctr_collection == dp[0]:
                    name = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu

            qty_ctr = len(dropb_itens)
            name_ctr = name
            qty_ctr_obj = len(bpy.data.collections[name_ctr].all_objects)
        else:
            qty_ctr = 0
            qty_ctr_obj = 0
        bpy.context.scene.khaos_tool.sk_qty_ctr = qty_ctr
        bpy.context.scene.khaos_tool.sk_qty_ctr_obj = qty_ctr_obj
        
    def updt_qty_frac():
        # name = bpy.context.scene.khaos_tool.sk_frac_name_collection
        # #nome padrao
        # count = 0
        # all_coll_frac = []
        # name_frac = name+'-'
        # coll = bpy.data.collections

        # len_name_start_ctr = len(name+'-{:03}'.format(0))
        # #get all constraints and keep to reference and organize
        # for myCol in coll:
        #     if myCol.name.startswith(name_frac) and myCol.name[len_name_start_ctr:].startswith('.Constraint') is not True:
        #         all_coll_frac.append(myCol.name)
        # #set the new amout
        # bpy.context.scene.khaos_tool.sk_qty_frac = len(all_coll_frac)



        frac_collection = bpy.context.scene.khaos_tool.sk_frac_collection #get frac collection ID
        if frac_collection != '0':
            dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
            for dp in dropb_itens:
                if frac_collection == dp[0]:
                    name = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu
                else: #if it doenst find a index for the frature, get one that is available
                    name = dp[1]

            qty_frac = len(dropb_itens)
            name_frac = name
            qty_frac_obj = len(bpy.data.collections[name_frac].all_objects)
        else:
            qty_frac = 0
            qty_frac_obj = 0


        bpy.context.scene.khaos_tool.sk_qty_frac = qty_frac
        bpy.context.scene.khaos_tool.sk_qty_frac_obj = qty_frac_obj
     
        
        
    def colapse_collection(name):
        context = bpy.context
        screen = context.screen
        #collection = context.collection
        collection = bpy.data.collections[name]
        #view_layer = context.view_layer

        outliners = [a for a in screen.areas if a.type == 'OUTLINER']
        c = context.copy()
        c["collection"] = collection
        for ol in outliners:
            c["area"] = ol

            bpy.ops.outliner.show_one_level(c, open=False)
            ol.tag_redraw()



    def updt_deactivate(self, context):
        #print('click funcionou')
        action = True if self.sk_deactivated_rb else False
        for obj in bpy.context.selected_objects:
            if obj.rigid_body is not None:
                obj.rigid_body.use_deactivation = action
                obj.rigid_body.use_start_deactivated = action
                # print('Start deactivated: ',action)
   
    def updt_convex_coll_margin_bool(self, context):
        collision_margin = bpy.context.scene.khaos_tool.sk_collision_margin
        action = True if self.sk_bool_conv_coll_margin else False
        for obj in bpy.context.selected_objects:
            if obj.type == 'MESH' and obj.rigid_body is not None:
                obj.rigid_body.collision_margin = collision_margin
                if obj.rigid_body.collision_shape not in ['MESH','CONE']:
                    obj.rigid_body.use_margin = action

    def updt_coll_margin(self, context):
        collision_margin = bpy.context.scene.khaos_tool.sk_collision_margin
        for obj in bpy.context.selected_objects:
            if obj.type == 'MESH' and obj.rigid_body is not None:
                obj.rigid_body.collision_margin = collision_margin
    
    
    def updt_ctr_breakable(self, context):
    #    print('click funcionou')
        global UPT_HNDLR

        if UPT_HNDLR == 0:
            action = True if self.sk_ctr_breakable_rb else False
            #--
            Helper.select_ctr(self, context)
            #--
            for obj in bpy.context.selected_objects:
                obj.rigid_body_constraint.use_breaking = action
        
    def updt_ctr_breakable2(ctr_breakable_rb):
        # print('click funcionou')
        global UPT_HNDLR

        if UPT_HNDLR == 0:
            action = True if ctr_breakable_rb else False
            #---
            ctr_collection = bpy.context.scene.khaos_tool.sk_ctr_collection
            name_ctr = Helper.coll_name_ctr(bpy.context,ctr_collection)
            Helper.select(name_ctr)
            #--
            for obj in bpy.context.selected_objects:
                obj.rigid_body_constraint.use_breaking = action

    def updt_ctr_threshold(self, context):
        global UPT_HNDLR

        if UPT_HNDLR == 0:
            ctr_brk_threshold = context.scene.khaos_tool.sk_ctr_brk_threshold
            Helper.select_ctr(self, context)
            for obj in bpy.context.selected_objects:
                obj.rigid_body_constraint.breaking_threshold = ctr_brk_threshold







blend_file = os.path.join(os.path.dirname(os.path.realpath(__file__)), 'particlegroups', 'ExplosionParticleGroups.blend')




##############
## Call back - This function updates the list of constraint in the dropbox menu
## It was done using the ascending order, then the descending order was done
## probably what will be enabled is the descending order.
##############
def my_settings_frac_callback(scene, context):
    name = context.scene.khaos_tool.sk_frac_name_collection
    name_ctr = name+'-'
    items = []
    colls = bpy.data.collections
    # frac_collection = context.scene.khaos_tool.sk_frac_collection
    i=0

    ####
    #generate the custom size to search for Constraint name (to be able to use "startswith")
    len_name_start_ctr = len(name+'-{:03}'.format(0))

    for x in range(len(colls)-1,-1,-1):
        if colls[x].name.startswith(name_ctr):
            if colls[x].name[len_name_start_ctr:].startswith('.Constraint') is not True:
                i=i+1
                # items.append((str(i),"%s" % colls[x].name,"Collection: %s" % colls[x].name))
                items.append((str(i),"%s" % colls[x].name,"Collection: %s" % colls[x].name))
                #print('my_settings_callback-coll_name: ',colls[x].name,' id: ',i)
    if len(items) == 0:
        items.append((str(0),"Nothing","No Collection available"))

    return items


def my_settings_callback(scene, context):
    # name = context.scene.khaos_tool.sk_frac_name_collection
    frac_collection = context.scene.khaos_tool.sk_frac_collection #get frac collection ID
    items = []
   
    
    dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
    for dp in dropb_itens:
        if frac_collection == dp[0]:
            name = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu

    name_ctr = name+'.'+'Constraint'
    colls = bpy.data.collections
    i=0
    for x in range(len(colls)-1,-1,-1):
        if colls[x].name.startswith(name_ctr):
            i=i+1
            items.append((str(i),"%s" % colls[x].name,"Collection: %s" % colls[x].name))
        #    print('my_settings_callback-coll_name: ',colls[x].name,' id: ',i)
    if len(items) == 0:
        items.append((str(0),"Nothing","No Collection available"))
    

    return items


class SnapFace(Operator):
    bl_idname = "view3d.snap_face"
    bl_label = "Snap Face"
    bl_description = "Snap Face"
    def execute(self,context):
        bpy.context.scene.tool_settings.snap_elements = {'FACE'}
        return{'FINISHED'}

class SnapEdge(Operator):
    bl_idname = "view3d.snap_edge"
    bl_label = "snap_edge"
    bl_description = "snap_edge"
    def execute(self,context):
        bpy.context.scene.tool_settings.snap_elements = {'EDGE'}
        return{'FINISHED'}

class SnapVertex(Operator):
    bl_idname = "view3d.snap_vertex"
    bl_label = "snap_vertex"
    bl_description = "snap_vertex"
    def execute(self,context):
        bpy.context.scene.tool_settings.snap_elements = {'VERTEX'}
        return{'FINISHED'}

class ColapseMenus(Operator):
    bl_idname = "view3d.colapse_menus"
    bl_label = "Colapse Collections"
    bl_description = "Colapse Collections"
    def execute(self,context):
        # context.object.expanded0 = False
        # context.object.expanded1 = False
        # context.object.expanded2 = False
        # context.object.expanded3 = False
        # context.object.expanded4 = False

        context.scene.expanded0 = False
        context.scene.expanded1 = False
        context.scene.expanded2 = False
        context.scene.expanded3 = False
        context.scene.expanded4 = False
        return{'FINISHED'}

class ExpandMenus(Operator):
    bl_idname = "view3d.expand_menus"
    bl_label = "Expand Menus"
    bl_description = "Colapse Collections"
    def execute(self,context):
        # context.object.expanded0 = True
        # context.object.expanded1 = True
        # context.object.expanded2 = True
        # context.object.expanded3 = True
        # context.object.expanded4 = True

        context.scene.expanded0 = True
        context.scene.expanded1 = True
        context.scene.expanded2 = True
        context.scene.expanded3 = True
        context.scene.expanded4 = True

        return{'FINISHED'}

class Colapse(Operator):
    bl_idname = "view3d.colapse"
    bl_label = "Colapse Collections"
    bl_description = "Colapse Collections"

    def execute(self,context):

        toggle_expand(context, 2)
        return{'FINISHED'}


#
class KhaosSettings(bpy.types.PropertyGroup):
    
    #
    my_bool : BoolProperty(
        name="Enable or Disable",
        description="Smoke Particles",
        default = False
        )
    
    my_bool1 : BoolProperty(
        name="Enable or Disable",
        description="Glass Particles",
        default = False
        )
     
    my_bool2 : BoolProperty(
        name="Enable or Disable",
        description="Metal Shard Particles",
        default = False
        )
    
    my_bool3 : BoolProperty(
        name="Enable or Disable",
        description="Wood Particles",
        default = False
        )
    
    my_bool4 : BoolProperty(
        name="Enable or Disable",
        description="Burning Debris",
        default = False
        )
    
    my_bool5 : BoolProperty(
        name="Enable or Disable",
        description="Sparks",
        default = False
        )
        
    my_bool6 : BoolProperty(
        name="Enable or Disable",
        description="Dirt Debris",
        default = False
        )
    
    my_bool7 : BoolProperty(
        name="Enable or Disable",
        description="Smoke Particlulate cheat",
        default = False
        )
    
    my_bool8 : BoolProperty(
        name="Enable or Disable",
        description="Smoke/Fire Particles",
        default = False
        )
    
    my_bool9 : BoolProperty(
        name="Enable or Disable",
        description="Tree Branch Debris",
        default = False
        )
    
    my_bool10 : BoolProperty(
        name="Enable or Disable",
        description="Concrete Debris",
        default = False
        )
    
    my_bool11 : BoolProperty(
        name="Enable or Disable",
        description="Rebar Debris",
        default = False
        )
    
    my_bool12 : BoolProperty(
        name="Enable or Disable",
        description="Rock Debris",
        default = False
        )
    
    my_bool13 : BoolProperty(
        name="Enable or Disable",
        description="Thicker Smoke/Fire",
        default = False
        )
    
    my_bool14 : BoolProperty(
        name="Enable or Disable",
        description="Dynamic Dirt with alternative domain settings",
        default = False
        )
        
    

    
    velocitydim : FloatProperty(
            name="Width",
            description="Scale the velocity of all particles",
            min=0.0, max=100.0,
            default=1.0,
        )
        
    
    randomspreaddim : FloatProperty(
            name="Width",
            description="Scale the random spread of all particles",
            min=0.00, max=100.0,
            default=1.0,
        )
        
    
    particleamountdim : IntProperty(
            name="Width",
            description="Scale the amount of particles included in each category",
            min=-100, max=10000,
            default=1,
        )
        
    
    particleemissiondurationdim : FloatProperty(
            name="Width",
            description="Scale the duration of time that the particles are emitted from source explosion (AKA Duration of Initial blast)",
            min=0.00, max=100.0,
            default=1.0,
        )
    
    particledlifetimedim : FloatProperty(
            name="Width",
            description="Scale the lifetime of all smoke particles emitted   (Larger value = bigger ending explosion size given same particle velocity",
            min=0.00, max=100.0,
            default=1.0,
        )

    #
    particlesmokeflowsizestartdim : FloatProperty(
            name="Width",
            description="Scale the start size of particles emitting smoke/fire (Larger Values create more 'smokey'/less 'debris like' blasts)",
            min=0.00, max=20.0,
            default=1.0,
        )

    #
    particlesmokeflowsizeenddim : FloatProperty(
            name="Width",
            description="Scale the end size of particles emitting smoke/fire (Larger values create more 'smokey'/less 'debris like' blasts)",
            min=0.00, max=20.0,
            default=1.0,
        )

    #
    particleflameratestartdim : FloatProperty(
            name="Width",
            description="Scale the amount of fuel emitted from fire particles at beginning of blast",
            min=0.00, max=10.0,
            default=1.0,
        )

    #
    particleflamerateenddim : FloatProperty(
            name="Width",
            description="Scale the amount of fuel emitted from fire particles at end of blast",
            min=0.00, max=20.0,
            default=1.0,
        )

    #
    particleinitialvelstartdim : FloatProperty(
            name="Width",
            description="Scale the amount of initial velocity turbulence in smoke/fire during beginning of blast",
            min=0.00, max=100.0,
            default=1.00,
        )

    #
    particleinitialvelenddim : FloatProperty(
            name="Width",
            description="Scale the amount of initial velocity turbulence in smoke/fire during the end of blast",
            min=0.00, max=100.0,
            default=1.00,
        )
    

    #
    mixfuelinitialturbulencestrength : FloatProperty(
            name="Width",
            description="Amount of turbulence strength that the mix fuel operator starts with",
            min=0.00, max=100.0,
            default=20.0,
        )

    #
    mixfuelfinalturbulencestrength : FloatProperty(
            name="Width",
            description="Amount of turbulence strength that the mix fuel operator timeline feathers down to",
            min=0.00, max=100.0,
            default=0.0,
        )

    #
    turbulenceduration : FloatProperty(
            name="Width",
            description="Number of frames the mix fuel operator lasts for until the final turbulence strength value is reached",
            min=0.00, max=100.0,
            default=24.0,
        )



    ##############################
    ##### Fracture properties#####
    #           Start

    sk_frac_name_collection: StringProperty(name="Name",default="KHAOS", description="Name of Collection")
    sk_floor_size: IntProperty(name="Size",default=10, description="Floor Size")
    sk_material_idx: IntProperty(name="Material in list",default=2, min=1,  description="Material order in the list")
    sk_deactivated_rb: BoolProperty(name='Start Deactivated', default=False, update=Helper.updt_deactivate)
    sk_frac_source_limit: IntProperty(name="Source Limit", description="Fracture Source Limit", default=100)
    sk_frac_source_noise: IntProperty(name="Source Noise", description="Fracture Source Noise", default=0)
    sk_frac_recursion: IntProperty(name="Recursion", description="Fracture Recursion", default=0)

    sk_frac_margin: FloatProperty(name="Margin", description="Fracture Margin", default= 0.001,precision=4)
    sk_collision_margin: FloatProperty(name="Collision Margin", description="Collision Margin", default= 0.0001,precision=5, update=Helper.updt_coll_margin)
    sk_bool_conv_coll_margin: BoolProperty(name='Convex Collision Margin Bool', default=False, update=Helper.updt_convex_coll_margin_bool)
    sk_mesh_collision: EnumProperty(
        name= "Type of Mesh Collider",
        description="Change mesh type collider",
        items= [('BOX','Box','Box Mesh Collision'), 
        ('SPHERE', 'Sphere','Sphere Mesh Collision'), 
        ('CAPSULE', 'Capsule','Capsule Mesh Collision'), 
        ('CYLINDER', 'Cylinder','Cylinder Mesh Collision'), 
        ('CONE','Cone','Cone Mesh Collision'), 
        ('CONVEX_HULL', 'Convex Hull','Convex Hull Mesh Collision'), 
        ('MESH', 'Mesh','Mesh Mesh Collision'), 
        ('COMPOUND','Compound','Compound Mesh Collision')
        ], 
        default = 'CONVEX_HULL',
        update=upt_mesh_colision
        )
    sk_calc_mass: EnumProperty(
        name= "Calculate Mass",
        description="Calculate Mass of rigidbody",
        items= [('Air|1','Air','Material Air'),
            ('Acrylic|1400','Acrylic','Material Acrylic'),
            ('Brick (Common)|2000','Brick (Common)','Material Brick (Common)'),
            ('Beans (Soy)|721','Beans (Soy)','Material Beans (Soy)'),
            ('Asphalt (Crushed)|721','Asphalt (Crushed)','Material Asphalt (Crushed)'),
            ('Bark|240','Bark','Material Bark'),
            ('Beans (Cocoa)|593','Beans (Cocoa)','Material Beans (Cocoa)'),
            ('Beans (Soy)|721','Beans (Soy)','Material Beans (Soy)'),
            ('Brick (Pressed)|2400','Brick (Pressed)','Material Brick (Pressed)'),
            ('Brick (Common)|2000','Brick (Common)','Material Brick (Common)'),
            ('Brick (Soft)|1600','Brick (Soft)','Material Brick (Soft)'),
            ('Brass|8216','Brass','Material Brass'),
            ('Bronze|8860','Bronze','Material Bronze'),
            ('Carbon (Solid)|2146','Carbon (Solid)','Material Carbon (Solid)'),
            ('Cardboard|689','Cardboard','Material Cardboard'),
            ('Cast Iron|7150','Cast Iron','Material Cast Iron'),
            ('Chalk (Solid)|2499','Chalk (Solid)','Material Chalk (Solid)'),
            ('Concrete|2320','Concrete','Material Concrete'),
            ('Charcoal|208','Charcoal','Material Charcoal'),
            ('Cork|240','Cork','Material Cork'),
            ('Copper|8933','Copper','Material Copper'),
            ('Garbage|481','Garbage','Material Garbage'),
            ('Glass (Broken)|1940','Glass (Broken)','Material Glass (Broken)'),
            ('Glass (Solid)|2190','Glass (Solid)','Material Glass (Solid)'),
            ('Gold|19282','Gold','Material Gold'),
            ('Granite (Broken)|1650','Granite (Broken)','Material Granite (Broken)'),
            ('Granite (Solid)|2691','Granite (Solid)','Material Granite (Solid)'),
            ('Gravel|2780','Gravel','Material Gravel'),
            ('Ice (Crushed)|593','Ice (Crushed)','Material Ice (Crushed)'),
            ('Ice (Solid)|919','Ice (Solid)','Material Ice (Solid)'),
            ('Iron|7874','Iron','Material Iron'),
            ('Lead|11342','Lead','Material Lead'),
            ('Limestone (Broken)|1554','Limestone (Broken)','Material Limestone (Broken)'),
            ('Limestone (Solid)|2611','Limestone (Solid)','Material Limestone (Solid)'),
            ('Marble (Broken)|1570','Marble (Broken)','Material Marble (Broken)'),
            ('Marble (Solid)|2563','Marble (Solid)','Material Marble (Solid)'),
            ('Paper|1201','Paper','Material Paper'),
            ('Peanuts (Shelled)|641','Peanuts (Shelled)','Material Peanuts (Shelled)'),
            ('Peanuts (Not Shelled)|272','Peanuts (Not Shelled)','Material Peanuts (Not Shelled)'),
            ('Plaster|849','Plaster','Material Plaster'),
            ('Plastic|1200','Plastic','Material Plastic'),
            ('Polystyrene|1050','Polystyrene','Material Polystyrene'),
            ('Rubber|1522','Rubber','Material Rubber'),
            ('Silver|10501','Silver','Material Silver'),
            ('Steel|7860','Steel','Material Steel'),
            ('Stone|2515','Stone','Material Stone'),
            ('Stone (Crushed)|1602','Stone (Crushed)','Material Stone (Crushed)'),
            ('Timber|610','Timber','Material Timber'),
        ], 
        default = 'Brick (Common)|2000',
        update=upt_calc_mass
    )
    sk_qty_ctr: IntProperty(name="Total Qty Constraint", min=0,  description="Quantity of constraint in current Fractured group")
    sk_qty_ctr_obj: IntProperty(name="Total Obj Qty Constraint", min=0,  description="Quantity of Obj in current Constraint Fractured group")
    sk_qty_frac: IntProperty(name="Total Qty Frac", min=0,  description="Quantity of Fractured group")
    sk_qty_frac_obj: IntProperty(name="Total Obj Qty Frac", min=0,  description="Quantity of Object in Fractured group")
    sk_ctr_idx: IntProperty(name="Number", min=0,  description="Quantity of constraint in current Fractured group")
    sk_ctr_conn_pattern: EnumProperty(
        name= "Connection Pattern",
        description="Change Connection Pattern",
        items= [
        ('CHAIN_DISTANCE','Chain Distance','CHAIN_DISTANCE Constraint'), 
        ('SELECTED_TO_ACTIVE', 'Selected to Active','SELECTED_TO_ACTIVE Constraint')
        ], 
        default = 'SELECTED_TO_ACTIVE'
        )

    sk_ctr_pivot_type: EnumProperty(
        name= "Pivot Type",
        description="Change Pivot Type",
        items= [
        ('CENTER','Center','Cneter Pivot Type'), 
        ('ACTIVE', 'Active','Active Pivot Type'),
        ('SELECTED', 'Selected','Selected Pivot Type')
        ], 
        default = 'CENTER'
        )

    sk_ctr_conn_type: EnumProperty(
        name= "Connection Type",
        description="Change Connection Type",
        items= [
        ('FIXED','Fixed','Fixed Connection Type'), 
        ('POINT', 'Point','Point Connection Type'),
        ('HINGE', 'Hinge','Hinge Connection Type'),
        ('SLIDER', 'Slider','Slider Connection Type'),
        ('PISTON', 'Piston','Piston Connection Type'),
        ('GENERIC', 'Generic','Generic Connection Type'),
        ('GENERIC_SPRING', 'Generic Spring','Generic Spring Connection Type'),
        ('MOTOR', 'Motor','Motor Connection Type')
        ], 
        default = 'FIXED'
        )

    sk_ctr_breakable_rb: BoolProperty(name='Breakable', default=False, update=Helper.updt_ctr_breakable)
    sk_ctr_brk_threshold: FloatProperty(name="Threshold", description="Breakable Threshold", default= 10.00,precision=2, update=Helper.updt_ctr_threshold)
    sk_ctr_collection : EnumProperty(
        name="Constraint Collection:",
        description="Select Constraint Collection.",
        items=my_settings_callback,
        update=Helper.select_ctr
        )
    sk_frac_collection : EnumProperty(
        name="Fractured Collection:",
        description="Select Fractured Collection.",
        items=my_settings_frac_callback,
        update=Helper.select_frac
        )
    #           End
    ##### Fracture properties#####
    ##############################


    ##############################
    #### Pop up smoke plume
    basicsmokeplume_panel_bool: BoolProperty(name='Switch to Plume options', default=False)
    highest_fuel_rate: FloatProperty(name= "Highest Fuel Rate:", default=1)
    lowest_fuel_rate: FloatProperty(name= "Lowest Fuel Rate:", default=0.5)
    fuelpulsetiming: IntProperty(name= "Fuel Pulse timing (Frames):", min=2, max=100, default=24)
    ###############
    ### Pop up wind options
    basicwindpulse_panel_bool: BoolProperty(name='Switch to wind options', default=False)
    highest_wind_strength : FloatProperty(name= "Highest Wind Strength:", default=1.80)
    lowest_wind_strength : FloatProperty(name= "Lowest Wind Strength:", default=0.25)
    pulsetiming : IntProperty(name= "Pulse timing (Frames):", min=2, max=100, default=26)
    



class NEW_OT_DirectionalExplosionPreset (bpy.types.Operator):
    bl_idname = 'my.directionexplosion'
    bl_label = 'Directional burst'
    
    def execute(self, context):
        #
        if (context.scene.khaos_tool.my_bool == True):
            
            #
            bpy.ops.mesh.primitive_plane_add(size=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)

       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'SMOKE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
           
            
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            
            
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
            
            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke Directional Particle Emit"
        
        
        
        
            #
            
            
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                     
                    #   
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
 
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'


        
        #
        if (context.scene.khaos_tool.my_bool8 == True):
            
            #
            bpy.ops.mesh.primitive_plane_add(size=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)

            
            
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
                
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Directional Particle Emit"
        
        
                #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #    
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
        
        
        #
        if (context.scene.khaos_tool.my_bool13 == True):
            
            #
            bpy.ops.mesh.primitive_plane_add(size=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
                
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'BOTH'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Directional Particle Emit"
        
        
                #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #    
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
        
        
        #
        if (context.scene.khaos_tool.my_bool14 == True):
            
            #
            bpy.ops.mesh.primitive_plane_add(size=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)

       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Dirtblast explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'SMOKE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Dirtblast Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
           
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
            
            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast Directional Particle Emit"
        
        
        
        
            #
            if bpy.data.objects.get('Dirt Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Dirt Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                     
                    #    
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
 
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'


        
        #
        if (context.scene.khaos_tool.my_bool7 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Smoke Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.groups["Smoke Pieces"].name = "Smoke Particles"
               
                #
                bpy.ops.object.move_to_layer(layers=(False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True))
               
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
            
            
            #
            bpy.ops.mesh.primitive_plane_add(view_align=False, enter_editmode=False, location=(bpy.context.scene.cursor_location), layers=(True, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Particulate Smoke Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Particulate Smoke explosion'
                settings.emit_from = 'FACE'
                settings.physics_type = 'NEWTON'
                settings.particle_size = 2
                settings.render_type = 'GROUP'
                settings.dupli_group = bpy.data.particles["Particulate Smoke explosion"].dupli_group = bpy.data.groups["Smoke Particles"] #just a note here the reason we are using the Glass Particles group is because we renamed the original Glass Pieces group above to Glass Particles
                settings.show_unborn = True
                settings.use_dead = True
                settings.frame_end = 1
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.jitter_factor = 0
                settings.normal_factor = 200 * context.scene.khaos_tool.velocitydim 
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

              
        
        #
        if (context.scene.khaos_tool.my_bool1 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Glass Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Glass Pieces"].name = "Glass Particles"
               
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Glass Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Glass Particle Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Glass explosion'
                settings.count = 500 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 28 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 15 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0
                bpy.data.particles["Glass explosion"].instance_collection = bpy.data.collections["Glass Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                

        
            
        #
        if (context.scene.khaos_tool.my_bool2 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Metal Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Metal Pieces"].name = "Metal Particles"
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Metal Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                
                
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                
                
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                    
                    
                    
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Metal Particle Emitter"
            
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Metal Shard explosion'
                settings.count = 45 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 30 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.15
                settings.size_random = 0.5
                bpy.data.particles["Metal Shard explosion"].instance_collection = bpy.data.collections["Metal Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                
            
            
            
        #
        if (context.scene.khaos_tool.my_bool3 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Wood Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Wood Pieces"].name = "_wood particles"
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_wood particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                
                
                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                    
                    
                    
            
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            
            for obj in bpy.context.selected_objects:
                obj.name = "_Wood Particle emitter"
            
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Wood pieces explosion'
                settings.count = 140 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 4)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.07
                settings.size_random = 0.3
                bpy.data.particles["_Wood pieces explosion"].instance_collection = bpy.data.collections["_wood particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
            
           

        #
        if (context.scene.khaos_tool.my_bool4 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Burning Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Burning Pieces"].name = "Burning Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Burning Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            

            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Burning Debris Emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Burning debris explosion'
                settings.count = 30 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 11 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.14
                settings.size_random = 0.4
                bpy.data.particles["Burning debris explosion"].instance_collection = bpy.data.collections["Burning Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Burning Debris Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = 0.3
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = 0.2
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = 0.5
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 18
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Burning Debris Directional Particle Emit"

    #
            if bpy.data.objects.get('Smoke Domain') == None:
                    
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #  
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'



        #
        if (context.scene.khaos_tool.my_bool5 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Spark Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                
                bpy.data.collections["Spark Pieces"].name = "_Spark Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #Change the Active LayerCollection to 'My Collection'
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Spark Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Spark Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Spark pieces explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 3)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 22 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.2
                settings.size_random = 0.3
                bpy.data.particles["_Spark pieces explosion"].instance_collection = bpy.data.collections["_Spark Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool6 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Dirt Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Dirt Pieces"].name = "_Dirt Particles"
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Dirt Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Dirt Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Dirt particle explosion'
                settings.count = 1000 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 8)
                settings.lifetime = 250 
                settings.emit_from = 'FACE'
                settings.normal_factor = 16 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0.1
                settings.drag_factor = 1
                settings.damping = 0.06
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.02
                settings.size_random = 1
                bpy.data.particles["_Dirt particle explosion"].instance_collection = bpy.data.collections["_Dirt Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        
        #
        if (context.scene.khaos_tool.my_bool9 == True):
            
            
            section = "\\Collection\\"
            objects = ["Tree Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Tree Pieces"].name = "_Branch Particles"
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #Change the Active LayerCollection to '_Dirt Particles'
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Branch Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                

                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Branch Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Branch particle explosion'
                settings.count = 120 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 16 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.1
                settings.size_random = 1
                bpy.data.particles["_Branch particle explosion"].instance_collection = bpy.data.collections["_Branch Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool10 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Concrete Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Concrete Pieces"].name = "_Concrete Particles"
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Concrete Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                

                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Concrete Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Concrete particle explosion'
                settings.count = 65 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 14 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 5
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 0.2
                bpy.data.particles["_Concrete particle explosion"].instance_collection = bpy.data.collections["_Concrete Particles"]
                
                
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool11 == True):
            #F
            
            section = "\\Collection\\"
            objects = ["Rebar Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Rebar Pieces"].name = "_Rebar Particles"
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #Change the Active LayerCollection to '_Concrete Particles'
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rebar Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                

                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rebar Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #a
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rebar particle explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 12 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 7 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 6
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0.25
                bpy.data.particles["_Rebar particle explosion"].instance_collection = bpy.data.collections["_Rebar Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool12 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Rock Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Rock Pieces"].name = "_Rock Particles"
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rock Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                

                
                
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_plane_add(enter_editmode=False, location=(bpy.context.scene.cursor.location))
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rock Particle emitter"
            #
            bpy.ops.transform.rotate(value=1.13446, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            #
            bpy.ops.transform.resize(value=(0.7, 0.7, 0.7), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
            
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rock particle explosion'
                settings.count = 200 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 13 * context.scene.khaos_tool.velocitydim 
                settings.factor_random = 6 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 12
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 1
                bpy.data.particles["_Rock particle explosion"].instance_collection = bpy.data.collections["_Rock Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0



        return{'FINISHED'}








#
class NEW_OT_OmnidirectionalExplosionPreset (bpy.types.Operator):
    bl_idname = 'my.omnidirectionalexplosion'
    bl_label = 'Omnidirectional burst'
    
    def execute(self, context):
        #
        if (context.scene.khaos_tool.my_bool == True):
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke Particle Emitter"
           
         
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke explosion'
                settings.count = 150 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'SMOKE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
            
            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke Omnidirectional Particle Emit"
        
        
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            
            
        
        #
        if (context.scene.khaos_tool.my_bool8 == True):
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke/Fire explosion'
                settings.count = 150 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #n
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Omnidirectional Particle Emit"
        
        
            #A
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #  
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            
        
        
        #
        if (context.scene.khaos_tool.my_bool13 == True):
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke/Fire explosion'
                settings.count = 150 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'BOTH'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True

            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
  
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #N
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Omnidirectional Particle Emit"
        
        
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #  
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            
            
        #
        if (context.scene.khaos_tool.my_bool14 == True):
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Dirtblast explosion'
                settings.count = 150 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'BOTH'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Dirtblast Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True

            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
  
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast Omnidirectional Particle Emit"
        
        
            #
            if bpy.data.objects.get('Dirt Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Dirt Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #   
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
                
        
        
        
        #
        if (context.scene.khaos_tool.my_bool7 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Smoke Pieces"] 
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.groups["Smoke Pieces"].name = "Smoke Particles"
               
                #
                bpy.ops.object.move_to_layer(layers=(False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True))
               
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
            
            
            #ad
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Glass Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Particulate Smoke explosion'
                settings.emit_from = 'FACE'
                settings.physics_type = 'NEWTON'
                settings.particle_size = 2
                settings.render_type = 'COLLECTION'
                settings.dupli_group = bpy.data.particles["Particulate Smoke explosion"].dupli_group = bpy.data.groups["Smoke Particles"] #just a note here the reason we are using the Glass Particles group is because we renamed the original Glass Pieces group above to Glass Particles
                settings.show_unborn = True
                settings.use_dead = True
                settings.frame_end = 1
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.jitter_factor = 0
                settings.normal_factor = 200
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

        
        #
        if (context.scene.khaos_tool.my_bool1 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Glass Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Glass Pieces"].name = "_Glass Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Glass Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Glass Particle Emitter"
           
       
       
            #
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Glass explosion'
                settings.count = 500 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 28 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 15 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0
                
                bpy.data.particles["_Glass explosion"].instance_collection = bpy.data.collections["_Glass Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                


        #
        if (context.scene.khaos_tool.my_bool2 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Metal Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Metal Pieces"].name = "_Metal Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Metal Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Metal Particle Emitter"
           
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Metal Shard explosion'
                settings.count = 45 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 30 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00 
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.15
                settings.size_random = 0.5
                
                bpy.data.particles["_Metal Shard explosion"].instance_collection = bpy.data.collections["_Metal Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                
            
            
        #
        if (context.scene.khaos_tool.my_bool3 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Wood Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Wood Pieces"].name = "_Wood Particles"
               
               
               
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Wood Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Wood Particle Emitter"
           
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Wood pieces explosion'
                settings.count = 140 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 4)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.07
                settings.size_random = 0.3
                bpy.data.particles["_Wood pieces explosion"].instance_collection = bpy.data.collections["_Wood Particles"]
            
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                

        #
        if (context.scene.khaos_tool.my_bool4 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Burning Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Burning Pieces"].name = "_Burning Particles"
               
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Burning Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Burning debris Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Burning debris explosion'
                settings.count = 30 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 11 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.14
                settings.size_random = 0.4
                bpy.data.particles["_Burning debris explosion"].instance_collection = bpy.data.collections["_Burning Particles"]
            
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["_Burning debris Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = 0.3
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = 0.2
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = 0.5
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Burning Debris Omnidirectional Particle Emit"

    #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #    
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'


        #
        if (context.scene.khaos_tool.my_bool5 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Spark Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Spark Pieces"].name = "_Spark Particles"
               
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Spark Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Spark Particle Emitter"
           
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Spark pieces explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 3)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 22 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.2
                settings.size_random = 0.3
                bpy.data.particles["_Spark pieces explosion"].instance_collection = bpy.data.collections["_Spark Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool6 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Dirt Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Dirt Pieces"].name = "_Dirt Particles"
               
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Dirt Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Dirt Particle Emitter"
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Dirt particle explosion'
                settings.count = 1000 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 8)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 16 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0.1
                settings.drag_factor = 1
                settings.damping = 0.06
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.02
                settings.size_random = 1
                bpy.data.particles["_Dirt particle explosion"].instance_collection = bpy.data.collections["_Dirt Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool9 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Tree Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Tree Pieces"].name = "_Branch Particles"
                
                
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Branch Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Branch Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Branch omnidirectional particle explosion'
                settings.count = 120 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 16 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.1
                settings.size_random = 1
                bpy.data.particles["_Branch omnidirectional particle explosion"].instance_collection = bpy.data.collections["_Branch Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool10 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Concrete Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #T
                bpy.data.collections["Concrete Pieces"].name = "_Concrete Particles"
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Concrete Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Concrete Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Concrete particle explosion'
                settings.count = 65 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 14 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 5
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 0.2
                bpy.data.particles["_Concrete particle explosion"].instance_collection = bpy.data.collections["_Concrete Particles"]
                
                #di
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool11 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Rebar Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #T
                bpy.data.collections["Rebar Pieces"].name = "_Rebar Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rebar Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rebar Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rebar particle explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 12 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 7 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 6
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0.25
                bpy.data.particles["_Rebar particle explosion"].instance_collection = bpy.data.collections["_Rebar Particles"]
                
                
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool12 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Rock Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #T
                bpy.data.collections["Rock Pieces"].name = "_Rock Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rock Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_uv_sphere_add(radius=.35, enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rock Particle Emitter"
       
       
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rocks particle explosion'
                settings.count = 200 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 13 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 6 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 12
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 1
                bpy.data.particles["_Rocks particle explosion"].instance_collection = bpy.data.collections["_Rock Particles"]
                
                #d
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        return{'FINISHED'}


#
class NEW_OT_GroundburstExplosionPreset (bpy.types.Operator):
    bl_idname = 'my.groundburstexplosion'
    bl_label = '360 groundburst'
    
    def execute(self, context):
        
        #
        if (context.scene.khaos_tool.my_bool == True):
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke 360 Groundburst Particle Emitter"
            
            
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'SMOKE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke 360 Groundburst Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
            
            
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke 360 Groundburst Particle Emit"
        
        
        
        
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #    
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                        
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'

        #
        if (context.scene.khaos_tool.my_bool8 == True):
            
             #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke/fire explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
            
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire 360 groundburst Particle Emit"
        
        
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #   
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            
        
        
        #
        if (context.scene.khaos_tool.my_bool13 == True):
            
             
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire Particle Emitter"
       
            
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Smoke/fire explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'BOTH'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Smoke/Fire Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
            
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #.
            for obj in bpy.context.selected_objects:
                obj.name = "Smoke/Fire 360 groundburst Particle Emit"
        
        
            #
            if bpy.data.objects.get('Smoke Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
        
        
        #
        if (context.scene.khaos_tool.my_bool14 == True):
            
             #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #N
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Dirtblast explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 4 * context.scene.khaos_tool.particledlifetimedim
                settings.lifetime_random = .5
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.physics_type = 'NEWTON'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = False 
                settings.particle_size = 2
                settings.render_type = 'HALO'
                settings.show_unborn = False
                settings.use_dead = False
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0

                bpy.ops.object.duplicates_make_real() 
                '''not sure what this line does but it was included
                in the stackexchange particle system question answer'''
        
            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'BOTH'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["Dirtblast Particle Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelstartdim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = context.scene.khaos_tool.particleinitialvelenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.velocity_factor', frame= (bpy.context.scene.frame_current+6)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = context.scene.khaos_tool.particlesmokeflowsizeenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.particle_size', frame= (bpy.context.scene.frame_current+4)* context.scene.khaos_tool.particleemissiondurationdim) #can experiment with these multiply values to get different outputs
            #
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = bpy.context.scene.khaos_tool.particleflameratestartdim 
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= bpy.context.scene.frame_current+2)
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = context.scene.khaos_tool.particleflamerateenddim
            obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount', frame= (bpy.context.scene.frame_current+1) + (context.scene.khaos_tool.particleemissiondurationdim * 5)) #can experiment with these multiply values to get different outputs
            
            #
            
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 16
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "Dirtblast 360 groundburst Particle Emit"
        
        
            #
            if bpy.data.objects.get('Dirt Domain') == None:
                
                    section = "\\Collection\\"
                    objects = ["Dirt Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #   
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
        
        
        
        #
        if (context.scene.khaos_tool.my_bool7 == True):
            #
            
            section = "\\Group\\"
            objects = ["Smoke Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.groups["Smoke Pieces"].name = "Smoke Particles"
               
                #
                bpy.ops.object.move_to_layer(layers=(False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, False, True))
               
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
            
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "Particulate smoke Particle Emitter"
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = 'Particulate Smoke explosion'
                settings.emit_from = 'FACE'
                settings.physics_type = 'NEWTON'
                settings.particle_size = 2
                settings.render_type = 'GROUP'
                settings.dupli_group = bpy.data.particles["Particulate Smoke explosion"].dupli_group = bpy.data.groups["Smoke Particles"] #just a note here the reason we are using the Glass Particles group is because we renamed the original Glass Pieces group above to Glass Particles
                settings.show_unborn = True
                settings.use_dead = True
                settings.frame_end = 1
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.jitter_factor = 0
                settings.normal_factor = 200 * context.scene.khaos_tool.velocitydim
                settings.object_factor = 1
                settings.factor_random = 85 * context.scene.khaos_tool.randomspreaddim
                settings.effector_weights.turbulence = 0

        
        #
        if (context.scene.khaos_tool.my_bool1 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Glass Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Glass Pieces"].name = "_Glass Particles"
               
               
               
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Glass Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Glass Particle Emitter"
           
       
       
            #
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Glass explosion'
                settings.count = 500 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 28 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 15 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0
                bpy.data.particles["_Glass explosion"].instance_collection = bpy.data.collections["_Glass Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                


        #
        if (context.scene.khaos_tool.my_bool2 == True):
            
            
            section = "\\Collection\\"
            objects = ["Metal Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Metal Pieces"].name = "_Metal Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Metal Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Metal Particle Emitter"
           
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Metal Shard explosion'
                settings.count = 45 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 30 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.15
                settings.size_random = 0.5
                bpy.data.particles["_Metal Shard explosion"].instance_collection = bpy.data.collections["_Metal Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                
            
            
            
        #
        if (context.scene.khaos_tool.my_bool3 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Wood Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #.
                bpy.data.collections["Wood Pieces"].name = "_Wood Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Wood Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Wood Particle Emitter"
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Wood pieces explosion'
                settings.count = 140 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 4)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.07
                settings.size_random = 0.3
                bpy.data.particles["_Wood pieces explosion"].instance_collection = bpy.data.collections["_Wood Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
                

        #
        if (context.scene.khaos_tool.my_bool4 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Burning Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Burning Pieces"].name = "_Burning Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Burning Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #Change the Active LayerCollection to 'Collection'
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Burning Debris Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Burning debris explosion'
                settings.count = 30 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 11 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = .2
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = False
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.14
                settings.size_random = 0.4
                bpy.data.particles["_Burning debris explosion"].instance_collection = bpy.data.collections["_Burning Particles"]
                
                
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


            #
            bpy.ops.object.modifier_add(type='FLUID')
            bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
            bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_system = bpy.data.objects["_Burning Debris Emitter"].particle_systems["part"]
            bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = 0.3
            bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
            bpy.context.object.modifiers["Fluid"].flow_settings.velocity_factor = 0.2
            bpy.context.object.modifiers["Fluid"].flow_settings.use_particle_size = True
            bpy.context.object.modifiers["Fluid"].flow_settings.particle_size = 0.5
            bpy.context.object.modifiers["Fluid"].flow_settings.subframes = 18
            bpy.context.object.modifiers["Fluid"].flow_settings.use_absolute = False
        
            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Burning Debris 360 groundburst Particle Emit"

    #
            if bpy.data.objects.get('Smoke Domain') == None:
                    
                    section = "\\Collection\\"
                    objects = ["Smoke Domain"] #
        
                    directory = blend_file + section
        
                    for obj in objects:
                        filename = obj
                        bpy.ops.wm.append(filename=filename, directory=directory)
                        
                    #
                    bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
                    
            #
            else:
                bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'PARTICLES'


        #
        if (context.scene.khaos_tool.my_bool5 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Spark Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Spark Pieces"].name = "_Spark Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Spark Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Spark Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Spark pieces explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 3)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 32 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 22 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.2
                settings.size_random = 0.3
                bpy.data.particles["_Spark pieces explosion"].instance_collection = bpy.data.collections["_Spark Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


        #
        if (context.scene.khaos_tool.my_bool6 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Dirt Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Dirt Pieces"].name = "_Dirt Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Dirt Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Dirt Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Dirt particle explosion'
                settings.count = 1000 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 8)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 16 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 10
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0.1
                settings.drag_factor = 1
                settings.damping = 0.06
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.02
                settings.size_random = 1
                bpy.data.particles["_Dirt particle explosion"].instance_collection = bpy.data.collections["_Dirt Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool9 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Tree Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Tree Pieces"].name = "_Branch Particles"
                
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Branch Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Branch Particle Emitter"
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Branch 360 groundburst particle explosion'
                settings.count = 120 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 19 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 16 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 8
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.08
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.1
                settings.size_random = 1
                bpy.data.particles["_Branch 360 groundburst particle explosion"].instance_collection = bpy.data.collections["_Branch Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool10 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Concrete Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Concrete Pieces"].name = "_Concrete Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Concrete Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                #
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Concrete Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Concrete particle explosion'
                settings.count = 65 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 14 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 12 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 5
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.02
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 0.2
                bpy.data.particles["_Concrete particle explosion"].instance_collection = bpy.data.collections["_Concrete Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool11 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Rebar Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                #
                bpy.data.collections["Rebar Pieces"].name = "_Rebar Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rebar Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
                        
                    
                
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rebar Particle Emitter"
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rebar particle explosion'
                settings.count = 100 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 3
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 6)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 12 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 7 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 6
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.03
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.05
                settings.size_random = 0.25
                bpy.data.particles["_Rebar particle explosion"].instance_collection = bpy.data.collections["_Rebar Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0


    #
        if (context.scene.khaos_tool.my_bool12 == True):
            #
            
            section = "\\Collection\\"
            objects = ["Rock Pieces"] #
        
            directory = blend_file + section
        
            for obj in objects:
                filename = obj
                bpy.ops.wm.append(filename=filename, directory=directory)
                
                bpy.data.collections["Rock Pieces"].name = "_Rock Particles"
               
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, '_Rock Particles')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                
                bpy.context.view_layer.active_layer_collection.hide_viewport = True
                


                
                #
                for ob in bpy.context.selected_objects:
                    ob.select = False
                    
                
                def recurLayerCollection(layerColl, collName):
                    found = None
                    if (layerColl.name == collName):
                        return layerColl
                    for layer in layerColl.children:
                        found = recurLayerCollection(layer, collName)
                        if found:
                            return found
                        
                #
                layer_collection = bpy.context.view_layer.layer_collection
                layerColl = recurLayerCollection(layer_collection, 'Collection')
                bpy.context.view_layer.active_layer_collection = layerColl
                        
                '''above testing'''  
            
            #
            bpy.ops.mesh.primitive_cone_add(vertices=28, radius1=.35, radius2=.07, depth=.245, end_fill_type='NOTHING', enter_editmode=False, location=(bpy.context.scene.cursor.location))

            #
            for obj in bpy.context.selected_objects:
                obj.name = "_Rock Particle Emitter"
       
       
       
       
            #
       
            obj = bpy.context.active_object

            if len(obj.particle_systems) == 0:
                obj.modifiers.new("part", type='PARTICLE_SYSTEM')
                part = obj.particle_systems[0]

                settings = part.settings
                settings.name = '_Rocks particle explosion'
                settings.count = 200 * context.scene.khaos_tool.particleamountdim
                settings.frame_start = bpy.context.scene.frame_current + 1
                settings.frame_end = (bpy.context.scene.frame_current) + (context.scene.khaos_tool.particleemissiondurationdim * 5)
                settings.lifetime = 250
                settings.emit_from = 'FACE'
                settings.normal_factor = 13 * context.scene.khaos_tool.velocitydim
                settings.factor_random = 6 * context.scene.khaos_tool.randomspreaddim
                settings.use_rotations = True
                settings.rotation_factor_random = 1.00
                settings.use_dynamic_rotation= True
                settings.angular_velocity_factor = 12
                settings.physics_type = 'NEWTON'
                settings.mass = 1
                settings.use_multiply_size_mass = True
                settings.brownian_factor = 0
                settings.drag_factor = 1
                settings.damping = 0.05
                settings.integrator = 'EULER'
                bpy.context.object.show_instancer_for_render = False
                settings.show_unborn = True
                settings.use_dead = True
                settings.render_type = 'COLLECTION'
                settings.particle_size = 0.08
                settings.size_random = 1
                bpy.data.particles["_Rocks particle explosion"].instance_collection = bpy.data.collections["_Rock Particles"]
                
                #
                
                settings.jitter_factor = 0
                settings.object_factor = 1
                settings.effector_weights.turbulence = 0
        


        return{'FINISHED'}





#


#
class MushroomExplosionPreset (bpy.types.Operator):
    bl_idname = 'my.mushroomcloudexplosion'
    bl_label = 'Mushroom Explosion'
    
    
#f "KHAOS"





#

#
class NEW_OT_CollisionPlaneOperator (bpy.types.Operator):
    bl_idname = 'my.collisionplaneoperator'
    bl_label = 'Collision Plane'
    
    def execute(self, context):
        #
        bpy.ops.mesh.primitive_plane_add(size=1, enter_editmode=False, location=(0, 0, 0))

        #
        bpy.ops.object.modifier_add(type='COLLISION')
        bpy.context.object.collision.damping_factor = 1
        bpy.context.object.collision.damping_random = 0.5
        bpy.context.object.collision.friction_factor = 0.05
        bpy.context.object.collision.stickiness = 10
        #
        bpy.ops.object.modifier_add(type='FLUID')
        bpy.context.object.modifiers["Fluid"].fluid_type = 'EFFECTOR'
        bpy.context.object.modifiers["Fluid"].effector_settings.effector_type = 'COLLISION'

        
        #
        for obj in bpy.context.selected_objects:
            obj.name = "Collision Plane"
        
        return{'FINISHED'}
    
#
class NEW_OT_CollisionCubeOperator (bpy.types.Operator):
    bl_idname = 'my.collisioncubeoperator'
    bl_label = 'Collision Cube'
    
    def execute(self, context):
        #
        bpy.ops.mesh.primitive_cube_add(size=2, enter_editmode=False, location=(0, 0, 0))
        
        #
        bpy.ops.object.modifier_add(type='COLLISION')
        bpy.context.object.collision.damping_factor = 1
        bpy.context.object.collision.damping_random = 0.5
        bpy.context.object.collision.friction_factor = 0.05
        bpy.context.object.collision.stickiness = 10
        #
        bpy.ops.object.modifier_add(type='FLUID')
        bpy.context.object.modifiers["Fluid"].fluid_type = 'EFFECTOR'
        bpy.context.object.modifiers["Fluid"].effector_settings.effector_type = 'COLLISION'
        
        #
        for obj in bpy.context.selected_objects:
            obj.name = "Collision Cube"
        
        
        return{'FINISHED'}
    
#
class NEW_OT_CollisionCylinderOperator (bpy.types.Operator):
    bl_idname = 'my.collisioncylinderoperator'
    bl_label = 'Collision Cylinder'
    
    def execute(self, context):
        #
        bpy.ops.mesh.primitive_cylinder_add(radius=1, depth=2, enter_editmode=False, location=(0, 0, 0))

        
        
        #
        bpy.ops.object.modifier_add(type='COLLISION')
        bpy.context.object.collision.damping_factor = 1
        bpy.context.object.collision.damping_random = 0.5
        bpy.context.object.collision.friction_factor = 0.05
        bpy.context.object.collision.stickiness = 10
        #
        bpy.ops.object.modifier_add(type='FLUID')
        bpy.context.object.modifiers["Fluid"].fluid_type = 'EFFECTOR'
        bpy.context.object.modifiers["Fluid"].effector_settings.effector_type = 'COLLISION'
        
        #
        for obj in bpy.context.selected_objects:
            obj.name = "Collision Cylinder"
        
        return{'FINISHED'}
    
    
    



#My Render settings preset
class NEW_OT_RendersettingsOperator (bpy.types.Operator):
    bl_idname = 'my.rendersettings'
    bl_label = 'HD Render Settings Preset'
    
    def execute(self, context):
        bpy.context.scene.render.resolution_x = 1920
        bpy.context.scene.render.resolution_y = 1080
        bpy.context.scene.render.resolution_percentage = 100
        bpy.context.scene.render.pixel_aspect_x = 1
        bpy.context.scene.render.pixel_aspect_y = 1

        bpy.context.scene.render.image_settings.file_format = 'OPEN_EXR'
        bpy.context.scene.render.image_settings.color_mode = 'RGBA'
        bpy.context.scene.render.image_settings.color_depth = '16'
        bpy.context.scene.render.image_settings.exr_codec = 'ZIP'
        bpy.context.scene.cycles.samples = 64
        bpy.context.scene.cycles.use_animated_seed = True
        bpy.context.scene.cycles.volume_step_size = 0.01
        bpy.context.scene.cycles.volume_max_steps = 250
        bpy.context.scene.cycles.volume_bounces = 4
        bpy.context.scene.render.use_motion_blur = True
        bpy.context.scene.render.motion_blur_shutter = 0.24
        bpy.context.scene.cycles.film_transparent = True
        bpy.context.scene.render.tile_x = 64
        bpy.context.scene.render.tile_y = 64
        bpy.context.scene.cycles.preview_start_resolution = 64
        bpy.context.scene.render.use_compositing = True
        bpy.context.scene.render.use_sequencer = True
        
        
        return{'FINISHED'}




#
class NEW_OT_BasicTurbulenceOperator (bpy.types.Operator):
    bl_idname = 'my.basicturbulence'
    bl_label = 'Mix Fuel!'
    
    def execute(self, context):
        #
        x = bpy.context.scene.frame_current
        #
        bpy.ops.object.effector_add(type='TURBULENCE', enter_editmode=False, location=(bpy.context.scene.cursor.location))
        #
        for obj in bpy.context.selected_objects:
                obj.name = "Fuel Mixer Field"
        #
        bpy.context.object.field.strength = context.scene.khaos_tool.mixfuelinitialturbulencestrength
        #
        context.object.keyframe_insert(data_path="field.strength")
        #
        bpy.context.scene.frame_set(x+context.scene.khaos_tool.turbulenceduration)
        #
        bpy.context.object.field.strength = context.scene.khaos_tool.mixfuelfinalturbulencestrength
        #
        context.object.keyframe_insert(data_path="field.strength")
        
        '''now that we have keyframed our first turbulence fields strength over time we will
        keyframe its location over time below'''
        
        #
        bpy.context.scene.frame_set(0)
        #
        bpy.ops.anim.keyframe_insert_menu(type='LocRotScale')
        #
        bpy.context.scene.frame_set(1000)
        #
        bpy.ops.transform.translate(value=(0, 0, 800), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, False, True), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        #
        bpy.ops.anim.keyframe_insert_menu(type='LocRotScale')
                
        #
        bpy.ops.object.hide_view_set(unselected=False)
        

        '''second turbulence field addition and corresponding keyframes in this same operator below''' 
        
        #
        bpy.ops.object.effector_add(type='TURBULENCE', enter_editmode=False, location=(bpy.context.scene.cursor.location))
        # 
        for obj in bpy.context.selected_objects:
                obj.name = "Fuel Mixer Field"
        #
        bpy.context.scene.frame_set(x)
        #
        bpy.context.object.field.strength = context.scene.khaos_tool.mixfuelinitialturbulencestrength/2
        #
        bpy.context.object.field.size = 0.1
        #
        context.object.keyframe_insert(data_path="field.strength")
        #
        bpy.context.scene.frame_set(x+context.scene.khaos_tool.turbulenceduration)
        #
        bpy.context.object.field.strength = context.scene.khaos_tool.mixfuelfinalturbulencestrength/2
        #
        context.object.keyframe_insert(data_path="field.strength")
        
        bpy.ops.transform.translate(value=(0, 0, 5), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, False, True), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        #
        bpy.context.scene.frame_set(0)
        #
        bpy.ops.anim.keyframe_insert_menu(type='LocRotScale')
        #
        bpy.context.scene.frame_set(1000)
        #
        bpy.ops.transform.translate(value=(0, 0, 800), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, False, True), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        #
        bpy.ops.anim.keyframe_insert_menu(type='LocRotScale')
        
        #
        bpy.ops.object.hide_view_set(unselected=False)
        
        #
        bpy.context.scene.frame_set(x)

        
        
        return{'FINISHED'}


class WM_OT_BasicSmokePlumeOperatorSwitchPanel (bpy.types.Operator):
    bl_idname = 'my.basicsmokeplume_switch_pannel'
    bl_label = 'Smoke Plume!'

    def execute(self, context):
        khaos_tool = context.scene.khaos_tool
        khaos_tool.basicsmokeplume_panel_bool = True
        return {'FINISHED'}


#
class WM_OT_BasicSmokePlumeOperator (bpy.types.Operator):
    bl_idname = 'my.basicsmokeplume'
    bl_label = 'Smoke Plume!'

    
    
    #text = bpy.props.StringProperty(name= "Enter Text:")
    # highest_fuel_rate = bpy.props.FloatProperty(name= "Highest Fuel Rate:", default=1)
    # lowest_fuel_rate = bpy.props.FloatProperty(name= "Lowest Fuel Rate:", default=0.25)
    # fuelpulsetiming = bpy.props.FloatProperty(name= "Fuel Pulse timing (Frames):", default=24)

    #def draw(self, context):
        #khaos_tool = context.scene.khaos_tool
        #layout = self.layout
        #layout.separator()
        #layout.prop(khaos_tool,'highest_fuel_rate')
        #layout.prop(khaos_tool,'lowest_fuel_rate')
        #layout.prop(khaos_tool,'fuelpulsetiming')
    
    def execute(self, context):
        khaos_tool = context.scene.khaos_tool
        #
        if bpy.data.objects.get('Smoke Plume Domain') == None:
                
                section = "\\Collection\\"
                objects = ["Smoke Plume Domain"] #
        
                directory = blend_file + section
        
                for obj in objects:
                    filename = obj
                    bpy.ops.wm.append(filename=filename, directory=directory)
                        
                #  
                bpy.ops.view3d.snap_selected_to_cursor(use_offset=False)
         
        #             
        bpy.context.scene.frame_set(0)
        #
        bpy.ops.mesh.primitive_ico_sphere_add(radius=1, enter_editmode=False, align='WORLD', location=(bpy.context.scene.cursor.location))
        #
        for obj in bpy.context.selected_objects:
                obj.name = "Smoke Plume emitter"
        #
        bpy.ops.object.editmode_toggle()
        #
        bpy.ops.mesh.duplicate_move(MESH_OT_duplicate={"mode":1}, TRANSFORM_OT_translate={"value":(-0.0558451, -0.893362, 0.507589), "orient_type":'GLOBAL', "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "release_confirm":False, "use_accurate":False})
        bpy.ops.transform.resize(value=(0.772502, 0.772502, 0.772502), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        bpy.ops.mesh.duplicate_move(MESH_OT_duplicate={"mode":1}, TRANSFORM_OT_translate={"value":(0.353793, 0.540304, -1.02273), "orient_type":'GLOBAL', "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "release_confirm":False, "use_accurate":False})
        bpy.ops.mesh.duplicate_move(MESH_OT_duplicate={"mode":1}, TRANSFORM_OT_translate={"value":(0.0903818, 1.05114, 0.297613), "orient_type":'GLOBAL', "orient_matrix":((1, 0, 0), (0, 1, 0), (0, 0, 1)), "orient_matrix_type":'GLOBAL', "constraint_axis":(False, False, False), "mirror":False, "use_proportional_edit":False, "proportional_edit_falloff":'SMOOTH', "proportional_size":1, "use_proportional_connected":False, "use_proportional_projected":False, "snap":False, "snap_target":'CLOSEST', "snap_point":(0, 0, 0), "snap_align":False, "snap_normal":(0, 0, 0), "gpencil_strokes":False, "cursor_transform":False, "texture_space":False, "remove_on_cancel":False, "release_confirm":False, "use_accurate":False})
        bpy.ops.transform.resize(value=(1.42968, 1.42968, 1.42968), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        bpy.ops.transform.translate(value=(-0.0277951, -0.0762881, 0.0596367), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        #
        bpy.ops.object.editmode_toggle()
        #
        bpy.ops.transform.resize(value=(0.5, 0.5, 0.35), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)

        
        #
        bpy.ops.object.modifier_add(type='FLUID')
        bpy.context.object.modifiers["Fluid"].fluid_type = 'FLOW'
        bpy.context.object.modifiers["Fluid"].flow_settings.flow_type = 'FIRE'
        bpy.context.object.modifiers["Fluid"].flow_settings.flow_behavior = 'INFLOW'
        bpy.context.object.modifiers["Fluid"].flow_settings.flow_source = 'MESH'
        bpy.context.object.modifiers["Fluid"].flow_settings.use_initial_velocity = True
        #
        bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = khaos_tool.highest_fuel_rate
        obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount')
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.fuelpulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.fuelpulsetiming
        #print('1-',frame)
        #context.scene.frame_set(frame)
        #Now we set the lowest fuel rate according to the user input
        # bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = self.lowest_fuel_rate
        bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = khaos_tool.lowest_fuel_rate
        #
        obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount')
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.fuelpulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.fuelpulsetiming
        #print('2-',frame)
        #context.scene.frame_set(frame)
        #Now we set the highest fuel rate according to the user input
        # bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = self.highest_fuel_rate
        bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = khaos_tool.highest_fuel_rate
        #And add a keyframe for that value below
        obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount')
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.fuelpulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.fuelpulsetiming
        #print('3-',frame)
        #context.scene.frame_set(frame)
        #Now we set the lowest fuel rate * 1.25 for some variation according to the user input
        # bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = self.lowest_fuel_rate * 1.25
        bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = khaos_tool.lowest_fuel_rate * 1.25
        #
        obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount')
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.fuelpulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.fuelpulsetiming
        #print('4-',frame)
        #context.scene.frame_set(frame)

        #
        #
        bpy.context.object.modifiers["Fluid"].flow_settings.fuel_amount = khaos_tool.highest_fuel_rate
        #
        obj.keyframe_insert(data_path='modifiers["Fluid"].flow_settings.fuel_amount')
        
        #
        bpy.context.area.ui_type = 'FCURVES'
        #
        bpy.ops.graph.extrapolation_type(type='MAKE_CYCLIC')
        #
        bpy.context.area.ui_type = 'VIEW_3D'
        #
        bpy.context.scene.frame_set(0)
        
        khaos_tool.basicsmokeplume_panel_bool = False
        return {'FINISHED'}
    
    #def invoke(self, context, event):
        # context.window_manager.invoke_props_dialog(self)
        # return self.execute(context)
        #wm = context.window_manager
        #return wm.invoke_props_dialog(self)
    
    
class WM_OT_BasicWindPulseOperatorSwitchPanel (bpy.types.Operator):
    bl_idname = 'my.basicwindpulse_switch_pannel'
    bl_label = 'Wind Pulse!'

    def execute(self, context):
        khaos_tool = context.scene.khaos_tool
        khaos_tool.basicwindpulse_panel_bool = True
        return {'FINISHED'}

#
class WM_OT_BasicWindPulseOperator (bpy.types.Operator):
    bl_idname = 'my.basicwindpulse'
    bl_label = 'Wind Pulse!'
    
    #text = bpy.props.StringProperty(name= "Enter Text:")
    # highest_wind_strength = bpy.props.FloatProperty(name= "Highest Wind Strength:", default=1.85)
    # lowest_wind_strength = bpy.props.FloatProperty(name= "Lowest Wind Strength:", default=0.15)
    # pulsetiming = bpy.props.FloatProperty(name= "Pulse timing (Frames):", default=26)

    # def draw(self, context):
    #     khaos_tool = context.scene.khaos_tool
    #     layout = self.layout
    #     layout.separator()
    #     layout.prop(khaos_tool,'highest_wind_strength')
    #     layout.prop(khaos_tool,'lowest_wind_strength')
    #     layout.prop(khaos_tool,'pulsetiming')
    
    
    def execute(self, context):
        khaos_tool = context.scene.khaos_tool
        #
        bpy.context.scene.frame_set(0)
        #
        bpy.ops.object.effector_add(type='WIND', enter_editmode=False, align='WORLD', location=(bpy.context.scene.cursor.location))
        #
        for obj in bpy.context.selected_objects:
                obj.name = "Wind Pulse"
        #
        bpy.ops.transform.rotate(value=1.5708, orient_axis='Y', orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', constraint_axis=(False, True, False), mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        #
        bpy.ops.transform.resize(value=(5, 5, 5), orient_type='GLOBAL', orient_matrix=((1, 0, 0), (0, 1, 0), (0, 0, 1)), orient_matrix_type='GLOBAL', mirror=True, use_proportional_edit=False, proportional_edit_falloff='SMOOTH', proportional_size=1, use_proportional_connected=False, use_proportional_projected=False)
        
        #
        bpy.context.object.field.strength = khaos_tool.highest_wind_strength
        #
        context.object.keyframe_insert(data_path="field.strength")
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.pulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.pulsetiming
        #bpy.context.scene.frame_set(frame)
        
        #
        bpy.context.object.field.strength = khaos_tool.lowest_wind_strength
        #
        context.object.keyframe_insert(data_path="field.strength")
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.pulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.pulsetiming
        #bpy.context.scene.frame_set(frame)
        
        #
        bpy.context.object.field.strength = khaos_tool.highest_wind_strength*0.80
        
        #
        context.object.keyframe_insert(data_path="field.strength")
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.pulsetiming)
        
        #frame = bpy.context.scene.frame_current + khaos_tool.pulsetiming
        #bpy.context.scene.frame_set(frame)
        #Now we set the lowest wind strength times 1.1 for a bit for variation according to the user input
        # bpy.context.object.field.strength = self.lowest_wind_strength*1.1
        bpy.context.object.field.strength = khaos_tool.lowest_wind_strength*1.1
        #
        context.object.keyframe_insert(data_path="field.strength")
        
        #
        bpy.context.scene.frame_set(bpy.context.scene.frame_current - khaos_tool.pulsetiming)
        #frame = bpy.context.scene.frame_current + khaos_tool.pulsetiming
        #bpy.context.scene.frame_set(frame)
        
        #Now we set the highest wind strength times 0.95 for a bit for variation according to the user input
        # bpy.context.object.field.strength = self.highest_wind_strength*0.95
        bpy.context.object.field.strength = khaos_tool.highest_wind_strength*0.95
        #
        context.object.keyframe_insert(data_path="field.strength")

        
        #
        bpy.context.area.ui_type = 'FCURVES'
        #
        bpy.ops.graph.extrapolation_type(type='MAKE_CYCLIC')
        #
        bpy.context.area.ui_type = 'VIEW_3D'
        
        #
        bpy.context.scene.frame_set(0)
        
        khaos_tool.basicwindpulse_panel_bool = False
        return {'FINISHED'}
    
    # def invoke(self, context, event):
    #     # return context.window_manager.invoke_props_dialog(self)
    #     wm = context.window_manager
    #     return wm.invoke_props_dialog(self)

    


######################################
##### Adding Fracture Codes###########
#              Start


#################################################
############## Cut Objects ################Start

class Cut_object_Operator(bpy.types.Operator):
    bl_idname = "view3d.cut_object"
    bl_label = "Cut 2 objects to fracture"
    bl_description = "The last object selected is the one that will be cut. The first object selected is the cutter"

    def execute(self, context):
        objs = bpy.context.selected_objects

        for o in objs:
            if o == bpy.context.active_object:
                ob_1 = o
            else:
                ob_2 = o

        print('ob_1', ob_1.name)
        print('ob_2', ob_2.name)

        
        #duplicate selected object
        #ob_1 = bpy.context.selected_objects[0]
        #ob_2 = bpy.context.selected_objects[1]
        bpy.ops.object.select_all(action='DESELECT')

        ob_1.select_set(True)
        bpy.context.view_layer.objects.active = ob_1
        bpy.ops.object.duplicate() #duplicate of original objt
        ob_bkp = bpy.context.selected_objects[0] 

        coll_name = 'KHAOS_Orig_Obj'
        #myCol = Helper.create_collection(coll_name)
        myCol =Helper.create_collection(coll_name)


        ##delete a previus backup obj before renaming the actual obj
        # for o in bpy.data.objects:
        #     if o.name == ob_1.name+'_bkp':
        #         objs = [bpy.context.scene.objects[ob_1.name+'_bkp']]
        #         bpy.ops.object.delete({"selected_objects": objs})


        
        ##-----------------
        
        bpy.ops.object.select_all(action='DESELECT')

        ob_1.select_set(True)
        bpy.context.view_layer.objects.active = ob_1
        bpy.ops.object.duplicate()
        ob_dup = bpy.context.selected_objects[0] #this is the object that is going to be the result cut

        #select the duplicated object


        bpy.ops.object.modifier_add(type='BOOLEAN')
        #bpy.context.object.modifiers["Boolean"].object = bpy.data.objects["sphere_cut_cube"]
        bpy.context.object.modifiers["Boolean"].object = ob_2
        bpy.context.object.modifiers["Boolean"].operation = 'INTERSECT'
        bpy.ops.object.modifier_apply(modifier="Boolean")


        ob_1.select_set(True)
        bpy.context.view_layer.objects.active = ob_1


        #Prepare fist part cut the part on the original object
        bpy.ops.object.modifier_add(type='BOOLEAN')
        bpy.context.object.modifiers["Boolean"].object = ob_2
        bpy.context.object.modifiers["Boolean"].operation = 'DIFFERENCE'
        bpy.ops.object.modifier_apply(modifier="Boolean")




        #get collections the object is in
                        

        obj = ob_2
        obj_old_coll = obj.users_collection
        ### Check is the object is already in the collection
        for ob_coll in obj_old_coll:
            if ob_coll.name != coll_name:
                myCol.objects.link(obj) #link the object to the KHAOS collection
                for ob in obj_old_coll: #unlink from all  precedent obj collections
                    if ob.name != 'RigidBodyWorld':
                        ob.objects.unlink(obj)
        context.view_layer.layer_collection.children[coll_name].hide_viewport = True

        #erase or backup the orioginal obj
        ##-----------------
        # part that will check if object already exists, and if exists, it wont create another backup
        # create variable with all the names
        names = []
        for ob in bpy.data.objects:
            names.append(ob.name)
        print(ob_1.name)

        if ob_1.name+'_bkp' not in names:
            # ob_bkp = bpy.context.selected_objects[0]
            ob_bkp.name = ob_1.name+'_bkp'
            # ob_dup.name = ob_1.name+'_bkp'

            #obj = bpy.context.object
            obj = ob_bkp
            # obj = ob_dup
            obj_old_coll = obj.users_collection
            ### Check is the object is already in the collection
            for ob_coll in obj_old_coll:
                if ob_coll.name != coll_name:
                    myCol.objects.link(obj) #link the object to the KHAOS collection
                    for ob in obj_old_coll: #unlink from all  precedent obj collections
                        if ob.name != 'RigidBodyWorld':
                            ob.objects.unlink(obj)
        else:
            objs = [bpy.context.scene.objects[ob_bkp.name]]
            bpy.ops.object.delete({"selected_objects": objs})
        print('result_cut: ',ob_dup.name)



        #Left the result cut selected (the probable piece to be fractured)
        bpy.ops.object.select_all(action='DESELECT')
        ob_dup.select_set(True)
        bpy.context.view_layer.objects.active = ob_dup
        return{'FINISHED'}


#################Cut Objects#################End
################################################






#############################################Start
##################### Draw #######################

class DrawFracture_Operator(bpy.types.Operator):
    bl_idname = "view3d.draw"
    bl_label = "Drasw Fracture Place"
    bl_description = "Draw Fracture Place"

    def execute(self, context):
        area = [area for area in bpy.context.screen.areas if area.type == "VIEW_3D"][0]
        override_context = bpy.context.copy()
        override_context['window'] = bpy.context.window
        override_context['screen'] = bpy.context.screen
        override_context['area'] = area
        override_context['region'] = area.regions[-1]
        override_context['scene'] = bpy.context.scene
        override_context['space_data'] = area.spaces.active

        #select annotate tool
        bpy.ops.wm.tool_set_by_id(override_context, name='builtin.annotate')
        bpy.context.scene.tool_settings.annotation_stroke_placement_view3d = "SURFACE"
        return{'FINISHED'}


class SelectBox_Operator(bpy.types.Operator):
    bl_idname = "view3d.selection_box"
    bl_label = "Selection Box"
    bl_description = "Goes back to selection box"

    def execute(self, context):
        area = [area for area in bpy.context.screen.areas if area.type == "VIEW_3D"][0]
        override_context = bpy.context.copy()
        override_context['window'] = bpy.context.window
        override_context['screen'] = bpy.context.screen
        override_context['area'] = area
        override_context['region'] = area.regions[-1]
        override_context['scene'] = bpy.context.scene
        override_context['space_data'] = area.spaces.active

        bpy.ops.wm.tool_set_by_id(override_context, name='builtin.select_box')

        return{'FINISHED'}
    
class Clear_lastGP_Operator(bpy.types.Operator):
    bl_idname = "view3d.clear_last_gp"
    bl_label = "Clear Annotation"
    bl_description = "Clear Annotation"
    
    def execute(self, context):
        bpy.data.grease_pencils[-1].clear()
        return{'FINISHED'}
    
##################### Draw #######################
###############################################End






#############################################Start
################### Fracture #####################

class FractureDraw_Operator(bpy.types.Operator):
    bl_idname = "view3d.fracture_draw"
    bl_label = "Fracture Draw"
    bl_description = "Fracture Draw object"
    
    def execute(self, context):
        frac_source_limit = context.scene.khaos_tool.sk_frac_source_limit
        frac_source_noise = context.scene.khaos_tool.sk_frac_source_noise
        frac_recursion = context.scene.khaos_tool.sk_frac_recursion
        frac_margin = context.scene.khaos_tool.sk_frac_margin

        if not addon_utils.check('object_fracture_cell')[1]: # check if the addon  cell fracture is enabled
            addon_utils.enable("object_fracture_cell",default_set=True) #enable the addon
        
        name_collection = context.scene.khaos_tool.sk_frac_name_collection
        len_name_start_ctr = len(name_collection+'-{:03}'.format(0)) #the size for the name of the constraint collection
        ##conta qtd de collection
        qtd_col = 0
        for col in bpy.data.collections:
            # if col.name.startswith(name_collection+'-'):
            if col.name.startswith(name_collection+'-') and col.name[len_name_start_ctr:].startswith('.Constraint') is not True:
                qtd_col+=1
        #####
        material_idx = context.scene.khaos_tool.sk_material_idx -1
        
        material_idx_final = Helper.material_set(material_idx)
        # active_obj = bpy.context.active_object
        bpy.ops.object.add_fracture_cell_objects(source={'PENCIL'}, source_limit=frac_source_limit, source_noise=frac_source_noise , cell_scale=(1, 1, 1), recursion=frac_recursion, recursion_source_limit=8, recursion_clamp=250, recursion_chance=0.25, recursion_chance_select='SIZE_MIN', use_smooth_faces=False, use_sharp_edges=True, use_sharp_edges_apply=True, use_data_match=True, use_island_split=True, margin=frac_margin , 
                                                material_index=material_idx_final, use_interior_vgroup=False, mass_mode='VOLUME', mass=1, use_recenter=True, use_remove_original=True, 
                                                collection_name=name_collection+'-'+'{:03}'.format(qtd_col+1), use_debug_points=False, use_debug_redraw=True, use_debug_bool=False)
        bpy.data.grease_pencils[-1].clear()
        
        #This part os for removing the anotation tool, forst whe have to set another context.
        area = [area for area in bpy.context.screen.areas if area.type == "VIEW_3D"][0]
        override_context = bpy.context.copy()
        override_context['window'] = bpy.context.window
        override_context['screen'] = bpy.context.screen
        override_context['area'] = area
        override_context['region'] = area.regions[-1]
        override_context['scene'] = bpy.context.scene
        override_context['space_data'] = area.spaces.active

        bpy.ops.wm.tool_set_by_id(override_context, name='builtin.select_box')
        
        
        #keep the original obj in a separated collection
        coll_name = 'KHAOS_Orig_Obj'
        myCol = Helper.create_collection(coll_name)
        
        ###
        # create a group to check if there is an object already created
        k_orig_obj = []
        for a in bpy.data.collections['KHAOS_Orig_Obj'].objects:
            k_orig_obj.append(a.name)

        #get collections the object is in
        obj = bpy.context.object
        obj_old_coll = obj.users_collection
        ### Check is the object is already in the collection
        for ob_coll in obj_old_coll:
            if ob_coll.name != coll_name:
                # checking if there is already an object with that name created inside khaos orig obj
                if obj not in k_orig_obj:
                    myCol.objects.link(obj) #link the object to the KHAOS collection
                    for ob in obj_old_coll: #unlink from all  precedent obj collections
                        ob.objects.unlink(obj)
                    break

        
        #Hide collection with original shape
        #vlayer = bpy.context.scene.view_layers['View Layer'] #custom viewlayer
        #vlayer.layer_collection.children['KHAOS_Orig_Obj'].hide_viewport = True #hide collection
        context.view_layer.layer_collection.children[coll_name].hide_viewport = True
        
        # Helper.select(fract_collection) #make only the created mesh selected
        # Helper.select_excep_ctr(fract_collection)
        
        Helper.updt_qty_frac()
    
        return{'FINISHED'}

class Fracture_Operator(bpy.types.Operator):
    bl_idname = "view3d.fracture"
    bl_label = "Fracture"
    bl_description = "Fracture object"
    
    def execute(self, context):
        frac_source_limit = context.scene.khaos_tool.sk_frac_source_limit
        frac_source_noise = context.scene.khaos_tool.sk_frac_source_noise
        frac_recursion = context.scene.khaos_tool.sk_frac_recursion
        frac_margin = context.scene.khaos_tool.sk_frac_margin

        if not addon_utils.check('object_fracture_cell')[1]: # check if the addon  cell fracture is enabled
            addon_utils.enable("object_fracture_cell",default_set=True) #enable the addon
        
        name_collection = context.scene.khaos_tool.sk_frac_name_collection
        len_name_start_ctr = len(name_collection+'-{:03}'.format(0)) #the size for the name of the constraint collection
        ##conta qtd de collection
        qtd_col = 0
        for col in bpy.data.collections:
            if col.name.startswith(name_collection+'-') and col.name[len_name_start_ctr:].startswith('.Constraint') is not True:
                qtd_col+=1
        #####
        material_idx = context.scene.khaos_tool.sk_material_idx -1
        
        material_idx_final = Helper.material_set(material_idx)
        # active_obj = bpy.context.active_object
        bpy.ops.object.add_fracture_cell_objects(source={'VERT_OWN'}, source_limit=frac_source_limit, source_noise=frac_source_noise , cell_scale=(1, 1, 1), recursion=frac_recursion , recursion_source_limit=8, recursion_clamp=250, recursion_chance=0.25, recursion_chance_select='SIZE_MIN', use_smooth_faces=False, use_sharp_edges=True, use_sharp_edges_apply=True, use_data_match=True, use_island_split=True, margin=frac_margin , 
                                                material_index=material_idx_final, use_interior_vgroup=False, mass_mode='VOLUME', mass=1, use_recenter=True, use_remove_original=True, 
                                                collection_name=name_collection+'-'+'{:03}'.format(qtd_col+1), use_debug_points=False, use_debug_redraw=True, use_debug_bool=False)
        #keep the original obj in a separated collection 
        coll_name = 'KHAOS_Orig_Obj'
        myCol = Helper.create_collection(coll_name)

        
        ###
        # create a group to check if there is an object already created
        k_orig_obj = []
        for a in bpy.data.collections['KHAOS_Orig_Obj'].objects:
            k_orig_obj.append(a.name)
        
        #get collections the object is in
        obj = bpy.context.object
        obj_old_coll = obj.users_collection
        ### Check is the object is already in the collection
        for ob_coll in obj_old_coll:
            if ob_coll.name != coll_name:
                # checking if there is already an object with that name created inside khaos orig obj
                if obj not in k_orig_obj:
                    myCol.objects.link(obj) #link the object to the KHAOS collection
                    for ob in obj_old_coll: #unlink from all  precedent obj collections
                        ob.objects.unlink(obj)
                    break

        #Hide collection with original shape
        #vlayer = bpy.context.scene.view_layers['View Layer'] #custom viewlayer
        #vlayer.layer_collection.children['KHAOS_Orig_Obj'].hide_viewport = True #hide collection
        context.view_layer.layer_collection.children[coll_name].hide_viewport = True
            
        # Helper.select(fract_collection) #make only the created mesh selected
        # Helper.select_excep_ctr(fract_collection)
        # Helper.select_excep_ctr(fract_collection+'-'+'{:03}'.format(qtd_col+1))
        
        Helper.updt_qty_frac()
    
        return{'FINISHED'}

class Delete_Fracture(bpy.types.Operator):
    bl_idname = "view3d.delete_frac"
    bl_label = "Delete Fracture"
    bl_description = "Delete Fracture"
    
    def execute(self, context):
        context = bpy.context
        name = context.scene.khaos_tool.sk_frac_name_collection
        frac_collection = context.scene.khaos_tool.sk_frac_collection
        
        # Helper.select_frac(self, context)
        
        if frac_collection != 0: #only do something if there is some fracture\
            
            
            dropb_itens = my_settings_frac_callback(bpy.context.scene,context) #get the list in the dropbox
            slct_dropb_item = frac_collection # get the id of the selected collection

            for dbi in dropb_itens:
                # all_coll_frac.append([dbi[0],dbi[1]]) #get the order and id of the dropbox options
                if dbi[0] == slct_dropb_item:
                    coll_name = dbi[1] #based on the selected colection, get its name

            ####
            # search for constraints 
            name_ctr = coll_name+'.Constraint'
            colls = bpy.data.collections
            all_coll_ctr =[]
            for ctr in colls:
                if ctr.name.startswith(name_ctr):
                    all_coll_ctr.append(ctr.name)
            
            if len(all_coll_ctr) >= 1:
                for coll_ctr in all_coll_ctr:
                    coll_ctr_obj = bpy.data.collections[coll_ctr].objects
                    for obj in coll_ctr_obj:
                    #    print('del obj:',obj.name)
                        bpy.data.objects.remove(obj, do_unlink=True)
                    bpy.data.collections.remove(bpy.data.collections[coll_ctr])



        
            #add command to delete cllection
            coll_obj = bpy.data.collections[coll_name].objects
            
            #remove the objects
            for obj in coll_obj:
            #    print('del obj:',obj.name)
                bpy.data.objects.remove(obj, do_unlink=True)
                
            #remove the collection
            bpy.data.collections.remove(bpy.data.collections[coll_name])
            
            idx,leng = Helper.reorganize_frac()
            Helper.updt_qty_frac()
            context.scene.khaos_tool.sk_frac_collection = str(idx)
            
            # qty_frac = context.scene.khaos_tool.sk_qty_frac
        #    context.scene.khaos_tool.sk_ctr_collection = 

        return{'FINISHED'}


################### Fracture #####################
###############################################End

class Select_obj_Operator(bpy.types.Operator):
    bl_idname = "view3d.select_obj"
    bl_label = "Select objects"
    bl_description = "Select Objects"
    
    def execute(self, context):
        #get the name of collection from the menu
        fract_collection = context.scene.khaos_tool.sk_frac_collection
        
        # Helper.select(fract_collection)
        Helper.select_excep_ctr(fract_collection)
        
        return{'FINISHED'}

#############################################Start
################# RIGID BODY #####################

                
class Add_ActiveRigidbody_Operator(bpy.types.Operator):
    bl_idname = "view3d.add_activerigidbody"
    bl_label = "Add Active RigidBody"
    bl_description = "Add Active RigidBody"
    
    def execute(self, context):
        #############
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0] #select the first object
        bpy.ops.rigidbody.objects_add(type='ACTIVE')
        
        #set the mass of the selected option
        calc_mass = context.scene.khaos_tool.sk_calc_mass
        result = calc_mass.split('|')
        print('calc_mass: --',calc_mass)
        bpy.ops.rigidbody.mass_calculate(material=result[0], density=int(result[1]))
        
        #set the mesh colider from what is already selected
        # mesh_collision = context.scene.khaos_tool.sk_mesh_collision
        #### change mesh type
        # bpy.ops.rigidbody.shape_change(type=mesh_collision)

        ## force to start as convexhull
        mesh_collision = 'CONVEX_HULL'
        context.scene.khaos_tool.sk_mesh_collision = mesh_collision
        bpy.ops.rigidbody.shape_change(type=mesh_collision) #force it to start as Convex Hull
        
        
        #start deactivated
        deactivated_rb = context.scene.khaos_tool.sk_deactivated_rb
        action = True if deactivated_rb else False
        for obj in bpy.context.selected_objects:
            obj.rigid_body.use_deactivation = action
            obj.rigid_body.use_start_deactivated = action
            
        return{'FINISHED'}
    
    
    
class Add_ActiveRigidbodyAnimated_Operator(bpy.types.Operator):
    bl_idname = "view3d.add_active_animated_rigidbody"
    bl_label = "Add Active RigidBody"
    bl_description = "Add Active RigidBody"
    
    def execute(self, context):
        #############
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0] #
        bpy.ops.rigidbody.objects_add(type='ACTIVE')
        
        #
        calc_mass = context.scene.khaos_tool.sk_calc_mass
        result = calc_mass.split('|')
        print('calc_mass: --',calc_mass)
        bpy.ops.rigidbody.mass_calculate(material=result[0], density=int(result[1]))
        
        #
        mesh_collision = context.scene.khaos_tool.sk_mesh_collision
        #### change mesh type
        bpy.ops.rigidbody.shape_change(type=mesh_collision)
        
        
        #start deactivated
    #    deactivated_rb = context.scene.khaos_tool.sk_deactivated_rb
    #    action = True if deactivated_rb else False
    #    for obj in bpy.context.selected_objects:
    #        obj.rigid_body.use_deactivation = action
    #        obj.rigid_body.use_start_deactivated = action
        
        #
        bpy.context.object.rigid_body.kinematic = True

        return{'FINISHED'}
    
class Remove_Rigidbody_Operator(bpy.types.Operator):
    bl_idname = "view3d.remove_rigidbody"
    bl_label = "Remove RigidBody"
    bl_description = "Remove RigidBody"
    
    def execute(self, context):
        # bpy.ops.rigidbody.objects_remove() #use this when all objects are rigidbodies, if there is one or more that is not rigid body, it will throw an error
        ob_rigid_remove = []
        for ob in bpy.context.selected_objects:
            #print(ob.name,'-',ob.users_collection)
            #check all the collections on the object, this is done to make sure it has the collection 
            #'RigidBodyWorld' that means, it has the rigid body properties. If there is not this collection, 
            #it means it is not a rigidbody, and because of that, constraint shouldnt be added
            for obcol in ob.users_collection:
                if obcol.name == 'RigidBodyWorld':
                    ob_rigid_remove.append(ob.name) #keep the names of objects that are rigid bodies

        for ob in bpy.context.selected_objects:
            if ob.name not in ob_rigid_remove: #compare to see which objects are not in the list of rigid bodies
                print(ob.name," not rigidbody")
                ob.select_set(False) #unselect object if it is not rigidbody
        
        bpy.context.view_layer.objects.active = bpy.context.selected_objects[0]    #make one selected object as active, or else the command to remove rigidbody wont work.        
        bpy.ops.rigidbody.objects_remove()
        return{'FINISHED'}


class Change_Collision_Operator(bpy.types.Operator):
    bl_idname = "view3d.change_collision"
    bl_label = "Change Collision"
    bl_description = "Change Collision"
    
    def execute(self, context):
        
        mesh_collision = context.scene.khaos_tool.sk_mesh_collision
        #### change mesh type
        bpy.ops.rigidbody.shape_change(type=mesh_collision)
        return{'FINISHED'}


class Add_PassiveRigidbody_Operator(bpy.types.Operator):
    bl_idname = "view3d.add_passiverigidbody"
    bl_label = "Add Passive RigidBody"
    bl_description = "Add Passive RigidBody"
    
    def execute(self, context):
        bpy.ops.rigidbody.objects_add(type='PASSIVE')
        collision_margin = bpy.context.scene.khaos_tool.sk_collision_margin
        bool_conv_coll_margin = bpy.context.scene.khaos_tool.sk_bool_conv_coll_margin
        action = True if bool_conv_coll_margin else False
        for obj in bpy.context.selected_objects:
            obj.rigid_body.use_margin = action
            obj.rigid_body.collision_margin = collision_margin
        return{'FINISHED'}


class Add_Complex_PassiveRigidbody_Operator(bpy.types.Operator):
    bl_idname = "view3d.add_complex_passiverigidbody"
    bl_label = "Add Complex Passive RigidBody"
    bl_description = "Add Complex Passive RigidBody"
    
    def execute(self, context):
        bpy.ops.rigidbody.objects_add(type='PASSIVE')
        margin = 0.01
        bpy.context.scene.khaos_tool.sk_collision_margin = margin
        # collision_margin = bpy.context.scene.khaos_tool.sk_collision_margin
        
        # bool_conv_coll_margin = bpy.context.scene.khaos_tool.sk_bool_conv_coll_margin #the colision mesh will be set as MESH so it wont have this checkbox option
        # action = True if bool_conv_coll_margin else False

        for obj in bpy.context.selected_objects:
            # obj.rigid_body.use_margin = action
            obj.rigid_body.collision_margin = margin
            bpy.ops.rigidbody.shape_change(type='MESH')
        return{'FINISHED'}

class Calculate_Mass(bpy.types.Operator):
    bl_idname = "view3d.calculate_mass"
    bl_label = "Calculate Mass"
    bl_description = "Calculate Mass"
    
    def execute(self, context):
        calc_mass = context.scene.khaos_tool.sk_calc_mass
        result = calc_mass.split('|')
        print('calc_mass: --',calc_mass)
        bpy.ops.rigidbody.mass_calculate(material=result[0], density=int(result[1]))
        return{'FINISHED'}

class Add_PassiveFloor_Operator(bpy.types.Operator):
    bl_idname = "view3d.add_passivefloor"
    bl_label = "Add Passive RigidBody Floor"
    bl_description = "Add Passive RigidBody Floor"
    
    def execute(self, context):
        floor_size = context.scene.khaos_tool.sk_floor_size
        bpy.ops.mesh.primitive_plane_add(size=floor_size, enter_editmode=False, align='WORLD', location=(0.0, 0.0, 0.0), scale=(1, 1, 1))
        bpy.context.active_object.name = 'KHAOS_Floor'
        bpy.ops.rigidbody.objects_add(type='PASSIVE')
        return{'FINISHED'}


################# RIGID BODY #####################
###############################################End



#############################################Start
############# CONSTRAINT CONTROL #################

                
class Qty_constraint_coll(bpy.types.Operator):
    bl_idname = "view3d.qty_ctr_coll"
    bl_label = "Check amout of constraint collections"
    bl_description = "Check amout of constraint collections"
    
    def execute(self, context):
        #############
        Helper.updt_qty_ctr(context)
        
        return{'FINISHED'}

class Create_constraint(bpy.types.Operator):
    bl_idname = "view3d.create_ctr"
    bl_label = "Create new constraint"
    bl_description = "Create new constraint"
    
    def execute(self, context):
        # name = context.scene.khaos_tool.sk_frac_name_collection
        ctr_conn_pattern = context.scene.khaos_tool.sk_ctr_conn_pattern
        ctr_conn_type = context.scene.khaos_tool.sk_ctr_conn_type
        ctr_pivot_type = context.scene.khaos_tool.sk_ctr_pivot_type
        # ctr_collection = context.scene.khaos_tool.sk_ctr_collection

        #####
        #Get current fractures collection
        frac_collection = context.scene.khaos_tool.sk_frac_collection #get frac collection ID
        dropb_itens = my_settings_frac_callback(bpy.context.scene,bpy.context) #get the list in the dropbox
        for dp in dropb_itens:
            if frac_collection == dp[0]:
                name_frac_coll = dp[1] #based on the id, I can get the name of the collection returning what is in the list in the callback function that fill the dropbox menu
        ###
        ######

        #Check if the objects are all rigidbodies
        tot_rigbody=0
        #check all the selected objects
        for ob in bpy.context.selected_objects:
            # print(ob.name,'-',ob.users_collection)
            #check all the collections on the object, this is done to make sure it has the collection 
            #'RigidBodyWorld' that means, it has the rigid body properties. If there is not this collection, 
            #it means it is not a rigidbody, and because of that, constraint shouldnt be added
            for obcol in ob.users_collection:
                # print(obcol.name)
                if obcol.name == 'RigidBodyWorld':
                    tot_rigbody += 1
                
        tot_obj= len(bpy.context.selected_objects)
        print('total rigidbody:',tot_rigbody,' total objcts:',tot_obj)
        if tot_rigbody != tot_obj:
            lines = ("Total objs: "+str(tot_obj),
                    'Total RigidBody objs: '+str(tot_rigbody),
                    ' All obj must be RigidBody') 
            Helper.ShowMessageBoxMultiLines(lines,'Error','ERROR')
        else:
            #rest of the code
            name_ctr = name_frac_coll+'.'+'Constraint'
            idx, len_coll = Helper.reorganize_ctr()

            #create new collection based on the existing ones     
            name_new_coll = name_ctr+'{:03}'.format(len_coll+1)
            myCol = bpy.data.collections.new(name_new_coll)
            fract_coll = bpy.data.collections[name_frac_coll]
            if fract_coll:
                fract_coll.children.link(myCol)
            else:
                bpy.context.scene.collection.children.link(myCol) #Creates a new collection
            print("created")
    #        Helper.updt_qty_ctr(context)
            
            print('conn patern: ',ctr_conn_pattern)
            #create the constraint
            bpy.ops.rigidbody.connect(con_type=ctr_conn_type, pivot_type=ctr_pivot_type, connection_pattern=ctr_conn_pattern)

        
            #Setup for organizing the collection
            coll_name = name_ctr+str(idx)

            ####
            #get created constraint objects
            created_ctr = []
            objs = bpy.context.scene.collection.objects
            for obs in objs:
                if obs.name.startswith('Constraint'):
                    created_ctr.append(obs.name)
                    
            rigid_coll = bpy.data.collections['RigidBodyConstraints'] #this will be used to avoid that the constrint is removed form this collection, or else, it wont work

            ######
            #moving constraint created to custom collection
            for ob_name in created_ctr:
                #get collections the object is in
                obj =  bpy.data.objects[ob_name]
                obj_old_coll = obj.users_collection
                ### Check is the object is already in the collection
                for ob_coll in obj_old_coll:
                    if ob_coll.name != coll_name and ob_coll.name != 'RigidBodyConstraints':
    #                    print('1-',ob_name,'-',obj.users_collection)
                        myCol.objects.link(obj) #link the object to the KHAOS collection
    #                    print('2-',ob_name,'-',obj.users_collection)
                        for ob in obj_old_coll: #unlink from all  precedent obj collections
                            if ob.name != 'RigidBodyConstraints':
                                ob.objects.unlink(obj)
    #                            print('3-',ob_name,'-',obj.users_collection)
    #        
            
            bpy.ops.ptcache.free_bake_all() #try to resolve the crash problem
            Helper.select_ctr(self,context)
            ctr_breakable_rb = context.scene.khaos_tool.sk_ctr_breakable_rb
            Helper.updt_ctr_breakable2(ctr_breakable_rb)
        
        Helper.updt_qty_ctr(context)
        

        return{'FINISHED'}

class Select_constraint(bpy.types.Operator):
    bl_idname = "view3d.select_ctr"
    bl_label = "Select constraint"
    bl_description = "Select constraint"
    
    def execute(self, context):
        
        Helper.select_ctr(self, context)
    
        return{'FINISHED'}
    
class Delete_constraint(bpy.types.Operator):
    bl_idname = "view3d.delete_ctr"
    bl_label = "Delete constraint"
    bl_description = "Delete constraint"
    
    def execute(self, context):
        # context = bpy.context
        # name = context.scene.khaos_tool.sk_frac_name_collection
        # qty_ctr = context.scene.khaos_tool.sk_qty_ctr
        ctr_collection = context.scene.khaos_tool.sk_ctr_collection
        
        # Helper.select_ctr(self, context)
        
        if ctr_collection != 0: #only do something if there is some constraint
            
            dropb_itens = my_settings_callback(bpy.context.scene,context) #get the list in the dropbox
            slct_dropb_item = ctr_collection  

            for dbi in dropb_itens:
                # all_coll_frac.append([dbi[0],dbi[1]]) #get the order and id of the dropbox options
                if dbi[0] == slct_dropb_item:
                    coll_name = dbi[1] #based on the selected colection, get its name
        
            """
            ####
            #delete code crashing blender
            #add command to delete cllection
            coll_obj = bpy.data.collections[coll_name].objects
            
            # #remove the objects
            for obj in coll_obj:
            #    print('del obj:',obj.name)
                bpy.data.objects.remove(obj, do_unlink=True)
            """
            
            ######
            ##alternative delete
            Helper.select(coll_name)
            bpy.ops.object.delete(use_global=False, confirm=False)


            #remove the collection
            bpy.data.collections.remove(bpy.data.collections[coll_name])
            
            #add command to reorganize collection
            #add command to update qty of collections
            idx,leng = Helper.reorganize_ctr()

            Helper.updt_qty_ctr(context)
            
            context.scene.khaos_tool.sk_ctr_collection = str(idx)

        return{'FINISHED'}
    
class Updt_ctr_trheshold(bpy.types.Operator):
    bl_idname = "view3d.updt_ctr_trheshold"
    bl_label = "Update Constraint Breakable Threshold"
    bl_description = "Update Constraint Breakable Threshold"
    
    def execute(self, context):
        ctr_brk_threshold = context.scene.khaos_tool.sk_ctr_brk_threshold
        
        Helper.select_ctr(self, context)
        
        for obj in bpy.context.selected_objects:
            obj.rigid_body_constraint.breaking_threshold = ctr_brk_threshold
        
        
        return{'FINISHED'}

#               End
##### Adding Fracture Codes###########
######################################

















































def add_particles(context,name1,name2,name3,name4):
    #
    objs = bpy.context.selected_objects
    #
    
    section = "\\Collection\\"
    objects = [name2] #

    directory = blend_file + section

    for obj in objects:
        filename = obj
        bpy.ops.wm.append(filename=filename, directory=directory)
        #
        bpy.data.collections[name2].name = name3
        
        
        def recurLayerCollection(layerColl, collName):
            found = None
            if (layerColl.name == collName):
                return layerColl
            for layer in layerColl.children:
                found = recurLayerCollection(layer, collName)
                if found:
                    return found
                
        #
        layer_collection = bpy.context.view_layer.layer_collection
        layerColl = recurLayerCollection(layer_collection, name3)
        bpy.context.view_layer.active_layer_collection = layerColl
                
        '''above testing'''  
                
        
        bpy.context.view_layer.active_layer_collection.hide_viewport = True
        

        #
        for ob in bpy.context.selected_objects:
            ob.select = False
            
        
        def recurLayerCollection(layerColl, collName):
            found = None
            if (layerColl.name == collName):
                return layerColl
            for layer in layerColl.children:
                found = recurLayerCollection(layer, collName)
                if found:
                    return found
                
        #
        layer_collection = bpy.context.view_layer.layer_collection
        layerColl = recurLayerCollection(layer_collection, 'Collection')
        bpy.context.view_layer.active_layer_collection = layerColl
                
        '''above testing'''  
    
    
    
        #
        for obj in objs:
            obj.select_set(True)

        #
        obj = bpy.context.active_object

        obj.modifiers.new("part", type='PARTICLE_SYSTEM')
        qty_particles = len(obj.particle_systems) #get the new amount of particles
        # part = obj.particle_systems[0]
        part = obj.particle_systems[qty_particles-1] #get the latest particle created


        settings = part.settings
        settings.name = name4
        settings.count = 200 * context.scene.khaos_tool.particleamountdim
        settings.frame_start = bpy.context.scene.frame_current
        settings.frame_end = (bpy.context.scene.frame_current +10)
        settings.lifetime = 300
        settings.emit_from = 'FACE'
        settings.normal_factor = 1 * context.scene.khaos_tool.velocitydim
        settings.object_factor = 1
        settings.factor_random = 3 * context.scene.khaos_tool.randomspreaddim
        settings.use_rotations = True
        settings.rotation_factor_random = 1.00
        settings.use_dynamic_rotation= True
        settings.angular_velocity_factor = 2
        settings.physics_type = 'NEWTON'
        settings.mass = 1
        settings.use_multiply_size_mass = True
        settings.brownian_factor = 0
        settings.drag_factor = 0
        settings.damping = 0.00
        settings.integrator = 'EULER'
        bpy.context.object.show_instancer_for_render = False
        settings.show_unborn = False
        settings.use_dead = True
        settings.particle_size = 0.1
        settings.size_random = 1
        settings.render_type = 'COLLECTION'
        bpy.data.particles[name4].instance_collection = bpy.data.collections[name3]

        settings.jitter_factor = 0
        settings.object_factor = 1
        settings.effector_weights.turbulence = 0


        #Then we copy this particle system to the rest of the selected objects
        bpy.ops.particle.copy_particle_systems(remove_target_particles=True, use_active=False)

#BELOW TESTING FOR PARTICLES DEBRIS CODE FOR SMALL SCALE DETAIL IN DESTRUCTION


#Add particle systems to selected objects on selected frames operator
class NEW_OT_DebrisParticlesOperator (bpy.types.Operator):
    bl_idname = 'my.debrisparticlesoperator'
    bl_label = 'Add Debris Particles'

    
    
    def execute(self, context):
        #First we need to store the selected objects in some kind of variable so we can reselect them later in the script
        # objs = bpy.context.selected_objects

    
        
        #Then we need to append the selected debris systems into the scene and create a particle system on the fractured object for each debris system selected(Depending on the checkboxes the user selects)
        
        

        #options to make easier to load the options
        options = [	[context.scene.khaos_tool.my_bool1, 'Glass Particles','Glass Pieces','_Glass Particles','_Glass explosion'],
			[context.scene.khaos_tool.my_bool2, 'Metal Shard Particles', 'Metal Pieces', '_Metal Particles','_Metal Shard explosion'],
			[context.scene.khaos_tool.my_bool3, 'Wood Particles', 'Wood Pieces', '_Wood Particles', '_Wood pieces explosion'],
			[context.scene.khaos_tool.my_bool4, 'Burning Debris', 'Burning Pieces', '_Burning Particles','_Burning debris explosion'],
			[context.scene.khaos_tool.my_bool5, 'Sparks', 'Spark Pieces', '_Spark Particles', '_Spark pieces explosion'],
			[context.scene.khaos_tool.my_bool6, 'Dirt Debris', 'Dirt Pieces', '_Dirt Particles', '_Dirt particle explosion'],
			[context.scene.khaos_tool.my_bool9, 'Tree Branch Debris', 'Tree Pieces', '_Branch Particles', '_Branch particle explosion'],
			[context.scene.khaos_tool.my_bool10, 'Concrete Debris', 'Concrete Pieces', '_Concrete Particles', '_Concrete particle explosion'],
			[context.scene.khaos_tool.my_bool11, 'Rebar Debris', 'Rebar Pieces', '_Rebar Particles', '_Rebar particle explosion'],
			[context.scene.khaos_tool.my_bool12, 'Rock Debris', 'Rock Pieces', '_Rock Particles','_Rock particle explosion']
			]
        #If the GLASS PARTICLES CHECKBOX aka bool1 is checked the following code should run
        # if (context.scene.khaos_tool.my_bool1 == True):

        # Check all the options to see which one apply
        for option in options:
            if option[0] == True:
                add_particles(context,option[1],option[2],option[3],option[4])

        return{'FINISHED'}
    
    
    
#
class NEW_OT_RemoveParticlesOperator (bpy.types.Operator):
    bl_idname = 'my.removeparticlesoperator'
    bl_label = 'Remove Debris Particles'
    
    def execute(self, context):
        #
        objs = bpy.context.selected_objects
        #
        for obj in objs:
            bpy.context.view_layer.objects.active = obj
            bpy.ops.object.particle_system_remove()



        return{'FINISHED'}
    







class NEW_PT_khaospanelDestruction(bpy.types.Panel):
    """Creates a Panel in the Object properties window"""
    bl_label = "KHAOS: Destruction Tools"
    bl_idname = "NEW_PT_khaospanelDestruction"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "KHAOS!"

    def draw(self, context):
        # sk_value_prop = context.scene.sk_value_prop
      
        scene = context.scene #from the online code boolean thing
        layout = self.layout
        obj = context.active_object
        # obj_colapse = context.object
        obj_colapse = context.scene
        
        

        row = layout.row()
        rowb = layout.row().box()
        row.label(text='Organization')
        row = rowb.row()
        row.label(text='Snap and Expand/Colapse Menus')
        row = rowb.row(align=True)
        row.operator('view3d.snap_face', text="Face")
        row.operator('view3d.snap_edge', text="Edge")
        row.operator('view3d.snap_vertex', text="Vertex")
        row = rowb.row(align=True)
        row.operator('view3d.colapse_menus', text="Colapse")
        row.operator('view3d.expand_menus', text="Expand")
        

        row = layout.row().box()
        row.label(text='Cutter Tool')
        row.enabled = len(context.selected_objects) == 2
        row.operator('view3d.cut_object', text="Cut 2 objects")

        # if obj is not None and (obj.type == 'MESH' or obj.type == 'EMPTY'):

        row = layout.row()
        
        rowb = layout.row().box()
        row = rowb.row()
        row.prop(obj_colapse, "expanded0",
            icon="TRIA_DOWN" if obj_colapse.expanded0 else "TRIA_RIGHT",
            icon_only=True, emboss=False
        )
        row.label(text='Drawing')
        if obj_colapse.expanded0:
            row = rowb.row(align=True)
            row.operator('view3d.draw', text="Draw Fracture Place")
            row.operator('view3d.selection_box', text='Selection Box')
            row = rowb.row()
            row.operator('view3d.clear_last_gp', text="Clear Annotation")
        
        rowb = layout.row().box()
        row = rowb.row()
        row.label(text='Fracture: '+str(scene.khaos_tool.sk_qty_frac))
        row = rowb.row()
        row.label(text='Qty Obj: '+str(scene.khaos_tool.sk_qty_frac_obj))
        row.operator('view3d.colapse', text="Colapse Collections")
        row = rowb.row()
        row.prop(scene.khaos_tool, "sk_frac_name_collection")
        row = rowb.row()
        row.enabled = scene.khaos_tool.sk_qty_frac > 0
        row.operator('view3d.select_obj', text="Select")
        row.operator('view3d.delete_frac', text="Delete")
        row = rowb.row()
        row.prop(scene.khaos_tool, "sk_frac_collection")
        
        row = rowb.row()
        row.prop(obj_colapse, "expanded1",
            icon="TRIA_DOWN" if obj_colapse.expanded1 else "TRIA_RIGHT",
            icon_only=True, emboss=False
        )
        row.label(text='Fracture Settings')
        if obj_colapse.expanded1:
            row = rowb.row()
            row.operator('view3d.fracture_draw', text="From Drawing")
            row.operator('view3d.fracture', text="Own Vertices")
            row = rowb.row()
            row.prop(scene.khaos_tool, "sk_material_idx")
            row = rowb.row()
            row.prop(scene.khaos_tool, "sk_frac_source_limit")
            row.prop(scene.khaos_tool, "sk_frac_source_noise")
            row = rowb.row()
            row.prop(scene.khaos_tool, "sk_frac_recursion")
            row.prop(scene.khaos_tool, "sk_frac_margin")

    
        rb_obj = context.active_object is not None and context.object.rigid_body is not None
        rowb = layout.row().box()
        row = rowb.row()
        row.prop(obj_colapse, "expanded2",
            icon="TRIA_DOWN" if obj_colapse.expanded2 else "TRIA_RIGHT",
            icon_only=True, emboss=False
        )
        row.label(text='Active Rigid Bodies')
        if obj_colapse.expanded2:
            row = rowb.row()
            row.operator('view3d.add_activerigidbody', text="Add Active")
            row.operator('view3d.remove_rigidbody', text="Remove RigidBody")
            row = rowb.row()
            row.operator('view3d.add_active_animated_rigidbody', text="Add Active Animated")
            rowstartdeact = rowb.row()
            rowstartdeact.prop(scene.khaos_tool, "sk_deactivated_rb", text="Start Deactivated")
            rowmass = rowb.row()
            rowmass.enabled = rb_obj
            rowmass.prop(scene.khaos_tool, "sk_calc_mass", text="Mass")
        # rowmass.operator('view3d.calculate_mass', text="Update")
        # layout.row().separator()
        # row = rowb.row()
        row = layout.row().box()
        row.label(text='Mesh (active/Passive)')
        row.enabled = rb_obj
        row.prop(scene.khaos_tool, "sk_mesh_collision", text="Collision")
        # row.operator('view3d.change_collision', text="Change")

        rowb = layout.row().box()
        row = rowb.row()
        row.prop(obj_colapse, "expanded3",
            icon="TRIA_DOWN" if obj_colapse.expanded3 else "TRIA_RIGHT",
            icon_only=True, emboss=False
        )
        row.label(text='Add Passive Rigid Bodies')
        if obj_colapse.expanded3:
            row = rowb.row()
            row.operator('view3d.add_passiverigidbody', text="Simple")
            row.operator('view3d.add_complex_passiverigidbody', text="Complex")
            if context.active_object is not None:
                rb = context.object.rigid_body
                if rb is not None and rb.collision_shape not in ['MESH','CONE']:
                    rowmarginbool = rowb.row()
                    rowmarginbool.enabled = rb is not None
                    rowmarginbool.prop(scene.khaos_tool, "sk_bool_conv_coll_margin", text="Enable Collision Margin")
                rowmarginmnumber = rowb.row()
                if (rb is not None and rb.use_margin is True) or rb is not None and (rb.collision_shape in ['MESH','CONE']  ):
                    rowmarginmnumber.enabled = True
                else:
                    rowmarginmnumber.enabled = False
                rowmarginmnumber.prop(scene.khaos_tool, "sk_collision_margin", text="Margin")

            else:
                rb = None

        # row = layout.row()
        # row.label(text='Floor')
        # row.operator('view3d.add_passivefloor', text="Add")
        # row.prop(scene.khaos_tool, "sk_floor_size")

        ###
        #Variable to set the constraint enabled
        if bpy.context.active_object != None:
            rb = context.object.rigid_body
            enable_ctr = rb is not None or (bpy.context.active_object != None and bpy.context.active_object.type == 'EMPTY')
        else:
            enable_ctr = False

        rowb = layout.row().box()
        row = rowb.row()
        # row.enabled = enable_ctr
        row.enabled = True
        row.prop(obj_colapse, "expanded4",
            icon="TRIA_DOWN" if obj_colapse.expanded4 else "TRIA_RIGHT",
            icon_only=True, emboss=False
        )
        row.label(text='Constraints: '+str(scene.khaos_tool.sk_qty_ctr)) 
        
        if obj_colapse.expanded4:
        
            row = rowb.row()
            row.enabled = enable_ctr
            row.label(text='Qty Objs: '+str(scene.khaos_tool.sk_qty_ctr_obj))
            row.operator('view3d.select_obj', text="Select fract obj")

            row = rowb.row()
            row.enabled = enable_ctr
            row.label(text='Constraint Collection')
            
            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_collection", text="")
        #    row = layout.row()
        #    row.operator('view3d.qty_ctr_coll', text="refresh qty constraint")
            
            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_conn_type")
            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_pivot_type")
            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_conn_pattern")
            row = rowb.row()
            row.enabled = enable_ctr
            # row.scale_y = 1.5
            row.operator('view3d.create_ctr', text="Create")

            row = rowb.row()
            row.enabled = scene.khaos_tool.sk_qty_ctr > 0
            row.operator('view3d.select_ctr', text="Select")        
            row.operator('view3d.delete_ctr', text="Delete")
            # row.label(text='')
            # row.label(text='')
            # row.label(text='')#these where created just to make more difficult to press the delete button  :)
            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_breakable_rb", text="Breakable")

            row = rowb.row()
            row.enabled = enable_ctr
            row.prop(scene.khaos_tool, "sk_ctr_brk_threshold")
        # row.operator('view3d.updt_ctr_trheshold', text="Updt Threshold")
        # else:
        #     row = layout.row().box()
        #     # row = rowb.row()
        #     row.label(text='Select at least one object to ')
        #     row.label(text='view the options') 
            row = rowb.row()
            


#
class NEW_PT_khaospanelone(bpy.types.Panel):
    """Creates a Panel in the Object properties window"""
    bl_label = "KHAOS: Procedural Explosions"
    bl_idname = "NEW_PT_KhaosPanelone"
    bl_space_type = "VIEW_3D"
    bl_region_type = 'UI'
    bl_category = "KHAOS!"

    def draw(self, context):
        layout = self.layout
        scene = context.scene #


        obj = context.object
        row = layout.row()
        row.label(text="GENERATE KHAOS!")
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row.label(text="Choose Your Smoke Type:") #
        #
        self.layout.prop(scene.khaos_tool, "my_bool", text="Dynamic Smoke")
        self.layout.prop(scene.khaos_tool, "my_bool8", text="Dynamic Smoke/Fire")
        self.layout.prop(scene.khaos_tool, "my_bool13", text="Thick Smoke/Fire")
        self.layout.prop(scene.khaos_tool, "my_bool14", text="Dynamic Dirt (New)")
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row.label(text="Choose Your Debris:")
        #
        self.layout.prop(scene.khaos_tool, "my_bool1", text="Glass Particles")
        self.layout.prop(scene.khaos_tool, "my_bool2", text="Metal Shards")
        self.layout.prop(scene.khaos_tool, "my_bool3", text="Wood Pieces")
        self.layout.prop(scene.khaos_tool, "my_bool4", text="Burning Debris")
        self.layout.prop(scene.khaos_tool, "my_bool5", text="Sparks")
        self.layout.prop(scene.khaos_tool, "my_bool6", text="Dirt")
        self.layout.prop(scene.khaos_tool, "my_bool9", text="Tree Branches")
        self.layout.prop(scene.khaos_tool, "my_bool10", text="Concrete")
        self.layout.prop(scene.khaos_tool, "my_bool11", text="Rebar Rods")
        self.layout.prop(scene.khaos_tool, "my_bool12", text="Rocks")
        row = layout.row()
        
        
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row.label(text="Type of Khaos:")
        row = layout.row()
        row.scale_y = 1.5
        row.operator("my.directionexplosion")
        row = layout.row()
        row.scale_y = 1.5
        row.operator("my.omnidirectionalexplosion")
        row = layout.row()
        row.scale_y = 1.5
        row.operator("my.groundburstexplosion")
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row.label(text="Destruction Tools Debris:")
        row = layout.row()
        row.scale_y = 1.5
        row.operator('my.debrisparticlesoperator', text="Add Debris")
        row.scale_y = 1.5
        row.operator('my.removeparticlesoperator', text="Remove Debris")
        row = layout.row()
        #row.label(text="Mix the fuel with some turbulence!")
        row = layout.row()
        #self.layout.prop(scene.khaos_tool, "mixfuelinitialturbulencestrength", text="Initial Turbulence Strength")
        row = layout.row()
        #self.layout.prop(scene.khaos_tool, "mixfuelfinalturbulencestrength", text="Ending Turbulence Strength")
        row = layout.row()
        #self.layout.prop(scene.khaos_tool, "turbulenceduration", text="Turbulence Duration")
        row = layout.row()
        row.scale_y = 2
        #row.operator("my.basicturbulence", icon ="OUTLINER_OB_FORCE_FIELD")
        row = layout.row()
        row = layout.row()
        
        
        obj = context.object

#
class NEW_PT_khaospaneltwo(bpy.types.Panel):
    """Creates a Panel in the Object properties window"""
    bl_label = "KHAOS Particle Parameters"
    bl_idname = "NEW_PT_KhaosPanelTwo"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "KHAOS!"

    def draw(self, context):
        layout = self.layout
        scene = context.scene #

        obj = context.object
        row = layout.row()
        '''ALL LINES BELOW THIS UNTIL OTHERWISE STATED ARE EXPERIMENTAL RIGHT NOW'''
        #
        
        row.label(text="Khaos All Particle Parameters:")
        self.layout.prop(scene.khaos_tool, "velocitydim", text="Scale Velocity")
        self.layout.prop(scene.khaos_tool, "randomspreaddim", text = "Scale Random Spread")
        self.layout.prop(scene.khaos_tool, "particleamountdim", text = "Scale Particle Amount")
        self.layout.prop(scene.khaos_tool, "particleemissiondurationdim", text = "Scale Emission Time")
        row = layout.row()
        row = layout.row()
        row.label(text="Exclusive Smoke/Fire Parameters:")
        self.layout.prop(scene.khaos_tool, "particledlifetimedim", text = "Scale Particle Life")
        row = layout.row()
        row = layout.row()
        row.label(text="Smoke Particle Decay Settings:")
        self.layout.prop(scene.khaos_tool, "particlesmokeflowsizestartdim", text = "Particle Start Size")
        self.layout.prop(scene.khaos_tool, "particlesmokeflowsizeenddim", text = "Particle End Size")
        row = layout.row()
        row = layout.row()
        row.label(text="Fire Particle Fuel Settings:")
        
        self.layout.prop(scene.khaos_tool, "particleflameratestartdim", text = "Fuel Start Amount")
        self.layout.prop(scene.khaos_tool, "particleflamerateenddim", text = "Fuel End Amount")
        
        row = layout.row()
        row = layout.row()
        row.label(text="Smoke Velocity Parameters:")
        self.layout.prop(scene.khaos_tool, "particleinitialvelstartdim", text = "Initial Starting Velocity")
        self.layout.prop(scene.khaos_tool, "particleinitialvelenddim", text = "Initial Ending Velocity")
        
        '''FINISH EXPERIMENTAL CODE HERE'''
        
        obj = context.object

#
class NEW_PT_khaospanelthree(bpy.types.Panel):
    """Creates a Panel in the Object properties window"""
    bl_label = "KHAOS: Extras"
    bl_idname = "NEW_PT_KhaosPanelthree"
    bl_space_type = 'VIEW_3D'
    bl_region_type = 'UI'
    bl_category = "KHAOS!"

    def draw(self, context):
        layout = self.layout
        scene = context.scene #
        khaos_tool = context.scene.khaos_tool
        obj_colapse = context.scene


        obj = context.object
        row = layout.row()
        
        
        
        
        if khaos_tool.basicsmokeplume_panel_bool == False:
            row.scale_y = 1.5
            row.operator("my.basicsmokeplume_switch_pannel")
        else:
            rowb = layout.row().box()
            row = rowb.row()
            row.label(text='Add Smoke Plume')
            row = rowb.row()
            row.prop(khaos_tool, "highest_fuel_rate", text="Highest Fuel Rate:")
            row = rowb.row()
            row.prop(khaos_tool, "lowest_fuel_rate", text="Lowest Fuel Rate:")
            row = rowb.row()
            row.prop(khaos_tool, "fuelpulsetiming", text="Fuel Pulse Timing (Frames):")
            row = rowb.row()
            row.scale_y = 1.5
            row.operator("my.basicsmokeplume")
        
        row = layout.row()
        
        if khaos_tool.basicwindpulse_panel_bool == False:
            row.scale_y = 1.5
            row.operator("my.basicwindpulse_switch_pannel")
        else:
            rowb = layout.row().box()
            row = rowb.row()
            row.label(text='Add Wind Pulse')
            row = rowb.row()
            row.prop(khaos_tool, "highest_wind_strength", text="Highest Wind Strength:")
            row = rowb.row()
            row.prop(khaos_tool, "lowest_wind_strength", text="Lowest Wind Strength:")
            row = rowb.row()
            row.prop(khaos_tool, "pulsetiming", text="Pulse timing (Frames):")
            row = rowb.row()
            row.scale_y = 1.5
            row.operator("my.basicwindpulse")

        # rowb = layout.row().box()
        # row = rowb.row()
        # # row.enabled = enable_ctr
        # row.enabled = True
        # row.prop(obj_colapse, "expanded_extra1",
        # icon="TRIA_DOWN" if obj_colapse.expanded_extra1 else "TRIA_RIGHT",
        # icon_only=True, emboss=False
        # )
        # row.label(text='Wind Pulse Options: ') 

        # if obj_colapse.expanded_extra1:
        #         # row = layout.row()
        #         # row.label(text='Time of Day')
        #         # row = layout.row().box()
        #         row = rowb.row()
        #         row.prop(khaos_tool, "highest_wind_strength", text="Highest Wind Strength:")
        #         row = rowb.row()
        #         row.prop(khaos_tool, "lowest_wind_strength", text="Lowest Wind Strength:")
        #         row = rowb.row()
        #         row.prop(khaos_tool, "pulsetiming", text="Pulse timing (Frames):")
        


        
        row = layout.row()
        row = layout.row()
        row = layout.row()
        row = layout.row().box()
        row.label(text="Add Collision Objects Below:")
        row.operator("my.collisionplaneoperator")
        
        row.operator("my.collisioncubeoperator")
        
        row.operator("my.collisioncylinderoperator")
        
        row = layout.row()
        row = layout.row().box()
        row.label(text="My Preset Render Settings:")
        row.operator("my.rendersettings", icon = 'CAMERA_DATA')
        
        obj = context.object






classes = (KhaosSettings, NEW_PT_khaospanelone, NEW_PT_khaospaneltwo, NEW_PT_khaospanelthree, NEW_OT_RendersettingsOperator, 
NEW_OT_DirectionalExplosionPreset, NEW_OT_OmnidirectionalExplosionPreset, NEW_OT_GroundburstExplosionPreset, 
NEW_OT_CollisionPlaneOperator, NEW_OT_CollisionCubeOperator, NEW_OT_CollisionCylinderOperator, 
NEW_OT_BasicTurbulenceOperator, WM_OT_BasicSmokePlumeOperator, WM_OT_BasicWindPulseOperator,
### Start of fracture classes
NEW_PT_khaospanelDestruction,DrawFracture_Operator, SelectBox_Operator, FractureDraw_Operator,
            Fracture_Operator,Delete_Fracture,Add_ActiveRigidbody_Operator,Add_PassiveRigidbody_Operator,
            Add_Complex_PassiveRigidbody_Operator, 
            Clear_lastGP_Operator,Add_PassiveFloor_Operator,Calculate_Mass,Select_obj_Operator,
            Remove_Rigidbody_Operator,Change_Collision_Operator,Qty_constraint_coll,
            Create_constraint,Select_constraint,Delete_constraint,
            Add_ActiveRigidbodyAnimated_Operator, Updt_ctr_trheshold,
            Cut_object_Operator,Colapse,WM_OT_BasicWindPulseOperatorSwitchPanel, WM_OT_BasicSmokePlumeOperatorSwitchPanel,
            SnapFace,SnapEdge, SnapVertex, ColapseMenus, ExpandMenus, NEW_OT_DebrisParticlesOperator, NEW_OT_RemoveParticlesOperator
            ) 




def register():
    for cls in classes:
        bpy.utils.register_class(cls)
    bpy.utils.register_class(KhaosSettings)
    bpy.types.Scene.khaos_tool = bpy.props.PointerProperty(type=KhaosSettings)

register, unregister = bpy.utils.register_classes_factory(classes)

def unregister():
    del bpy.types.Scene.khaos_tool
    for cls in reversed(classes):
        bpy.utils.unregister_class(cls)

#

def register():
    for cls in classes:
        bpy.utils.register_class(cls)
    bpy.types.Scene.khaos_tool = bpy.props.PointerProperty(type=KhaosSettings)
    # bpy.types.Scene.coll_margin = bpy.props.FloatProperty(get=get_float,set=set_float)
    # bpy.types.Object.expanded0 = bpy.props.BoolProperty(default=False)
    # bpy.types.Object.expanded1 = bpy.props.BoolProperty(default=False)
    # bpy.types.Object.expanded2 = bpy.props.BoolProperty(default=False)
    # bpy.types.Object.expanded3 = bpy.props.BoolProperty(default=False)
    # bpy.types.Object.expanded4 = bpy.props.BoolProperty(default=False)

    bpy.types.Scene.expanded0 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.expanded1 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.expanded2 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.expanded3 = bpy.props.BoolProperty(default=False)
    bpy.types.Scene.expanded4 = bpy.props.BoolProperty(default=False)

    bpy.types.Scene.expanded_extra1 = bpy.props.BoolProperty(default=False)

def unregister():
    del bpy.types.Scene.khaos_tool
    for cls in reversed(classes):
        bpy.utils.unregister_class(cls)


if __name__ == "__main__":
    register()


