<?php
/* ------------------------------------------------------------------------
* session_mysql.php
* ------------------------------------------------------------------------
* PHP4 MySQL Session Handler
* Version 1.00
* by Ying Zhang (ying@zippydesign.com)
* Last Modified: May 21 2000
*
* ------------------------------------------------------------------------
* TERMS OF USAGE:
* ------------------------------------------------------------------------
* You are free to use this library in any way you want, no warranties are
* expressed or implied. This works for me, but I don't guarantee that it
* works for you, USE AT YOUR OWN RISK.
*
* While not required to do so, I would appreciate it if you would retain
* this header information. If you make any modifications or improvements,
* please send them via email to Ying Zhang <ying@zippydesign.com>.
*
* ------------------------------------------------------------------------
* DESCRIPTION:
* ------------------------------------------------------------------------
* This library tells the PHP4 session handler to write to a MySQL database
* instead of creating individual files for each session.
*
* Create a new database in MySQL called "sessions" like so:
*
* CREATE TABLE sessions (
* sesskey char(32) not null,
* expiry int(11) unsigned not null,
* value text not null,
* PRIMARY KEY (sesskey)
* );
*
* ------------------------------------------------------------------------
* INSTALLATION:
* ------------------------------------------------------------------------
* Make sure you have MySQL support compiled into PHP4. Then copy this
* script to a directory that is accessible by the rest of your PHP
* scripts.
*
* ------------------------------------------------------------------------
* USAGE:
* ------------------------------------------------------------------------
* Include this file in your scripts before you call session_start(), you
* don't have to do anything special after that.
*/

$SESS_DBH = "";
function sess_open($save_path, $session_name)
{
	global $db['host'], $db['name'], $db['user'], $db['pass'], $SESS_DBCONN;
	
	if (!$SESS_DBCONN = mysql_connect($db['host'], $db['user'], $db['pass']))
	{
		echo "<li>Can't connect to ".$db['host']." as ".$db['user']."";
		echo "<li>MySQL Error: ", mysql_error();
		die;
	}
	
	if (!mysql_select_db($db['name'], $SESS_DBCONN))
	{
		echo "<li>Unable to select database ".$db['name']."";
		die;
	}
	
	return true;
	
}

function sess_close() {
	return true;
}

function sess_read($key) {
	
	global $SESS_DBCONN, $db['name'], $SESS_LIFE;
	$SQL = "SELECT value FROM ".PREFIX."_sessions WHERE sesskey = '$key'";
	$REF = mysql_db_query($db['name'], $SQL, $SESS_DBCONN);
	if (list($value) = mysql_fetch_row($REF))
	{
		return $value;
	}
	
	return false;
}


function sess_write($key, $val) {
	global $db['host'], $db['name'], $db['user'], $db['pass'], $SESS_DBCONN;
	
	$expiry = time() + 3600;
	$value = addslashes($val);
	
	$qry = "INSERT INTO ".PREFIX."_sessions VALUES ('$key', $expiry, '$value')";
	$qid = mysql_query($qry, $SESS_DBCONN);
	
	if (! $qid) {
		$qry = "UPDATE ".PREFIX."_sessions SET expiry = $expiry, value = '$value' WHERE sesskey = '$key'";
		$qid = mysql_query($qry, $SESS_DBCONN);
	}
	
	return $qid;
}

function sess_destroy($key) {
	global $db['host'], $db['name'], $db['user'], $db['pass'], $SESS_DBCONN;
	
	$qry = "DELETE FROM ".PREFIX."_sessions WHERE sesskey = '$key'";
	$qid = mysql_query($qry, $SESS_DBCONN);
	
	return $qid;
}

function sess_gc($maxlifetime) {
	global $db['host'], $db['name'], $db['user'], $db['pass'], $SESS_DBCONN;
	
	$qry = "DELETE FROM ".PREFIX."_sessions WHERE expiry < " . time();
	$qid = mysql_query($qry, $SESS_DBCONN);
	
	return mysql_affected_rows($SESS_DBCONN);
}

session_set_save_handler(
"sess_open",
"sess_close",
"sess_read",
"sess_write",
"sess_destroy",
"sess_gc");
?>

