CREATE TABLE koobi4_active ( 
  val char(15) NOT NULL default '',
  active tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (val)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_adminlogs (
  id int(10) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  ip varchar(25) NOT NULL default '',
  action tinytext NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_affiliates (
  id int(11) NOT NULL auto_increment,
  url varchar(255) NOT NULL default '',
  posi smallint(3) unsigned NOT NULL default '0',
  hits int(11) NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  image varchar(255) NOT NULL default '',
  area smallint(3) unsigned NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_areas (
  area_id smallint(3) unsigned NOT NULL auto_increment,
  area_name varchar(200) NOT NULL default '',
  area_descr text NOT NULL,
  area_template varchar(200) NOT NULL default 'standard',
  active tinyint(1) unsigned NOT NULL default '1',
  tmpl text NOT NULL,
  pass varchar(20) NOT NULL default '',
  PRIMARY KEY  (area_id),
  KEY area_id (area_id),
  KEY area_template (area_template),
  KEY active (active)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=2 ;##


CREATE TABLE koobi4_articlecat (
  catid mediumint(5) unsigned NOT NULL auto_increment,
  parent_id mediumint(5) unsigned NOT NULL default '0',
  catname varchar(100) default NULL,
  catdesc text NOT NULL,
  area smallint(3) unsigned NOT NULL default '1',
  posi smallint(3) unsigned NOT NULL default '1',
  icon varchar(255) NOT NULL default '',
  PRIMARY KEY  (catid),
  KEY area (area),
  KEY catid (catid),
  KEY catname (catname)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_articlecomments (
  id mediumint(6) unsigned NOT NULL auto_increment,
  articleid mediumint(6) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_articles (
  id int(11) unsigned NOT NULL auto_increment,
  articlecat int(10) unsigned NOT NULL default '0',
  title varchar(255) default NULL,
  genre mediumint(5) unsigned default NULL,
  publisher mediumint(5) unsigned default NULL,
  manufacturer mediumint(5) unsigned default NULL,
  voting smallint(3) unsigned default NULL,
  artvotes text NOT NULL,
  content text,
  subtitle varchar(255) NOT NULL default '',
  asin varchar(255) NOT NULL default '',
  platform varchar(100) default NULL,
  release varchar(50) default NULL,
  price varchar(255) NOT NULL default '',
  shopurl varchar(255) default NULL,
  shop varchar(255) default NULL,
  boxshot varchar(255) default NULL,
  links text,
  gallery varchar(100) default NULL,
  inline_screens text NOT NULL,
  uid mediumint(5) unsigned NOT NULL default '1',
  ctime int(10) unsigned NOT NULL default '0',
  hits int(10) unsigned NOT NULL default '0',
  type enum('special','preview','review','interview','column') NOT NULL default 'review',
  area smallint(3) unsigned NOT NULL default '1',
  printed mediumint(8) unsigned NOT NULL default '0',
  active tinyint(1) NOT NULL default '1',
  top text NOT NULL,
  flop text NOT NULL,
  minimum text NOT NULL,
  optimum text NOT NULL,
  time_start int(10) unsigned NOT NULL default '0',
  time_end int(10) unsigned NOT NULL default '0',
  cansearch enum('yes','no') NOT NULL default 'yes',
  isontop enum('yes','no') NOT NULL default 'no',
  image_top varchar(255) NOT NULL default '',
  canvote tinyint(1) NOT NULL default '0',
  voting_value mediumint(5) unsigned NOT NULL default '0',
  voting_votes mediumint(5) unsigned NOT NULL default '0',
  voting_ip varchar(25) NOT NULL default '',
  voting_uid text NOT NULL,
  allareas enum('yes','no') NOT NULL default 'no',
  image_align enum('left','right') NOT NULL default 'left',
  end_top int(11) unsigned NOT NULL default '0',
  matchword varchar(255) NOT NULL default '',
  product mediumint(5) unsigned NOT NULL default '0',
  password varchar(255) NOT NULL default '',
  showonpage tinyint(1) NOT NULL default '1',
  votes mediumint(6) unsigned NOT NULL default '0',
  votes_data mediumint(6) unsigned NOT NULL default '0',
  votes_ip text NOT NULL,
  votes_uid text NOT NULL,
  cancomment tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_autowords (
  id int(10) unsigned NOT NULL auto_increment,
  words varchar(200) NOT NULL default '',
  text text NOT NULL,
  hits int(10) unsigned NOT NULL default '0',
  active tinyint(4) NOT NULL default '1',
  PRIMARY KEY  (id),
  KEY words (words)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_container (
  id smallint(3) unsigned NOT NULL default '0',
  name varchar(200) NOT NULL default '',
  tpl varchar(100) NOT NULL default 'standard_1',
  typ enum('in','out') NOT NULL default 'in',
  area smallint(5) unsigned NOT NULL default '1',
  KEY container (tpl),
  KEY id (id)
) TYPE=MyISAM PACK_KEYS=0;##



CREATE TABLE koobi4_downloadcat (
  catid mediumint(5) unsigned NOT NULL auto_increment,
  parent_id mediumint(5) unsigned NOT NULL default '0',
  catname varchar(100) NOT NULL default '',
  catdesc text NOT NULL,
  area smallint(3) unsigned NOT NULL default '1',
  posi smallint(3) unsigned NOT NULL default '1',
  icon varchar(255) NOT NULL default '',
  group_id varchar(255) NOT NULL default '1,2,3',
  PRIMARY KEY  (catid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_downloadcomments (
  id mediumint(6) unsigned NOT NULL auto_increment,
  dlid mediumint(6) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_downloads (
  id int(10) NOT NULL auto_increment,
  catid int(10) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text text NOT NULL,
  dlurl varchar(255) NOT NULL default '',
  dlurl_local varchar(255) NOT NULL default '',
  hits int(10) unsigned NOT NULL default '0',
  hits_today int(10) unsigned NOT NULL default '0',
  hits_perday int(10) unsigned NOT NULL default '0',
  size varchar(35) NOT NULL default '0',
  password varchar(255) NOT NULL default '',
  ctime int(10) unsigned NOT NULL default '0',
  today int(11) NOT NULL default '0',
  votes mediumint(6) unsigned NOT NULL default '0',
  votes_data mediumint(6) unsigned NOT NULL default '0',
  votes_ip text NOT NULL,
  votes_uid text NOT NULL,
  canvote tinyint(1) NOT NULL default '0',
  cancomment tinyint(1) NOT NULL default '0',
  area smallint(3) NOT NULL default '1',
  uid int(10) unsigned NOT NULL default '1',
  active tinyint(1) NOT NULL default '1',
  gallery tinytext NOT NULL,
  platform tinytext NOT NULL,
  end_top int(10) unsigned NOT NULL default '0',
  image varchar(255) NOT NULL default '',
  image_top varchar(255) NOT NULL default '',
  isontop tinyint(1) NOT NULL default '0',
  language varchar(255) NOT NULL default '',
  author_file tinytext NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_f_allowed_files (
  id tinyint(3) unsigned NOT NULL auto_increment,
  filetype varchar(200) NOT NULL default '',
  filesize int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=12 ;##



CREATE TABLE koobi4_f_attachment (
  id mediumint(8) unsigned NOT NULL auto_increment,
  orig_name varchar(200) NOT NULL default '',
  filename varchar(200) NOT NULL default '',
  hits int(11) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY filename (filename),
  FULLTEXT KEY filename_2 (filename)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_f_category (
  id int(11) NOT NULL auto_increment,
  title varchar(200) NOT NULL default '',
  position smallint(5) unsigned NOT NULL default '0',
  parent_id smallint(5) unsigned default NULL,
  comment text,
  group_id text,
  PRIMARY KEY  (id),
  KEY title (title),
  FULLTEXT KEY title_2 (title)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='kategorie eines forums' AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_f_forum (
  id int(11) unsigned NOT NULL auto_increment,
  title varchar(200) NOT NULL default '',
  category_id int(11) unsigned NOT NULL default '0',
  statusicon varchar(20) default NULL,
  comment text,
  status tinyint(1) default '0',
  last_post timestamp(14) NOT NULL,
  group_id text,
  active tinyint(3) unsigned NOT NULL default '0',
  password varchar(100) default NULL,
  password_raw varchar(255) NOT NULL default '',
  moderator int(11) default NULL,
  position smallint(6) default '0',
  moderated tinyint(1) NOT NULL default '0',
  moderated_posts tinyint(1) NOT NULL default '0',
  topic_emails text NOT NULL,
  post_emails text NOT NULL,
  PRIMARY KEY  (id),
  KEY title (title),
  FULLTEXT KEY title_2 (title)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='forum' AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_f_mods (
  forum_id int(11) NOT NULL default '0',
  user_id int(11) NOT NULL default '0'
) TYPE=MyISAM;##



CREATE TABLE koobi4_f_permissions (
  forum_id int(11) NOT NULL default '0',
  group_id int(11) NOT NULL default '0',
  permissions text NOT NULL,
  PRIMARY KEY  (forum_id,group_id)
) TYPE=MyISAM;##



CREATE TABLE koobi4_f_post (
  id bigint(20) unsigned NOT NULL auto_increment,
  title varchar(200) default NULL,
  topic_id smallint(6) NOT NULL default '0',
  datum datetime NOT NULL default '0000-00-00 00:00:00',
  uid smallint(6) NOT NULL default '0',
  use_bbcode tinyint(1) NOT NULL default '0',
  use_smilies tinyint(1) NOT NULL default '0',
  use_sig tinyint(1) NOT NULL default '0',
  message text NOT NULL,
  attachment tinytext,
  opened tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (id),
  KEY title (title),
  FULLTEXT KEY title_2 (title)
) TYPE=MyISAM PACK_KEYS=0 COMMENT='beitrag eines forum' AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_f_rating (
  topic_id int(11) NOT NULL default '0',
  rating text NOT NULL,
  ip text NOT NULL,
  uid text NOT NULL,
  PRIMARY KEY  (topic_id)
) TYPE=MyISAM;##


CREATE TABLE koobi4_f_topic (
  id int(11) NOT NULL auto_increment,
  title varchar(200) NOT NULL default '',
  status int(11) default '0',
  views int(11) NOT NULL default '0',
  rating text,
  forum_id int(11) NOT NULL default '0',
  icon smallint(5) unsigned default NULL,
  posticon smallint(5) unsigned default NULL,
  datum datetime NOT NULL default '0000-00-00 00:00:00',
  replies int(10) unsigned NOT NULL default '0',
  uid smallint(5) unsigned NOT NULL default '0',
  notification text NOT NULL,
  type tinyint(1) NOT NULL default '0',
  last_post timestamp(14) NOT NULL,
  last_post_id int(11) default NULL,
  opened tinyint(4) NOT NULL default '1',
  last_post_int int(14) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_faq (
  id int(10) unsigned NOT NULL auto_increment,
  parent_id int(10) unsigned NOT NULL default '0',
  faq varchar(255) NOT NULL default '',
  answer text NOT NULL,
  posi smallint(3) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  uid mediumint(5) unsigned NOT NULL default '1',
  active tinyint(1) NOT NULL default '1',
  area smallint(3) unsigned NOT NULL default '1',
  hits int(10) unsigned NOT NULL default '0',
  inline_screens text NOT NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_gallery (
  id int(10) unsigned NOT NULL auto_increment,
  parent_id int(10) unsigned NOT NULL default '0',
  area smallint(3) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  active tinyint(1) NOT NULL default '1',
  descr text NOT NULL,
  ctime int(10) unsigned NOT NULL default '0',
  posi smallint(3) unsigned NOT NULL default '0',
  uid mediumint(5) unsigned NOT NULL default '1',
  field_1 varchar(255) NOT NULL default '',
  field_2 varchar(255) NOT NULL default '',
  field_3 varchar(255) NOT NULL default '',
  field_1_text text NOT NULL,
  field_2_text text NOT NULL,
  field_3_text text NOT NULL,
  matchword varchar(255) NOT NULL default '',
  product mediumint(5) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_gallery_items (
  id int(10) unsigned NOT NULL auto_increment,
  gal_id int(10) unsigned NOT NULL default '0',
  path varchar(255) NOT NULL default '',
  name varchar(255) NOT NULL default '',
  author varchar(255) NOT NULL default '',
  vote int(10) unsigned NOT NULL default '0',
  descr text NOT NULL,
  ctime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_genres (
  id int(10) unsigned NOT NULL auto_increment,
  genre varchar(255) NOT NULL default '',
  area smallint(3) unsigned NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_ignore (
  uid mediumint(8) unsigned NOT NULL default '0',
  ignore_uid mediumint(8) unsigned NOT NULL default '0',
  reason varchar(75) NOT NULL default '',
  itime int(11) unsigned NOT NULL default '0',
  KEY uid (uid)
) TYPE=MyISAM;##



CREATE TABLE koobi4_linkcat (
  catid mediumint(5) unsigned NOT NULL auto_increment,
  parent_id mediumint(5) unsigned NOT NULL default '0',
  catname varchar(100) NOT NULL default '',
  catdesc text NOT NULL,
  area smallint(3) unsigned NOT NULL default '1',
  posi smallint(3) unsigned NOT NULL default '1',
  icon varchar(255) NOT NULL default '',
  group_id varchar(255) NOT NULL default '1,2,3',
  PRIMARY KEY  (catid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_linkcomments (
  id mediumint(6) unsigned NOT NULL auto_increment,
  dlid mediumint(6) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_links (
  id int(10) NOT NULL auto_increment,
  catid int(10) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text text NOT NULL,
  url tinytext NOT NULL,
  hits int(10) unsigned NOT NULL default '0',
  hits_today int(10) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  today int(11) NOT NULL default '0',
  votes mediumint(6) unsigned NOT NULL default '0',
  votes_data mediumint(6) unsigned NOT NULL default '0',
  votes_ip text NOT NULL,
  votes_uid text NOT NULL,
  canvote tinyint(1) NOT NULL default '0',
  cancomment tinyint(1) NOT NULL default '0',
  area smallint(3) NOT NULL default '1',
  uid int(10) unsigned NOT NULL default '1',
  active tinyint(1) NOT NULL default '1',
  image varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_manufacturer (
  id int(11) NOT NULL auto_increment,
  name varchar(255) default NULL,
  s_year int(8) default NULL,
  people int(11) NOT NULL default '0',
  hits int(11) NOT NULL default '0',
  full_name varchar(255) default NULL,
  s_country varchar(255) default NULL,
  url varchar(255) default NULL,
  email varchar(255) default NULL,
  adress text,
  descr text,
  icon varchar(255) NOT NULL default '',
  ctime int(10) unsigned NOT NULL default '1093604028',
  uid int(10) unsigned NOT NULL default '1',
  area smallint(3) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_navi (
  id int(10) unsigned NOT NULL auto_increment,
  parent_id int(10) unsigned default NULL,
  title varchar(200) NOT NULL default '',
  document tinytext NOT NULL,
  area smallint(3) unsigned NOT NULL default '1',
  openonclick tinyint(1) NOT NULL default '1',
  group_id tinytext NOT NULL,
  posi tinyint(3) unsigned default NULL,
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_news (
  newsid int(10) unsigned NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  shortintro varchar(255) NOT NULL default '',
  text text NOT NULL,
  textmore text NOT NULL,
  area_id smallint(3) unsigned NOT NULL default '1',
  newscat smallint(3) unsigned NOT NULL default '0',
  uid mediumint(8) unsigned NOT NULL default '0',
  ntime int(11) unsigned NOT NULL default '1',
  time_start int(11) unsigned NOT NULL default '1',
  time_end int(11) unsigned NOT NULL default '1',
  cansearch enum('yes','no') NOT NULL default 'yes',
  canvote enum('yes','no') NOT NULL default 'no',
  cancomment enum('yes','no') NOT NULL default 'yes',
  ispublic tinyint(1) NOT NULL default '1',
  isontop enum('yes','no') NOT NULL default 'no',
  end_top int(10) unsigned NOT NULL default '1',
  allareas enum('yes','no') NOT NULL default 'no',
  hits mediumint(8) unsigned NOT NULL default '0',
  printed mediumint(8) unsigned NOT NULL default '0',
  searchwords tinytext NOT NULL,
  image varchar(255) NOT NULL default '',
  image_top varchar(255) NOT NULL default '',
  image_align enum('left','right') NOT NULL default 'left',
  votes mediumint(6) unsigned NOT NULL default '0',
  votes_data mediumint(6) unsigned NOT NULL default '0',
  galids tinytext NOT NULL,
  newsids tinytext NOT NULL,
  inline_screens text NOT NULL,
  matchword tinytext NOT NULL,
  product mediumint(5) unsigned NOT NULL default '0',
  manufacturer mediumint(5) unsigned NOT NULL default '0',
  votes_ip text NOT NULL,
  votes_uid text NOT NULL,
  links tinytext NOT NULL,
  PRIMARY KEY  (newsid),
  KEY newscat (newscat),
  KEY newsid (newsid),
  KEY uid (uid),
  KEY ispublic (ispublic),
  KEY area_id (area_id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_newscat (
  catid mediumint(5) unsigned NOT NULL auto_increment,
  parent_id mediumint(5) unsigned NOT NULL default '0',
  catname varchar(100) default NULL,
  catdesc tinytext NOT NULL,
  area smallint(3) unsigned NOT NULL default '1',
  posi smallint(3) unsigned NOT NULL default '1',
  icon varchar(255) NOT NULL default '',
  PRIMARY KEY  (catid),
  KEY area (area),
  KEY catid (catid),
  KEY catname (catname)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_newscomments (
  id mediumint(6) unsigned NOT NULL auto_increment,
  id_parent mediumint(6) unsigned NOT NULL default '0',
  newsid mediumint(6) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_newsletter (
  id mediumint(5) NOT NULL auto_increment,
  name varchar(255) NOT NULL default '',
  area smallint(3) unsigned NOT NULL default '1',
  posi smallint(2) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_newsletter_abos (
  id int(11) NOT NULL auto_increment,
  newsletter mediumint(6) unsigned NOT NULL default '0',
  name varchar(255) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  ctime int(10) unsigned NOT NULL default '0',
  format enum('text','html') NOT NULL default 'text',
  securecode varchar(20) NOT NULL default '',
  active tinyint(1) NOT NULL default '0',
  area smallint(3) unsigned NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_newsletter_archiv (
  id int(10) unsigned NOT NULL auto_increment,
  ctime int(10) unsigned NOT NULL default '0',
  type enum('groups','abos') NOT NULL default 'abos',
  title varchar(255) NOT NULL default '',
  htmlv text NOT NULL,
  textv text NOT NULL,
  absmail varchar(255) NOT NULL default '',
  absname varchar(255) NOT NULL default '',
  author int(10) unsigned NOT NULL default '0',
  attachments text NOT NULL,
  groups varchar(255) NOT NULL default '',
  area smallint(3) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_permissions (
  group_id int(11) NOT NULL default '0',
  section_id int(11) NOT NULL default '0',
  permissions text NOT NULL,
  PRIMARY KEY  (group_id,section_id)
) TYPE=MyISAM PACK_KEYS=0;##


CREATE TABLE koobi4_platform (
  id int(10) unsigned NOT NULL auto_increment,
  platform varchar(255) NOT NULL default '',
  area smallint(3) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_pn (
  pnid int(11) unsigned NOT NULL auto_increment,
  to_uid mediumint(8) unsigned default NULL,
  from_uid mediumint(8) unsigned default NULL,
  topic varchar(255) default NULL,
  message text,
  is_readed enum('yes','no') default NULL,
  pntime int(11) default '0',
  typ enum('inbox','outbox') default 'inbox',
  smilies enum('yes','no') NOT NULL default 'yes',
  parseurl enum('yes','no') NOT NULL default 'no',
  reply enum('yes','no') NOT NULL default 'no',
  forward enum('yes','no') NOT NULL default 'no',
  PRIMARY KEY  (pnid),
  KEY id (pnid)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_poll (
  id int(10) unsigned NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  area_id int(11) NOT NULL default '0',
  active tinyint(1) NOT NULL default '0',
  group_id tinytext,
  ip text NOT NULL,
  uid text NOT NULL,
  can_comment tinyint(4) default '0',
  place_id tinyint(4) NOT NULL default '0',
  start int(10) unsigned NOT NULL default '0',
  end int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY title (title),
  FULLTEXT KEY title_2 (title)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_poll_item (
  id int(10) unsigned NOT NULL auto_increment,
  poll_id int(10) unsigned NOT NULL default '0',
  title tinytext NOT NULL,
  hits int(10) unsigned NOT NULL default '0',
  color varchar(10) NOT NULL default '',
  posi smallint(2) unsigned NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_pollcomments (
  id mediumint(6) unsigned NOT NULL auto_increment,
  pollid mediumint(6) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_posticons (
  id int(11) NOT NULL auto_increment,
  posi mediumint(5) NOT NULL default '1',
  active tinyint(1) NOT NULL default '1',
  path varchar(55) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=19 ;##



CREATE TABLE koobi4_products (
  id int(11) unsigned NOT NULL auto_increment,
  title varchar(255) default NULL,
  genre mediumint(5) unsigned default NULL,
  publisher mediumint(5) unsigned default NULL,
  manufacturer mediumint(5) unsigned default NULL,
  voting smallint(3) unsigned default NULL,
  descr text,
  subtitle varchar(255) NOT NULL default '',
  asin varchar(255) NOT NULL default '',
  platform varchar(100) default NULL,
  release varchar(50) default NULL,
  price varchar(255) NOT NULL default '',
  shopurl varchar(255) default NULL,
  shop varchar(255) default NULL,
  boxshot varchar(255) default NULL,
  links text,
  gallery varchar(100) default NULL,
  inline_screens text NOT NULL,
  uid mediumint(5) unsigned NOT NULL default '1',
  ctime int(10) unsigned NOT NULL default '1093884725',
  hits int(10) unsigned NOT NULL default '0',
  area smallint(3) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_referer (
  id int(11) NOT NULL auto_increment,
  user_os varchar(20) default NULL,
  user_ua varchar(20) default NULL,
  user_referer varchar(255) default NULL,
  datum datetime default '0000-00-00 00:00:00',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_securecode (
  id int(10) unsigned NOT NULL auto_increment,
  code varchar(10) NOT NULL default '',
  ctime int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_sessions (
  sesskey varchar(32) NOT NULL default '',
  expiry int(10) unsigned NOT NULL default '0',
  value text NOT NULL,
  PRIMARY KEY  (sesskey)
) TYPE=MyISAM;##



CREATE TABLE koobi4_settings (
  id int(11) NOT NULL auto_increment,
  company_name varchar(255) NOT NULL default '',
  company_website varchar(255) NOT NULL default '',
  company_street varchar(255) NOT NULL default '',
  company_city varchar(255) NOT NULL default '',
  company_zip varchar(20) NOT NULL default '',
  company_country varchar(25) NOT NULL default '',
  company_email varchar(255) NOT NULL default '',
  company_email_support varchar(255) NOT NULL default '',
  company_email_siteadmin varchar(255) NOT NULL default '',
  company_email_reply varchar(255) NOT NULL default '',
  company_phone varchar(255) NOT NULL default '',
  company_fax varchar(255) NOT NULL default '',
  company_mobile varchar(255) NOT NULL default '',
  company_owner varchar(255) NOT NULL default '',
  company_impressum text NOT NULL,
  company_agb text NOT NULL,
  lang char(2) NOT NULL default 'zh',
  langadmin char(2) NOT NULL default 'zh',
  tformat varchar(15) NOT NULL default 'd.m.Y',
  tformat_h varchar(15) NOT NULL default 'H:i',
  bbcodesite tinyint(1) unsigned NOT NULL default '1',
  bbcodecomments tinyint(1) NOT NULL default '1',
  imgcode tinyint(1) unsigned NOT NULL default '1',
  smilies tinyint(3) unsigned NOT NULL default '1',
  bannednames text NOT NULL,
  bannedemails text NOT NULL,
  regtype enum('norm','now','admin') NOT NULL default 'norm',
  mailbyregister tinyint(1) unsigned NOT NULL default '1',
  smileycomments tinyint(1) unsigned NOT NULL default '1',
  commentnews tinyint(1) unsigned NOT NULL default '1',
  maxlines smallint(3) unsigned NOT NULL default '50',
  boxwidthcomm varchar(10) NOT NULL default '100%',
  boxwidthforums varchar(10) NOT NULL default '100%',
  galwidth smallint(4) unsigned NOT NULL default '120',
  galheight smallint(4) unsigned NOT NULL default '110',
  nofactor tinyint(1) unsigned NOT NULL default '0',
  thumbcomp smallint(3) unsigned NOT NULL default '90',
  picspp smallint(3) unsigned NOT NULL default '12',
  picspr smallint(3) unsigned NOT NULL default '4',
  smiliebr smallint(3) unsigned NOT NULL default '4',
  admintheme varchar(25) NOT NULL default 'original',
  badwords text NOT NULL,
  badwords_replace varchar(75) NOT NULL default '!#*$&?',
  imagewatermark tinyint(1) unsigned NOT NULL default '1',
  watermark varchar(255) NOT NULL default 'uploads/galerie/watermark.png',
  watermarktrans smallint(3) unsigned NOT NULL default '100',
  spamprotect tinyint(1) NOT NULL default '1',
  spamprotect_time smallint(4) unsigned NOT NULL default '3',
  mygmt varchar(5) NOT NULL default '1',
  mailbycomment tinyint(1) NOT NULL default '0',
  maxlengthword mediumint(3) NOT NULL default '150',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=2 ;##



CREATE TABLE koobi4_sitestats (
  datum varchar(12) default NULL,
  hits int(10) unsigned default '0',
  visits int(10) unsigned default '0',
  tag smallint(2) unsigned default '0',
  monat smallint(2) unsigned default '0',
  jahr smallint(4) unsigned default '0'
) TYPE=MyISAM;##



CREATE TABLE koobi4_smileys (
  id int(11) NOT NULL auto_increment,
  posi mediumint(5) NOT NULL default '1',
  active tinyint(1) NOT NULL default '1',
  code varchar(15) NOT NULL default '',
  path varchar(55) NOT NULL default '',
  area smallint(2) NOT NULL default '1',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=37 ;##


CREATE TABLE koobi4_speedbar (
  id int(10) unsigned NOT NULL auto_increment,
  section smallint(3) unsigned NOT NULL default '0',
  posi int(10) unsigned NOT NULL default '0',
  slink varchar(255) NOT NULL default '',
  linkname varchar(255) NOT NULL default '',
  aktiv enum('Y','N') NOT NULL default 'Y',
  target varchar(10) NOT NULL default '_self',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##



CREATE TABLE koobi4_static (
  id int(10) unsigned NOT NULL auto_increment,
  categ smallint(3) unsigned NOT NULL default '1',
  title varchar(255) NOT NULL default '',
  content text NOT NULL,
  pagename varchar(255) NOT NULL default '',
  area smallint(3) unsigned NOT NULL default '1',
  uid int(10) unsigned NOT NULL default '0',
  ctime int(11) NOT NULL default '0',
  hits int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=6 ;##



CREATE TABLE koobi4_static_categ (
 id SMALLINT( 3 ) NOT NULL AUTO_INCREMENT ,
 name VARCHAR( 255 ) NOT NULL ,
 PRIMARY KEY (id)
) TYPE=MyISAM ;##



CREATE TABLE koobi4_user (
  uid mediumint(8) unsigned NOT NULL auto_increment,
  ugroup smallint(3) unsigned NOT NULL default '0',
  name varchar(65) NOT NULL default '',
  uname varchar(25) NOT NULL default '',
  email varchar(65) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  user_avatar_pref varchar(255) NOT NULL default '',
  user_regdate int(11) unsigned NOT NULL default '0',
  user_icq varchar(15) NOT NULL default '',
  user_aim varchar(25) NOT NULL default '',
  user_yim varchar(25) NOT NULL default '',
  user_msnm varchar(100) NOT NULL default '',
  user_sig text NOT NULL,
  user_from varchar(75) NOT NULL default '',
  user_interests text NOT NULL,
  user_birthday varchar(10) NOT NULL default '',
  pass varchar(35) NOT NULL default '',
  passtemp varchar(35) NOT NULL default '',
  posts mediumint(8) unsigned NOT NULL default '0',
  theme varchar(75) NOT NULL default '',
  last_login int(11) unsigned NOT NULL default '0',
  user_viewemail enum('yes','no') NOT NULL default 'yes',
  user_canpn enum('yes','no') NOT NULL default 'yes',
  invisible enum('yes','no') NOT NULL default 'no',
  pntomail enum('yes','no') NOT NULL default 'yes',
  status tinyint(1) unsigned NOT NULL default '1',
  user_lastonline int(11) unsigned default NULL,
  user_lastonline_temp int(11) unsigned default NULL,
  user_posts mediumint(8) unsigned NOT NULL default '0',
  user_lastpost int(10) unsigned default NULL,
  tformat varchar(20) NOT NULL default 'Y-m-d',
  tformat_h varchar(20) NOT NULL default ' ,H:i',
  gender enum('male','female','no') NOT NULL default 'no',
  mygmt varchar(5) NOT NULL default '1',
  recieve_newsletter tinyint(1) NOT NULL default '1',
  usedefault_avatar smallint(1) NOT NULL default '1',
  user_avatar varchar(255) NOT NULL default '',
  country char(2) NOT NULL default 'ZH',
  group_id_misc tinytext NOT NULL,
  person enum('private','company') NOT NULL default 'private',
  phone varchar(255) NOT NULL default '',
  phone_mobile varchar(255) NOT NULL default '',
  fax varchar(255) NOT NULL default '',
  lastname varchar(255) NOT NULL default '',
  zip varchar(255) NOT NULL default '',
  street varchar(255) NOT NULL default '',
  title varchar(20) NOT NULL default '',
  PRIMARY KEY  (uid),
  KEY uid (uid),
  KEY user_lastonline (user_lastonline),
  KEY user_lastonline_temp (user_lastonline_temp)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##


CREATE TABLE koobi4_usergroup (
  ugroup mediumint(8) unsigned NOT NULL auto_increment,
  groupname_single varchar(75) NOT NULL default '',
  groupname varchar(100) NOT NULL default '',
  groupmaxpn mediumint(6) unsigned NOT NULL default '50',
  groupmaxsig mediumint(6) unsigned NOT NULL default '100',
  maxpnlength mediumint(6) unsigned NOT NULL default '1000',
  maxcommlength mediumint(6) unsigned NOT NULL default '500',
  maxpicdownload smallint(3) unsigned NOT NULL default '5',
  avatar_size int(10) unsigned NOT NULL default '15360',
  avatar_width int(11) NOT NULL default '120',
  avatar_height int(11) NOT NULL default '100',
  default_avatar varchar(255) NOT NULL default '',
  set_default_avatar tinyint(1) NOT NULL default '0',
  maxlength_post int(11) NOT NULL default '50000',
  max_attachments int(11) NOT NULL default '5',
  PRIMARY KEY  (ugroup),
  KEY groupid (ugroup)
) TYPE=MyISAM PACK_KEYS=0 AUTO_INCREMENT=5 ;##



CREATE TABLE koobi4_useronline (
  ip varchar(25) NOT NULL default '0',
  uid int(10) unsigned NOT NULL default '0',
  expire int(11) NOT NULL default '0',
  uname varchar(255) NOT NULL default '',
  invisible varchar(10) NOT NULL default ''
) TYPE=MyISAM;##


CREATE TABLE koobi4_languages (
  code char(2) NOT NULL default 'zh',
  name varchar(128) NOT NULL default '',
  value text NOT NULL,
  value_original text NOT NULL,
  original tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (code,name)
) TYPE=MyISAM ;##


CREATE TABLE koobi4_languages_admin (
  code char(2) NOT NULL default 'zh',
  name varchar(128) NOT NULL default '',
  value text NOT NULL,
  value_original text NOT NULL,
  original tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (code,name)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_downloadcat_restricted (
  id int(11) NOT NULL auto_increment,
  uid int(11) NOT NULL default '0',
  catid int(10) unsigned NOT NULL default '0',
  time_till int(11) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM AUTO_INCREMENT=1 ;##

CREATE TABLE koobi4_userfields (
  id smallint(3) unsigned NOT NULL auto_increment,
  page enum('register','details') NOT NULL default 'register',
  fieldname varchar(25) NOT NULL default '',
  required enum('yes','no') NOT NULL default 'yes',
  active enum('yes','no') NOT NULL default 'yes',
  editable tinyint(1) unsigned NOT NULL default '1',
  posi smallint(3) NOT NULL default '0',
  type enum('norm','other','misc') NOT NULL default 'norm',
  extra_error text NOT NULL,
  default_val varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_f_rank (
  id int(10) unsigned NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  count int(11) NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_guestbook (
  id int(11) NOT NULL auto_increment,
  ctime int(11) NOT NULL default '0',
  author varchar(255) NOT NULL default '',
  comment text NOT NULL,
  email varchar(255) NOT NULL default '',
  web varchar(255) NOT NULL default '',
  ip varchar(255) NOT NULL default '',
  authfrom varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;##


CREATE TABLE koobi4_guestbook_settings (
 id int(11) NOT NULL auto_increment,
 spamprotect TINYINT( 1 ) DEFAULT '1' NOT NULL ,
 spamprotect_time MEDIUMINT( 5 ) DEFAULT '1' NOT NULL ,
 mailbycomment TINYINT( 1 ) DEFAULT '1' NOT NULL ,
 maxpostlength MEDIUMINT( 5 ) DEFAULT '1000' NOT NULL,
 PRIMARY KEY  (id)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_calendar (
  id int(4) unsigned NOT NULL auto_increment,
  uid int(10) unsigned NOT NULL default '0',
  datum varchar(10) NOT NULL default '',
  name varchar(255) NOT NULL default '',
  descr text NOT NULL,
  start int(15) unsigned NOT NULL default '0',
  ende int(15) unsigned NOT NULL default '0',
  type enum('public','private') NOT NULL default 'public',
  weight tinyint(1) unsigned NOT NULL default '3',
  wd tinyint(1) unsigned NOT NULL default '0',
  tdays int(15) unsigned NOT NULL default '0',
  done tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;##

CREATE TABLE koobi4_gallerycomments (
  id int(10) unsigned NOT NULL auto_increment,
  imgid int(10) unsigned NOT NULL default '0',
  ctime int(10) unsigned NOT NULL default '0',
  autor mediumint(6) unsigned NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  comment text NOT NULL,
  ip varchar(20) NOT NULL default '',
  PRIMARY KEY  (id)
) TYPE=MyISAM ;##


CREATE TABLE koobi4_banner (
  id mediumint(5) unsigned NOT NULL auto_increment,
  area mediumint(5) unsigned NOT NULL default '1',
  name varchar(255) NOT NULL default '',
  code text NOT NULL,
  active tinyint(1) unsigned NOT NULL default '1',
  weight int(10) unsigned NOT NULL default '1',
  views int(14) unsigned NOT NULL default '0',
  PRIMARY KEY  (id)
) TYPE=MyISAM;##


