<?php
// ======================================================================== //
//   KOOBI - CMS                                                            //
//   SCRiPTMAFiA 2005 - THE DiRTY HANDS ON YOUR SCRiPTS                     //
//                                                                          //
//   DREAM4 - AM MICHELSGRUND 7 - 69469 WEINHEIM - GERMANY                  //    
//   TEL. +49(0) 6201 - 980442 / FAX. +49(0) 6201 - 64809                   //
// ======================================================================== //
if(!checkactive('forums')) include(dirname(__FILE__)."/lib/notactive.php" );
$sname = simpletitle($lang['forums']);

$browser_title = "";

// parent_id = 0 bedeutet, dass es keine uebergeordnete foren gibt dem
// die kategorie angehoert
if ($_GET["cid"] == "") {
	$navigation = getNavigation(0, "category", null);
	$cat_query = "SELECT id, title, position, comment, parent_id, group_id FROM " . PREFIX . "_f_category WHERE parent_id = 0 ORDER BY position";
	} else {
	$navigation = getNavigation($_GET["cid"], "category", null);
	$cat_query = "SELECT id, title, position, comment, parent_id, group_id FROM " . PREFIX . "_f_category WHERE id = " . $_GET["cid"];
	
}

$categories = new dbc($cat_query); 

// enthaellt zur jeder kategorie ein array der dazugehoerigen foren
$forums_array = array();
$category_array = array();

// alle kategorien durchgehen
while ($category = $categories->fetchrow_assoc()) {
	
	$group_ids = array();
	include( BASEDIR . "/system/misc_ids.php");
	
	// gruppen, die zugriff auf die kategorie haben
	$groups = @explode(",", $category['group_id']);
	
	if (array_intersect($group_ids, $groups)) {
		// wenn eine spezielle kategorie angezeigt wird
		// soll der navigationspfad um diese erweitert werden
		if ($_GET["cid"] != "") $navigation .= SEPARATOR . $category["title"];
		
		// den status der anzeige aus dem cookie holen
		$position = strpos($_COOKIE["categories"], "id" . $category["id"]);
		if ( is_numeric($position) ) {
			$category["display"] = "none";
			$category["image"] = "plus.gif";
		}
		
		$category["link"] = "index.php?p=showforums&amp;cid=" . $category["id"];
		$category["newforumlink"] = "index.php?p=newforum&amp;cid=" . $category["id"];
		$category["moveuplink"] = "index.php?p=movecat&amp;param=up&amp;cid=" . $category["id"] . "&amp;pid=0";
		$category["movedownlink"] = "index.php?p=movecat&amp;param=down&amp;cid=" . $category["id"] . "&amp;pid=0";
		$category["movelink"] = "index.php?p=move&amp;item=c&amp;id=" . $category["id"];
		$category["delcategorylink"] = "index.php?p=delcategory&amp;cid=" . $category["id"] . "&amp;pid=0";
		
		array_push($category_array, $category);
		
		$forum_query = "
		SELECT 
			f.id, 
			f.title, 
			f.comment, 
			f.status,
			f.position
		FROM 
			" . PREFIX . "_f_forum AS f
		WHERE 
			f.category_id = " . $category["id"] . " AND
			f.active = 1
		ORDER BY
			f.position
		";
		
		// alle foren der jeweiligen kategorie
		$foren = new dbc($forum_query);
		
		// alle foren zur kategorie holen
		$forums_array[$category["title"]] = array();
		
		while ($forum = $foren->fetchrow_assoc()) {
			// rechte fuer das forum
			$permissions = getForumPermissionsByUser($forum['id'], UID);
			 if ($permissions[FORUM_PERMISSION_CAN_SEE] == 1) {
				// --------- Anzahl der Themen und Beitrge ermittln ----------
				$pcount = 0;
				// kann die topics anderer sehen?
				$show_only_own_topics = "";
				if ($permissions[FORUM_PERMISSION_CAN_SEE_TOPIC] == 0) {
					$show_only_own_topics = " AND uid = " . UID;
				}
				
				// wenn user nicht mod dieses forum ist und kein admin ist, 
				// nicht freigeschaltete themen verbergen
				if(!is_mod($forum['id'])) { 
					$q_tcount_extra .= " AND opened = 1 ";
				}
				
				$q_tcount = "
				SELECT 
					id 
				FROM 
					" . PREFIX . "_f_topic 
				WHERE 
					forum_id = " . $forum["id"] . "
					$q_tcount_extra 
					$show_only_own_topics 
				";				
				
				$r_tcount = new dbc($q_tcount);
				$forum["tcount"] = $r_tcount->numrows();
				
				$ids = "";
				
				while ($tid = $r_tcount->fetchrow()) {
					if ($ids == "") {
						$ids .= $tid->id;
					} else {
						$ids .= " OR topic_id = " . $tid->id;
					} 
				}
				
				$last_post = "";
				
				if ($ids != "") {
					$q_pcount = "
					SELECT 
					id
					FROM 
					" . PREFIX . "_f_post 
					WHERE 
					topic_id = $ids 
					";
					
					$r_pcount = new dbc($q_pcount);
					$pcount = $r_pcount->numrows();
					
					// letzter beitrag
					
					$q_last_post = "
						SELECT DISTINCT
							p.id,
							p.uid,
							p.topic_id,
							p.datum,
							t.title,
							x.user_regdate
						FROM
							" . PREFIX . "_f_post AS p,
							" . PREFIX . "_f_topic AS t,
							" . PREFIX . "_user AS x
						WHERE
							(p.topic_id = $ids) AND
							t.id = p.topic_id AND
							x.uid = p.uid 
						GROUP BY
							p.id
						ORDER BY
							p.datum DESC
						LIMIT 1
					";

					$r_last_post = new dbc($q_last_post);
					$last_post = $r_last_post->fetchrow();
					
					$query = "SELECT COUNT(id) AS replies FROM " . PREFIX . "_f_post WHERE topic_id = '" . $last_post->topic_id . "'";
					$result = new dbc($query);
					$topic = $result->fetchrow();
					
					$last_post->page = getPageNum($topic->replies, 15);

					$forum['last_post'] = $last_post;
					
				}
				
				$forum['pcount'] = $pcount;
				// /--------- Anzahl der Themen und Beitrge ermitteln ----------
				
				$forum["comment"] = oform($forum["comment"]);
				$forum["link"] = "index.php?p=showforum&amp;fid=" . $forum["id"];
				
				// ==============================================================
				// <<-- Forumicon -->>
				// ==============================================================
				
				if ($islogged == 0) {
					$forum["statusicon"] = getIcon("forum_old_lock.gif", "forum");
				} else {
					@setForumIcon($forum);
				}
				
				// ==============================================================
				
				// alle unterkategorien
				$subcat_query = "SELECT id FROM " . PREFIX . "_f_category WHERE parent_id = '$forum[id]'";
				$subcategories = new dbc($subcat_query);
				
				
				// array fuer die subforen
				$subforums_array = array();
				
				// alle unterkategorien durchgehen
				while ($subcategory = $subcategories->fetchrow()) {
				
					// alle foren zu der unterkategorie
					// FIND_IN_SET('" . UGROUP . "', group_id) AS group_found,
					$subforums_query = "
					SELECT 
					  group_id,
					  id, 
					  title 
					FROM 
					  " . PREFIX . "_f_forum 
					WHERE 
					  category_id = '" . $subcategory->id . "' AND 
					active = 1";
					
					
					$subforums_result =& new dbc($subforums_query);
					
					// alle foren in das subforum array schieben
					while ($subforum = $subforums_result->fetchrow_assoc()) {
						//if ($subforum['group_found'] > 0) {
							if ($subforum['group_found'] != "no") {	
								$subforum['link'] = "index.php?p=showforum&amp;fid=" . $subforum["id"];
								array_push($subforums_array, $subforum);
							}
						}
					}
					
					$forum["subforums"] = $subforums_array;
					
					array_push($forums_array[$category["title"]], $forum);
				}
			} // while forums
		} // if in_array(group, groups)
	}
	
	$stitle = $lang["forumtitle"];
	$sname = simpletitle(str_replace($lang['f_navi_separator'], " - ", strip_tags($navigation)));
	
	$tmpl->register_function("get_status_icon", "getStatusIcon");
	
	$tmpl->assign("uid", UID);
	$tmpl->assign("navigation", $navigation);
	$tmpl->assign("f_id", 0);
	$tmpl->assign("newcatlink", $newcatlink);
	$tmpl->assign("allowed", $allowed);
	$tmpl->assign("lang", $lang);
	$tmpl->assign("categories", $category_array);
	$tmpl->assign("forums", $forums_array);
	$tmpl->assign("content", parsetrue("container/".container("forum"), $stitle, $tmpl->fetch("forums/showforums.tpl")));
?>