﻿#target photoshop

// converts bitmap font atlas to set of layers, one layer per glyph
// this script helps to convert bitmap atlas to the set of layers that can be used 
// with layers2ramp script for L3tt3rM4pp3r After Effects plugin

// usage: script is applied to active document, so with your atlas opened in Photoshop, run this script, 
// enter rows/colunms amount and be patient for a little while



function lm_atlas2layers()
{
	var inWidth = prompt("How many columns?", "8","Please, enter integer number");
	var inHeight = prompt("How many rows?", "8", "Please, enter integer number");

    if (inWidth != null) var awidth=Math.round(inWidth);
    if (inHeight != null) var aheight=Math.round(inHeight);

    var sourceDoc=app.activeDocument;

    var targetDocName=sourceDoc.name+"_sliced";

    glyphW=Number(sourceDoc.width/awidth);
    glyphH=Number(sourceDoc.height/aheight);
    
    var targetDoc=app.documents.add(UnitValue(Number(glyphW), "px"), UnitValue(Number(glyphH), "px"),72,targetDocName,NewDocumentMode.RGB);
    targetDoc.mode=RGBColor;

    for (i=0;i<awidth;i++)
    {
        for(j=0;j<aheight;j++)
        {
                app.activeDocument=sourceDoc;
                sel=sourceDoc.selection.select([
                [i*glyphW*1, j*glyphH*1], 
                [i*glyphW*1, j*glyphH*1+glyphH*1], 
                [i*glyphW*1+glyphW, j*glyphH*1+glyphH*1],
                [i*glyphW*1+glyphW*1,j*glyphH*1]
                ], SelectionType.REPLACE, 0, false);
                sourceDoc.selection.copy(false);       
                app.activeDocument=targetDoc;
                
                var targetLayer= app.activeDocument.artLayers.add();
                targetLayer.name = "["+i+"]"+"["+j+"]";
                targetLayer.blendMode = BlendMode.NORMAL;
                targetDoc.paste (false);           
            
        }
        
    }
    
}
lm_atlas2layers();