﻿#target photoshop

//this script helps to convert BMF raster font to symbol map for L3tt3rM4pp3r After Effects plugin
//usage: convert any TTF/OTF font to BMF using Bitmap font generator tool (http://www.angelcode.com/products/bmfont/) 
//be sure you've set font descriptor to XML and texture format to PNG in tool's export options
//run the script and open the BMF file
//the script will analyze glyph data and create new symbol map - 
//PSD file with symbols placed from left to right, sorted by overall symbol area
//you can then edit it and merge all layers/save when ready

 
function getAverageColor(doc,x,y,inWidth,inHeight){
//Usage: averageColor=getAverageColor([ColorPicker],[Area]);    
    
    app.preferences.rulerUnits = Units.PIXELS;
    
    for (var i=0; i<doc.colorSamplers.length; i++) {
        doc.colorSamplers[i].remove();
    }
    var CP = doc.colorSamplers.add([x*1+inWidth*0.5, y*1+inHeight*0.5]);
    
    
    

    sel=doc.selection.select([[x*1, y*1], [x*1,y*1+inHeight*1], [x*1+inWidth*1, y*1+inHeight*1],[x*1+inWidth*1,y*1]], SelectionType.REPLACE, 0, false);
    //doc.selection.select([[0, 0], [10,     0], [10,            10],[0,10]], SelectionType.REPLACE, 0, false);
    doc.activeLayer.applyAverage();
    var sColor = new SolidColor();
    sColor=CP.color;
    executeAction( charIDToTypeID('undo'), undefined, DialogModes.NO );
    doc.selection.deselect();
    
    //alert(sColor.rgb.red);

    return sColor;
}

function calcDensity (doc,x,y,width,height)
{
    //var sampler = doc.colorSamplers.add([0, 0]);
    
    var density=0;
    var m_color=getAverageColor(doc,x,y,width,height)
    /*
        for(i=0;i<width;i++)
    {
        for(j=0;j<height;j++)
        {
            
            var m_color=sampler.color;
            density=(m_color.rgb.red+m_color.rgb.blue+m_color.rgb.green)/3;
            //density+=getColorAt (doc, x+i, y+j)
        }
    }
    */
    density=(m_color.rgb.red*1+m_color.rgb.blue*1+m_color.rgb.green*1)/3.0;    
    //alert ('color:'+m_color.rgb.red);
    return Number(m_color.rgb.red); 
}


function sortGlyphs(a, b){

  if(a.density<b.density)
     return -1 
  if(a.density>b.density)
     return 1  
  return 0
}



function lm_bmf2ramp()
{

    var fontFile = File.openDialog("Choose A BMFONT XML File","XML:*.fnt");
    if (!fontFile)
    {
        alert("Could not open file.");
        return;
    }

    fontFile.encoding = "UTF8";
    fontFile.lineFeed = "unix";
    fontFile.open("r");
    fontFile.open("r");

    var xmlString = fontFile.read();
    var myXML = new XML(xmlString);

    if(myXML.xpath ('//page[@id]').length()>1)
    {
       alert ('Found '+myXML.xpath('//page[@id]').length()+' bitmaps. Only fonts with 1 source bitmap are supported'); 
       return;
       
    }
    
    var sourceBitmapFile=File(fontFile.path+'/'+myXML.xpath('//page').attribute('file'));
    if (!sourceBitmapFile.exists)
    {
        alert('cant find source bimap file');
        return;
    }
    var sourceDoc=app.open(sourceBitmapFile);
    sourceDoc.mode=RGBColor;
    
    ///////////Calculate common bigger size of glyph and target document size->
    var g_TargetDocWidth=0;
    var g_TargetDocHeight=0;
    var g_TargetGlyphWidth=0;
    var g_TargetGlyphHeight=0;
    for (i=0;i<myXML.xpath('//char[@id]').length();i++)
    {
        var m_W=myXML.xpath ('//char[@id]')[i].attribute('width').toString();
        var m_H=myXML.xpath ('//char[@id]')[i].attribute('height').toString();
        
        if(Number(m_W)>Number(g_TargetGlyphWidth)) g_TargetGlyphWidth=m_W;
        if(Number(m_H)>Number(g_TargetGlyphHeight)) g_TargetGlyphHeight=m_H;
    }
    g_TargetDocWidth=myXML.xpath('//char[@id]').length()*g_TargetGlyphWidth;
    g_TargetDocHeight=g_TargetGlyphHeight;
    ////////////
    
    
    var glyphs=[];
    for (i=0;i<myXML.xpath('//char[@id]').length();i++)
    {
       
       var m_id=(myXML.xpath ('//char[@id]')[i].attribute('id').toXMLString());
       var m_x=(myXML.xpath ('//char[@id]')[i].attribute('x').toXMLString());
       var m_y=(myXML.xpath ('//char[@id]')[i].attribute('y').toXMLString());
       var m_width=(myXML.xpath ('//char[@id]')[i].attribute('width').toXMLString());
       var m_height=(myXML.xpath ('//char[@id]')[i].attribute('height').toXMLString());       
       var m_density=calcDensity(sourceDoc,m_x,m_y,m_width,m_height)
       m_density=m_density*m_width*m_height/g_TargetGlyphWidth/g_TargetGlyphHeight;
       var glyph={id:m_id, density:Number(m_density), x:Number(m_x), y:Number(m_y), width:Number(m_width), height:Number(m_height)};
       glyphs.push(glyph);                
    }
    
    
    
    
    
    targetDoc=app.documents.add(UnitValue(Number(g_TargetDocWidth), "px"), UnitValue(Number(g_TargetDocHeight), "px"),72,'colormap_'+glyphs.length,NewDocumentMode.RGB);
    glyphs=glyphs.sort(sortGlyphs);
    
    app.activeDocument=targetDoc;
    var o=Number(0);
    var targetLayer= app.activeDocument.artLayers.add();
        targetLayer.name = "TargetLayer";
        targetLayer.blendMode = BlendMode.NORMAL;
        
    for (i=0;i<glyphs.length;i++)
    {
        
        app.activeDocument = sourceDoc;
        var sel=sourceDoc.selection.select([
        [glyphs[i].x*1,                     glyphs[i].y*1                   ], 
        [glyphs[i].x*1,                     glyphs[i].y*1+glyphs[i].height*1], 
        [glyphs[i].x*1+glyphs[i].width*1,   glyphs[i].y*1+glyphs[i].height*1],
        [glyphs[i].x*1+glyphs[i].width*1,   glyphs[i].y*1                   ]
        ], SelectionType.REPLACE, 0, false);
        app.activeDocument.selection.copy();
        app.activeDocument = targetDoc;
        
        
        var xoffset=((g_TargetGlyphWidth*1-glyphs[i].width*1)*0.5);
        
        sel=targetDoc.selection.select(
        [ 
        [o*1+xoffset*1                  , 0], 
        [o*1+xoffset*1,                   glyphs[i].height*1], 
        [o*1+g_TargetGlyphWidth*1-xoffset*1, glyphs[i].height*1],
        [o*1+g_TargetGlyphWidth*1-xoffset*1, 0]
        ], SelectionType.REPLACE, 0, false);
        targetDoc.paste (true);
        o+=g_TargetGlyphWidth*1;
        
    }

    fontFile.close();
}
 

lm_bmf2ramp();