-- Author: Ekibunnel

function SwapCostume()
	local ItemInfoObject = FindObject(nil, nil, "/Game/ContentInfo/InfoAsset/ItemInfo.ItemInfo", false)
	local ContentInfoDBObject = ItemInfoObject["ContentInfoDB"]
	
	ContentInfoDBObject:ForEachProperty(function(Property)
		if Property:IsA(PropertyTypes.ArrayProperty) then
			local PropertyName = Property:GetFName():ToString()
			local PropertyObject = ContentInfoDBObject[PropertyName]
			if PropertyObject:GetArrayNum() > 1 and PropertyName == "_ItemCommon_array" then
				PropertyObject:ForEach(function(index, elem)
					local element = elem:get()
					if element["_code_name"]:ToString() == "Costume_01" then
						element:ForEachProperty(function(Property2)
							if Property2:GetFName():ToString() ~= "_code_name" then
								if Property2:IsA(PropertyTypes.NameProperty) or Property2:IsA(PropertyTypes.StrProperty) then
									local Property2Object = element[Property2:GetFName():ToString()]
									local Property2ObjectValue = Property2Object:ToString()
									if string.find(Property2ObjectValue, "Costume_01") ~= nil then
										if Property2:IsA(PropertyTypes.NameProperty) then
											element[Property2:GetFName():ToString()] = FName(string.gsub(Property2ObjectValue, "Costume_01", "Costume_02"))
										elseif Property2:IsA(PropertyTypes.StrProperty) then
											element[Property2:GetFName():ToString()] = string.gsub(Property2ObjectValue, "Costume_01", "Costume_02")
										end
									end
								end
							end
						end)
					end
				end)
			end
		end
	end)
end

RegisterHook("/Script/Engine.PlayerController:ClientRestart", function(Context, NewPawn)
	SwapCostume()
	print("[LiesofP CostumeSwap] Costume swaped\n")
end)