#if DXCommon
public static class AssemblyInfo {
#else
namespace DevExpress.Internal {
	internal static class AssemblyInfo {
#endif
    public const string AssemblyCopyright = "Copyright (c) 2000-2017 Developer Express Inc.";
    public const string AssemblyCompany = "Developer Express Inc.";

    public const int VersionId = 172;
    public const int VersionIdMinor = 17201;
    public const string VersionShort = "17.2";
#if NETFX_CORE
    public const string Version = VersionShort + ".0.3";
#else
    public const string Version = VersionShort + ".0.0";
#endif
    public const string FileVersion = Version;
    public const string MarketingVersion = "v2017 vol 2";
    public const string VirtDirSuffix = "_v17_2";

    public const string PublicKeyToken = "79868b8147b5eae4";
    public const string PublicKey = "0024000004800000940000000602000000240000525341310004000001000100dd3415ad127e2479d518586804419e99231acd687f889e897fb021bec3d90d53781811bb9d569e032d00362413298930c553dfd43a24e699c6a3d4922824f3c987fc01524b94059de1ccfbef1ff6aedc86055d56c4c3c92c550c84a1410b0c0e891e8f2f0fa193e1532f25727ae634055808129b901bdc24cb517e95fb8815b5";

    public const string FullAssemblyVersionExtension = ", Version=" + Version + ", Culture=neutral, PublicKeyToken=" + PublicKeyToken;

    public const string TestsSuffix = ".Tests";
    public const string DesignSuffix = ".Design";

    public const string SatelliteContractVersion = VersionShort + ".0.0";
    public const string VSuffixWithoutSeparator = "v" + VersionShort;
    public const string VSuffix = "." + VSuffixWithoutSeparator;
    public const string VSuffixDesign = VSuffix + ".Design";
    public const string VSuffixExport    = VSuffix + ".Export";
    public const string VSuffixLinq = VSuffix + ".Linq";
    public const string SRAssemblyAgScheduler = "DevExpress.Xpf.Scheduler" + VSuffix;
    public const string SRAssemblyAssemblyLoader = "DevExpress.Xpf.AssemblyLoader" + VSuffix;
    public const string SRAssemblyXpfSpellChecker = "DevExpress.Xpf.SpellChecker" + VSuffix;
    public const string SRAssemblyXpfRichEdit = "DevExpress.Xpf.RichEdit" + VSuffix;
    public const string SRAssemblyXpfSpreadsheet = "DevExpress.Xpf.Spreadsheet" + VSuffix;
    public const string SRAssemblyXpfScheduler = "DevExpress.Xpf.Scheduler" + VSuffix;
    public const string SRAssemblyXpfRichEditExtensions = "DevExpress.Xpf.RichEdit" + VSuffix + ".Extensions";
    public const string SRAssemblyXpfPrinting = "DevExpress.Xpf.Printing" + VSuffix;
    public const string SRAssemblyXpfPrintingFull = SRAssemblyXpfPrinting + FullAssemblyVersionExtension;
    public const string SRAssemblyXpfDataAccess = "DevExpress.Xpf.DataAccess" + VSuffix;
    public const string SRAssemblyXpfExpressionEditor = "DevExpress.Xpf.ExpressionEditor" + VSuffix;
    public const string SRAssemblyXpfReportDesigner = "DevExpress.Xpf.ReportDesigner" + VSuffix;
    public const string SRAssemblyXpfCore = "DevExpress.Xpf.Core" + VSuffix;
    public const string SRAssemblyXpfPdfViewer = "DevExpress.Xpf.PdfViewer" + VSuffix;
    public const string SRAssemblyXpfDocumentViewerCore = "DevExpress.Xpf.DocumentViewer" + VSuffix + ".Core";
    public const string SRAssemblyXpfMvvm = "DevExpress.Mvvm" + VSuffix;
    public const string SRAssemblyXpfMvvmFree = "DevExpress.Mvvm";
    public const string SRAssemblyXpfMvvmUIFree = "DevExpress.Mvvm.UI";
    public const string SRAssemblyXpfRibbon = "DevExpress.Xpf.Ribbon" + VSuffix;
    public const string SRAssemblyXpfNavBar = "DevExpress.Xpf.NavBar" + VSuffix;
    public const string SRAssemblyXpfCoreExtensions = "DevExpress.Xpf.Core" + VSuffix + ".Extensions";
    public const string SRAssemblyXpfDemoBase = "DevExpress.Xpf.DemoBase" + VSuffix;
    public const string SRAssemblyXpfGrid = "DevExpress.Xpf.Grid" + VSuffix;
    public const string SRAssemblyXpfGridCore = "DevExpress.Xpf.Grid" + VSuffix + ".Core";
    public const string SRAssemblyXpfGridExtensions = "DevExpress.Xpf.Grid" + VSuffix + ".Extensions";
    public const string SRAssemblyXpfDiagram = "DevExpress.Xpf.Diagram" + VSuffix;
    public const string SRAssemblyXpfDiagramTests = "DevExpress.Xpf.Diagram" + VSuffix + ".Tests";
    public const string SRAssemblyXpfAccordion = "DevExpress.Xpf.Accordion" + VSuffix;
    public const string SRAssemblyXpfAccordionTests = "DevExpress.Xpf.Accordion" + VSuffix + TestsSuffix;
    public const string SRAssemblyXpfAccordionDesign = "DevExpress.Xpf.Accordion" + VSuffixDesign;
    public const string SRAssemblyXpfDocking = "DevExpress.Xpf.Docking" + VSuffix;
    public const string SRAssemblyXpfControls = "DevExpress.Xpf.Controls" + VSuffix;
    public const string SRAssemblyXpfLayoutControl = "DevExpress.Xpf.LayoutControl" + VSuffix;
    public const string SRAssemblyImages = "DevExpress.Images" + VSuffix;
    public const string SRAssemblyImagesFull = "DevExpress.Images" + VSuffix + FullAssemblyVersionExtension;
    public const string SRAssemblyMvvm = SRAssemblyXpfMvvm;
    public const string SRAssemblyMvvmFull = SRAssemblyXpfMvvm + FullAssemblyVersionExtension;
    public const string SRAssemblyXpfDockingExtensions = "DevExpress.Xpf.Docking" + VSuffix + ".Extensions";
    public const string SRAssemblyXpfLayoutCore = "DevExpress.Xpf.Layout" + VSuffix + ".Core";
    public const string SRAssemblyDXCharts = "DevExpress.Xpf.Charts" + VSuffix;
    public const string SRAssemblyChartDesigner = "DevExpress.Charts.Designer" + VSuffix;
    
    public const string SRAssemblyDXGauges = "DevExpress.Xpf.Gauges" + VSuffix;
    public const string SRAssemblyDXMap = "DevExpress.Xpf.Map" + VSuffix;
    public const string SRAssemblyDXMapTests = "DevExpress.Xpf.Map.Tests";
    public const string SRAssemblyDXTreeMap = "DevExpress.Xpf.TreeMap" + VSuffix;

    public const string SRAssemblyData = "DevExpress.Data" + VSuffix;
    public const string SRAssemblyDemoDataCore = "DevExpress.DemoData" + VSuffix + ".Core";
    public const string SRAssemblyPrintingCore = "DevExpress.Printing" + VSuffix + ".Core";
    public const string SRAssemblyRichEditCore = "DevExpress.RichEdit" + VSuffix + ".Core";
    public const string SRAssemblyOfficeCore = "DevExpress.Office" + VSuffix + ".Core";
    public const string SRAssemblyDocs = "DevExpress.Docs" + VSuffix;
    public const string SRAssemblySpreadsheetCore = "DevExpress.Spreadsheet" + VSuffix + ".Core";
    public const string SRAssemblySchedulerCore = "DevExpress.XtraScheduler" + VSuffix + ".Core";
    public const string SRAssemblyReports = "DevExpress.XtraReports" + VSuffix;
    public const string SRAssemblyReportsFull = SRAssemblyReports + FullAssemblyVersionExtension;
    public const string SRAssemblyPrintingDesign = "DevExpress.XtraPrinting" + VSuffixDesign;

    public const string SRDocumentationLink = "http://documentation.devexpress.com/";
    public const string InstallationRegistryKeyBase = "SOFTWARE\\DevExpress\\Components\\";
    public const string InstallationRegistryKey = InstallationRegistryKeyBase + VSuffixWithoutSeparator;
    public const string InstallationRegistryRootPathValueName = "RootDirectory";
    public const string SRAssemblyXpfPrefix = "DevExpress.Xpf";
    public const string ThemePrefixWithoutSeparator = "Themes";
    public const string ThemePrefix = "." + ThemePrefixWithoutSeparator + ".";

#region UWP
    public const string UINamespace = "DevExpress.UI.Xaml.";

    public const string SRAssemblyCoreUwp = "DevExpress.Core";
    public const string SRAssemblyCoreUwpTests = SRAssemblyCoreUwp + TestsSuffix;
    public const string SRAssemblyCoreUwpDesign = SRAssemblyCoreUwp + DesignSuffix;

    public const string SRAssemblyPdfCoreUwp = "DevExpress.Pdf.Core";
    public const string SRAssemblyPdfCoreUwpTests = SRAssemblyPdfCoreUwp + TestsSuffix;

    public const string SRAssemblyDrawingUwp = "DevExpress.Drawing";
    public const string SRAssemblyDrawingUwpTests = SRAssemblyDrawingUwp + TestsSuffix;

    public const string SRAssemblyUIUwp = "DevExpress.UI.Xaml";
    public const string SRAssemblyUIUwpTests = SRAssemblyUIUwp + TestsSuffix;
    public const string SRAssemblyUIUwpDesign = SRAssemblyUIUwp + DesignSuffix;

    public const string SRAssemblyEditorsUwp = UINamespace + "Editors";
    public const string SRAssemblyEditorsUwpTests = SRAssemblyEditorsUwp + TestsSuffix;
    public const string SRAssemblyEditorsUwpDesign = SRAssemblyEditorsUwp + DesignSuffix;

    public const string SRAssemblyLayoutUwp = UINamespace + "Layout";
    public const string SRAssemblyLayoutUwpTests = SRAssemblyLayoutUwp + TestsSuffix;
    public const string SRAssemblyLayoutUwpDesign = SRAssemblyLayoutUwp + DesignSuffix;

    public const string SRAssemblyGridUwp = UINamespace + "Grid";
    public const string SRAssemblyGridUwpTests = SRAssemblyGridUwp + TestsSuffix;
    public const string SRAssemblyGridUwpDesign = SRAssemblyGridUwp + DesignSuffix;

    public const string SRAssemblyControlsUwp = UINamespace + "Controls";
    public const string SRAssemblyControlsUwpTests = SRAssemblyControlsUwp + TestsSuffix;
    public const string SRAssemblyControlsUwpDesign = SRAssemblyControlsUwp + DesignSuffix;


    public const string SRAssemblyChartsUwp = UINamespace + "Charts";
    public const string SRAssemblyChartsUwpTests = SRAssemblyChartsUwp + TestsSuffix;
    public const string SRAssemblyChartsUwpDesign = SRAssemblyChartsUwp + DesignSuffix;

    public const string SRAssemblyGaugesUwp = UINamespace + "Gauges";
    public const string SRAssemblyGaugesUwpTests = SRAssemblyGaugesUwp + TestsSuffix;
    public const string SRAssemblyGaugesUwpDesign = SRAssemblyGaugesUwp + DesignSuffix;

    public const string SRAssemblyMapUwp = UINamespace + "Map";
    public const string SRAssemblyMapUwpTests = SRAssemblyMapUwp + TestsSuffix;
    public const string SRAssemblyMapUwpDesign = SRAssemblyMapUwp + DesignSuffix;

    public const string SRAssemblyRibbonUwp = UINamespace + "Ribbon";
    public const string SRAssemblyRibbonUwpTests = SRAssemblyRibbonUwp + TestsSuffix;
    public const string SRAssemblyRibbonUwpDesign = SRAssemblyRibbonUwp + DesignSuffix;

    public const string SRAssemblyColorSchemeManagerUwp = "DevExpress.ColorSchemeManager";
    public const string SRAssemblyColorSchemeManagerUwpTests = SRAssemblyCoreUwp + TestsSuffix;
	
	public const string SRAssemblyThemesUwp = "DevExpress.Themes";
    public const string SRAssemblyThemesUwpTests = SRAssemblyThemesUwp + TestsSuffix;
#endregion

#region ASPNETCORE
    public const string
        SRAssemblyAspNetCore = "DevExpress.AspNetCore.Core" + VSuffix,
        SRAssemblyAspNetCoreBootstrap = "DevExpress.AspNetCore.Bootstrap.Core" + VSuffix,
        SRAssemblyAspNetCoreBootstrapMvc = "DevExpress.AspNetCore.Bootstrap.Mvc" + VSuffix,

        SRAssemblyAspNetCoreTests = "DevExpress.AspNetCore.Core.Tests",
        SRAssemblyAspNetCoreBootstrapMvcTests = "DevExpress.AspNetCore.Bootstrap.Mvc.Tests";
#endregion

    public const string
        SRAssemblyMVC = "DevExpress.Web.Mvc" + VSuffix,
        SRAssemblyMVC5 = "DevExpress.Web.Mvc5" + VSuffix,
        SRAssemblyMVCTests = "DevExpress.Web.Mvc" + VSuffix + ".Tests",
		SRAssemblyBootstrap = "DevExpress.Web.Bootstrap" + VSuffix,
        SRAssemblyBootstrapDesign = "DevExpress.Web.Bootstrap" + VSuffixDesign,
        SRAssemblyBootstrapDesignFull = "DevExpress.Web.Bootstrap" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyBootstrapTests = "DevExpress.Web.Bootstrap" + VSuffix + ".Tests",
        SRAssemblyExpressAppWeb = "DevExpress.ExpressApp.Web" + VSuffix,
        SRAssemblyExpressAppNotificationsWeb = "DevExpress.ExpressApp.Notifications.Web" + VSuffix,
        SRAssemblyExpressAppMapsWeb = "DevExpress.ExpressApp.Maps.Web" + VSuffix,
        SRAssemblyASPxThemes = "DevExpress.Web.ASPxThemes" + VSuffix,
        SRAssemblyASPxThemesFull = SRAssemblyASPxThemes + FullAssemblyVersionExtension,
        SRAssemblyASPxThemesTests = "DevExpress.Web.ASPxThemes" + VSuffix + ".Tests",
        SRAssemblyASPxResources = "DevExpress.Web.Resources" + VSuffix,
        SRAssemblyASPxGridView = "DevExpress.Web.ASPxGridView" + VSuffix,
        SRAssemblyASPxPivotGrid = "DevExpress.Web.ASPxPivotGrid" + VSuffix,
        SRAssemblyASPxPivotGridExport = "DevExpress.Web.ASPxPivotGrid" + VSuffixExport,
        SRAssemblyASPxPivotGridTests = "DevExpress.Web.ASPxPivotGrid" + VSuffix + ".Tests",
        SRAssemblyBonusSkins = "DevExpress.BonusSkins" + VSuffix,
        SRAssemblyBonusSkinsFull = "DevExpress.BonusSkins" + VSuffix + FullAssemblyVersionExtension,
        //SRAssemblyOfficeSkins = "DevExpress.OfficeSkins" + VSuffix,
        SRAssemblyDesign = "DevExpress.Design" + VSuffix,
        SRAssemblyDesignFull = "DevExpress.Design" + VSuffix + FullAssemblyVersionExtension, 
        SRAssemblyDataLinq = "DevExpress.Data" + VSuffixLinq,
        SRAssemblyUtils = "DevExpress.Utils" + VSuffix,
        SRAssemblyUtilsFull = SRAssemblyUtils + FullAssemblyVersionExtension,
        SRAssemblyParser = "DevExpress.Parser" + VSuffix,
        SRAssemblyPrinting = "DevExpress.XtraPrinting" + VSuffix,
        SRAssemblyPrintingFull = SRAssemblyPrinting + FullAssemblyVersionExtension,
        SRAssemblyEditors = "DevExpress.XtraEditors" + VSuffix,
        SRAssemblyEditorsFull = SRAssemblyEditors + FullAssemblyVersionExtension,
        SRAssemblyEditorsDesign = "DevExpress.XtraEditors" + VSuffixDesign,
        SRAssemblyEditorsDesignFull = "DevExpress.XtraEditors" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyDiagramCore = "DevExpress.Diagram" + VSuffix + ".Core",
        SRAssemblyDiagramCoreTests = "DevExpress.Diagram" + VSuffix + ".Core.Tests",
        SRAssemblyDiagram = "DevExpress.XtraDiagram" + VSuffix,
        SRAssemblyDiagramTests = "DevExpress.XtraDiagram" + VSuffix + ".Tests",
        SRAssemblyDiagramDesign = "DevExpress.XtraDiagram" + VSuffixDesign,
        SRAssemblyDiagramDesignFull = "DevExpress.XtraDiagram" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyNavBar = "DevExpress.XtraNavBar" + VSuffix,
        SRAssemblyNavBarDesign = "DevExpress.XtraNavBar" + VSuffixDesign,
        SRAssemblyBars = "DevExpress.XtraBars" + VSuffix,
        SRAssemblyBarsDesign = "DevExpress.XtraBars" + VSuffixDesign,
        SRAssemblyBarsDesignFull = "DevExpress.XtraBars" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyGrid = "DevExpress.XtraGrid" + VSuffix,
        SRAssemblyGaugesCore = "DevExpress.XtraGauges" + VSuffix + ".Core",
        SRAssemblyGaugesPresets = "DevExpress.XtraGauges" + VSuffix + ".Presets",
        SRAssemblyGaugesWin = "DevExpress.XtraGauges" + VSuffix + ".Win",
        SRAssemblyASPxGauges = "DevExpress.Web.ASPxGauges" + VSuffix,
        SRAssemblyASPxGaugesTests = "DevExpress.Web.ASPxGauges" + VSuffix + ".Tests",
        SRAssemblyGaugesDesignWin = "DevExpress.XtraGauges" + VSuffixDesign + ".Win",
        SRAssemblyGridDesign = "DevExpress.XtraGrid" + VSuffixDesign,
        SRAssemblyPivotGrid = "DevExpress.XtraPivotGrid" + VSuffix,
        SRAssemblyPivotGridFull = SRAssemblyPivotGrid + FullAssemblyVersionExtension,
        SRAssemblyPivotGridCore = "DevExpress.PivotGrid" + VSuffix + ".Core",
        SRAssemblyPivotGridDesign = "DevExpress.XtraPivotGrid" + VSuffixDesign,
        SRAssemblyPivotGridDesignFull = "DevExpress.XtraPivotGrid" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyTreeList = "DevExpress.XtraTreeList" + VSuffix,
        SRAssemblyTreeListDesign = "DevExpress.XtraTreeList" + VSuffixDesign,
        SRAssemblyVertGrid = "DevExpress.XtraVerticalGrid" + VSuffix,
        SRAssemblyVertGridDesign = "DevExpress.XtraVerticalGrid" + VSuffixDesign,
        SRAssemblyReportsService = "DevExpress.XtraReports" + VSuffix + ".Service",
        SRAssemblyReportsDesign = "DevExpress.XtraReports" + VSuffixDesign,
        SRAssemblyReportsDesignFull = SRAssemblyReportsDesign + FullAssemblyVersionExtension,
        SRAssemblyReportsImport = "DevExpress.XtraReports" + VSuffix + ".Import",
        SRAssemblyReportsWeb = "DevExpress.XtraReports" + VSuffix + ".Web",
		SRAssemblyReportsWebTests = "DevExpress.XtraReports" + VSuffix + ".Web.Tests",
        SRAssemblyReportsExtensions = "DevExpress.XtraReports" + VSuffix + ".Extensions",
        SRAssemblyReportsExtensionsFull = SRAssemblyReportsExtensions + FullAssemblyVersionExtension,
        SRAssemblyReportServerDesigner = "DevExpress.ReportDesigner" + VSuffix + ".Core",
        SRAssemblyReportServerWeb = "DevExpress.ReportServer" + VSuffix + ".Web",
        SRAssemblyReportServerDataAccess = "DevExpress.ReportServer" + VSuffix + ".DataAccess",
        SRAssemblyRichEdit = "DevExpress.XtraRichEdit" + VSuffix,
        SRAssemblyRichEditDesign = "DevExpress.XtraRichEdit" + VSuffixDesign,
        SRAssemblyRichEditExtensions = "DevExpress.XtraRichEdit" + VSuffix + ".Extensions",
        SRAssemblyRichEditExport = "DevExpress.RichEdit" + VSuffix + ".Export",
        SRAssemblySpreadsheet = "DevExpress.XtraSpreadsheet" + VSuffix,
        SRAssemblySpreadsheetDesign = "DevExpress.XtraSpreadsheet" + VSuffixDesign,
        SRAssemblyScheduler = "DevExpress.XtraScheduler" + VSuffix,
        SRAssemblySchedulerDesign = "DevExpress.XtraScheduler" + VSuffixDesign,
        SRAssemblySchedulerWeb = "DevExpress.Web.ASPxScheduler" + VSuffix,
        SRAssemblySchedulerWebDesign = "DevExpress.Web.ASPxScheduler" + VSuffixDesign,
        SRAssemblySchedulerWebDesignFull = "DevExpress.Web.ASPxScheduler" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblySchedulerExtensions = "DevExpress.XtraScheduler" + VSuffix + ".Extensions",
        SRAssemblySchedulerReporting = "DevExpress.XtraScheduler" + VSuffix + ".Reporting",
        SRAssemblySchedulerReportingExtensions = "DevExpress.XtraScheduler" + VSuffix + ".Reporting.Extensions",
        SRAssemblyChartsCore = "DevExpress.Charts" + VSuffix + ".Core",
        SRAssemblySparklineCore = "DevExpress.Sparkline" + VSuffix + ".Core",
        SRAssemblyCharts = "DevExpress.XtraCharts" + VSuffix,
        SRAssemblyChartsExtensions = "DevExpress.XtraCharts" + VSuffix + ".Extensions",
        SRAssemblyChartsWizard = "DevExpress.XtraCharts" + VSuffix + ".Wizard" + FullAssemblyVersionExtension,
        SRAssemblyChartsDesign = "DevExpress.XtraCharts" + VSuffixDesign,
        SRAssemblyChartsWebDesign = "DevExpress.XtraCharts" + VSuffix + ".Web.Design" + FullAssemblyVersionExtension,
        SRAssemblyChartsUI = "DevExpress.XtraCharts" + VSuffix + ".UI",
        SRAssemblyChartsWeb = "DevExpress.XtraCharts" + VSuffix + ".Web",
        SRAssemblyWizard = "DevExpress.XtraWizard" + VSuffix,
        SRAssemblyWizardDesign = "DevExpress.XtraWizard" + VSuffixDesign,
        SRAssemblyXpo = "DevExpress.Xpo" + VSuffix,
        SRAssemblyXpoDesign = "DevExpress.Xpo" + VSuffixDesign,
        SRAssemblyXpoDesignFull = SRAssemblyXpoDesign + FullAssemblyVersionExtension,
        SRAssemblyLayoutControl = "DevExpress.XtraLayout" + VSuffix,
        SRAssemblyLayoutControlDesign = "DevExpress.XtraLayout" + VSuffixDesign,
        SRAssemblySpellCheckerCore = "DevExpress.SpellChecker" + VSuffix + ".Core",
        SRAssemblySpellChecker = "DevExpress.XtraSpellChecker" + VSuffix,
        SRAssemblySpellCheckerDesign = "DevExpress.XtraSpellChecker" + VSuffixDesign,
        SRAssemblySpellCheckerDesignFull = SRAssemblySpellCheckerDesign + FullAssemblyVersionExtension,
        SRAssemblySpellCheckerWeb = "DevExpress.Web.ASPxSpellChecker" + VSuffix,
        SRAssemblySpellCheckerWebTests = "DevExpress.Web.ASPxSpellChecker" + VSuffix + ".Tests",
        SRAssemblyWeb = "DevExpress.Web" + VSuffix,
        SRAssemblyWebDesign = "DevExpress.Web" + VSuffixDesign,
        SRAssemblyWebTests = "DevExpress.Web" + VSuffix + ".Tests",
        SRAssemblyWebDemoData = "DevExpress.Web.DemoData" + VSuffix,
        SRAssemblyWebDemoDataTests = "DevExpress.Web.DemoData" + VSuffix + ".Tests",
        SRAssemblyWebDesignFull = "DevExpress.Web" + VSuffixDesign + FullAssemblyVersionExtension,
        SRAssemblyWebDesignTests = "DevExpress.Web" + VSuffixDesign + ".Tests",
        SRAssemblyWebLinq = "DevExpress.Web" + VSuffixLinq,
        SRAssemblyWebSpreadsheet = "DevExpress.Web.ASPxSpreadsheet" + VSuffix,
        SRAssemblyWebSpreadsheetFull = "DevExpress.Web.ASPxSpreadsheet" + VSuffix + FullAssemblyVersionExtension,
        SRAssemblyWebSpreadsheetTests = "DevExpress.Web.ASPxSpreadsheet" + VSuffix + ".Tests",
        SRAssemblyWebRichEdit = "DevExpress.Web.ASPxRichEdit" + VSuffix,
        SRAssemblyWebRichEditFull = "DevExpress.Web.ASPxRichEdit" + VSuffix + FullAssemblyVersionExtension,
        SRAssemblyWebRichEditTests = "DevExpress.Web.ASPxRichEdit" + VSuffix + ".Tests",

        SRAssemblyHtmlEditorWeb = "DevExpress.Web.ASPxHtmlEditor" + VSuffix,
        SRAssemblyWebHtmlEditorTests = "DevExpress.Web.ASPxHtmlEditor" + VSuffix + ".Tests",
        SRAssemblyEditorsWeb = "DevExpress.Web.ASPxEditors" + VSuffix,
        SRAssemblyTreeListWeb = "DevExpress.Web.ASPxTreeList" + VSuffix,
        SRAssemblyTreeListWebTests = "DevExpress.Web.ASPxTreeList" + VSuffix + ".Tests",
        SRAssemblyDXPivotGrid = "DevExpress.Xpf.PivotGrid" + VSuffix,
        SRAssemblyDXThemeEditorUIWithoutVSuffix = "DevExpress.Xpf.ThemeEditor",
        SRAssemblyDXThemeEditorUI = SRAssemblyDXThemeEditorUIWithoutVSuffix + VSuffix,

        SRAssemblySnap = "DevExpress.Snap" + VSuffix,
        SRAssemblySnapCore = "DevExpress.Snap" + VSuffix + ".Core",
        SRAssemblySnapExtensions = "DevExpress.Snap" + VSuffix + ".Extensions",
        SRAssemblySnapDesign = "DevExpress.Snap" + VSuffixDesign,

        SRAssemblyUtilsUI = "DevExpress.Utils" + VSuffix + ".UI",
        SRAssemblyUtilsUIFull = SRAssemblyUtilsUI + FullAssemblyVersionExtension,
        SRAssemblyDashboardCore = "DevExpress.Dashboard" + VSuffix + ".Core",
        SRAssemblyDashboardWin = "DevExpress.Dashboard" + VSuffix + ".Win",
        SRAssemblyDashboardWeb = "DevExpress.Dashboard" + VSuffix + ".Web",
        SRAssemblyDashboardWebMVC = "DevExpress.Dashboard" + VSuffix + ".Web.Mvc",
        SRAssemblyDashboardWebMVC5 = "DevExpress.Dashboard" + VSuffix + ".Web.Mvc5",
        SRAssemblyDashboardWinDesign = "DevExpress.Dashboard" + VSuffix + ".Win.Design",
        SRAssemblyDashboardWebDesign = "DevExpress.Dashboard" + VSuffix + ".Web.Design" + FullAssemblyVersionExtension,
        SRAssemblyMapCore = "DevExpress.Map" + VSuffix + ".Core",
        SRAssemblyMapCoreTests = "DevExpress.Map.Core.Tests",
        SRAssemblyMap = "DevExpress.XtraMap" + VSuffix,
        SRAssemblyMapTests = "DevExpress.XtraMap.Tests",
        SRAssemblyMapDesign = "DevExpress.XtraMap" + VSuffixDesign,
        SRAssemblyTreeMapCore = "DevExpress.TreeMap" + VSuffix + ".Core",
        SRAssemblyTreeMap = "DevExpress.XtraTreeMap" + VSuffix,
        SRAssemblyTreeMapDesign = "DevExpress.XtraTreeMap" + VSuffixDesign,
        SRAssemblyDataAccess = "DevExpress.DataAccess" + VSuffix,
        SRAssemblyDataAccessUI = "DevExpress.DataAccess" + VSuffix + ".UI",
        SRAssemblyDataAccessDesign = "DevExpress.DataAccess" + VSuffix + ".Design",
        SRAssemblyDataAccessDesignFull = SRAssemblyDataAccessDesign + FullAssemblyVersionExtension,
        SRAssemblyCodeParser = "DevExpress.CodeParser" + VSuffix,
        SRAssemblyPdfCore = "DevExpress.Pdf" + VSuffix + ".Core",
        SRAssemblyPdfDrawing = "DevExpress.Pdf" + VSuffix + ".Drawing",
        SRAssemblyXtraPdfViewer = "DevExpress.XtraPdfViewer" + VSuffix,
        SRAssemblyXtraPdfViewerDesign = "DevExpress.XtraPdfViewer" + VSuffix + ".Design",
        SRAssemblySpreadsheetCoreTestsRangeCopy = "DevExpress.Spreadsheet" + VSuffix + ".Core.Tests.RangeCopy",
        SRAssemblySpreadsheetCoreTestsNotification = "DevExpress.Spreadsheet" + VSuffix + ".Core.Tests.Notification",
        SRAssemblySpreadsheetCoreTestsFunctions = "DevExpress.Spreadsheet" + VSuffix + ".Core.Tests.Functions";

    public const string
        DXTabNameComponents = "Components",
        DXTabNameNavigationAndLayout = "Navigation & Layout",
        DXTabNameOrmComponents = "ORM Components",
        DXTabNameReporting = "Reporting",
        DXTabNameReportControls = "Report Controls",
        DXTabNameDataUwp = "Data",
        DXTabNameDashboardItems = "Dashboard Items",
        DXTabNameData = "Data & Analytics",
        DXTabNameVisualization = "Visualization",
        DXTabNameScheduling = "Scheduling",
        DXTabNameSchedulerReporting = "Scheduler Reporting",
        DXTabNameRichEdit = "Rich Text Editor",
        DXTabNameSpreadsheet = "Spreadsheet",
        DXTabNameCommon = "Common Controls",
		DXTabNameBootstrap = "Bootstrap Controls",
        DXTabNameLayoutContainers = "Layout Containers",
        DXTabNameLayoutControl = "Layout Control",
        DXTabPrefix = "DX." + VersionShort + ": ",
        DXTabFree = DXTabPrefix + "Free",
        DXTabComponents = DXTabPrefix + DXTabNameComponents,
        DXTabNavigation = DXTabPrefix + DXTabNameNavigationAndLayout,
        DXTabLayoutControl = DXTabPrefix + DXTabNameLayoutControl,
        DXTabLayoutContainers = DXTabPrefix + DXTabNameLayoutContainers,
        DXTabReporting = DXTabPrefix + DXTabNameReporting,
        DXTabReportControls = DXTabPrefix + DXTabNameReportControls,
        DXTabDataUwp = DXTabPrefix + DXTabNameDataUwp,
        DXTabDashboardItems = DXTabPrefix + DXTabNameDashboardItems,
        DXTabData = DXTabPrefix + DXTabNameData,
        DXTabVisualization = DXTabPrefix + DXTabNameVisualization,
        DXTabOrmComponents = DXTabPrefix + DXTabNameOrmComponents,
        DXTabScheduling = DXTabPrefix + DXTabNameScheduling,
        DXTabSchedulerReporting = DXTabPrefix + DXTabNameSchedulerReporting,
        DXTabRichEdit = DXTabPrefix + DXTabNameRichEdit,
        DXTabSpreadsheet = DXTabPrefix + DXTabNameSpreadsheet,
        DXTabCommon = DXTabPrefix + DXTabNameCommon,
		DXTabBootstrap = DXTabPrefix + DXTabNameBootstrap,
        DXTabNameXPOProfiler = "XPO " + VersionShort + " Profiler";

    public const string
        DXTabWpfNavigation = "DX." + VersionShort + ": Navigation & Layout",
        DXTabWpfReporting = "DX." + VersionShort + ": Reporting",
        DXTabWpfData = "DX." + VersionShort + ": Data",
        DXTabWpfVisualization = "DX." + VersionShort + ": Visualization",
        DXTabWpfCommon = "DX." + VersionShort + ": Common Controls",
        DXTabWpfScheduling = "DX." + VersionShort + ": Scheduling",
        DXTabWpfSchedulingNew = "DX." + VersionShort + ": Scheduling (new)",
        DXTabWpfRichEdit = "DX." + VersionShort + ": Rich Text Editor",
        DXTabWpfSpreadsheet = "DX." + VersionShort + ": Spreadsheet";

    public const string
        DXLinkCompetitiveDiscounts = "https://go.devexpress.com/Demo_2013_Competitive_Discounts.aspx",
        DXLinkCompare = "https://go.devexpress.com/Demo_2013_CompareSubscriptions.aspx",
        DXLinkTrial = "https://go.devexpress.com/Demo_2013_DownloadTrial.aspx",
        DXLinkChat = "Https://go.devexpress.com/Demo_2013_Chat.aspx",
        DXLinkHelp = "Https://go.devexpress.com/Demo_2013_Help.aspx",
        DXLinkBuyNow = "Https://go.devexpress.com/Demo_2013_BuyNow.aspx",
        DXLinkBuyNowASP = "https://go.devexpress.com/Demo_2013_BuyNow_ASP.aspx",
        DXLinkWhatsNew = "Https://go.devexpress.com/Demo_2013_13_2_WhatsNew.aspx",
        DXLinkGetSupport = "Https://go.devexpress.com/Demo_2013_GetSupport.aspx",
        DXLinkGetStarted = "Https://go.devexpress.com/Demo_2013_GetStartedOverall.aspx",
        DXLinkRegisterKB = "https://go.devexpress.com/Demo_2013_RegisterTrial.aspx",
        DXLinkGetStartedWinGrid = "https://go.devexpress.com/Demo_2013_GetStartedWinGrid.aspx",
        DXEmailInfo = "info@devexpress.com",
        DXLinkEmailInfo = "mailto:" + DXEmailInfo;
    
}
#if !DXCommon
}
#endif