import os
import bpy
import random

from bpy.types import (
    Operator,
    Panel
)
from bpy.props import (
    StringProperty
)

from bpy.types import  EnumProperty, WindowManager
import bpy.utils.previews

bl_info = {
    "name": "Lighter",
    "description": "by vfxmed.com Professional lighting for everyone",
    "author": "Morelewd",
    "version": (1, 0 , 6),
    "blender": (3, 0, 0),
    "location" : "3D View > Properties Panel > Lighter",
    "warning": "",  
    "tracker_url": "",
    "category": "lighting"
}


colors = [

[(1.0, 1.0, 1.0),
(1.0, 1.0, 1.0),
(1.0, 1.0, 1.0),
(1.0, 1.0, 1.0)],

[(0.898, 0.866, 0.784),
(0.003, 0.580, 0.603),
(0, 0.262, 0.411),
(0.858, 0.121, 0.282)],

[(0.129, 0.772, 0.768),
(0.976, 0.913, 0.313),
(0.984, 0.635, 0.764),
(0.756, 0.309, 0.376)],

[(0.850, 0.349, 0.501),
(0.388, 0.666, 0.752),
(0.976, 0.607, 0.270),
(0.156, 0.305, 0.376)],

[(0.984, 0.737, 0.329),
(0.972, 0.862, 0.690),
(0.988, 0.368, 0.439),
(0.949, 0.694, 0.564)],

[(0.635, 0.768, 0.878),
(0.968, 0.796, 0.176),
(0.321, 0.407, 0.560),
(0.509, 0.643, 0.890)],

[(0.709, 0.949, 0.933),
(1, 0.474, 0.188),
(0, 0.878, 0.917),
(0.247, 0.317, 0.709)],

[(0.368, 0.215, 0.427),
(247, 233, 81),
(0.831, 0.733, 0.866),
(0.964, 0.901, 0.909)],

[(0.913, 0.156, 0.627),
(0.152, 0.066, 0.250),
(0.235, 0.745, 0.815),
(0.901, 0.827, 0.313)],

[(0.862, 0.466, 0.149),
(0.925, 0.752, 0.274),
(0.960, 0.968, 0.929),
(0.258, 0.752, 0.823)],

[(0.913, 0.403, 0.607),
(0.972, 0.803, 0.309),
(0.725, 0.639, 0.819),
(0.431, 0.878, 0.878)],


[(0.898, 0.866, 0.784),
(1, 0.827, 0.098),
(1, 0.984, 0.690),
(1, 0.647, 0.552)],

        ]

# ------------------------------------------------------------------------
#    PROPS
# ------------------------------------------------------------------------


class SceneLightsItems(bpy.types.PropertyGroup):
   id: bpy.props.IntProperty(name="id", default=0)
   object: bpy.props.PointerProperty( name="Object",type=bpy.types.Light)
   collection: bpy.props.PointerProperty( name="Collection",type=bpy.types.Collection)

class ColorGroup(bpy.types.PropertyGroup):
    red: bpy.props.FloatProperty(name="r" , default= 0.0)
    green: bpy.props.FloatProperty(name="g" , default= 0.0)
    blue: bpy.props.FloatProperty(name="b", default= 0.0)

# ------------------------------------------------------------------------
#    OPERATORS
# ------------------------------------------------------------------------



preview_collections = {}

def generate_previews():
    # We are accessing all of the information that we generated in the register function below
    pcoll = preview_collections["thumbnail_previews"]
    image_location = os.path.join(bpy.utils.script_path_user(), 'addons', 'lighter',  "previews" ) 
    VALID_EXTENSIONS = ('.png', '.jpg', '.jpeg')
    
    enum_items = []
    
    # Generate the thumbnails
    for i, image in enumerate(os.listdir(image_location)):
        if image.endswith(VALID_EXTENSIONS):
            filepath = os.path.join(image_location, image)
            thumb = pcoll.load(filepath, filepath, 'IMAGE')
            enum_items.append((image, image, "", thumb.icon_id, i))   
    return enum_items


def setRandomEnergy(self,context):
    
    if self.EnergySeed == 0 :
        self.energy = self.DefaultEnergy
    else:   
        self.energy = 100 *  (random.random()*2) + self.EnergySeed
        
def setRandomColor(self,context):
    
    random.seed(self.ColorSeed)
    r, g, b = [random.random() for i in range(3)]
    if self.ColorSeed == 0 :
        self.color[0] = self.DefaultColor.red
        self.color[1] = self.DefaultColor.green
        self.color[2] = self.DefaultColor.blue
    else:
        self.color = r, g, b 
    
class LIGHTER_OT_ReleaseInstances(Operator):
    """Export the lights"""
    bl_idname = "lighter.release_node_tree"
    bl_label = "Release the lights"

            
    @classmethod
    def poll(cls, context):
        try:
            context.active_object['lighter-instance']
            return True
        except:
            return False
    def execute(self, context):
        
        bpy.ops.object.duplicates_make_real()
        id = context.active_object['lighter-instance-id']
        name = 'Lighter-' + str(id) 
        lights = 'Lights-' + str(id)
        for c in bpy.data.collections[name].objects:
                try:
                    c['lighter-instance']
                    bpy.data.objects.remove(bpy.context.scene.objects[c.name], do_unlink = True)
                except:
                        continue
        for b in bpy.data.collections[lights].objects:
                try:
                    b.data['lighter-light']
                    bpy.data.objects.remove(bpy.context.scene.objects[b.name], do_unlink = True)
                except:
                    continue
                    
                    
        return {'FINISHED'}


class LIGHTER_OT_GetRandomColor(Operator):
    """Export the lights"""
    bl_idname = "lighter.get_random_color"
    bl_label = "randomize color"  
    
    light: bpy.props.StringProperty( name="lighted")
    
    def get_random_color(self ,context):
        ''' generate rgb using a list comprehension '''
        r, g, b = [random.random() for i in range(3)]
        light = bpy.data.objects[self.light]
        light.data.color = r, g, b

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        self.get_random_color(context)
        return {'FINISHED'}
    
class LIGHTER_OT_Append(Operator):
    """Select the object you want to light and push this button"""
    bl_idname = "lighter.append_node_tree"
    bl_label = "Append LIGHTER"
    bl_options = {'REGISTER' , 'UNDO'}

    blend : StringProperty(name="Library Blend File")
    ng_name : StringProperty(name="Node group Name")
    
    def findCollection(self , collection_name , parent_coll):
        if not any(collection.name == collection_name for collection in bpy.data.collections):
            my_coll = bpy.data.collections.new(collection_name)
            if parent_coll:
                parent_coll.children.link(my_coll)
            else:
                bpy.context.scene.collection.children.link(my_coll)
            return my_coll
        else:
            return bpy.data.collections[collection_name]
    
    def recurLayerCollection(self , layerColl, collName):
        found = None
        if (layerColl.name == collName):
            return layerColl
        for layer in layerColl.children:
            found = self.recurLayerCollection(layer, collName)
            if found:
                return found

            
    def addMainObject(self, context, name , id):                
        for collection in bpy.data.collections:
            if collection.name == name:
                if not any(object.name == name for object in collection.all_objects):
                    mesh = bpy.data.meshes.new("mesh")  # add a new mesh
                    lightobj = bpy.data.objects.new(name , mesh)  # add a new object using the mesh
                    bpy.ops.object.select_all(action='DESELECT')
                    bpy.data.collections[name].objects.link(lightobj)
                    lightobj.select_set(True)
                    lightobj["lighter-instance"] = True
                    lightobj["lighter-instance-id"] = id
                    bpy.context.view_layer.objects.active = lightobj
                    return lightobj
                else :
                    bpy.ops.object.select_all(action='DESELECT')
                    lightobj = bpy.data.objects[name]
                    lightobj.select_set(True)
                    bpy.context.view_layer.objects.active = lightobj
                    return lightobj
   
   
    def get_random_color(self):
        ''' generate rgb using a list comprehension '''
        r, g, b = [random.random() for i in range(3)]
        return r, g, b

            
    def loadNodes(self,context , object, point , nameLights):
         dimension = 1.0
         try:
            dimension = point.dimensions[0]
         except:
            dimension = 1.0
        
         if not any(modifier.type == "NODES" for modifier in object.modifiers):
            mod = object.modifiers.new(name = "nodes", type = 'NODES')         
            filepath = os.path.join(bpy.utils.script_path_user(), 'addons', 'lighter',  "lighter.blend" )         
            with bpy.data.libraries.load(filepath, link=False) as (data_from, data_to):
                data_to.node_groups = [
                    name for name in data_from.node_groups if name.startswith("Lighter")]
            for nodeTree in bpy.data.node_groups:
                if nodeTree.name == "Lighter":
                    mod.node_group = nodeTree
                    mod['Input_11'] = point
                    mod['Input_3'] = dimension * 2.0
                    bpy.data.node_groups["Lighter"].inputs[3].max_value = 20
                    bpy.data.node_groups["Lighter"].inputs[7].max_value = 20
                    bpy.data.node_groups["Lighter"].inputs[8].max_value = 20
                    mod['Input_7'] = dimension * 4.0
                    mod['Input_9'] = bpy.data.collections[nameLights]
                    mod['Input_10'][0] = 8.0
                    mod['Input_10'][1] = 8.0
                    mod['Input_10'][2] = 8.0

#                    mod.node_group  = coll
                    break;
    
    
    def get_rand(self ):

        return random.randint(0, 9)
    
            
    def createLights(self, context , nameLights , id , point):
        
        dimension = 1.0
        try:
            dimension = point.dimensions[0]
        except:
            dimension = 1.0

        
        for collection in bpy.data.collections:
            if collection.name == nameLights:
               for obj in collection.all_objects:
                  bpy.data.objects.remove(obj, do_unlink = True)
      
        for num  in range(4):
            light_data = bpy.data.lights.new(name="my-light-data", type='AREA')
            light_data.energy = 100 * dimension * (random.random()*2)
            light_data.DefaultEnergy = light_data.energy
            # Create new object, pass the light data 
            light_object = bpy.data.objects.new(name="my-light" + str(num) , object_data=light_data)
            light_object.data['lighter-light'] = True
            light_object.data['lighter-light-id'] = id
            # Link object to collection in context
#            bpy.context.collection.objects.link(light_object)
            bpy.data.collections[nameLights].objects.link(light_object)
            rand = self.get_rand()
            idx = int(os.path.splitext(context.scene.color_thumbnails)[0])
            color = colors[idx][num]
            light_object.data.color = color
            light_object.data.DefaultColor.red= color[0]
            light_object.data.DefaultColor.green= color[1]
            light_object.data.DefaultColor.blue= color[2]
            # Change light position
            light_object.location = (1 + num, 0, 0 )


#        root = self.set_collection('Lighter_lights')
#        root.exclude = True
            
    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):
        id = context.scene.lighters
        name = 'Lighter-' + str(id)
        nameLights = 'Lights-' + str(id)
        point = context.active_object
        parentColl = self.findCollection( name, None);
        self.findCollection(nameLights , parentColl)       
        self.createLights(context , nameLights , id , point);
        object = self.addMainObject(context , name , id)      
        self.loadNodes(context , object, point , nameLights)
        bpy.data.collections[nameLights].hide_viewport = True
        bpy.data.collections[nameLights].hide_render = True
        context.scene.lighters += 1
        return {'FINISHED'}


# ------------------------------------------------------------------------
#    Panel 
# ------------------------------------------------------------------------

class LIGHTER_PT_mainPanel(Panel):
    '''Adds nodetree to active object'''
    bl_label = "Lighter"
    bl_idname = "LIGHTER_PT_mainPanel"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = "Lighter"

    def draw(self, context):
        layout = self.layout

        file_name = "lighter"
        ng_name = "lighter"
        
        
        row = layout.column()
        row9 = row.row(align=True)        
        row9.scale_y = 0.4               
        row.scale_y = 1.5             
        row.operator(LIGHTER_OT_Append.bl_idname,text="Light It Up !", icon='LIGHT')
        row9.template_icon_view(context.scene, "color_thumbnails", scale=3 ,scale_popup=3)
        row.operator(LIGHTER_OT_ReleaseInstances.bl_idname,text="Release Lights !", icon='RESTRICT_INSTANCED_OFF')
        
                    
        for num , ob in enumerate(bpy.context.scene.objects):
            panelId = None
            try:
                ob["lighter-instance"]
                id = ob["lighter-instance-id"]
                panelId = id
                gm = ob.modifiers.get("nodes")
                box = layout.box()
                col1 = box.column()
                col1.prop_search(gm, '["Input_9"]', bpy.data, "collections", text="Light Collection")
                col1.prop_search(gm, '["Input_11"]', bpy.data, "objects", text="Point To")
                col1.prop(gm, '["Input_6"]',   text="Lights count")
                
                col = box.column_flow(align=True)            
                col.prop(gm, '["Input_2"]',  text="Seed")
                row = col.row(align=True)
                row.prop(gm, '["Input_21"]',   text="Random") 
                row.prop(gm, '["Input_15"]',   text="Span") 
                
                col.prop(gm, '["Input_12"]',  text="Rotate Lights")
                col.prop(gm, '["Input_3"]',  text="Distance Min")
                col.prop(gm, '["Input_7"]',  text="Distance Max")
                col.prop(gm, '["Input_8"]',  slider= True, text="Spread Lights")
                col.prop(gm, '["Input_13"]',  text="Min_Size")
                col.prop(gm, '["Input_14"]',  text="Max_Size")
                col.prop(gm, '["Input_10"]',   text="Constraints")  
                 
                box = layout.box()
                coll_name = 'Lights-' + str(id)
                num = gm['Input_6']
                for uid in range(num):
                    if uid == 5:
                         break
                    rox = box.row(align=True)
                    name = '["Input_' + str(16 + uid)+'"]'
                    rox.prop(gm, name, text="")
               
              
            except:
                if ob.type == "LIGHT" and  "lighter-light-id" in ob.data  :
                            box = layout.box()
                            row1 = box.row(align=True) 
                            row1.prop(ob.data, "color", text="")
                            row1.prop(ob.data, "ColorSeed", text="")                
                            row1.prop(ob.data, "EnergySeed", text="")                
                            row1.prop(ob.data, "energy", text="")
                            row1.prop(ob, "hide_viewport", text="" )                
                            col1 = box.row(align=True)
                            col1.prop(ob.data, "type", text="" ) 
                            if ob.data.type == "AREA":               
                             col1.prop(ob.data, "size", text="" ) 
                             col1.prop(ob.data, "shape", text="" ) 
                            if ob.data.type == "SPOT":              
                                col1.prop(ob.data, "spot_size", text="" )
                                col1.prop(ob.data, "spot_blend", text="" )
                            if ob.data.type == "SUN" :                
                                col1.prop(ob.data, "angle", text="" )                
                            if ob.data.type == "POINT" :   
                                col1.prop(ob.data, "shadow_soft_size", text="" ) 
                else:
                    
                    continue
               


# ------------------------------------------------------------------------
#    Registration
# ------------------------------------------------------------------------



classes = [
    LIGHTER_OT_Append,
    LIGHTER_PT_mainPanel,
    LIGHTER_OT_ReleaseInstances,
    SceneLightsItems,
    LIGHTER_OT_GetRandomColor,
    ColorGroup
]


def register():
    from bpy.utils import register_class
    from bpy.props import StringProperty, EnumProperty
    for cls in classes:
        register_class(cls)
    bpy.types.Scene.lighters = bpy.props.IntProperty(name='lighters' , default = 0)
    bpy.types.Light.ColorSeed = bpy.props.IntProperty(name='colorSeed' , default = 0 , update=setRandomColor)
    bpy.types.Light.EnergySeed = bpy.props.IntProperty(name='EnergySeed' , default = 0 , update=setRandomEnergy)
    bpy.types.Light.DefaultColor = bpy.props.PointerProperty(type=ColorGroup)
    bpy.types.Light.DefaultEnergy = bpy.props.FloatProperty(name='energy' , default = 0.0)
    
    pcoll = bpy.utils.previews.new()
    preview_collections["thumbnail_previews"] = pcoll
    
    bpy.types.Scene.color_thumbnails = EnumProperty(name="Color previews" , items=generate_previews(),default=0)

def unregister():
    from bpy.utils import unregister_class
    from bpy.types import WindowManager
    for cls in reversed(classes):
        unregister_class(cls)
    del bpy.types.Scene.lighters
    del bpy.types.Light.ColorSeed
    del bpy.types.Light.DefaultColor   
    for pcoll in preview_collections.values():
        bpy.utils.previews.remove(pcoll)
    preview_collections.clear()
    
    del bpy.types.Scene.color_thumbnails

if __name__ == "__main__":
    register()