local WINDOW_OPEN = false
local SKILLFILTER_OPEN = false

local re = re
local sdk = sdk
local d2d = d2d
local imgui = imgui
local log = log
local json = json

local function FindIndex(table, value)
	for i = 1, #table do
		if table[i] == value then
			return i;
		end
	end

	return nil;
end

local localization = require("lingsamuels-data-reporter.localization")

local config = json.load_file('lingsamuels-data-reporter.json') or {}
if config.Enabled == nil then
	config.Enabled = true
end
if config.EnablePanel == nil then
	config.EnablePanel = true
end
if config.EnableBuff == nil then
	config.EnableBuff = true
end
if config.KeyboardHotKey == nil then
	config.KeyboardHotKey = 35
end

if config.Language == nil or FindIndex(localization.Languages, config.Language) == nil then
	config.Language = "zh-CN"
end
localization.config = config

if config.WindowSettings == nil then
	config.WindowSettings = {
		Width = 450,
		PosX = 900,
		PosY = 260,
		RowHeight = 27,
		Indent = 10,
		ColumnAOffset = 260,
		ColumnBOffset = 350,
	}
end
-- Patch config
if config.WindowSettings.FontSize == nil or config.WindowSettings.FontSize == 0 then
	config.WindowSettings.FontSize = 22
	config.WindowSettings.FontColor = 0xFFFFFFFF
	-- "FontColor": 4294967295,
	config.WindowSettings.BackgroundColor = 0x96000000
end

if config.BuffSettings == nil then
	config.BuffSettings = {
		PosX = config.WindowSettings.PosX + config.WindowSettings.Width + 10,
		PosY = 200,
		BarWidth = 300,
		Height = 14,
		Indent = 10,
		FontSize = config.WindowSettings.FontSize,
		FontColor = config.WindowSettings.FontColor,
		BackgroundColor = 0x69000000,
		BarColor = 0xFFAEAEAE,
		BorderWidth = 2,
        -- "BackgroundColor": 1761607680,
        -- "BarColor": 4289638062,
        -- "FontColor": 4294967295,
	}
end

local ModName = "lingsamuels-data-reporter"
-- local singletons = require(ModName .. "/singletons")
local singletons = require("lingsamuels-data-reporter.singletons")
local utils = require("lingsamuels-data-reporter.utils")
local debug = require("lingsamuels-data-reporter.debug")

local collector = require("lingsamuels-data-reporter.data")
collector.utils = utils
collector.localization = localization
collector.singletons = singletons

local summary = require("lingsamuels-data-reporter.summary")
summary.PanelOpts = config.WindowSettings
summary.BuffOpts = config.BuffSettings

if config.NotifyConfig == nil then
	config.NotifyConfig = {}
end

local function InitDisplayInPanelConfig()
	for i = 1, #summary.TimerTypes do
		local skillType = summary.TimerTypes[i]
		if config.NotifyConfig[skillType] ~= nil and config.NotifyConfig[skillType].DisplayInPanel == nil then
			config.NotifyConfig[skillType].DisplayInPanel = true
		end
	end
	for i = 1, #summary.ValidRowCounterTypes do
		local skillType = summary.ValidRowCounterTypes[i]
		if config.NotifyConfig[skillType] ~= nil and config.NotifyConfig[skillType].DisplayInPanel == nil then
			config.NotifyConfig[skillType].DisplayInPanel = true
		end
	end
end

local function InitDisplayBuffConfig()
	for i = 1, #summary.TimerTypes do
		local skillType = summary.TimerTypes[i]
		if config.NotifyConfig[skillType] ~= nil and config.NotifyConfig[skillType].DisplayBuffBar == nil then
			config.NotifyConfig[skillType].DisplayBuffBar = true
		end
	end
end

local function InitAttributeConfig()
	if config.AttributeConfig == nil then
		config.AttributeConfig = {}
		config.AttributeConfig["Health"] = true
		config.AttributeConfig["Affinity"] = true
		config.AttributeConfig["BattleTime"] = true
	end
	for i = 1, #summary.Attributes do
		local attr = summary.Attributes[i]
		config.AttributeConfig[attr] = true
	end
end

local function InitHitConfig()
	if config.HitConfig == nil then
		config.HitConfig = {}
	end
	for i = 1, #summary.SpecialHitTypes do
		local hitType = summary.SpecialHitTypes[i]
		config.HitConfig[hitType] = true
	end
end

local function InitDisplayBuffHitConfig()
	for i = 1, #summary.TimerTypes do
		local skillType = summary.TimerTypes[i]
		if config.NotifyConfig[skillType] ~= nil and config.NotifyConfig[skillType].BuffHitConfig == nil then
			config.NotifyConfig[skillType].BuffHitConfig = {}
			config.NotifyConfig[skillType].BuffHitConfig["Hit"] = true

			for j = 1, #summary.SpecialHitTypes do
				config.NotifyConfig[skillType].BuffHitConfig[summary.SpecialHitTypes[j]] = false
			end

			if skillType == "Clothfly" or
				skillType == "WireBugPowerup" or
				skillType == "Armorskin" or
				skillType == "MegaArmorskin" or
				skillType == "HardshellPowder" or
				skillType == "AdamantSeed" or
				skillType == "GourmetFish" or
				skillType == "Immunizer" or
				skillType == "DashJuice" or
				skillType == "OtomoRunhigh" or
				skillType == "MusicRegen" then
				-- 非攻击性技能，不显示命中数
				config.NotifyConfig[skillType].BuffHitConfig["Hit"] = false
			end
		end
	end
end

local function InitNotifyConfig()
	for i = 1, #summary.TimerTypes do
		local skillType = summary.TimerTypes[i]
		if config.NotifyConfig[skillType] == nil then
			config.NotifyConfig[skillType] = {}
			config.NotifyConfig[skillType].NotifyActivate = true
			config.NotifyConfig[skillType].NotifyDeactivate = true

			if skillType == "ChainCrit" or
				skillType == "KushalaDaoraSoul" or
				skillType == "Resentment" or
				skillType == "Dereliction"
			then
				-- 禁用发动、消失提示
				config.NotifyConfig[skillType].NotifyActivate = false
				config.NotifyConfig[skillType].NotifyDeactivate = false
			elseif skillType == "Coalescence" or
				skillType == "AdrenalineRush" or
				skillType == "StatusTrigger" or
				skillType == "MusicSharpnessRegen" or
				skillType == "MusicRegen" or
				skillType == "BladescaleHoneBow"
			then
				-- 禁用发动提示
				config.NotifyConfig[skillType].NotifyActivate = false
			end
		end
	end
	for i = 1, #summary.GaugeTypes do
		local skillType = summary.GaugeTypes[i]
		if config.NotifyConfig[skillType] == nil then
			config.NotifyConfig[skillType] = {}
			config.NotifyConfig[skillType].NotifyActivate = true
			config.NotifyConfig[skillType].NotifyDeactivate = true
		end
	end
	for i = 1, #summary.ValidRowCounterTypes do
		local skillType = summary.ValidRowCounterTypes[i]
		if config.NotifyConfig[skillType] == nil then
			config.NotifyConfig[skillType] = {}
		end
	end
	if config.NotifyConfig["BladescaleHone"] == nil then
		config.NotifyConfig["BladescaleHone"] = {}
		config.NotifyConfig["BladescaleHone"].NotifyActivate = false
	end

	if config.NotifyConfig["DangoDefender"].NotifyReady == nil then
		config.NotifyConfig["DangoDefender"].NotifyReady = true
	end
	if config.NotifyConfig["Furious"].NotifyReady == nil then
		config.NotifyConfig["Furious"].NotifyReady = true
	end

	InitDisplayBuffConfig()
	InitDisplayInPanelConfig()
	InitAttributeConfig()
	InitHitConfig()
	InitDisplayBuffHitConfig()
end

InitNotifyConfig()
if config.NotifyConfig.DisableAll == nil then
	config.NotifyConfig.DisableAll = false
end

collector.NotifyConfig = config.NotifyConfig

local EnemyCharacterBase = sdk.find_type_definition("snow.enemy.EnemyCharacterBase")
local PlayerBase = sdk.find_type_definition("snow.player.PlayerBase")
local PlayerQuestBase = sdk.find_type_definition("snow.player.PlayerQuestBase")
local QuestManager = sdk.find_type_definition("snow.QuestManager")

re.on_frame(function()
	singletons.RefreshManagers()
end)

---

-- sdk.hook(
--     PlayerBase:get_method("addRengekiPowerup"),
--     function(args)
-- 		-- 不生效
--         SendMessage("技能 连击 已发动")
--     end
-- )
---

-- sdk.hook(PlayerQuestBase:get_method("awake"),
-- 	function(args)
-- 		-- singletons.SendMessage("awake")
-- 	end
-- )

-- sdk.hook(sdk.find_type_definition("snow.gui.GuiManager"):get_method("onPauseEvent(System.Boolean)",
-- 	function (args)
-- 		local success = (sdk.to_int64(args[3]) & 1) == 1
-- 		utils.SetPauseStatus(sdk.to_int64(args[3]))
-- 	end)
-- )
-- sdk.hook(QuestManager:get_method("onPaused(System.Boolean)",
-- 	function (args)
-- 		local success = (sdk.to_int64(args[3]) & 1) == 1
-- 		utils.SetPauseStatus(sdk.to_int64(args[3]))
-- 	end)
-- )

local playerQuest = nil
sdk.hook(PlayerQuestBase:get_method("start"),
	function(args)
		if not config.Enabled then return end

		collector.ResetAllData()
		local this = sdk.to_managed_object(args[2])
		if not this:call("isMaster") then
			return
		end

		playerQuest = this
		-- singletons.SendMessage("start")
	end
)
sdk.hook(PlayerQuestBase:get_method("update"),
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			return
		end

		if playerQuest == nil then playerQuest = sdk.to_managed_object(args[2]) end
	end
)

local beforeBloodyHealth = 0
sdk.hook(PlayerQuestBase:get_method("calcBloodySkillHealVital(snow.hit.EnemyCalcDamageInfo.AfterCalcInfo_DamageSide, System.Boolean)")
	,
	function(args)
		if not config.Enabled then return end

		if playerQuest == nil then
			return
		end
		if not sdk.to_managed_object(args[2]):call("isMaster") then
			return
		end

		beforeBloodyHealth = playerQuest:call("get_PlayerData"):call("getFloatVital")
		-- SendMessage("气血发动" .. beforeBloodyHealth)
	end,
	function(retval)
		if not config.Enabled then return retval end

		if beforeBloodyHealth == 0 then
			return retval
		end

		local afterBloodyHealth = playerQuest:call("get_PlayerData"):call("getFloatVital")
		local bloodyRecover = afterBloodyHealth - beforeBloodyHealth
		beforeBloodyHealth = 0
		-- SendMessage("气血发动后" .. afterBloodyHealth)
		collector.RecordCounter("BloodRite", bloodyRecover)
		return retval
	end
)

local beforeMysteryHealth = 0
sdk.hook(PlayerQuestBase:get_method("calcMysteryDebuffHealVital(snow.hit.EnemyCalcDamageInfo.AfterCalcInfo_DamageSide)")
	,
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			beforeMysteryHealth = 0
			return
		end

		if playerQuest == nil then
			return
		end
		beforeMysteryHealth = playerQuest:call("get_PlayerData"):call("getFloatVital")
		-- SendMessage("气血发动" .. beforeBloodyHealth)
	end,
	function(retval)
		if not config.Enabled then return retval end

		if beforeMysteryHealth == 0 then
			return retval
		end

		local afterMysteryHealth = playerQuest:call("get_PlayerData"):call("getFloatVital")
		local mysteryRecover = afterMysteryHealth - beforeMysteryHealth
		beforeMysteryHealth = 0
		-- SendMessage("劫血发动后" .. afterBloodyHealth)
		collector.RecordCounter("BloodblightHeal", mysteryRecover)
		return retval
	end
)

sdk.hook(PlayerQuestBase:get_method("executeEquipSkill216(System.UInt32)"),
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			return
		end
		collector.RecordCounter("BladescaleHone")
		collector.SkillTrigger("BladescaleHone")
	end,
	function(retval)
		return retval
	end
)

sdk.hook(PlayerQuestBase:get_method("onDestroy"),
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			return
		end

		playerQuest = nil
	end
)

-- sdk.hook(EnemyCharacterBase:get_method("update"),
-- 	function (args)
-- 	end
-- )

-- On accept quest
sdk.hook(
	sdk.find_type_definition("snow.QuestManager"):get_method("questActivate(snow.LobbyManager.QuestIdentifier)"),
	function(args)
		if not config.Enabled then return end

		collector.ResetAllData()
	end
)

sdk.hook(
	PlayerBase:get_method("update"),
	function(args)
		if not config.Enabled then return end

		local playerBase = sdk.to_managed_object(args[2])
		if playerBase:call("isMaster") then
			collector.CurrentHealth = playerBase:call("get_PlayerData"):call("getFloatVital")
		end
	end
)

local function GetEnumMap(enumTypeName)
	local t = sdk.find_type_definition(enumTypeName)
	if not t then return {} end

	local fields = t:get_fields()
	local enum = {}

	for i, field in ipairs(fields) do
		if field:is_static() then
			local name = field:get_name()
			local raw_value = field:get_data(nil)
			enum[raw_value] = name
		end
	end

	return enum
end

local HitOwnerTypeMap = GetEnumMap("snow.hit.DamageFlowOwnerType")
local KeysDef = GetEnumMap("via.hid.KeyboardKey")

-- snow.hit.EnemyCalcDamageInfo.AfterCalcInfo_Damage 可以获取shell或者action id吗
-- getAdjustPhysicalDamageRateBySkill(snow.player.PlayerIndex)

-- snow.enemy.EnemyUtility, getAdjustElementDamageRateFromSkill(snow.player.PlayerIndex, System.Single, snow.DamageReceiver.HitInfo)

-- snow.hit.PreCalcInfo_AttackSideBase, get_FinalDamageAdjustRate()

-- snow.player.PlayerBase
--  getAdjustTotalElement(snow.data.ElementData.ElementType, System.Single)

-- snow.hit.userdata.PlHitAttackRSData

-- snow.player.PlayerQuestBase
-- 	get_ActionStaminaRecoverAdj()
-- 	getRecoverStaminaAdjustCoefficient()
--  getAdjustActionAttack(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  getAdjustWeaponElementTypeValue(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase, snow.data.ElementData.ElementType, System.Single)
--  getAdjustCriticalRate(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  getAdjustStaminaAttack(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  calcGunnerPhysicalAttackResult(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase, System.Single, System.Single)
--  getWeaponAttackAdjust(snow.hit.userdata.PlHitAttackRSData)
--  getPhysicalSharpnessAdjust(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  getElementSharpnessAdjust(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  getHitTimingAdjust(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase)
--  getGunnerPhysicalAttackAdjustRate(snow.hit.userdata.PlHitAttackRSData, snow.hit.DamageFlowInfoBase, snow.DamageReceiver.HitInfo, snow.CharacterBase)
--  似乎这个不生效：calcWeaponAdjustEquipSkill213(System.Single, System.UInt32, snow.hit.userdata.PlHitAttackRSData)

-- snow.player.PlayerSharpnessAdjustRate, getSharpnessAdjustRate(snow.player.PlayerDefine.PlSharpness, snow.player.PlayerSharpnessCategory)


-- snow.Player.PlayerUserDataQuestCommon, get_GunnerDefenseAdjust()

-- 关键词：Adjust, AttackRate, Physic

sdk.hook(sdk.find_type_definition("snow.enemy.EnemyUtility"):get_method("getAdjustElementDamageRateFromSkill(snow.player.PlayerIndex, System.Single, snow.DamageReceiver.HitInfo)"),
	function(args)
		if not config.Enabled then return end
	end,
	function(retval)
		if not config.Enabled then return retval end

		-- 仅属性弱特，属性超会心不算
		local rate = sdk.to_float(retval)
		if rate > 1 then
			collector.RecordCounter("RealElementExploit")
		end
		return retval
	end
)

-- sdk.hook(
-- 	EnemyCharacterBase:get_method("getAdjustPhysicalDamageRateBySkill(snow.player.PlayerIndex)"),
-- 	function (args)
-- 	end,
-- 	function (retval)
-- 			-- 弩倍率
-- 		local rate = sdk.to_float(retval)
-- 		if rate > 1 then
-- 			-- collector.RecordCounter("UnkPhyAdjust")
-- 			-- singletons.SendMessage("你触发了一个未知倍率行为，请告知我:  " .. rate)
-- 		end
-- 		return retval
-- 	end
-- )

local assassinPre = 0
local assassinAfter = 0
sdk.hook(
	PlayerQuestBase:get_method("calcPhysicalDamageAssassin(System.Single, snow.hit.userdata.PlHitAttackRSData, snow.DamageReceiver.HitInfo, snow.CharacterBase)")
	,
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			assassinPre = 0
			return
		end

		-- local casterPlayer = sdk.to_managed_object(args[6])
		-- if casterPlayer ~= singletons.GetMasterPlayer() then -- Multiplayer
		-- 	assassinPre = 0
		-- 	return
		-- end
		assassinPre = sdk.to_float(args[3])
		-- local data = sdk.to_managed_object(args[4])
		-- local sharp = data:call("get_ReduceSharpnessRate")
		-- singletons.ComposeMessage("Sharp: " .. sharp .. ")

		-- local hitInfo = sdk.to_managed_object(args[5]) -- ??
		-- local dmgData = hitInfo:call("get_DamageRSData") -- snow.hit.userdata.BaseHitDamageRSData
		-- local history = dmgData:call("get_History")
		-- for i = 1, #history do
		-- 	singletons.ComposeMessage(i .. ": " .. history[i])
		-- end
		-- singletons.SendMessage()
	end,
	function(retval)
		if not config.Enabled then return retval end

		-- 偷袭，代码内部名：Assassin
		if assassinPre ~= 0 then
			assassinAfter = sdk.to_float(retval)
			local delta = assassinAfter - assassinPre
			local rate = assassinAfter / assassinPre
			-- TODO: 虽然更严谨的做法是检测偷袭技能等级
			-- 但是这个函数是专用的，所以无所谓了
			if rate > 1.049 or delta >= 1 then
				-- 实际最小值是 5%，考虑到舍入问题，很可能需要差值 > 1
				-- 实际记录的值只能作为参考，因为不是最终值，是中间值
				collector.RecordCounter("SneakAttack")
				-- singletons.SendMessage("Assassin:  " .. assassinPre .. " -> " .. sdk.to_float(retval))
			end
		end
		return retval
	end
)

local dmgSharpCost = 0
sdk.hook(
	PlayerQuestBase:get_method("calcNormalPhysicalAttackResult(snow.hit.userdata.PlHitAttackRSData, snow.CharacterBase, snow.player.PlayerQuestBase.CalcNormalPhysicalAttackData)")
	,
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			return
		end

		local attackData = sdk.to_managed_object(args[5])
		local critical = attackData:get_field("_Critical")
		local weaponAdjust = attackData:get_field("_WeaponAdjust")
		-- singletons.ComposeMessage("Crit: ".. critical..", weaponAdj: "..weaponAdjust)

		local data = sdk.to_managed_object(args[3])
		local sharp = data:call("get_ReduceSharpnessRate")
		dmgSharpCost = sharp

		-- singletons.ComposeMessage("Sharp: " .. sharp)

		local resIdx = data:call("get_RequestSetResourseIndex()")
		local setId = data:call("get_RequestSetID")
		-- singletons.ComposeMessage("Idx: " .. resIdx .. ", setId: " .. setId)
		-- local hitInfo = sdk.to_managed_object(args[5]) -- ??
		-- local dmgData = hitInfo:call("get_DamageRSData") -- snow.hit.userdata.BaseHitDamageRSData
		-- local history = dmgData:call("get_History")
		-- for i = 1, #history do
		-- 	singletons.ComposeMessage(i .. ": " .. history[i])
		-- end
		-- singletons.SendMessage()
	end,
	function(retval)
		if not config.Enabled then return retval end

		local ret = sdk.to_float(retval)
		-- singletons.ComposeMessage("ret:  " .. ret)
		-- singletons.SendMessage()
		return retval
	end
)

-- 蓄力大师 calcDebuffDamageChargeMaster(System.Single, snow.hit.userdata.PlHitAttackRSData)
-- 蓄力大师 calcDebuffDamageChargeMaster(System.Single, snow.hit.userdata.PlHitAttackRSData)
-- 达人艺？？ calcHitReduceSharpness(snow.hit.userdata.PlHitAttackRSData, snow.player.PlayerHitResponse)
-- afterCalcDamage_AttackSide(snow.hit.DamageFlowInfoBase, snow.DamageReceiver.HitInfo)

-- calcDamageValue(snow.hit.userdata.BaseHitAttackRSData, snow.hit.DamageFlowInfoBase)

-- calcDamage_DamageSide(snow.hit.DamageFlowInfoBase, snow.hit.DamageFlowInfoBase, snow.DamageReceiver.HitInfo)

-- sdk.hook(
-- 	PlayerQuestBase:get_method("calcDamage_DamageSide(snow.hit.DamageFlowInfoBase, snow.hit.DamageFlowInfoBase, snow.DamageReceiver.HitInfo)"),
-- 	function (args)
-- 		-- singletons.SendMessage("HP_A: "..playerQuestBase:call("get_PlayerData"):call("getFloatVital"))
-- 	end,
-- 	function (retval)
-- 		-- singletons.SendMessage("HP_A2: "..playerQuestBase:call("get_PlayerData"):call("getFloatVital"))
-- 		return retval
-- 	end
-- )

local function divineBlessingLevel()
	local skillList = playerQuest:call("get_PlayerSkillList") -- snow.player.PlayerSkillLisst
	local skillDataArr = skillList:get_field("_PlayerSkillData") -- snow.player.PlayerSkillData[]

	for i = 1, #skillDataArr do
		local skillData = skillDataArr[i - 1] -- snow.player.PlayerSkillData
		if skillData then
			local skillID = skillData:get_field("SkillId") -- snow.DataDef.PlEquipSkillId
			local skillLv = skillData:get_field("SkillLv") -- uint32
			if skillID == utils.NormalizeSkillID(56) then
				return skillLv
			end
		end
	end
	return 0
end

local function dangoBlessingLevel()
	local skillList = playerQuest:call("get_PlayerSkillList") -- snow.player.PlayerSkillLisst
	local skillDataArr = skillList:call("get_KitchenSkillData") -- snow.player.PlayerKitchenSkillData[]

	for i = 1, #skillDataArr do
		local skillData = skillDataArr[i - 1] -- snow.player.PlayerSkillData
		if skillData then
			local skillID = skillData:get_field("_SkillId") -- snow.DataDef.PlEquipSkillId
			local skillLv = skillData:get_field("_SkillLv") -- uint32
			if skillID == 11 or skillID == 12 then
				-- 团子防御小 团子防御大
				return skillLv
			end
		end
	end
	return 0
end

local function dangoDefenderLevel()
	local skillList = playerQuest:call("get_PlayerSkillList") -- snow.player.PlayerSkillLisst
	local skillDataArr = skillList:call("get_KitchenSkillData") -- snow.player.PlayerKitchenSkillData[]

	for i = 1, #skillDataArr do
		local skillData = skillDataArr[i - 1] -- snow.player.PlayerSkillData
		if skillData then
			local skillID = skillData:get_field("_SkillId") -- snow.DataDef.PlEquipSkillId
			local skillLv = skillData:get_field("_SkillLv") -- uint32
			if skillID == 49 then
				-- 团子防护术
				return skillLv
			end
		end
	end
	return 0
end

-- 精灵加护：0.85，0.7，0.5
-- 团子防御、团子防护：0.8, 0.7, 0.6, 0.5
local DivineBlessingRate = {
	[0] = 1,
	[1] = 0.85,
	[2] = 0.7,
	[3] = 0.5,
}

local DangoBlessingRate = {
	[0] = 1,
	[1] = 0.8,
	[2] = 0.7,
	[3] = 0.6,
	[4] = 0.5,
}

local DangoDefenseRate = {
	[0] = 1,
	[1] = 0.8,
	[2] = 0.7,
	[3] = 0.6,
	[4] = 0.5,
}

-- 真正掉血是在这个函数发生的
local preDamageHp = 0
local rawDamage = 0
local dangoDefenseReady = false
sdk.hook(
	PlayerQuestBase:get_method("checkDamage_calcDamage(System.Single, System.Single, snow.player.PlayerDamageInfo, System.Boolean)")
	,
	function(args)
		if not config.Enabled then return end

		if not sdk.to_managed_object(args[2]):call("isMaster") then
			rawDamage = 0
			return
		end

		local dango = playerQuest:call("get_PlayerData"):get_field("_KitchenSkill048_Damage")
		if dango >= 200 then
			dangoDefenseReady = true
		else
			dangoDefenseReady = false
		end

		rawDamage = sdk.to_float(args[3])
		-- singletons.ComposeMessage("Arg1: ".. rawDamage .. ", args2: " .. sdk.to_float(args[4]) .. ", dango: "  .. dango)
		preDamageHp = playerQuest:call("get_PlayerData"):call("getFloatVital")
	end,
	function(retval)
		if not config.Enabled then return retval end

		if rawDamage == nil or rawDamage == 0 or rawDamage == 1 then
			return retval
		end
		local postDamageHp = playerQuest:call("get_PlayerData"):call("getFloatVital")
		if postDamageHp == 0 then
			return retval
		end

		-- 没有减伤
		local actualDamage = (preDamageHp - postDamageHp)
		if rawDamage == actualDamage then
			return retval
		end

		-- singletons.ComposeMessage("精灵加护等级："..divineBlessingLevel().."，团子防御等级："..dangoBlessingLevel())
		local divineBlessingLV = divineBlessingLevel()
		local factorDivineBlessing = DivineBlessingRate[divineBlessingLV]

		local dangoBlessingLV = dangoBlessingLevel()
		local factorDangoBlessing = DangoBlessingRate[dangoBlessingLV]

		local dangoDefenderLV = dangoDefenderLevel()
		local factorDangoDefender = 1
		if dangoDefenseReady then
			factorDangoDefender = DangoDefenseRate[dangoDefenderLV]
		end

		-- 预测

		if dangoDefenseReady then
			-- singletons.ComposeMessage("团子防护术"..dangoDefenseLV.." 发动")
			collector.RecordCounter("DangoDefender")
			collector.RecordCounter("DangoDefenderValue", rawDamage * (1 - factorDangoDefender))
		end

		local baseFactor = factorDangoDefender
		if math.floor(rawDamage * baseFactor) == actualDamage then
			-- 仅防护术
		elseif math.floor(rawDamage * baseFactor * factorDivineBlessing) == actualDamage then
			-- 防护术+加护
			-- 也可能是减伤率等于加护的防御术
			if (divineBlessingLV == 2 and dangoBlessingLV == 2) or (divineBlessingLV == 3 and dangoBlessingLV == 4) then
				-- singletons.ComposeMessage("精灵加护"..divineBlessingLV.."或团子防御术"..dangoBlessingLV.." 发动")
				collector.SkillTrigger("DivineBlessing")
			else
				collector.SkillTrigger("DivineBlessing")
			end

			collector.RecordCounter("DivineBlessing")
			collector.RecordCounter("DivineBlessingValue", rawDamage * (1 - factorDivineBlessing))
		elseif math.floor(rawDamage * baseFactor * factorDangoBlessing) == actualDamage then
			-- 防护术+防御术，不会是加护，因为这个 branch 优先级比较低
			collector.SkillTrigger("DangoBlessing")
			collector.RecordCounter("DangoBlessing")
			collector.RecordCounter("DangoBlessingValue", rawDamage * (1 - factorDangoBlessing))
		elseif math.floor(rawDamage * baseFactor * factorDivineBlessing * factorDangoBlessing) == actualDamage then
			-- 三个都发动了
			collector.SkillTrigger("DivineBlessing")
			collector.RecordCounter("DivineBlessing")
			collector.RecordCounter("DivineBlessingValue", rawDamage * (1 - factorDivineBlessing))
			collector.SkillTrigger("DangoBlessing")
			collector.RecordCounter("DangoBlessing")
			collector.RecordCounter("DangoBlessingValue", rawDamage * (1 - factorDangoBlessing))
		else
			local dango = playerQuest:call("get_PlayerData"):get_field("_KitchenSkill048_Damage")
			-- singletons.ComposeMessage("DamageTaken: "..actualDamage.. ", dango: "  .. dango)
			if postDamageHp > 0 and actualDamage ~= rawDamage and rawDamage ~= 0 then
				-- singletons.ComposeMessage("DefenseRate: ".. actualDamage/rawDamage)
			end
		end

		-- singletons.SendMessage()

		return retval
	end
)

-- sdk.hook(
-- 	PlayerQuestBase:get_method("calcKitchenSkill048Damage(System.Single)"),
-- 	function (args)
-- 		local dango = sdk.to_float(args[3])
-- 		-- 似乎不生效
-- 		-- singletons.SendMessage("DangoDMG: "  .. dango)
-- 	end
-- )

-- sdk.hook(
-- 	EnemyCharacterBase:get_method("calcDamageCore(snow.enemy.EnemyDamageCalcParam)"),
-- 	function (args)

-- 	end,
-- 	function (retval)
-- 		-- snow.hit.EnemyCalcDamageInfo.AfterCalcInfo_DamageSide
-- 		return retval
-- 	end
-- )

-- 联机会出问题，这只是权宜之计
local isForay = false
sdk.hook(EnemyCharacterBase:get_method("isCheckApplyConditionForPlSkill213"),
	function(args)
		if not config.Enabled then return end


	end,
	function(retval)
		if not config.Enabled then return retval end

		local success = (sdk.to_int64(retval) & 1)
		isForay = success == 1
		if success == 1 then
			-- collector.RecordCounter("Foray")
			-- singletons.SendMessage("攻势")
		elseif success == 0 then
		end
		return retval
	end
)

local afterCalcInfo
local lastRecordBuffCoveredHitTime = 0
sdk.hook(
	sdk.find_type_definition("snow.enemy.EnemyUtility"):get_method("getHitUIColorType"),
	function(args)
		if not config.Enabled then return end

		afterCalcInfo = sdk.to_managed_object(args[2]);
	end,

	function(retval)
		if not config.Enabled then return retval end

		-- snow.hit.EnemyCalcDamageInfo.AfterCalcInfo_Damage
		local calcParam = afterCalcInfo:get_field("_CalcParam"); -- snow.enemy.EnemyDamageCalcParam
		local ownerType = calcParam:call("get_OwnerType()"); -- snow.hit.DamageFlowOwnerType

		-- 3 is Player, 4 is PlayerShell aka following damage
		if ownerType ~= 3 and ownerType ~= 4 then
			return retval
		end
		if isForay then
			collector.RecordCounter("Foray")
		end

		local calcType = calcParam:call("get_CalcType()"); -- snow.enemy.EnemyDef.DamageCalcType
		local elementMeatAdjustRate = calcParam:call("get_ElementMeatAdjustRate()")
		local physicalMeatAdjustRate = calcParam:call("get_PhysicalMeatAdjustRate()")

		if (assassinAfter - assassinPre) > 0.05 then
			local meat = math.floor(physicalMeatAdjustRate * 100)

			local beforeDmg = math.floor(assassinPre * meat / 100.0 + 0.5)
			local afterDmg = math.floor(assassinAfter * meat / 100.0 + 0.5)
			-- singletons.SendMessage("Meat: " .. meat .. ", After: " .. afterDmg..", Before: ".. beforeDmg)
			collector.RecordCounter("SneakAttackValue", afterDmg - beforeDmg)
		end

		local isElement = false
		local isElementExploit = false
		local elementDmg = afterCalcInfo:call("get_ElementDamage");
		if elementDmg ~= nil and elementDmg > 0 then
			-- TODO：伤害构成中有元素伤害
			isElement = true
			collector.RecordCounter("ElementHit")
			if 1 > elementMeatAdjustRate and elementMeatAdjustRate >= 0.199 then
				isElementExploit = true
				collector.RecordCounter("ElementExploitHit")
			end
		end

		local isCritical = afterCalcInfo:call("get_CriticalResult") == 1
		local isMindEye = retval == sdk.to_ptr(0)
		local isPhysicsExploit = false
		-- 0 is slash, 1 is strike
		if calcType == 0 or calcType == 1 then
			-- if ownerType == 3 then
			if dmgSharpCost > 0 then
				-- 达人艺的与总会心率不同，它只在掉斩的动作上生效
				-- PlayerShell 一般都不掉斩，但 Player 的一些动作也是不掉斩的
				-- 因此需要从：snow.hit.userdata.PlHitAttackRSData 的 ReduceSharpnessRate 中获取（达人艺不改变这个值）
				collector.RecordCounter("MasterTouchHit")
				if isCritical then
					collector.RecordCounter("MasterTouchCriticalHit")
				end
			end

			collector.RecordCounter("PhysicsHit")
			-- color is incorrect
			if 1 > physicalMeatAdjustRate and physicalMeatAdjustRate >= 0.449 then
				isPhysicsExploit = true
				collector.RecordCounter("PhysicsExploitHit")
			end

			-- 因为斩味等会影响伤害颜色，只能通过伤害颜色而非肉质来判断心眼的触发
			-- 例如：红斩味天彗太刀气刃1打青蛙腿约33+2伤害，而心眼3打青蛙腿可以有42+2，刚好1.3倍
			-- 而白斩的天彗伤害数字是一样的
			-- 此外，心眼对 PlayerShell 伤害也有效
			if isMindEye then
				collector.RecordCounter("MindEyeHit")
			end
		elseif calcType == 2 then
			collector.RecordCounter("PhysicsHit")
			if retval == sdk.to_ptr(1) then
				isPhysicsExploit = true
				collector.RecordCounter("PhysicsExploitHit")
			end
		else
			-- 3 is IgnoreMeat, 4 is Friendly fire, just ignore they
		end

		-- --- 记录伤害发生时的 Buff 数据 ---
		local time = utils.GetTime()
		collector.RecordCounter("Hit")
		if isCritical then
			collector.RecordCounter("CriticalHit") -- 会心击
			if isElement then
				collector.RecordCounter("ElementCriticalHit") -- 会心击【属性】
			end
		end
		if time > lastRecordBuffCoveredHitTime then
			local player = singletons.GetMasterPlayer()
			if player == nil then return end
			collector.CollectData(time, player, playerQuest)

			collector.RecordHitBuffs(isCritical, isPhysicsExploit, isMindEye, isElement, isElementExploit)
		end
		lastRecordBuffCoveredHitTime = time

		return retval
	end
)

-- sdk.hook(
--     EnemyCharacterBase:get_method("afterCalcDamage_DamageSide"),
--     function(args)
--         local afterCalcInfo=sdk.to_managed_object(args[3])
-- 	end
-- )

-- sdk.hook(
-- 	PlayerQuestBase:get_method("calcWeaponAdjustEquipSkill213(System.Single, System.UInt32, snow.hit.userdata.PlHitAttackRSData)"),
-- 	function (args)
-- 		-- 不生效
-- 		-- singletons.SendMessage("攻势 已发动")
-- 	end
-- )

-- snow.enemy.EmBossCharacterBase

local keyboard = sdk.call_native_func(sdk.get_native_singleton("via.hid.Keyboard"), sdk.find_type_definition("via.hid.Keyboard"), "get_Device")
local gamepad = sdk.call_native_func(sdk.get_native_singleton("via.hid.GamePad"),
sdk.find_type_definition("via.hid.GamePad"), "get_Device");

re.on_frame(function ()
	if not config.Enabled then return end

	if not keyboard then
		keyboard = sdk.call_native_func(sdk.get_native_singleton("via.hid.Keyboard"), sdk.find_type_definition("via.hid.Keyboard"), "get_Device")
	end
	if keyboard ~= nil then
		local released = keyboard:call("isRelease", config.KeyboardHotKey)
		if released then
			config.EnablePanel = not config.EnablePanel
		end
	end

	if not gamepad then
		gamepad = sdk.call_native_func(sdk.get_native_singleton("via.hid.GamePad"), sdk.find_type_definition("via.hid.GamePad"), "get_Device");
	end
end)

local windowFont
local buffFont
local function initFont()
	if config.WindowSettings.FontSize == nil or config.WindowSettings.FontSize <= 8 then
		config.WindowSettings.FontSize = 8
	end
	windowFont = d2d.Font.new("Tahoma", config.WindowSettings.FontSize, true)
	if config.BuffSettings.FontSize == nil or config.BuffSettings.FontSize <= 8 then
		config.BuffSettings.FontSize = 8
	end
	buffFont = d2d.Font.new("Tahoma", config.BuffSettings.FontSize, true)
end
d2d.register(function()
	initFont()
end,
	function()
		if not config.Enabled then return end

		initFont()

		-- 放一起而不是分开，保证调用顺序
		local inBattle = singletons.CheckIfInBattle()
		local training = singletons.IsInTrainingArea()
		local complete = singletons.QuestComplete()

		-- We need this. If not, the CollectData will be call but 2 calls of EndAllRecord inside OnUpdateSummaryUI will be called.
		-- I guess that's because in some loading screen state, the three condition is not in a expected value.
		local shouldCollectData = training or (inBattle and (not complete))
		if shouldCollectData then
			local player = singletons.GetMasterPlayer()
			if player == nil then return end
			collector.CollectData(utils.GetTime(), player, playerQuest)
		end

		if config.EnablePanel then
			summary.OnUpdateSummaryUI(windowFont, config.AttributeConfig, config.NotifyConfig, config.HitConfig, collector, singletons, utils, localization)
		end

		if config.EnableBuff then
			summary.DrawBars(buffFont, config.NotifyConfig, collector, singletons)
		end

		if false then
		-- if true then
			debug.DebugUI(collector, singletons, singletons.GetMasterPlayer(), playerQuest)
		end
	end
)

----------- Font ---------------------------
FONT_NAME = 'NotoSansSC-Regular.otf'
FONT_SIZE = 18
CJK_GLYPH_RANGES = {
	0x0020, 0x00FF, -- Basic Latin + Latin Supplement
	0x2000, 0x206F, -- General Punctuation
	0x3000, 0x30FF, -- CJK Symbols and Punctuations, Hiragana, Katakana
	0x31F0, 0x31FF, -- Katakana Phonetic Extensions
	0xFF00, 0xFFEF, -- Half-width characters
	0x4e00, 0x9FAF, -- CJK Ideograms
	0,
}

local font = imgui.load_font(FONT_NAME, FONT_SIZE, CJK_GLYPH_RANGES)

local function DrawSkillOption(skillType)
	if imgui.tree_node(localization.RowName(skillType)) then
		local conf = config.NotifyConfig[skillType]
		if conf == nil then
			imgui.text(skillType .. " conf is nil!")
			return false
		end

		local configChanged = false
		local changed = false
		local needNewLine = false

		if config.NotifyConfig[skillType].DisplayInPanel ~= nil then
			changed, config.NotifyConfig[skillType].DisplayInPanel = imgui.checkbox("Display",
				config.NotifyConfig[skillType].DisplayInPanel)
			configChanged = configChanged or changed
			imgui.same_line()
		end
		if config.NotifyConfig[skillType].DisplayBuffBar ~= nil then
			changed, config.NotifyConfig[skillType].DisplayBuffBar = imgui.checkbox("DisplayBuffBar",
				config.NotifyConfig[skillType].DisplayBuffBar)
			configChanged = configChanged or changed
			imgui.same_line()
		end
		if config.NotifyConfig[skillType].NotifyActivate ~= nil then
			changed, config.NotifyConfig[skillType].NotifyActivate = imgui.checkbox("NotifyActive",
				config.NotifyConfig[skillType].NotifyActivate)
			configChanged = configChanged or changed
			imgui.same_line()
			needNewLine = true
		end
		if config.NotifyConfig[skillType].NotifyDeactivate ~= nil then
			changed, config.NotifyConfig[skillType].NotifyDeactivate = imgui.checkbox("NotifyEnd",
				config.NotifyConfig[skillType].NotifyDeactivate)
			configChanged = configChanged or changed
			imgui.same_line()
			needNewLine = true
		end
		if config.NotifyConfig[skillType].NotifyReady ~= nil then
			changed, config.NotifyConfig[skillType].NotifyReady = imgui.checkbox("NotifyReady",
				config.NotifyConfig[skillType].NotifyReady)
			configChanged = configChanged or changed
			imgui.same_line()
			needNewLine = true
		end
		if needNewLine then
			imgui.new_line()
			needNewLine = false
		end

		if config.NotifyConfig[skillType] ~= nil and config.NotifyConfig[skillType].BuffHitConfig ~= nil then
			for j = 0, #summary.SpecialHitTypes do
				local hitType = "Hit"
				if j > 0 then
					hitType = summary.SpecialHitTypes[j]
				end
				changed, config.NotifyConfig[skillType].BuffHitConfig[hitType] =
				imgui.checkbox(hitType, config.NotifyConfig[skillType].BuffHitConfig[hitType])
				configChanged = configChanged or changed
				imgui.same_line()
			end
		end

		imgui.new_line()
		imgui.tree_pop()
		return configChanged
	else
		return false
	end
end

re.on_draw_ui(function()
	local configChanged = false
	imgui.push_font(font)
	if imgui.tree_node("LingSamuel's Data Reporter") then
		local changed = false
		changed, config.Enabled = imgui.checkbox("Enabled", config.Enabled)
		configChanged = configChanged or changed
		changed, config.EnablePanel = imgui.checkbox("Enable Panel", config.EnablePanel)
		configChanged = configChanged or changed
		changed, config.EnableBuff = imgui.checkbox("Enable Buff", config.EnableBuff)
		configChanged = configChanged or changed
		changed, config.NotifyConfig.DisableAll = imgui.checkbox("Disable All Notification", config.NotifyConfig.DisableAll)
		configChanged = configChanged or changed

		local langIdx = FindIndex(localization.Languages, config.Language)
		changed, langIdx = imgui.combo("Language", langIdx, localization.Languages)
		configChanged = configChanged or changed
		config.Language = localization.Languages[langIdx]

		changed, config.KeyboardHotKey = imgui.combo("HotKey", config.KeyboardHotKey, KeysDef)
		configChanged = configChanged or changed

		if imgui.tree_node("Customize Stats Panel") then
			_, config.WindowSettings.FontSize = imgui.slider_int("Font Size", config.WindowSettings.FontSize, 8, 40)
			_, config.WindowSettings.Width = imgui.drag_int("Width", config.WindowSettings.Width, 10, 300, 800)
			_, config.WindowSettings.PosX = imgui.drag_int("PosX", config.WindowSettings.PosX, 20, 0, 4000)
			_, config.WindowSettings.PosY = imgui.drag_int("PosY", config.WindowSettings.PosY, 20, 0, 4000)
			_, config.WindowSettings.RowHeight = imgui.drag_int("RowHeight", config.WindowSettings.RowHeight, 1, 10, 100)
			_, config.WindowSettings.Indent = imgui.drag_int("Indent", config.WindowSettings.Indent, 1, 5, 20)
			_, config.WindowSettings.ColumnAOffset = imgui.drag_int("ColumnAOffset", config.WindowSettings.ColumnAOffset, 1, 100, 500)
			_, config.WindowSettings.ColumnBOffset = imgui.drag_int("ColumnBOffset", config.WindowSettings.ColumnBOffset, 1, 100, 500)

			if imgui.tree_node("Change color") then
				changed, config.WindowSettings.FontColor = imgui.color_picker_argb("Font Color", config.WindowSettings.FontColor, 0x40000)
				configChanged = configChanged or changed
				changed, config.WindowSettings.BackgroundColor = imgui.color_picker_argb("Background Color", config.WindowSettings.BackgroundColor, 0x40000)
				configChanged = configChanged or changed
				imgui.tree_pop()
			end
			-- local change, value = imgui.slider_int("FontSize", , 12, 28)
			summary.PanelOpts = config.WindowSettings
			imgui.tree_pop()
		end
		summary.PanelOpts = config.WindowSettings

		if imgui.tree_node("Customize Buff") then
			_, config.BuffSettings.FontSize = imgui.slider_int("Font Size", config.BuffSettings.FontSize, 8, 40)
			_, config.BuffSettings.BarWidth = imgui.drag_int("BarWidth", config.BuffSettings.BarWidth, 5, 60, 800)
			_, config.BuffSettings.PosX = imgui.drag_int("PosX", config.BuffSettings.PosX, 20, 0, 4000)
			_, config.BuffSettings.PosY = imgui.drag_int("PosY", config.BuffSettings.PosY, 20, 0, 4000)
			_, config.BuffSettings.Height = imgui.slider_int("Height", config.BuffSettings.Height, 10, 40)
			_, config.BuffSettings.BorderWidth = imgui.slider_int("BorderWidth", config.BuffSettings.BorderWidth, 1, 10)
			_, config.BuffSettings.Indent = imgui.slider_int("Indent", config.BuffSettings.Indent, 5, 20)

			if imgui.tree_node("Change color") then
				changed, config.BuffSettings.FontColor = imgui.color_picker_argb("Font Color", config.BuffSettings.FontColor, 0x40000)
				configChanged = configChanged or changed
				changed, config.BuffSettings.BackgroundColor = imgui.color_picker_argb("Background Color", config.BuffSettings.BackgroundColor, 0x40000)
				configChanged = configChanged or changed
				changed, config.BuffSettings.BarColor = imgui.color_picker_argb("Bar Color", config.BuffSettings.BarColor, 0x40000)
				configChanged = configChanged or changed
				imgui.tree_pop()
			end
			summary.BuffOpts = config.BuffSettings

			imgui.tree_pop()
		end

		if imgui.tree_node("Skill Config") then
			for i = 1, #summary.TimerTypes do
				changed = DrawSkillOption(summary.TimerTypes[i])
				configChanged = configChanged or changed
			end
			for i = 1, #summary.ValidRowCounterTypes do
				changed = DrawSkillOption(summary.ValidRowCounterTypes[i])
				configChanged = configChanged or changed
			end
			imgui.tree_pop()
		end

		if imgui.tree_node("Hit Config") then
			for i = 1, #summary.SpecialHitTypes do
				local hitType = summary.SpecialHitTypes[i]
				changed, config.HitConfig[hitType] = imgui.checkbox(hitType, config.HitConfig[hitType])
				configChanged = configChanged or changed
			end
			imgui.tree_pop()
		end

		if imgui.tree_node("Attribute Config") then
			for i = 1, #summary.Attributes do
				local attr = summary.Attributes[i]
				changed, config.AttributeConfig[attr] = imgui.checkbox(attr, config.AttributeConfig[attr])
				configChanged = configChanged or changed
			end
			imgui.tree_pop()
		end

		if imgui.button("Reset Notification Config") then
			config.NotifyConfig = {}
			InitNotifyConfig()
		end
		imgui.tree_pop()
	end
	imgui.pop_font();

	if configChanged then
		json.dump_file("lingsamuels-data-reporter.json", config)
	end
end)

re.on_config_save(function()
	json.dump_file("lingsamuels-data-reporter.json", config)
end)
