# LingSamuel's Data Reporter

Report how long a skill has covered your fight. Almost every skill.

## Supported Features

### Display Stats In-Time

Currently, the mod displays HP, atk and element atk, affinity, and defense at the top of the report panel.

### Skills Activate/Deacviate Notification, And Covered Time

- Bloodblight
- Clothfly, Cutterfly, Red/Gold Wirebug
- Demondrug, MegaDemondrug, DemonPowder
- Armorskin, MegaArmorskin, HardshellPowder
- GourmetFish
- Otomo Roar, Otomo Dance, Otomo Drum
- MaximumMight, LatentPower, AffinitySliding, WallRun
- ProtectivePolish, Grinder, Counterstrike, OffensiveGuard, Agitator
- Furious
- BladescaleHone (Bow)
- AdrenalineRush, StatusTrigger
- MusicSharpnessRegen, MusicRegen
- Dereliction
- VirusOvercome
- Coalescence
- Heroics, KitchenHeroics
- Resuscitate, Peak Performance, Resentment
- Dragonheart
- ChainCrit, KushalaDaoraSoul (both support level I and II)
- Divine Blessing, Dango Defender

Especially, "MightSeed" shares a timer with Butterflame and some other buffs, I currently can't distinguish them, so I named it "Attack up". AdamantSeed, Immunizer, and DashJuice also have similar problems, I rename them to effect instead of the item name.

Some notifications, like peak performance, resentment, chain crit, and KushalaDaoraSoul level 1, are disabled by default because they are obvious.
Some skills have in-game notifications, like Coalescence, these skills only notify deactivate by default.

All notification is configurable.

### Skills Readiness Notification

- Dango Defender
- Furious

### Calculator

- Bloodblight Healing
- Blood Rite Healing
- Bladescale Hone trigger counter
- Foray trigger counter
- Sneak Attack trigger counter and extra damage dealt
- Divine Blessing/Dango Defender/Dango Defender (Hi) trigger counter and total damage reduction
- Master touch buffable hit rate. Calculate precisely by counting sharpness-consumed and critical hits. This means that if some hits don't consume sharpness, like LongSword's Spirit Helm Breaker, won't be counted.
- Physical weakness hit count and hit rate.
- Elemental weakness hit count and hit rate. Please note that the denominator is the count of hits with elemental damage. That means if you hit 100 times but only once contains elemental damage and it hits the element weakness, then your elemental weakness hit count will be 1, and the elemental weakness hit rate will be 100%. There is an elemental weakness counter that you can use to know how many elemental hits you actually have done.
- Bad hitzones hit rate, also means Mind Eye will take effect. Judged by damage color because several factors such as sharpness and hitzone influence MindEye determination together.

## Planned Features

- Wirebug-related skills
- More otomo and Dango skills
- Resistance
- Part breaker, charge master, etc
- Buff remaining timers
- Weapon buffs
- More endemic life, such as Lampsquid
- Horn music
- Calculate the buff covered rate by how many hits it covered. This data gives a better representation of how the buffs affect hunting. For example, you may have a very high Agitator coverage, but the damage you deal while the Agitator is in effect could be not very high.

## Further Research Needed Features

- For some skills, I couldn't find a good way to get the data. For example, I don't know how to get QuickBreath's remaining cooldown right now (although I know it has a fixed cooldown based on your SkillLv).
- Some data are grabbed from Enemy's function hook, like Foray, they may not work or calculate wrong in multiplayer. I made some simple workarounds but I haven't tested them yet.

---

## What do these fields mean?

In general, these fields are grouped into two categories, timer and counter.

Most skills are Timer, where they take effect for a certain amount of time. The mod records the activated duration of these skills in battle.

Other skills are Counter, which is non-continuous each time they take effect. Some related values like how much damage SneakAttack dealt are recorded accordingly.

Hit-related fields are explained above.

If you still get confused about some fields, please leave a comment.

## Known Problems

### Agitator

Because of some Capcom behavior, Agitator MAY switch quickly from active to inactive outside battle and the notification MAY spam your chat.

I considered adding some limitations to it, but haven't implemented it yet. You could disable the notification of it to avoid the problem.

### Reset Script Freeze

For some reason I don't understand, this mod seems to have a low probability of causing the game to freeze randomly when using the "reset script" feature of REFramework. Waiting a moment or switching the focused window might help the game to recover. I'm not sure if this is related to auto-saving or something else.

Other than that, everything works fine with the script.
The script works fine, but I'm not a Lua expert, so if you find some performance bugs or errors in the script, please contact me.

### Potential Performance Impact

I am not a Lua expert and this mod is obviously a script-heavy mod. It MAY affect your framerate. No significant performance loss has been observed on my computer but I have no guarantees about that because I have a very strong computer.

If you encountered any performance issues, please leave a comment.

### Compatiblity

All the features listed above were tested by me during the initial implementation.

But I can't guarantee that they are still available now as my work progresses. They are just too many for me to test one by one.

### Multiplayer Compatibility

Many skills have been tested by me to work properly in multiplayer games. But some of them are not (waht I know is SneakAttack and Foray), and I haven't tested my workaround solution yet.

They should work well in single-player, and most of the other features should work fine in multiplayer as well.

## About Translations

I am not an English native speaker and I don't know much about the MH-related terms and abbreviations in English. So if you have a better translation, please leave a comment, thanks!

### Dango Denfender Hi and Low

Dango Defender Hi has the same damage reduction rate as Dango Defender Low, so I didn't distinguish them in the report panel. I can't ignore the Hi/Low mark because there is a real "Dango Defender".

If you have a better term to solve this small problem, please leave a comment.

## Special Thanks

Thanks to Raff's mod utils. I learn how the weapon works with PlayerQuestBase and how to detect in-battle from it.
Thanks to praydog, the author of REFramework. Besides the great framework, he teaches me how to resolve an access violation problem.
