local M = {
    Counter = {},

    BuffCoveredHitCounter = {},

    TimeRecord = {},
    InBattleRecord = {},
    SkillStatusData = {},

    lastRengekiCount = 0,
    lastDragonCount = 0,
    lastSymbiosisVital = 0,
    dangoDefenseReady = false,
    wholeBodyPrepareDeactivate = false,
    wholeBodyFirstTriggered = false,
    wholeBodyActivated = false,
    lastDemonDrug = 0,
    lastArmorSkin = 0,
    furiousReady = false,
    lastAgitatorNotifyTime = 0,

    lastCollectTime = 0,

    InBattle = false,
    TotalInBattleTime = 0,
    LastInBattleTime = 0,
}

function M.ResetAllData()
    M.Counter = {}

    -- SkillName -> HitType -> HitCount
    M.BuffCoveredHitCounter = {}

    M.TimeRecord = {}
    M.InBattleRecord = {}
    M.SkillStatusData = {}
    M.BuffBars.Skills = {}

    M.lastRengekiCount = 0
    M.lastDragonCount = 0
    M.lastSymbiosisVital = 0
    M.dangoDefenseReady = false
    M.wholeBodyPrepareDeactivate = false
    M.wholeBodyFirstTriggered = false
    M.wholeBodyActivated = false
    M.lastDemonDrug = 0
    M.lastArmorSkin = 0
    M.furiousReady = false
    M.lastAgitatorNotifyTime = 0

    M.lastCollectTime = 0

    M.InBattle = false
    M.TotalInBattleTime = 0
    M.LastInBattleTime = 0
end

M.utils = nil
M.localization = nil
M.singletons = nil

M.CurrentHealth = 0
M.NotifyConfig = {}

local function SkillReady(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig[typename]
    if conf ~= nil and conf.NotifyReady == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().SkillReady, name))
end

local function SkillTrigger(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig[typename]
    if conf ~= nil and conf.NotifyActivate == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().SkillActivated, name))
end

local function SkillEnd(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig[typename]
    if conf ~= nil and conf.NotifyDeactivate == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().SkillEnd, name))
end

local function ItemTrigger(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig[typename]
    if conf ~= nil and conf.NotifyReady == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().ItemActivated, name))
end

local function ItemEnd(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig[typename]
    if conf ~= nil and conf.NotifyDeactivate == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().ItemEnd, name))
end

local function DerelictionReset(typename)
    if M.NotifyConfig.DisableAll == true then return end
    local conf = M.NotifyConfig["Dereliction"]
    if conf ~= nil and conf.NotifyDeactivate == false then return end

    local name = M.localization.RowName(typename)
    if name == nil then name = typename end
    M.singletons.ComposeMessage(string.format(M.localization.Localized().DerelictionReset, name))
end


local BuffBars = {
    Rows = 0,

    Skills = {},
}
M.BuffBars = BuffBars

local function InitBuffBar(skillName, timer, max)
    if timer == nil or timer <= 1 then
        if BuffBars.Skills[skillName] ~= nil then
            BuffBars.Skills[skillName] = nil
        end
        return
    end

    if BuffBars.Skills[skillName] == nil then
        BuffBars.Skills[skillName] = {}
        BuffBars.Skills[skillName].MaxTimer = 0
        -- BuffBars.Skills[skillName].Rows = BuffBars.Rows
        -- BuffBars.Rows = BuffBars.Rows + 1
    end

    BuffBars.Skills[skillName].CurrentTimer = timer
    if max ~= nil and max ~= 0 then
        BuffBars.Skills[skillName].MaxTimer = max * 60
    elseif timer > BuffBars.Skills[skillName].MaxTimer then
        BuffBars.Skills[skillName].MaxTimer = timer
    end
end

function M.RecordTimerSkillActivate(skillName)
    if M.TimeRecord[skillName] == nil then
        M.TimeRecord[skillName] = {}
        M.TimeRecord[skillName].Activated = false
        M.TimeRecord[skillName].LastActivated = 0
        M.TimeRecord[skillName].TotalTime = 0
    end

    M.SkillStatusData[skillName] = true

    local time = M.utils.GetTime()
    if M.TimeRecord[skillName].Activated == false then
        M.TimeRecord[skillName].LastActivated = time
    end
    M.TimeRecord[skillName].TotalTime = M.TimeRecord[skillName].TotalTime + time - M.TimeRecord[skillName].LastActivated
    M.TimeRecord[skillName].Activated = true
end

function M.RecordTimerSkillDeactivate(skillName)
    if M.TimeRecord[skillName] == nil then
        M.TimeRecord[skillName] = {}
        M.TimeRecord[skillName].Activated = false
        M.TimeRecord[skillName].LastActivated = 0
        M.TimeRecord[skillName].TotalTime = 0
    end

    M.SkillStatusData[skillName] = false

    local time = M.utils.GetTime()
    if M.TimeRecord[skillName].Activated then
        M.TimeRecord[skillName].TotalTime = M.TimeRecord[skillName].TotalTime + time - M.TimeRecord[skillName].LastActivated
    end
    M.TimeRecord[skillName].Activated = false
end

function M.EndAllTimerRecord()
    local time = M.utils.GetTime()

    for skilName, _ in pairs(M.SkillStatusData) do
        M.SkillStatusData[skilName] = false
    end

    for skillName, timeData in pairs(M.TimeRecord) do
        if M.TimeRecord[skillName].Activated then
            M.TimeRecord[skillName].Activated = false
            M.TimeRecord[skillName].TotalTime = M.TimeRecord[skillName].TotalTime + time - M.TimeRecord[skillName].LastActivated
        end
    end
end

function M.RecordCounter(skillName, value)
	if M.Counter[skillName] == nil then
		M.Counter[skillName] = 0
	end
    if value == nil then
	    M.Counter[skillName] = M.Counter[skillName] + 1
    else
        M.Counter[skillName] = M.Counter[skillName] + value
    end
end

function M.RecordBuffCoveredHitCounter(skillName, hitType, value)
	if M.BuffCoveredHitCounter[skillName] == nil then
		M.BuffCoveredHitCounter[skillName] = {}
	end
    if value == nil then value = 1 end
    if hitType == nil then hitType = "Hit" end

    if M.BuffCoveredHitCounter[skillName][hitType] == nil then
        M.BuffCoveredHitCounter[skillName][hitType] = 0
    end

    M.BuffCoveredHitCounter[skillName][hitType] = M.BuffCoveredHitCounter[skillName][hitType] + value
end

function M.CreateTimerRecorder(playerData, skillType, field, notifyAppear, notifyDisappear)
    local timer = playerData:get_field(field)
    if timer == nil then
        return nil
    end

    if timer > 0 then
        InitBuffBar(skillType, timer)
    end

    if M.SkillStatusData[skillType] == nil then
        M.SkillStatusData[skillType] = false
    end
    if notifyAppear == nil then notifyAppear = true end
    if notifyDisappear == nil then notifyDisappear = true end

    if timer > 0 and M.SkillStatusData[skillType] == false then
        M.RecordTimerSkillActivate(skillType)
        M.SkillStatusData[skillType] = true
        if notifyAppear then
            SkillTrigger(skillType)
        end
    elseif timer == 0 and M.SkillStatusData[skillType] == true then
        M.RecordTimerSkillDeactivate(skillType)
        M.SkillStatusData[skillType] = false
        if notifyDisappear then
            SkillEnd(skillType)
        end
    end
    return timer
end

function M.CreateBooleanRecorder(activated, skillType, notifyAppear, notifyDisappear)
    if M.SkillStatusData[skillType] == nil then
        M.SkillStatusData[skillType] = false
    end
    if notifyAppear == nil then notifyAppear = true end
    if notifyDisappear == nil then notifyDisappear = true end

    if activated == true and M.SkillStatusData[skillType] == false then
        M.RecordTimerSkillActivate(skillType)
        M.SkillStatusData[skillType] = true
        if notifyAppear then
            SkillTrigger(skillType)
        end
    elseif activated == false and M.SkillStatusData[skillType] == true then
        M.RecordTimerSkillDeactivate(skillType)
        M.SkillStatusData[skillType] = false
        if notifyDisappear then
            SkillEnd(skillType)
        end
    end
end

local WeaponNames = {
    [0] = "大剑",
    [1] = "斩斧",
    [2] = "太刀",
    [3] = "轻弩",
    [4] = "重弩",
    [5] = "大锤",
    [6] = "铳枪",
    [7] = "长枪",
    [8] = "片手",
    [9] = "双刀",
    [10] = "笛子",
    [11] = "盾斧",
    [12] = "操虫棍",
    [13] = "弓",
}
local WeaponTimers = {
    [0] = function (playerQuestBase)
        -- 大剑
        M.CreateTimerRecorder(playerQuestBase, "_tameTimer", "_tameTimer")
        M.CreateTimerRecorder(playerQuestBase, "MoveWpOffBuffGreatSwordTimer", "MoveWpOffBuffGreatSwordTimer")
    end,
    [1] = function (playerQuestBase)
        -- 斩斧
        M.CreateTimerRecorder(playerQuestBase, "_BottleRecoverTimer", "_BottleRecoverTimer")
        M.CreateTimerRecorder(playerQuestBase, "_BotteReduceTimer", "_BotteReduceTimer")
        M.CreateTimerRecorder(playerQuestBase, "_BottleAwakeReduceTimer", "_BottleAwakeReduceTimer")
        M.CreateTimerRecorder(playerQuestBase, "_BottleAwakeDurationTimer", "_BottleAwakeDurationTimer")
        M.CreateTimerRecorder(playerQuestBase, "_NoUseSlashGaugeTimer", "_NoUseSlashGaugeTimer")
        M.CreateTimerRecorder(playerQuestBase, "_BottleAwakeAssistTimer", "_BottleAwakeAssistTimer")
    end,
    [2] = function (playerQuestBase)
        -- 太刀
        M.CreateTimerRecorder(playerQuestBase, "_LongSwordGaugeTimer", "_LongSwordGaugeTimer")
        M.CreateTimerRecorder(playerQuestBase, "_LongSwordGaugeLvTimer", "_LongSwordGaugeLvTimer")
        -- Kabutowar = 气刃兜割
        M.CreateTimerRecorder(playerQuestBase, "_CreateAfterKabutowariShellTimer", "_CreateAfterKabutowariShellTimer")
        M.CreateTimerRecorder(playerQuestBase, "_LongSwordGaugePowerupTime", "_LongSwordGaugePowerupTime")
        M.CreateTimerRecorder(playerQuestBase, "_LongSwordGaugePowerupAddTime", "_LongSwordGaugePowerupAddTime")
    end,
    [3] = function (playerQuestBase)
        -- 轻弩
        M.CreateTimerRecorder(playerQuestBase, "_AimRotStartTimer", "_AimRotStartTimer")
        M.CreateTimerRecorder(playerQuestBase, "_FullAutoModeReloadTimer", "_FullAutoModeReloadTimer")
        M.CreateTimerRecorder(playerQuestBase, "LightBowgunWireBuffTimer", "LightBowgunWireBuffTimer")
    end,
    [4] = function (playerQuestBase)
        -- 重弩
        M.CreateTimerRecorder(playerQuestBase, "_ReduseChargeTimer", "_ReduseChargeTimer")
        M.CreateTimerRecorder(playerQuestBase, "_SpecialBulletTimer", "_SpecialBulletTimer")
        M.CreateTimerRecorder(playerQuestBase, "_MachineGunFireTimer", "_MachineGunFireTimer")
        M.CreateTimerRecorder(playerQuestBase, "_FullAutoInputTimer", "_FullAutoInputTimer")
    end,
    [5] = function (playerQuestBase)
        -- 大锤
        M.CreateTimerRecorder(playerQuestBase, "_ChargeTimer", "_ChargeTimer")
        M.CreateTimerRecorder(playerQuestBase, "_AerialHighOverLoopTimer", "_AerialHighOverLoopTimer")
        M.CreateTimerRecorder(playerQuestBase, "_ImpactPullsTimer", "_ImpactPullsTimer")
    end,
    [6] = function (playerQuestBase)
        -- 铳枪
        -- TODO: snow.player.GunLance
        M.CreateTimerRecorder(playerQuestBase, "_ShotDamageUpDurationTimer", "_ShotDamageUpDurationTimer")
        M.CreateTimerRecorder(playerQuestBase, "_ExplodePileBuffTimer", "_ExplodePileBuffTimer")
    end,
    [7] = function (playerQuestBase)
        -- 长枪
        M.CreateTimerRecorder(playerQuestBase, "_ShargeSwingTimer", "<_ShargeSwingTimer>k__BackingField")
        M.CreateTimerRecorder(playerQuestBase, "_ChargeTime", "_ChargeTime")
        M.CreateTimerRecorder(playerQuestBase, "_ChargePowerupTime", "_ChargePowerupTime")
        M.CreateTimerRecorder(playerQuestBase, "_ChargePeriodicUpdateTimer", "_ChargePeriodicUpdateTimer")
        M.CreateTimerRecorder(playerQuestBase, "_ChainDeathMatchMoveTimer", "_ChainDeathMatchMoveTimer")
        M.CreateTimerRecorder(playerQuestBase, "_GuardRageTimer", "_GuardRageTimer")
        M.CreateTimerRecorder(playerQuestBase, "_RutenTimer", "_RutenTimer")
    end,
    [8] = function (playerQuestBase)
        -- 剑盾
        M.CreateTimerRecorder(playerQuestBase, "_OilBuffTimer", "_OilBuffTimer")
    end,
    [9] = function (playerQuestBase)
        -- 双刀
        M.CreateTimerRecorder(playerQuestBase, "SharpnessRecoveryBuffValidTimer", "SharpnessRecoveryBuffValidTimer")
    end,
    [10] = function (playerQuestBase)
        -- 笛子
        M.CreateTimerRecorder(playerQuestBase, "MusicRegeneTime", "MusicRegeneTime")
        M.CreateTimerRecorder(playerQuestBase, "_ImpactPullsTimer", "_ImpactPullsTimer")
    end,
    [11] = function (playerQuestBase)
        -- 盾斧
        M.CreateTimerRecorder(playerQuestBase, "_ShieldBuffTimer", "_ShieldBuffTimer")
        M.CreateTimerRecorder(playerQuestBase, "_SwordBuffTimer", "_SwordBuffTimer")
        M.CreateTimerRecorder(playerQuestBase, "_StoreSwordBuffTimer", "_StoreSwordBuffTimer")
        M.CreateTimerRecorder(playerQuestBase, "_ChainsawBuffBottleAddTimer", "_ChainsawBuffBottleAddTimer")
    end,
    [12] = function (playerQuestBase)
        -- 虫棍
        M.CreateTimerRecorder(playerQuestBase, "_MarkingAttackTimer", "_MarkingAttackTimer")
        M.CreateTimerRecorder(playerQuestBase, "_RedExtractiveTime", "_RedExtractiveTime")
        M.CreateTimerRecorder(playerQuestBase, "_OrangeExtractiveTime", "_OrangeExtractiveTime")
        M.CreateTimerRecorder(playerQuestBase, "_WhiteExtractiveTime", "_WhiteExtractiveTime")
    end,
    [13] = function (playerQuestBase)
        -- 弓
        M.CreateTimerRecorder(playerQuestBase, "_ChargeTimer", "_ChargeTimer")
        M.CreateTimerRecorder(playerQuestBase, "WireBuffAtk", "_WireBuffAttackUpTimer")
        M.CreateTimerRecorder(playerQuestBase, "WireBuffArrow", "_WireBuffArrowUpTimer")
        M.CreateTimerRecorder(playerQuestBase, "BladescaleHoneBow", "_EquipSkill216_BottleUpTimer")
    end,
}

function M.CollectData(triggeredTime, player, playerQuestBase)
    if M.lastCollectTime >= triggeredTime then
        return
    end
    M.lastCollectTime = triggeredTime

    local PlayerData = player:call("get_PlayerData")
    local currentHealth = M.CurrentHealth
    local maxHealth = PlayerData:get_field("_vitalMax")

    local rengekiCount = PlayerData:get_field("_RengekiPowerUpCnt")
    local rengekiTimer = PlayerData:get_field("_RengekiPowerUpTimer")
    if rengekiCount < 5 then
        InitBuffBar("ChainCrit", rengekiTimer)
        InitBuffBar("ChainCritII", 0)
    else
        InitBuffBar("ChainCrit", 0)
        InitBuffBar("ChainCritII", rengekiTimer)
    end

    if rengekiCount ~= M.lastRengekiCount then
        if rengekiCount == 1 then
            M.RecordTimerSkillActivate("ChainCrit")
            M.RecordTimerSkillDeactivate("ChainCritII")
            SkillTrigger("ChainCrit")
            -- 在显示伤害数字后结算，因此第一次时记一个数
            -- TODO: 无法记录 HitType
            M.RecordBuffCoveredHitCounter("ChainCrit")
        elseif rengekiCount == 5 then
            M.RecordTimerSkillDeactivate("ChainCrit")
            M.RecordTimerSkillActivate("ChainCritII")
            SkillTrigger("ChainCritII")
            -- 同理
            M.RecordBuffCoveredHitCounter("ChainCrit", "Hit", -1)
            M.RecordBuffCoveredHitCounter("ChainCritII")
        elseif rengekiCount == 0 then
            M.RecordTimerSkillDeactivate("ChainCrit")
            M.RecordTimerSkillDeactivate("ChainCritII")
            if M.lastRengekiCount >= 5 then
                SkillEnd("ChainCritII")
            else
                SkillEnd("ChainCrit")
            end
            -- SendMessage("技能 连击 已消失")
        end
        M.lastRengekiCount = rengekiCount
    end

    local dragonCount = PlayerData:get_field("_HyakuryuDragonPowerUpCnt")
    local dragonTimer = PlayerData:get_field("_HyakuryuDragonPowerUpTimer")
    if dragonCount < 5 then
        InitBuffBar("KushalaDaoraSoul", dragonTimer)
        InitBuffBar("KushalaDaoraSoulII", 0)
    else
        InitBuffBar("KushalaDaoraSoul", 0)
        InitBuffBar("KushalaDaoraSoulII", dragonTimer)
    end

    if dragonCount ~= M.lastDragonCount then
        if dragonCount == 1 then
            M.RecordTimerSkillActivate("KushalaDaoraSoul")
            M.RecordTimerSkillDeactivate("KushalaDaoraSoulII")
            SkillTrigger("KushalaDaoraSoul")
            -- 在显示伤害数字后结算，因此第一次时记一个数
            M.RecordBuffCoveredHitCounter("KushalaDaoraSoul")
        elseif dragonCount == 5 then
            M.RecordTimerSkillDeactivate("KushalaDaoraSoul")
            M.RecordTimerSkillActivate("KushalaDaoraSoulII")
            SkillTrigger("KushalaDaoraSoulII")
            -- 同理
            M.RecordBuffCoveredHitCounter("KushalaDaoraSoul", "Hit", -1)
            M.RecordBuffCoveredHitCounter("KushalaDaoraSoulII")
        elseif dragonCount == 0 then
            M.RecordTimerSkillDeactivate("KushalaDaoraSoul")
            M.RecordTimerSkillDeactivate("KushalaDaoraSoulII")
            if M.lastDragonCount >= 5 then
                SkillEnd("KushalaDaoraSoulII")
            else
                SkillEnd("KushalaDaoraSoul")
            end
        end
        M.lastDragonCount = dragonCount
    end

    local dangoDefenseTaken = PlayerData:get_field("_KitchenSkill048_Damage")
    if dangoDefenseTaken >= 200 and M.dangoDefenseReady == false then
        SkillReady("DangoDefender")
        -- M.RecordCounter("DangoDefense")
        M.dangoDefenseReady = true
    elseif dangoDefenseTaken < 200 then
        M.dangoDefenseReady = false
    end

    -- Maximum Might, 10
    local skillList = player:call("get_PlayerSkillList") -- snow.player.PlayerSkillLisst
    local skillDataArr = skillList:get_field("_PlayerSkillData") -- snow.player.PlayerSkillData[]
    local hasWholeBody = false
    local hasHeroics = false
    local hasResuscitate = false
    local hasPeakPerformance = false
    local hasResentment = false
    local hasDragonheart = false
    local dragonheartLevel = 0
    local hasDereliction = false
    for i = 1, #skillDataArr do
        local skillData = skillDataArr[i-1] -- snow.player.PlayerSkillData
        if skillData then
            local skillID = skillData:get_field("SkillId") -- snow.DataDef.PlEquipSkillId
            local skillLv = skillData:get_field("SkillLv") -- uint32
            if skillID == M.utils.NormalizeSkillID(9) then
                hasWholeBody = true -- 精神抖擞
            elseif skillID == M.utils.NormalizeSkillID(90) then
                hasHeroics = true -- 火场怪力
            elseif skillID == M.utils.NormalizeSkillID(4) then
                hasResuscitate = true -- 死逃
            elseif skillID == M.utils.NormalizeSkillID(2) then
                hasPeakPerformance = true -- 无伤
            elseif skillID == M.utils.NormalizeSkillID(3) then
                hasResentment = true -- 怨恨
            elseif skillID == M.utils.NormalizeSkillID(102) then
                hasDragonheart = true -- 龙气活性
                dragonheartLevel = skillLv
            elseif skillID == M.utils.NormalizeSkillID(201) then
                hasDereliction = true -- 伏魔耗命
            end
        end
    end

    -- TODO: reset script 时不能正确显示，但无所谓
    if hasDereliction then
        local symbiosisVital = PlayerData:get_field("_SymbiosisSkillLostVital")
        if symbiosisVital ~= M.lastSymbiosisVital then
            if M.lastSymbiosisVital > 0 and symbiosisVital == 0 then
                if M.lastSymbiosisVital >= 100 then
                    M.RecordTimerSkillActivate("Dereliction")
                    M.RecordTimerSkillDeactivate("DerelictionII")
                    M.RecordTimerSkillDeactivate("DerelictionIII")
                    DerelictionReset("DerelictionIII")
                elseif M.lastSymbiosisVital >= 50 then
                    M.RecordTimerSkillActivate("Dereliction")
                    M.RecordTimerSkillDeactivate("DerelictionII")
                    M.RecordTimerSkillDeactivate("DerelictionIII")
                    DerelictionReset("DerelictionIII")
                end
            elseif symbiosisVital == 50 then
                M.RecordTimerSkillDeactivate("Dereliction")
                M.RecordTimerSkillActivate("DerelictionII")
                M.RecordTimerSkillDeactivate("DerelictionIII")
                -- SendMessage("技能 伏魔耗命 II 已发动")
                SkillTrigger("DerelictionII")
            elseif symbiosisVital == 100 then
                M.RecordTimerSkillDeactivate("Dereliction")
                M.RecordTimerSkillDeactivate("DerelictionII")
                M.RecordTimerSkillActivate("DerelictionIII")
                -- SendMessage("技能 伏魔耗命 III 已发动")
                SkillTrigger("DerelictionIII")
            elseif symbiosisVital == 0 or symbiosisVital == 1 then
                M.RecordTimerSkillActivate("Dereliction")
                M.RecordTimerSkillDeactivate("DerelictionII")
                M.RecordTimerSkillDeactivate("DerelictionIII")
                SkillTrigger("Dereliction")
            end
            M.lastSymbiosisVital = symbiosisVital
        end
    else
        if M.lastSymbiosisVital ~= 0 then
            if M.lastSymbiosisVital == 100 then
                SkillEnd("DerelictionIII")
            elseif M.lastSymbiosisVital >= 50 then
                SkillEnd("DerelictionII")
            else
                SkillEnd("Dereliction")
            end
            M.lastSymbiosisVital = 0
        end
        M.RecordTimerSkillDeactivate("Dereliction")
        M.RecordTimerSkillDeactivate("DerelictionII")
        M.RecordTimerSkillDeactivate("DerelictionIII")
    end

    if playerQuestBase ~= nil and hasWholeBody then
        local wholeBodyTimer = PlayerData:get_field("_WholeBodyTimer")

        if M.wholeBodyActivated then
            InitBuffBar("MaximumMight", wholeBodyTimer, 2.0)
        else
            InitBuffBar("MaximumMight", wholeBodyTimer, 3.0)
        end
        local stamina = PlayerData:get_field("_stamina")
        local staminaMax = PlayerData:get_field("_staminaMax")

        if M.wholeBodyFirstTriggered == false and M.wholeBodyActivated == false and stamina == staminaMax and wholeBodyTimer > 179 then
            M.wholeBodyFirstTriggered = true
            -- This will make "Reset Script" cannot record correctly if the character already have whole body
        end
        if M.wholeBodyActivated == false and stamina == staminaMax and wholeBodyTimer == 0 and M.wholeBodyFirstTriggered == true then
            M.wholeBodyActivated = true
            M.wholeBodyPrepareDeactivate = false
            M.RecordTimerSkillActivate("MaximumMight")
            SkillTrigger("MaximumMight")
        elseif M.wholeBodyActivated == true and M.wholeBodyPrepareDeactivate == false and stamina ~= staminaMax and wholeBodyTimer == 0 then
            M.wholeBodyPrepareDeactivate = true
            -- Delay one frame to avoid miscalculation
            -- M.singletons.SendMessage("技能 精神抖擞 计时中！")
        elseif M.wholeBodyActivated == true and M.wholeBodyPrepareDeactivate == true and stamina ~= staminaMax and wholeBodyTimer == 0 then
            M.wholeBodyActivated = false
            M.wholeBodyPrepareDeactivate = false
            M.RecordTimerSkillDeactivate("MaximumMight")
            SkillEnd("MaximumMight")
        end
    elseif M.wholeBodyActivated or M.wholeBodyPrepareDeactivate then
        M.wholeBodyActivated = false
        M.wholeBodyPrepareDeactivate = false
        M.RecordTimerSkillDeactivate("MaximumMight")
        SkillEnd("MaximumMight")
    end

    local atkUp = PlayerData:get_field("_AtkUpAlive")
    if atkUp ~= M.lastDemonDrug then
        if atkUp == 5 then
            M.RecordTimerSkillActivate("Demondrug")
            M.RecordTimerSkillDeactivate("MegaDemondrug")
            ItemTrigger("Demondrug")
        elseif atkUp == 7 then
            M.RecordTimerSkillDeactivate("Demondrug")
            M.RecordTimerSkillActivate("MegaDemondrug")
            ItemTrigger("MegaDemondrug")
        elseif atkUp == 0 then
            M.RecordTimerSkillDeactivate("Demondrug")
            M.RecordTimerSkillDeactivate("MegaDemondrug")
            if M.lastDemonDrug == 5 then
                ItemEnd("Demondrug")
            elseif M.lastDemonDrug == 7 then
                ItemEnd("MegaDemondrug")
            end
        end
        M.lastDemonDrug = atkUp
    end

    local defUp = PlayerData:get_field("_DefUpAlive")
    if defUp ~= M.lastArmorSkin then
        if defUp == 15 then
            M.RecordTimerSkillActivate("Armorskin")
            M.RecordTimerSkillDeactivate("MegaArmorskin")
            ItemTrigger("Armorskin")
        elseif defUp == 25 then
            M.RecordTimerSkillDeactivate("Armorskin")
            M.RecordTimerSkillActivate("MegaArmorskin")
            ItemTrigger("MegaArmorskin")
        elseif defUp == 0 then
            M.RecordTimerSkillDeactivate("Armorskin")
            M.RecordTimerSkillDeactivate("MegaArmorskin")
            if M.lastArmorSkin == 15 then
                ItemEnd("Armorskin")
            elseif M.lastArmorSkin == 25 then
                ItemEnd("MegaArmorskin")
            end
        end
        M.lastArmorSkin = defUp
    end

    -- local redirection = player:get_field("_EquipSkill210_IsUtsusemi")
    -- if redirection then
    --     SendMessage("合气 已发动")
    -- end

    -- local redirection = player:get_field("_EquipSkill210_Lv2_IsAikiSuccess")
    -- if redirection then
    --     SendMessage("合气2 已发动")
    -- end

    M.CreateTimerRecorder(player, "LatentPower", "_PowerFreedomTimer") -- "力量解放"
    M.CreateTimerRecorder(player, "ProtectivePolish", "_SharpnessGaugeBoostTimer") -- "刚刃打磨"

    if playerQuestBase ~= nil then
        M.CreateTimerRecorder(playerQuestBase, "Bloodblight", "_MysteryDebuffTimer") -- "劫血"

        local WeaponType = player:get_field("_playerWeaponType")
        -- Thanks mod_utils getCurrentPlayer comment, it let me know how the weapon data stores and the inheritance relation

        --TODO:SUPPORT ME
        -- WeaponTimers[WeaponType](playerQuestBase)
    end

    M.CreateTimerRecorder(PlayerData, "Clothfly", "_DefUpBuffSecondRateTimer") -- "匹白蝶"
    M.CreateTimerRecorder(PlayerData, "Cutterfly", "_CritUpEcSecondTimer") -- "碎网赤蜻"

    M.CreateTimerRecorder(PlayerData, "GourmetFish", "_FishRegeneEnableTimer") -- "烤熟的鱼"
    M.CreateTimerRecorder(PlayerData, "DemonPowder", "_AtkUpItemSecondTimer") -- "鬼人粉尘"
    M.CreateTimerRecorder(PlayerData, "MightSeed", "_AtkUpBuffSecondTimer") -- "怪力种子/霞魂龙珠"
    M.CreateTimerRecorder(PlayerData, "HardshellPowder", "_DefUpItemSecondTimer") -- "硬化粉尘"
    M.CreateTimerRecorder(PlayerData, "AdamantSeed", "_DefUpBuffSecondTimer") -- "忍耐种子/霞魂龙珠"
    M.CreateTimerRecorder(PlayerData, "Immunizer", "_VitalizerTimer") -- "活力剂"
    M.CreateTimerRecorder(PlayerData, "DashJuice", "_StaminaUpBuffSecondTimer") -- "强走药/耐力消耗减少/百目蝶"

    M.CreateTimerRecorder(PlayerData, "Grinder", "_BrandNewSharpnessAdjustUpTimer") -- "打磨术【锐】"
    M.CreateTimerRecorder(PlayerData, "Counterstrike", "_CounterattackPowerupTimer") -- "逆袭"
    M.CreateTimerRecorder(PlayerData, "AffinitySliding", "_SlidingPowerupTimer") -- "滑走强化"
    M.CreateTimerRecorder(PlayerData, "VirusOvercome", "_VirusOvercomeBuffTimer") -- "狂龙症（克服）"
    M.CreateTimerRecorder(PlayerData, "Coalescence", "_DisasterTurnPowerUpTimer") -- "因祸得福"
    M.CreateTimerRecorder(PlayerData, "AdrenalineRush", "_EquipSkill208_AtkUpTimer") -- "巧击"
    M.CreateTimerRecorder(PlayerData, "WallRun", "_WallRunPowerupTimer") -- "墙面移动 III"
    M.CreateTimerRecorder(PlayerData, "OffensiveGuard", "_EquipSkill_036_Timer") -- "攻击守势"


    M.CreateTimerRecorder(PlayerData, "HellfireCloak", "_OnibiPowerUpTiemr") -- 鬼火缠
    local inBattle = M.singletons.CheckIfInBattle()
    local time = M.utils.GetTime()
    local shouldNotifyAgitator = time - M.lastAgitatorNotifyTime > 5
    local agiTimer = M.CreateTimerRecorder(PlayerData, "Agitator", "_ChallengeTimer", shouldNotifyAgitator, inBattle) -- "挑战者"
    if shouldNotifyAgitator and agiTimer ~= nil and agiTimer > 0 then
        M.lastAgitatorNotifyTime = time
    end

    M.CreateTimerRecorder(PlayerData, "Furious", "_FuriousSkillStaminaBuffSecondTimer") -- "激昂"
    M.CreateTimerRecorder(PlayerData, "WireBugPowerup", "_WireBugPowerUpTimer") -- "变幻翔虫"
    M.CreateTimerRecorder(PlayerData, "StatusTrigger", "_EquipSkill222_Timer") -- "状态异常必定累积"

    M.CreateTimerRecorder(PlayerData, "OtomoRoar", "_BeastRoarOtomoTimer") -- "猫的强化咆哮之技"
    M.CreateTimerRecorder(PlayerData, "OtomoKijin", "_KijinOtomoTimer") -- "猫的强化太鼓之技"
    M.CreateTimerRecorder(PlayerData, "OtomoRunhigh", "_RunhighOtomoTimer") -- "猫的应援舞蹈之技"

    M.CreateTimerRecorder(PlayerData, "MusicSharpnessRegen", "_MusicKireajiRegeneTimer") -- "旋律：斩味恢复"
    M.CreateTimerRecorder(PlayerData, "MusicRegen", "_MusicRegeneTimer") -- "旋律：体力持续恢复"

    if hasHeroics then
        M.CreateBooleanRecorder(player:call("isPredicamentPowerUp"), "Heroics") -- "火场怪力"
    end
    M.CreateBooleanRecorder(player:call("isKitchenSkillPredicamentPowerUp"), "KitchenHeroics") -- "猫的火场怪力"
    if hasResuscitate then
        M.CreateBooleanRecorder(player:call("isDebuffState"), "Resuscitate") -- "死里逃生"
    end
    if playerQuestBase ~= nil and hasPeakPerformance then
        -- was player:call("isVitalMax") but it access violation
        M.CreateBooleanRecorder(currentHealth == maxHealth, "PeakPerformance") -- "无伤"
    end

    if hasDragonheart or hasResentment then
        if hasDragonheart then
            local hpRate = currentHealth / maxHealth
            local triggered = false
            if dragonheartLevel == 5 then
                if hpRate <= 0.8 then
                    triggered = true
                end
            elseif dragonheartLevel == 3 or dragonheartLevel == 4 then
                if hpRate <= 0.7 then
                    triggered = true
                end
            else
                if hpRate <= 0.5 then
                    triggered = true
                end
            end
            M.CreateBooleanRecorder(triggered, "Dragonheart") -- "龙气活性"
        else
            M.RecordTimerSkillDeactivate("Dragonheart")
        end

        -- TODO: 斩裂伤怎么算？
        if playerQuestBase ~= nil and  hasResentment then
            M.CreateBooleanRecorder((currentHealth < PlayerData:get_field("_r_Vital")), "Resentment") -- "怨恨"
        else
            M.RecordTimerSkillDeactivate("Resentment")
        end
    end

    local fury = PlayerData:get_field("_FuriousSkillAccumulator")
    if fury == 100 and M.furiousReady == false then
        SkillReady("Furious")
        M.furiousReady = true
    elseif fury < 100 then
        M.furiousReady = false
    end

    M.singletons.SendMessage()
end

function M.RecordHitBuffs(isCritical, isPhysicsExploit, isMindEye, isElement, isElementExploit)
    for skillName, activated in pairs(M.SkillStatusData) do
        if activated then
            M.RecordBuffCoveredHitCounter(skillName, "Hit")
            if isCritical then
                -- 会心
                M.RecordBuffCoveredHitCounter(skillName, "CriticalHit")
            end
            if isPhysicsExploit then
                -- 弱点特效
                M.RecordBuffCoveredHitCounter(skillName, "PhysicsExploitHit")
            end
            if isMindEye then
                -- 心眼
                M.RecordBuffCoveredHitCounter(skillName, "MindEyeHit")
            end
            if isElement then
                M.RecordBuffCoveredHitCounter(skillName, "ElementHit")
                if isElementExploit then
                    -- 弱点特效【属性】
                    M.RecordBuffCoveredHitCounter(skillName, "ElementExploitHit")
                end
                if isCritical then
                    -- 会心击【属性】
                    M.RecordBuffCoveredHitCounter(skillName, "ElementCriticalHit")
                end
            end
            -- else
        --     M.RecordBuffCoveredHitCounter(skillName .. "NotCoveredHit")
        end
    end
end

M.SkillTrigger = SkillTrigger
M.SkillEnd = SkillEnd
M.ItemTrigger = ItemTrigger
M.ItemEnd = M.ItemEnd

return M

--- Features Done ---
-- o 挑战者
-- o 精神抖擞
-- o 滑走强化
-- o 墙面移动
-- o 连击
-- o 逆袭
-- o 攻击手势
-- o 因祸得福
-- o 巧击
-- o 状态异常必定累积

-- 血条有关：
-- o 龙气活性
-- o 无伤
-- o 火场怪力
-- o 怨恨

-- o 死里逃生
-- o 力量解放
-- o 狂龙症（克服）

-- o 劫血：提示与回复量

-- 环境生物：
-- o 匹白蝶
-- o 碎网赤请
-- 炎火蝶 -- TODO
-- 百目蝶 -- TODO

-- o 打磨术【锐】

-- o 猫：
-- o 会心
-- o 耐力
-- o 攻防

-- o 气血：回复量

-- o 弱点特效、弱点特效【属性】：攻击弱点次数
-- o 心眼：触发次数

-- o 刃鳞打磨：触发次数
-- o 刃鳞打磨（弓）

-- o 攻势
-- o 偷袭
-- o 偷袭：额外伤害

-- o 精灵加护，团子防护术，团子防御术：发动次数与值
-- snow.data.armor.FilterType

--- Features TODO ---
-- 环境生物：
--   不知火乌贼


-- 下面这俩的数值是直接写在 snow.player.EquipSkillParameter 里的，不是函数，无法 hook
-- 迅之气息：冷却时间 -- snow.player.EquipSkill_221
-- 疑点：PlayerQuestBase 的 updateCalcTotalAttackRate 返回值是 Void，可能是直接计算的攻击力最终值
-- 

-- snow.player.EquipSkillParameter
-- snow.player.PlayerUserDataSkillParameter

-- 狂龙症（发作）
-- 翔虫使（3）：计算翔虫冷却且在空中的时间
-- 走壁移动【翔】：计算翔虫冷却且在爬墙的时间

-- 计数类：
-- 攻势：额外伤害
-- 破坏王：额外伤害
-- 蓄力大师：额外累计值
-- 属耐、耐晕：发动次数

-- 其他：
-- 强化持续
-- 防性
-- 拔刀力
-- 广域化

-- 团子技能：
-- 团子特殊攻击术
-- 团子牵绊术
