
local LocalizedStrings = {
	["en-US"] = {
		Bloodblight = "Bloodblight",

		Clothfly = "Clothfly",
		Butterflame = "Butterflame",
		Peepersects = "Peepersects",
		Cutterfly = "Cutterfly",
		RedLampsquid = "Red Lampsquid",
		YellowLampsquid = "Yellow Lampsquid",
		GreenLampsquid = "Green Lampsquid",
		GoldenLampsquid = "Golden Lampsquid",
		WireBugPowerup = "Special Wirebug",

		Demondrug = "Demondrug",
		MegaDemondrug = "Mega Demondrug",
		DemonPowder = "Demon Powder",
		MightSeed = "Attack UP",
		Armorskin = "Armorskin",
		MegaArmorskin = "Mega Armorskin",
		HardshellPowder = "Hardshell Powder",
		AdamantSeed = "Defense Up",

		GourmetFish = "Gourmet Fish",
		Immunizer = "Regene Boost",
		DashJuice = "Reduce Stamina Depletion",

        OtomoRoar = "Buddy's Rousing Roar",
        OtomoRunhigh = "Buddy's Go, Fight, Win",
        OtomoKijin = "Buddy's Power Drum",

		MaximumMight = "Maximum Might",
		LatentPower = "Latent Power",
		AffinitySliding = "Affinity Sliding",
		WallRun = "Wall Run",

		ProtectivePolish = "Protective Polish",
        Grinder = "Grinder (S)",
		Counterstrike = "Counterstrike",
		OffensiveGuard = "Offensive Guard",
		HellfireCloak = "Hellfire Cloak",
		Agitator = "Agitator",
		Furious = "Furious",

		AdrenalineRush = "Adrenaline Rush",
		StatusTrigger = "Status Trigger",
        BladescaleHoneBow = "Bladescale Hone (Bow)",

		MusicSharpnessRegen = "Music: Sharpness Regen",
		MusicRegen = "Music: Regen",

		Dereliction = "Dereliction",
		DerelictionII = "Dereliction II",
		DerelictionIII = "Dereliction III",
		VirusOvercome = "Virus Overcome",
		Coalescence = "Coalescence",

		Heroics = "Heroics",
		KitchenHeroics = "Kitchen Heroics",
		Resuscitate = "Resuscitate",
		PeakPerformance = "Peak Performance",
		Dragonheart = "Dragonheart",
		Resentment = "Resentment",

		ChainCrit = "Chain Crit",
		ChainCritII = "Chain Crit II",
		KushalaDaoraSoul = "Kushala Daora Soul",
		KushalaDaoraSoulII = "Kushala Daora Soul II",

		BloodblightHeal = "Bloodblight Regene",
        BloodRite = "Blood Rite Regene",
        BladescaleHone = "Bladescale Hone",
		Foray = "Foray",

		SneakAttack = "Sneak Attack",
		SneakAttackValue = "Sneak Attack Damage",

		DivineBlessing = "Divine Blessing",
		DangoBlessing = "Dango Defender (Hi)",
		DangoDefender = "Dango Defender",

		MasterTouchCriticalRate = "Master Touch (Crit)",
		PhysicsExploitRate = "Weakness",
		ElementExploitRate = "Element Weakness",
		MindEyeRate = "Bad Hitzone",

		SkillReady = "Skill [<COL YEL>%s</COL>] is ready.",
		SkillActivated = "Skill [<COL YEL>%s</COL>] has activated.",
		SkillEnd = "Skill [<COL YEL>%s</COL>] end.",
		ItemActivated = "Item [<COL YEL>%s</COL>] has activated.",
		ItemEnd = "Item [<COL YEL>%s</COL>] end.",
		DerelictionReset = "Skill [<COL YEL>%s</COL>] reset.",

		CriticalHit = "Critical Hits",
		CriticalHitSuffix = "(Crit)",
		PhysicsExploitHit = "Exploit Weakness",
		PhysicsExploitHitSuffix = "(Exploit)",
		MindEyeHit = "Bad Hitzone",
		MindEyeHitSuffix = "(BadHit)",
		ElementHit = "Element Hits",
		ElementHitSuffix = "(Ele)",
		ElementExploitHit = "Element Exploit",
		ElementExploitHitSuffix = "(EleExploit)",
		ElementCriticalHit = "Critical Element",
		ElementCriticalHitSuffix = "(CriticalEle)",
		MasterTouchHit = "Master Touch",
		MasterTouchHitSuffix = "(MasterTouch)",
		MasterTouchCriticalHit = "Master Touch (Crit)",
		MasterTouchCriticalHitSuffix = "(CritMasterTouch)",
	},
	["zh-CN"] = {
		------------
		-- Timers --
		------------

		Bloodblight = "劫血",

		-- Timers.EndemicLife
		Clothfly = "匹白蝶",
		Butterflame = "炎火蝶",
		Peepersects = "百目蝶",
		Cutterfly = "碎网赤蜻",
		RedLampsquid = "红不知火乌贼",
		YellowLampsquid = "黄不知火乌贼",
		GreenLampsquid = "绿不知火乌贼",
		GoldenLampsquid = "金不知火乌贼",
		WireBugPowerup = "变幻翔虫",

		-- Timers.Items
		Demondrug = "鬼人药",
		MegaDemondrug = "鬼人药G",
		DemonPowder = "鬼人粉尘",
		MightSeed = "攻击上升", -- 怪力种子/霞魂攻击/炎火蝶
		Armorskin = "硬化药",
		MegaArmorskin = "硬化药G",
		HardshellPowder = "硬化粉尘",
		AdamantSeed = "防御上升", -- 忍耐种子/霞魂防御

		GourmetFish = "烤熟的鱼",
		Immunizer = "回复加速", -- 猫式活力壶
		DashJuice = "耐力消耗减少", -- 强走药/耐力消耗减少/百目蝶

		-- Timers.Otomo
        OtomoRoar = "猫的强化咆哮之技",
        OtomoRunhigh = "猫的应援舞蹈之技",
        OtomoKijin = "猫的强化太鼓之技",

		-- Timers.Affinity
		MaximumMight = "精神抖擞",
		LatentPower = "力量解放",
		AffinitySliding = "滑走强化",
		WallRun = "墙面移动 III",

		-- Timers.Buffs
		ProtectivePolish = "刚刃打磨",
        Grinder = "打磨术【锐】",
		Counterstrike = "逆袭",
		OffensiveGuard = "攻击守势",
		HellfireCloak = "鬼火缠",
		Agitator = "挑战者",
		Furious = "激昂",

		-- Timers.Dodge
		AdrenalineRush = "巧击",
		StatusTrigger = "状态异常必定累积",
        BladescaleHoneBow = "刃鳞打磨【弓】",

		-- Timers.Muisc
		MusicSharpnessRegen = "旋律：斩味恢复",
		MusicRegen = "旋律：体力持续恢复",

		-- Timers.Dereliction and Virus
		Dereliction = "伏魔耗命",
		DerelictionII = "伏魔耗命 II",
		DerelictionIII = "伏魔耗命 III",
		VirusOvercome = "狂龙症【克服】",
		Coalescence = "因祸得福",

		-- Timers.HpRelated
		Heroics = "火场怪力",
		KitchenHeroics = "猫的火场怪力",
		Resuscitate = "死里逃生",
		PeakPerformance = "无伤",
		Dragonheart = "龙气活性",
		Resentment = "怨恨",

		-- Timers.ChainAttack
		ChainCrit = "连击",
		ChainCritII = "连击 II",
		KushalaDaoraSoul = "钢魂龙珠",
		KushalaDaoraSoulII = "钢魂龙珠 II",

		--------------
		-- Counters --
		--------------

		BloodblightHeal = "劫血【回复量】",
        BloodRite = "气血【回复量】",
        BladescaleHone = "刃鳞打磨",
		Foray = "攻势",

		-- Gauges
		SneakAttack = "偷袭",
		SneakAttackValue = "偷袭【伤害】",

		DivineBlessing = "精灵加护",
		DivineBlessingValue = "精灵加护格挡伤害",
		DangoBlessing = "团子防御术",
		DangoBlessingValue = "团子防御术格挡伤害",
		DangoDefender = "团子防护术",
		DangoDefenderValue = "团子防护术格挡伤害",

		-- Special calculation
		MasterTouchCriticalRate = "达人艺【会心】",
		PhysicsExploitRate = "弱点特效",
		ElementExploitRate = "弱点特效【属性】",
		MindEyeRate = "坚硬部位",

		-- Strings

		SkillReady = "技能 [<COL YEL>%s</COL>] 已就绪。",
		SkillActivated = "技能 [<COL YEL>%s</COL>] 已发动。",
		SkillEnd = "技能 [<COL YEL>%s</COL>] 已结束。",
		ItemActivated = "道具 [<COL YEL>%s</COL>] 已发动。",
		ItemEnd = "道具 [<COL YEL>%s</COL>] 已结束。",
		DerelictionReset = "技能 [<COL YEL>%s</COL>] 降为 I。",

		HitStatsPanel = "--- 命中数统计 ---",
		Hit = "命中",
		HitSuffix = " ",
		CriticalHit = "会心攻击",
		CriticalHitSuffix = "【会心】",
		PhysicsExploitHit = "弱点特效",
		PhysicsExploitHitSuffix = "【弱特】",
		MindEyeHit = "坚硬部位",
		MindEyeHitSuffix = "【心眼】",
		ElementHit = "元素攻击",
		ElementHitSuffix = "【元素】",
		ElementExploitHit = "弱点特效【属性】",
		ElementExploitHitSuffix = "【属弱特】",
		ElementCriticalHit = "会心击【属性】",
		ElementCriticalHitSuffix = "【属会】",
		MasterTouchHit = "达人艺",
		MasterTouchHitSuffix = "【达艺】",
		MasterTouchCriticalHit = "达人艺【会心】",
		MasterTouchCriticalHitSuffix = "【会心达艺】",
	}
}

local M = {}
local Languages = {"en-US", "zh-CN"}

local function Localized()
	return LocalizedStrings[M.config.Language]
end

local function RowName(typename)
    local name = Localized()[typename]
    if name == nil or name == "" then
		return typename
 	end
	return name
end

M.Languages = Languages
M.Localized = Localized
M.RowName = RowName
return M
