
local ChatManager = sdk.get_managed_singleton("snow.gui.ChatManager")
local VillageAreaManager = sdk.get_managed_singleton("snow.VillageAreaManager")
local PlayerManager = sdk.get_managed_singleton("snow.player.PlayerManager")
local QuestManager = sdk.get_managed_singleton("snow.QuestManager")
local MusicManager = sdk.get_managed_singleton("snow.wwise.WwiseMusicManager")
local MusicMixManager = sdk.get_managed_singleton("snow.wwise.WwiseMixManager")

local function GetChatManager()
    if ChatManager == nil then ChatManager = sdk.get_managed_singleton("snow.gui.ChatManager") end
    return ChatManager
end

local function GetVillageAreaManager()
	if VillageAreaManager == nil then VillageAreaManager = sdk.get_managed_singleton("snow.VillageAreaManager"); end
	return VillageAreaManager
end

local function GetPlayerManager()
    if PlayerManager == nil then PlayerManager = sdk.get_managed_singleton("snow.player.PlayerManager") end
	return PlayerManager
end

local function GetQuestManager()
    if QuestManager == nil then QuestManager = sdk.get_managed_singleton("snow.QuestManager") end
	return QuestManager
end

local function GetMusicManager()
    if MusicManager == nil then MusicManager = sdk.get_managed_singleton("snow.wwise.WwiseMusicManager") end
	return MusicManager
end

local function GetMusicMixManager()
    if MusicMixManager == nil then MusicMixManager = sdk.get_managed_singleton("snow.wwise.WwiseMixManager") end
	return MusicMixManager
end

local function RefreshManagers()
    GetChatManager()
    GetVillageAreaManager()
    GetPlayerManager()
    GetQuestManager()
    GetMusicManager()
    GetMusicMixManager()
end

local villageAreaManagerTypeDef = sdk.find_type_definition("snow.VillageAreaManager");
local isInTrainingAreaMethod = villageAreaManagerTypeDef:get_method("checkCurrentArea_TrainingArea");

local function IsInTrainingArea()
	local villageManager = GetVillageAreaManager()
	if villageManager == nil then return end
	return isInTrainingAreaMethod:call(villageManager)
end

-- Very useful if you don't want your mod to interfere in fights
-- Credit: raffRun's Mod Utils
-- https://www.nexusmods.com/monsterhunterrise/mods/376?tab=files
local function CheckIfInBattle()
    local musicManager = GetMusicManager()

    local currentMusicType = musicManager:get_field("_FightBGMType")
    local currentBattleState = musicManager:get_field("_CurrentEnemyAction")

    local musicMixManager = GetMusicMixManager()
    local currentMixUsed = musicMixManager:get_field("_Current")

    local questManager = GetQuestManager()

    local currentQuestType = questManager:get_field("_QuestType")
    local currentQuestStatus = questManager:get_field("_QuestStatus")

    local inBattle = currentBattleState == 3 -- Fighting a monster
    or currentMixUsed == 37 -- Fighting a wave of monsters
    or currentMixUsed == 10 -- Stronger battle music mix is being used
    or currentMixUsed == 31 -- Used in some arena battles
    or currentQuestType == 64 -- Fighting in the arena (Utsushi)

    local isQuestComplete = currentQuestStatus == 3 -- Completed the quest
    or currentQuestStatus == 0 -- Not in a quest

    return inBattle and not isQuestComplete
end

local function QuestComplete()
    local questManager = GetQuestManager()
	if questManager == nil then return nil end
    local currentQuestStatus = questManager:get_field("_QuestStatus")
	if currentQuestStatus == nil then return nil end
    local isQuestComplete = currentQuestStatus == 3 -- Completed the quest
    or currentQuestStatus == 0 -- Not in a quest

	return isQuestComplete
end

local function NeedRecord()
	return IsInTrainingArea() or CheckIfInBattle()
end

-- SCRIPT functions
local stackedText = ""
local function ComposeMessage(text)
	if stackedText == "" then
		stackedText = text
		return
	end
	stackedText = stackedText .. "\n" .. text
end

local function SendMessage(text)
	if text == nil or text == "" then
		text = stackedText
		stackedText = ""
		if text == "" or text == nil then
			return
		end
	end
    local chatManager = GetChatManager()
	if chatManager == nil then return end
	chatManager:call("reqAddChatInfomation", text, 2289944406)
end

local function GetMasterPlayer()
	local playerManager = GetPlayerManager()
	if playerManager == nil then return nil end
    local MasterPlayer = playerManager:call("findMasterPlayer")
    return MasterPlayer
end

local M = {}
M.GetChatManager = GetChatManager
M.GetVillageAreaManager = GetVillageAreaManager
M.GetPlayerManager = GetPlayerManager
M.GetQuestManager = GetQuestManager
M.GetMusicManager = GetMusicManager
M.GetMusicMixManager = GetMusicMixManager
M.RefreshManagers = RefreshManagers
M.GetMasterPlayer = GetMasterPlayer

M.IsInTrainingArea = IsInTrainingArea
M.CheckIfInBattle = CheckIfInBattle
M.QuestComplete = QuestComplete
M.NeedRecord = NeedRecord
M.ComposeMessage = ComposeMessage
M.SendMessage = SendMessage
return M
