
local TimerTypes = {
    "Bloodblight",

	"Clothfly",
	-- "Butterflame",
	-- "Peepersects",
	"Cutterfly",
	-- "RedLampsquid",
	-- "YellowLampsquid",
	-- "GreenLampsquid",
	-- "GoldenLampsquid",
	"WireBugPowerup",

	"Demondrug",
	"MegaDemondrug",
	"DemonPowder",
	"MightSeed",
	"Armorskin",
	"MegaArmorskin",
	"HardshellPowder",
	"AdamantSeed",
	"GourmetFish",
	"Immunizer",
	"DashJuice",

    "OtomoRoar",
    "OtomoRunhigh",
    "OtomoKijin",

	"MaximumMight",
	"LatentPower",
	"AffinitySliding",
	"WallRun",

	"ProtectivePolish",
	"Grinder",
	"Counterstrike",
	"OffensiveGuard",
	"HellfireCloak",
	"Agitator",
	"Furious",

    "BladescaleHoneBow",
	"AdrenalineRush",
	"StatusTrigger",

	"MusicSharpnessRegen",
	"MusicRegen",

	"Dereliction",
	"DerelictionII",
	"DerelictionIII",
	"VirusOvercome",
	"Coalescence",

	"Heroics",
	"KitchenHeroics",
	"Resuscitate",
	"PeakPerformance",
	"Dragonheart",
	"Resentment",

	"ChainCrit",
	"ChainCritII",
	"KushalaDaoraSoul",
	"KushalaDaoraSoulII",
}

local CounterTypes = {
    "BloodblightHeal",
    "BloodRite",
    "BladescaleHone",
    "Foray",
}

local GaugeTypes = {
    "SneakAttack",
    "DivineBlessing",
    "DangoBlessing",
    "DangoDefender",
}

local ValidRowCounterTypes = {
    "BloodblightHeal",
    "BloodRite",
    "BladescaleHone",
    "Foray",

    "SneakAttack",
    "DivineBlessing",
    "DangoBlessing",
    "DangoDefender",
}

local SpecialHitTypes = {
	"CriticalHit",
    "PhysicsExploitHit",
    "MindEyeHit",
	"ElementHit",
	"ElementExploitHit",
    "ElementCriticalHit",
	"MasterTouchHit",
    "MasterTouchCriticalHit",
}

local Attributes = {
	"Health",
	"Attack",
	"ElementAttack",
	"ElementAttack2nd",
	"Affinity",
	"Defense",
	"BattleTime",
}

local M = {}
M.PanelOpts = {}
M.BuffOpts = {}
M.logDebugInfo = false
M.TimerTypes = TimerTypes
M.GaugeTypes = GaugeTypes
M.ValidRowCounterTypes = ValidRowCounterTypes
M.SpecialHitTypes = SpecialHitTypes
M.Attributes = Attributes

local UIRow = 0

function M.NewTable(rows)
	d2d.fill_rect(M.PanelOpts.PosX, M.PanelOpts.PosY, 
		M.PanelOpts.Width, rows * M.PanelOpts.RowHeight + M.PanelOpts.Indent * 2, M.PanelOpts.BackgroundColor)
	UIRow = 0
end

function M.TableEnd(rows)
end

function M.NewRow(rowName, valA, valB, extraName)
	if rowName == nil then return nil end

	local name = M.localization.RowName(rowName)
	if extraName ~= nil then
		name = name .. M.localization.RowName(extraName)
	end
	local posY = M.PanelOpts.PosY + (UIRow) * M.PanelOpts.RowHeight + 10

	d2d.text(M.font, name, M.PanelOpts.PosX + M.PanelOpts.Indent, posY, M.PanelOpts.FontColor)
	if valA ~= nil and valA ~= "" then
		d2d.text(M.font, valA, M.PanelOpts.PosX + M.PanelOpts.ColumnAOffset, posY, M.PanelOpts.FontColor)
	end
	if valB ~= nil and valB ~= "" then
		d2d.text(M.font, valB, M.PanelOpts.PosX + M.PanelOpts.ColumnBOffset, posY, M.PanelOpts.FontColor)
	end
	UIRow = UIRow + 1
    return true
end

local function SecondsColumn(val)
	if val ~= nil then -- and val ~= 0 then
		return string.format("%.1fs", val)
	end
	return ""
end

local function IntColumn(val)
	if val ~= nil then -- and val ~= 0 then
		return tostring(math.floor(val))
	end
	return ""
end

local function FloatColumn(val)
	if val ~= nil then -- and val ~= 0 then
		return string.format("%.1f", val)
	end
	return ""
end

local function PercentageColumn(val)
	if val ~= nil then -- and val ~= 0 then
		return string.format("%.1f%%", val)
	end
	return ""
end

function M.OnUpdateSummaryUI(font, attrConf, notifyConfig, hitConf, collector, singletons, utils, localization)
    M.font = font
    M.localization = localization

	local time = utils.GetTime()
	local inBattle = singletons.CheckIfInBattle()

	if inBattle then
		if collector.InBattle == false then
			collector.LastInBattleTime = time
		end
		collector.InBattle = true
	else
		if collector.InBattle == true then
			collector.TotalInBattleTime = collector.TotalInBattleTime + time - collector.LastInBattleTime
		end
		collector.InBattle = false
	end

	local totalInBattleTime = collector.TotalInBattleTime
	if collector.InBattle then
		totalInBattleTime = totalInBattleTime + time - collector.LastInBattleTime
	end

	local training = singletons.IsInTrainingArea()
	local complete = singletons.QuestComplete()

	local shouldUpdateInBattleActivateTime = training or (inBattle and (not complete))

	-- 计算 Hit 行数
	local HitRows = 0
	for i = 1, #SpecialHitTypes do
		local hitType = SpecialHitTypes[i]
		local value = collector.Counter[hitType]
		if hitConf[hitType] == true and value ~= nil and value ~= 0 then
			HitRows = HitRows + 1
		end
    end

	if HitRows > 0 then
		HitRows = HitRows + 2
	end

	-- 计算 Timer, BuffHit 行数
    local TimerRows = 0
	local BuffCoveredHitRows = 0
	for i = 1, #TimerTypes do
		local skillName = TimerTypes[i]

		local hasTitle = false
		if notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayInPanel == true then
			local timeData = collector.TimeRecord[skillName]
			if timeData ~= nil and timeData.LastActivated ~= 0 then
				TimerRows = TimerRows + 1
				hasTitle = true
			end
		end

		local hitsData = collector.BuffCoveredHitCounter[skillName]
		if hitsData ~= nil then
			local rows = 0
			for j = 0, (#SpecialHitTypes - 2) do -- 不包含最后的达人艺
				local hitType = "Hit"
				if j > 0 then
					hitType = SpecialHitTypes[j]
				end

				if (notifyConfig[skillName] ~= nil and
					notifyConfig[skillName].BuffHitConfig ~= nil and
					notifyConfig[skillName].BuffHitConfig[hitType] == true) then
					local value = hitsData[hitType]
					if value ~= nil and value ~= 0 then
						rows = rows + 1
					end
				end
			end
			if rows > 0 then
				BuffCoveredHitRows = BuffCoveredHitRows + rows
			end
			if not hasTitle then
				BuffCoveredHitRows = BuffCoveredHitRows + 1
			end
		end
    end

	-- 计算 Counter 行数
    local CounterRows = 0
	for i = 1, #ValidRowCounterTypes do
		local skillName = ValidRowCounterTypes[i]
		if notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayInPanel == true then
			local value = collector.Counter[skillName]
			if value ~= nil and value ~= 0 then
				CounterRows = CounterRows + 1
			end
		end
    end

	-- ---------------------------------------------

    local ValidRows = TimerRows + CounterRows + HitRows + BuffCoveredHitRows

    if not shouldUpdateInBattleActivateTime and ValidRows == 0 then
        return
    end

    local playerData = singletons.GetMasterPlayer():call("get_PlayerData")

	-- 计算 Attrs
	if attrConf["Health"] then
		ValidRows = ValidRows + 1
	end
	if attrConf["Attack"] then
		ValidRows = ValidRows + 1
	end
	if attrConf["Affinity"] then
		ValidRows = ValidRows + 1
	end
	if attrConf["Defense"] then
		ValidRows = ValidRows + 1
	end
    local elemAtk = playerData:get_field("_ElementAttack")
    local elemAtk2 = playerData:get_field("_ElementAttack2nd")
    if attrConf["ElementAttack"] and elemAtk ~= nil and elemAtk ~= 0 then ValidRows = ValidRows + 1 end
    if attrConf["ElementAttack2nd"] and elemAtk2 ~= nil and elemAtk2 ~= 0 then ValidRows = ValidRows + 1 end
	if not training and attrConf["BattleTime"] then
		ValidRows = ValidRows + 1
	end
	-- ValidRows = ValidRows + 4 -- Debug Rows
    M.NewTable(ValidRows)

	if attrConf["Health"] then
		M.NewRow("Health", IntColumn(collector.CurrentHealth))
	end
	if attrConf["Attack"] then
		M.NewRow("Attack", IntColumn(playerData:get_field("_Attack")))
	end
	if attrConf["ElementAttack"] and elemAtk ~= nil and elemAtk ~= 0 then
    	M.NewRow("ElementAttack", IntColumn(elemAtk))
	end
	if attrConf["ElementAttack2nd"] and elemAtk2 ~= nil and elemAtk2 ~= 0 then
    	M.NewRow("ElementAttack2nd", IntColumn(elemAtk2))
	end

	if attrConf["Affinity"] then
		M.NewRow("Affinity", IntColumn(playerData:get_field("_CriticalRate")))
	end
	if attrConf["Defense"] then
		M.NewRow("Defense", IntColumn(playerData:get_field("_Defence")))
	end

    if M.logDebugInfo then
		M.NewRow("Running:", tostring(utils.Paused))
		M.NewRow("Time:", SecondsColumn(time))
    end
	if not training and attrConf["BattleTime"] then
		M.NewRow("BattleTime:", SecondsColumn(totalInBattleTime))
	end

	if training then
        if M.logDebugInfo then
            M.NewRow("Training:", tostring(training))
        end
	else
		if complete then
			collector.EndAllTimerRecord()
		end
        if M.logDebugInfo then
            M.NewRow("QuestComplete:", tostring(complete))
        end
	end

    if M.logDebugInfo then
		M.NewRow("TimerRows:", tostring(TimerRows))
		M.NewRow("CounterRows:", tostring(CounterRows))
		M.NewRow("HitRows:", tostring(HitRows))
		M.NewRow("BuffCoveredHitRows:", tostring(BuffCoveredHitRows))
		M.NewRow("ShouldRecord:", tostring(shouldUpdateInBattleActivateTime))
    end

	local totalHit = collector.Counter["Hit"]
	for i = 1, #TimerTypes do
		local skillName = TimerTypes[i]
		local timeData = collector.TimeRecord[skillName]

		local hasTitle = false
		if (notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayInPanel == true) and
			timeData ~= nil and timeData.LastActivated ~= 0 then
			local totalTime = timeData.TotalTime
			if (training or not complete) and timeData.Activated then
				totalTime = totalTime + time - timeData.LastActivated
			end
			if collector.InBattleRecord[skillName] == nil then
				collector.InBattleRecord[skillName] = {}
				collector.InBattleRecord[skillName].TotalTime = 0
				collector.InBattleRecord[skillName].LastInBattle = time
			end
			local totalTimeInBattle = collector.InBattleRecord[skillName].TotalTime
			if shouldUpdateInBattleActivateTime and timeData.Activated then
				collector.InBattleRecord[skillName].TotalTime = collector.InBattleRecord[skillName].TotalTime + time - collector.InBattleRecord[skillName].LastInBattle
				collector.InBattleRecord[skillName].LastInBattle = time
				totalTimeInBattle = collector.InBattleRecord[skillName].TotalTime
			else
				collector.InBattleRecord[skillName].LastInBattle = time
			end

			local rate = nil
			if totalInBattleTime ~= 0 then
				rate = 100*totalTimeInBattle/totalInBattleTime
			end
			hasTitle = true
			M.NewRow(skillName, SecondsColumn(totalTimeInBattle), PercentageColumn(rate))
		end

		local hitsData = collector.BuffCoveredHitCounter[skillName]
		if hitsData ~= nil then
			for j = 0, (#SpecialHitTypes - 2) do -- 不包含最后的达人艺
				local hitType = "Hit"
				if j > 0 then
					hitType = SpecialHitTypes[j]
				end

				local hits = hitsData[hitType]
				if hits ~= nil and hits > 0 then
					if (notifyConfig[skillName] ~= nil and
						notifyConfig[skillName].BuffHitConfig ~= nil and
						notifyConfig[skillName].BuffHitConfig[hitType] == true) then
						local rate = 100*hits/totalHit
						if not hasTitle then
							M.NewRow(skillName)
							hasTitle = true
						end
						M.NewRow("  "..localization.RowName(hitType), tostring(hits), PercentageColumn(rate))
					end
				end
			end
		end
	end

	for i = 1, #CounterTypes do
		local skillName = CounterTypes[i]
		local value =collector.Counter[skillName]
		if (notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayInPanel == true) and
			value ~= nil and value ~= 0 then
			M.NewRow(skillName, tostring(value))
		end
	end

	for i = 1, #GaugeTypes do
		local skillName = GaugeTypes[i]
		local hits = collector.Counter[skillName]
		if (notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayInPanel == true) and
			hits ~= nil and hits ~= 0 then
			local val = collector.Counter[skillName .. "Value"]
			M.NewRow(skillName, tostring(hits), FloatColumn(val))
		end
	end

	-- local masterTouchHit = collector.Counter["MasterTouchHit"]
	-- local masterTouchCriticalHit = collector.Counter["MasterTouchCriticalHit"]
	-- if (notifyConfig["MasterTouchCriticalRate"] ~= nil and notifyConfig["MasterTouchCriticalRate"].DisplayInPanel == true) and
	-- 	masterTouchHit ~= nil and masterTouchHit ~= 0 then
	-- 	if masterTouchCriticalHit ~= nil then
	-- 		local rate = 100*masterTouchCriticalHit/masterTouchHit
	-- 		M.NewRow("MasterTouchCriticalRate", tostring(masterTouchCriticalHit), PercentageColumn(rate))
	-- 	end
	-- end

	-- local phyExploitHit = collector.Counter["PhysicsExploitHit"]
	-- local phyHit = collector.Counter["PhysicsHit"]
	-- if (notifyConfig["PhysicsExploitRate"] ~= nil and notifyConfig["PhysicsExploitRate"].DisplayInPanel == true) and
	-- 	phyHit ~= nil and phyHit ~= 0 then
	-- 	if phyExploitHit ~= nil then
	-- 		local rate = 100*phyExploitHit/phyHit
	-- 		M.NewRow("PhysicsExploitRate", tostring(phyExploitHit), PercentageColumn(rate))
	-- 	end
	-- end

	-- local eleExploitHit = collector.Counter["ElementExploitHit"]
	-- local eleHit = collector.Counter["ElementHit"]
	-- if (notifyConfig["ElementExploitRate"] ~= nil and notifyConfig["ElementExploitRate"].DisplayInPanel == true) and
	-- 	eleHit ~= nil and eleHit ~= 0 then
	-- 	if eleExploitHit ~= nil then
	-- 		local rate = 100*eleExploitHit/eleHit
	-- 		M.NewRow("ElementExploitRate", tostring(eleExploitHit), PercentageColumn(rate))
	-- 	end
	-- end

	-- local mindEyeHit = collector.Counter["MindEyeHit"]
	-- if (notifyConfig["MindEyeRate"] ~= nil and notifyConfig["MindEyeRate"].DisplayInPanel == true) and
	-- 	phyHit ~= nil and phyHit ~= 0 then
	-- 	if mindEyeHit ~= nil then
	-- 		local rate = 100*mindEyeHit/phyHit
	-- 		M.NewRow("MindEyeRate", tostring(mindEyeHit), PercentageColumn(rate))
	-- 	end
	-- end

	-- Buff Covered Hit Rows

	if HitRows > 0 or BuffCoveredHitRows > 0 then
		M.NewRow("")
		M.NewRow("HitStatsPanel")
	end
	if totalHit == nil or totalHit == 0 then totalHit = 1 end

	for i = 1, #SpecialHitTypes do
		local hitType = SpecialHitTypes[i]
		local value = collector.Counter[hitType]
		if hitConf[hitType] == true and value ~= nil and value ~= 0 then
			local rate = 100*value/totalHit
			M.NewRow(hitType, tostring(value), PercentageColumn(rate))
		end
    end

    M.TableEnd()
end

function M.DrawBars(font, notifyConfig, collector, singletons)
	local isTraining = singletons.IsInTrainingArea()
	local questComplete = singletons.QuestComplete()
	if not isTraining and questComplete then
		return
	end

	local BuffBars = collector.BuffBars
    local rows = 0
    for i = 1, #TimerTypes do
		local skillName = TimerTypes[i]
		local data = BuffBars.Skills[skillName]
		if data ~= nil and notifyConfig[skillName] ~= nil and notifyConfig[skillName].DisplayBuffBar == true then
			local posX = M.BuffOpts.PosX
			local posY = M.BuffOpts.PosY + rows * (M.BuffOpts.Height + M.BuffOpts.Indent)

			local name = M.localization.RowName(skillName)
			d2d.fill_rect(posX, posY, #name * M.BuffOpts.FontSize / 2 + 4, M.BuffOpts.FontSize + M.BuffOpts.BorderWidth * 2,  M.BuffOpts.BackgroundColor)
			d2d.text(font, name, posX + M.BuffOpts.BorderWidth, posY + M.BuffOpts.BorderWidth, M.BuffOpts.FontColor)

			rows = rows + 1
			posY = M.BuffOpts.PosY + rows * (M.BuffOpts.Height + M.BuffOpts.Indent)
			d2d.fill_rect(posX, posY, M.BuffOpts.BarWidth, M.BuffOpts.Height,  M.BuffOpts.BackgroundColor)
			d2d.fill_rect(posX + M.BuffOpts.BorderWidth, posY + M.BuffOpts.BorderWidth, (M.BuffOpts.BarWidth - M.BuffOpts.BorderWidth * 2) * data.CurrentTimer / data.MaxTimer, M.BuffOpts.Height - M.BuffOpts.BorderWidth * 2, M.BuffOpts.BarColor)
			d2d.text(font, string.format("%.1fs", data.CurrentTimer / 60), posX + M.BuffOpts.BarWidth + M.BuffOpts.Indent, posY - M.BuffOpts.BorderWidth * 2, M.BuffOpts.FontColor)
			rows = rows + 1
		end
    end
end

return M
