local function TableLength(T)
	local count = 0
	for _ in pairs(T) do count = count + 1 end
	return count
end

-- 传入解包表的 ID
local function NormalizeSkillID(id)
	if id <= 110 then
		-- 解包表从 0 开始，但游戏内是从 1 开始
		return id + 1
	end
	if id >= 200 then
		-- 解包表中 DLC 技能从 200 开始（本体是 0-110）
		-- 但游戏内是按顺序的
		-- 例如，伏魔耗命在解包表中是 201，实际获取到的是 113
		-- 也就是说，200 实际上是 111，相差 89
		return (id + 1) - 89
	end
end

local getTimeSecond = sdk.find_type_definition("via.Application"):get_method("get_UpTimeSecond")
local getActive = sdk.find_type_definition("via.Application"):get_method("get_Active")
local function GetTime()
    return getTimeSecond:call(nil)
end
local function GetActive()
	return getActive:call(nil)
end

local utils = {
	Paused = 100
}

function utils.SetPauseStatus(paused)
	utils.Paused = paused
end
utils.TableLength = TableLength
utils.NormalizeSkillID = NormalizeSkillID
utils.GetTime = GetTime
utils.GetActive = GetActive
return utils
