using System;
using System.Collections.Generic;
using ElmSharp;
using Microsoft.Maui.Controls.Platform;
using Microsoft.Maui.Controls.Compatibility.Platform.Tizen.Native;
using Microsoft.Maui.Controls.Compatibility.Platform.Tizen.Native.Watch;
using Microsoft.Maui.Devices;
using EEntry = ElmSharp.Entry;
using NIEntry = Microsoft.Maui.Controls.Compatibility.Platform.Tizen.Native.IEntry;

namespace Microsoft.Maui.Controls.Compatibility.Platform.Tizen
{
	[System.Obsolete(Compatibility.Hosting.MauiAppBuilderExtensions.UseMapperInstead)]
	public class PickerRenderer : ViewRenderer<Picker, EEntry>
	{
		List _list;
		Dialog _dialog;
		Dictionary<ListItem, int> _itemToItemNumber = new Dictionary<ListItem, int>();

		public PickerRenderer()
		{
			RegisterPropertyHandler(Picker.SelectedIndexProperty, UpdateSelectedIndex);
			RegisterPropertyHandler(Picker.TextColorProperty, UpdateTextColor);
			RegisterPropertyHandler(Picker.FontSizeProperty, UpdateFontSize);
			RegisterPropertyHandler(Picker.FontFamilyProperty, UpdateFontFamily);
			RegisterPropertyHandler(Picker.FontAttributesProperty, UpdateFontAttributes);
			RegisterPropertyHandler(Picker.TitleProperty, UpdateTitle);
			RegisterPropertyHandler(Picker.TitleColorProperty, UpdateTitleColor);
			RegisterPropertyHandler(Picker.HorizontalTextAlignmentProperty, UpdateHorizontalTextAlignment);
		}

		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (Control != null)
				{
					if (Control is NIEntry ie)
					{
						ie.TextBlockFocused -= OnTextBlockFocused;
						ie.EntryLayoutFocused -= OnFocused;
						ie.EntryLayoutUnfocused -= OnUnfocused;
						if (DeviceInfo.Idiom == DeviceIdiom.TV)
						{
							ie.EntryLayoutFocused -= OnLayoutFocused;
							ie.EntryLayoutUnfocused -= OnLayoutUnfocused;
						}
					}
					CleanView();
				}
			}
			base.Dispose(disposing);
		}

		protected override void OnElementChanged(ElementChangedEventArgs<Picker> e)
		{
			if (Control == null)
			{
				var entry = CreateNativeControl();
				entry.SetVerticalTextAlignment(0.5);
				if (entry is NIEntry ie)
				{
					ie.TextBlockFocused += OnTextBlockFocused;
					ie.EntryLayoutFocused += OnFocused;
					ie.EntryLayoutUnfocused += OnUnfocused;

					if (DeviceInfo.Idiom == DeviceIdiom.TV)
					{
						ie.EntryLayoutFocused += OnLayoutFocused;
						ie.EntryLayoutUnfocused += OnLayoutUnfocused;
					}
				}
				SetNativeControl(entry);
			}
			base.OnElementChanged(e);
		}

		protected virtual EEntry CreateNativeControl()
		{
			return new EditfieldEntry(Forms.NativeParent)
			{
				IsSingleLine = true,
				InputPanelShowByOnDemand = true,
				IsEditable = false,
				HorizontalTextAlignment = Native.TextAlignment.Center
			};
		}

		protected virtual void UpdateSelectedIndex()
		{
			Control.Text = (Element.SelectedIndex == -1 || Element.Items == null ?
				"" : Element.Items[Element.SelectedIndex]);
		}

		protected virtual void UpdateTitleColor()
		{
			if (Control is NIEntry ie)
			{
				ie.PlaceholderColor = Element.TitleColor.ToPlatformEFL();
			}
		}

		protected virtual void UpdateTextColor()
		{
			if (Control is NIEntry ie)
			{
				ie.TextColor = Element.TextColor.ToPlatformEFL();
			}
		}

		void UpdateFontSize()
		{
			if (Control is NIEntry ie)
			{
				ie.FontSize = Element.FontSize;
			}
		}

		void UpdateFontFamily()
		{
			if (Control is NIEntry ie)
			{
				ie.FontFamily = Element.FontFamily;
			}
		}

		void UpdateFontAttributes()
		{
			if (Control is NIEntry ie)
			{
				ie.FontAttributes = Element.FontAttributes;
			}
		}

		void UpdateTitle()
		{
			if (Control is NIEntry ie)
			{
				ie.Placeholder = Element.Title;
			}
		}

		void UpdateHorizontalTextAlignment()
		{
			if (Control is NIEntry ie)
			{
				ie.HorizontalTextAlignment = Element.HorizontalTextAlignment.ToNative();
			}
		}

		void OnLayoutFocused(object sender, EventArgs e)
		{
			if (Control is NIEntry ie)
			{
				ie.FontSize = ie.FontSize * 1.5;
			}
		}

		void OnLayoutUnfocused(object sender, EventArgs e)
		{
			if (Control is NIEntry ie)
			{
				ie.FontSize = ie.FontSize / 1.5;
			}
		}

		void OnTextBlockFocused(object sender, EventArgs e)
		{
			// For EFL Entry, the event will occur even if it is currently disabled.
			// If the problem is resolved, no conditional statement is required.
			if (Element.IsEnabled)
			{
				int i = 0;
				if (DeviceInfo.Idiom == DeviceIdiom.Watch)
				{
					_dialog = new WatchDialog(Forms.NativeParent, false);
				}
				else
				{
					_dialog = new Dialog(Forms.NativeParent);
				}
				_dialog.AlignmentX = -1;
				_dialog.AlignmentY = -1;
				_dialog.Title = Element.Title;
				_dialog.TitleColor = Element.TitleColor.ToPlatformEFL();
				_dialog.Dismissed += OnDialogDismissed;
				_dialog.BackButtonPressed += (object senders, EventArgs es) =>
				{
					_dialog.Dismiss();
				};

				_list = new List(_dialog);
				foreach (var s in Element.Items)
				{
					ListItem item = _list.Append(s);
					_itemToItemNumber[item] = i;
					i++;
				}
				_list.ItemSelected += OnItemSelected;
				_dialog.Content = _list;

				// You need to call Show() after ui thread occupation because of EFL problem.
				// Otherwise, the content of the popup will not receive focus.
				Application.Current.Dispatcher.Dispatch(() =>
				{
					_dialog.Show();
					_list.Show();
				});
			}
		}

		void OnItemSelected(object senderObject, EventArgs ev)
		{
			Element.SetValueFromRenderer(Picker.SelectedIndexProperty, _itemToItemNumber[(senderObject as List).SelectedItem]);
			_dialog.Dismiss();
		}

		void OnDialogDismissed(object sender, EventArgs e)
		{
			CleanView();
		}

		void CleanView()
		{
			if (null != _list)
			{
				_list.Unrealize();
				_itemToItemNumber.Clear();
				_list = null;
			}
			if (null != _dialog)
			{
				_dialog.Unrealize();
				_dialog = null;
			}
		}
	}
}
