﻿#if IOS && !MACCATALYST
using PlatformView = Microsoft.Maui.Platform.MauiDatePicker;
#elif MACCATALYST
using PlatformView = UIKit.UIDatePicker;
#elif MONOANDROID
using PlatformView = Microsoft.Maui.Platform.MauiDatePicker;
#elif WINDOWS
using PlatformView = Microsoft.UI.Xaml.Controls.CalendarDatePicker;
#elif TIZEN
using PlatformView = Tizen.UIExtensions.ElmSharp.Entry;
#elif (NETSTANDARD || !PLATFORM) || (NET6_0 && !IOS && !ANDROID && !TIZEN)
using PlatformView = System.Object;
#endif

namespace Microsoft.Maui.Handlers
{
	public partial class DatePickerHandler : IDatePickerHandler
	{
		public static IPropertyMapper<IDatePicker, IDatePickerHandler> Mapper = new PropertyMapper<IDatePicker, IDatePickerHandler>(ViewHandler.ViewMapper)
		{
#if __ANDROID__
			[nameof(IDatePicker.Background)] = MapBackground,
#elif __IOS__
			[nameof(IDatePicker.FlowDirection)] = MapFlowDirection,
#endif
			[nameof(IDatePicker.CharacterSpacing)] = MapCharacterSpacing,
			[nameof(IDatePicker.Date)] = MapDate,
			[nameof(IDatePicker.Font)] = MapFont,
			[nameof(IDatePicker.Format)] = MapFormat,
			[nameof(IDatePicker.MaximumDate)] = MapMaximumDate,
			[nameof(IDatePicker.MinimumDate)] = MapMinimumDate,
			[nameof(IDatePicker.TextColor)] = MapTextColor,
		};

		public static CommandMapper<IPicker, IDatePickerHandler> CommandMapper = new(ViewCommandMapper)
		{
		};

		public DatePickerHandler() : base(Mapper)
		{
		}

		public DatePickerHandler(IPropertyMapper mapper) : base(mapper)
		{
		}

		IDatePicker IDatePickerHandler.VirtualView => VirtualView;

		PlatformView IDatePickerHandler.PlatformView => PlatformView;
	}
}