using Microsoft.Maui.ApplicationModel;
using Microsoft.Maui.Media;
using Xunit;

namespace Tests
{
	public class TextToSpeech_Tests
	{
		[Fact]
		public void TextToSpeech_Speak_Fail_On_NetStandard() =>
			 Assert.ThrowsAsync<NotImplementedInReferenceAssemblyException>(() => TextToSpeech.SpeakAsync("Xamarin Essentials!"));

		[Fact]
		public void TextToSpeech_Slit_Text()
		{
			var lorem = "Lorem ipsum dolor sit amet, cu commune philosophia qui, est ea copiosae pertinacia. An modus prodesset cum, in quo reque mundi. Ea illum velit erroribus cum, mei id natum etiam conceptam. In erant dignissim eum. Nusquam constituto reprimique sea at, omnium iisque prodesset quo cu. Soluta semper persius ea vim. Est ad mollis dissentiet. Ut delenit accusamus pri. Libris vivendo definitiones eam ut, in ius quot conceptam, sit dicunt fabellas no. Qui ne quod unum autem. Vel ex iudico accumsan. Ferri propriae adolescens mel et. Est suas detracto delectus ad, id sit sumo quaerendum. At cum quas quaestio aliquando, pro sale definitiones ne, ei feugiat omnesque usu. Ei vis erant eirmod habemus. Adhuc regione sit at, mei cu corpora eligendi. Electram definitiones et vim, vivendo copiosae quaerendum pri id, eu sea dico senserit percipitur. Et graece suscipit pri, ne vis labitur euripidis incorrupte, in sea amet detracto. Mea ne elitr conclusionemque, cu essent equidem persecuti sea. Cu mel vocibus omittam albucius, sea praesent moderatius id. Vivendum deserunt intellegat te vim. Eos in error impedit deseruisse. Dicant prompta elaboraret et eam, aperiri urbanitas mel et. Vix justo nullam dissentiunt eu, qui ut consulatu voluptatibus, nam lorem copiosae ne. Sea verterem disputando ex, at placerat facilisis reprimique qui. Ei per dicta accumsan, ex cum dicam libris malorum, no mucius aperiam ancillae vis. Dicat feugiat vim ei, mei modo meis velit cu. Bonorum omittam tacimates ne duo, ei duo mucius vivendo. Per iisque impedit ne. Wisi movet sadipscing ex nec. Sit an meis latine nusquam, at dicam semper ullamcorper nec. Usu cu erat alterum necessitatibus. Ea mel wisi conceptam moderatius, virtute voluptaria ei vim. Has vero postea at, qui ea sonet tacimates. Mea ad illud novum graeci, per ex quot similique. Has eu erat docendi. Eum salutandi incorrupte ut, te mel falli scribentur, sed labore option volutpat ne. Utinam propriae pri ad, eum ea dicit adipiscing. Fabulas legendos interesset id sit. An fugit nullam impetus eos. Pri in omittam adversarium, et utamur phaedrum maiestatis eum. His equidem maluisset voluptaria et, ea pro erat laudem veritus. Iriure propriae scaevola ei quo. Vim no meis argumentum, prodesset mediocritatem te quo. Singulis electram nec ad. Vel elitr consul altera id, utamur philosophia ne quo, aperiri dolores duo id. An usu eruditi elaboraret, no vis verear aliquip, cu eros rebum usu. Dictas fastidii concludaturque ei sit, iuvaret placerat abhorreant sit id, cu vel definiebas contentiones deterruisset. Te duo dicat fastidii, paulo argumentum et cum. Prima maluisset vituperata est cu, et tollit soleat moderatius est, nec veniam exerci te. Platonem sententiae sadipscing no nec. Mutat libris cum an, an pri assum alienum reformidans, in sea mucius albucius mnesarchum. Ius habemus oportere volutpat te, essent dissentiet has ea. Quo prompta petentium consetetur at, ne quod commodo patrioque pro. Et eam semper intellegam, copiosae mediocritatem in vix. Id mea laudem omnium officiis, quem exerci possit ad ius, appetere intellegebat sea at. Ea odio elit idque mel. In legere ceteros conclusionemque vim, ea graeco luptatum cum. Ne corpora imperdiet referrentur per, ipsum ludus in vel. Ex sit omnis tation aliquam, modo similique ei pro. Ad elit adipisci sententiae qui. Graeci alienum reprehendunt ei vel, propriae appetere sea no. An novum antiopam nec, mel quot quodsi iuvaret in, an ignota sapientem cum. Vim atqui eleifend ut, ut error delenit qualisque his. Altera persecuti mel ex, has facilis fierent tractatos no, te congue perpetua gubergren per. Stet periculis quo cu, nec et volumus epicurei sensibus, tamquam temporibus nam ei. Ex diam soleat tempor per, vel id paulo ubique discere. Vel cu possit insolens. Modo brute disputationi sit at, eu amet postulant pri, ea justo facilis inimicus cum. Iusto volumus perfecto vis ei, at saperet luptatum platonem vis. Usu at simul alterum quaestio, novum tamquam persius ut vis, vim numquam praesent definiebas id. Usu te purto paulo, duo aperiam maiorum consetetur ei. Et quo novum quidam. Ei adhuc explicari nam. Vide eleifend honestatis pri in, eum ex praesent persecuti conclusionemque. Nam omittam detraxit suscipiantur eu, posidonium assueverit ne eos. Eu vidit senserit nam, ad audire aliquando vim, cu eos imperdiet comprehensam. Ut delectus abhorreant quo, case choro maiorum id eos, te mel stet affert vocibus. Quod commodo reprimique sit an. Sea in scripserit dissentiet, cu stet delectus eam. An his dicta principes, atomorum temporibus no qui. Nam ad tantas deseruisse, illud officiis disputando cu sea, an has essent nostro vocent. Melius numquam tacimates mea ea. Ubique semper cum no, eu regione officiis mel. Vix ex commodo aliquam eloquentiam, id sea clita consul, dolorum vivendo et eum. Sit ne timeam definitionem. Vel an elit summo elaboraret, cu sale primis patrioque usu, eos suas forensibus ut. Ea numquam deseruisse philosophia est, ut vis purto facete, sed an prima tractatos delicatissimi. Id has case ferri interpretaris, qui ne suas saepe tritani. At mea suavitate contentiones, ne nam alii corpora explicari, nec te oratio graece. Porro lobortis at eum, mei at laudem postulant, ad mel alii omnis concludaturque. Vide affert adolescens ad pri, mundi facilisis sea ei. Saepe forensibus adolescens ut vis, at eum utroque scaevola. Quo propriae vivendum ea, sea ludus platonem expetenda at. An ius numquam apeirian, vis graecis docendi in. Sed id velit possit. Te qui wisi mucius concludaturque. Minim repudiandae reprehendunt sed id. Labores consequat in pro, tacimates maiestatis moderatius no sea. Delenit fastidii referrentur in cum, ei paulo utinam vel. Solum detracto efficiendi eos te, mei ad malorum gloriatur. Efficiantur definitiones eu ius, lorem doctus corrumpit usu ad. Ne assum qualisque sea, sed eu maiorum facilisis referrentur. Vix ut erat affert. Liber dicunt consequuntur nec id, eu debet antiopam theophrastus sed. Vide euismod tibique sed ei, nam ne stet rebum volutpat. Ludus evertitur intellegebat eum ea, sed ad errem qualisque. Ea viris accusamus mel, usu elit quas fabulas ad. Cu deserunt oportere vix. Eu pro habemus intellegebat, offendit probatus eu ius, an ipsum interpretaris his. Graecis verterem at mei. Delicata persecuti ea nec. Partem vivendo deterruisset eos ex, usu ea veri dicta. In quo vitae periculis, in mea purto utamur, eos in numquam.";

			var items = TextToSpeech.SplitSpeak(lorem, 4000);

			Assert.Equal(2, items.Count);
		}
	}
}
