/*
 * Decompiled with CFR 0.152.
 */
package net.unladenswallow.minecraft.autofish;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.unladenswallow.minecraft.autofish.ModAutoFish;

public class AutoFishEventHandler {
    private long ticksInWater = 0L;
    private boolean caughtFish = false;
    private boolean fishing = false;
    private long castQueuedAt = -1L;
    private static final int QUEUE_TICK_LENGTH = 30;
    private static final int INWATER_DELAY_TICK_LENGTH = 100;
    private static final int AUTOFISH_BREAKPREVENT_THRESHOLD = 5;
    private static final double MOTION_Y_THRESHOLD = 0.02;

    @SubscribeEvent
    public void onClientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (!minecraft.func_147113_T() && minecraft.field_71439_g != null) {
            EntityPlayerSP player = minecraft.field_71439_g;
            if (ModAutoFish.config_autofish_enable) {
                if (ModAutoFish.config_autofish_multirod && this.fishing && this.castQueued() && !this.canCast((EntityPlayer)player)) {
                    this.switchRods((EntityPlayer)player);
                }
                if (this.canCast((EntityPlayer)player)) {
                    this.fishing = true;
                    if (player.field_71104_cf != null) {
                        if (!this.caughtFish && player.field_71104_cf.func_70090_H()) {
                            ++this.ticksInWater;
                            if (this.ticksInWater > 100L && Math.abs(player.field_71104_cf.field_70181_x) > 0.02) {
                                this.caughtFish = true;
                                minecraft.field_71442_b.func_78769_a((EntityPlayer)player, (World)minecraft.field_71441_e, player.func_70694_bm());
                                this.castQueuedAt = minecraft.field_71441_e.func_82737_E();
                            }
                        }
                    } else if (this.castQueued() && minecraft.field_71441_e.func_82737_E() > this.castQueuedAt + 30L) {
                        minecraft.field_71442_b.func_78769_a((EntityPlayer)player, (World)minecraft.field_71441_e, player.func_70694_bm());
                        this.castQueuedAt = -1L;
                    } else {
                        this.ticksInWater = 0L;
                        this.caughtFish = false;
                    }
                } else if (this.fishing) {
                    this.fishing = false;
                    this.ticksInWater = 0L;
                    this.caughtFish = false;
                    this.castQueuedAt = -1L;
                }
            }
        }
    }

    private boolean castQueued() {
        return this.castQueuedAt > 0L;
    }

    private void switchRods(EntityPlayer player) {
        InventoryPlayer inventory = player.field_71071_by;
        for (int i = 0; i < 9; ++i) {
            ItemStack curItemStack = inventory.field_70462_a[i];
            if (curItemStack == null || curItemStack.func_77973_b() != Items.field_151112_aM || ModAutoFish.config_autofish_preventBreak && curItemStack.func_77958_k() - curItemStack.func_77952_i() <= 5) continue;
            inventory.field_70461_c = i;
            break;
        }
    }

    private boolean canCast(EntityPlayer player) {
        ItemStack heldItem = player.func_70694_bm();
        if (heldItem == null || heldItem.func_77973_b() == Items.field_151112_aM) {
            // empty if block
        }
        return ModAutoFish.config_autofish_enable && heldItem != null && heldItem.func_77973_b() == Items.field_151112_aM && heldItem.func_77952_i() <= heldItem.func_77958_k() && (!ModAutoFish.config_autofish_preventBreak || heldItem.func_77958_k() - heldItem.func_77952_i() > 5);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.modID.equals("mod_autofish")) {
            ModAutoFish.syncConfig();
        }
    }
}

