/*
 * Decompiled with CFR 0.152.
 */
package net.unladenswallow.minecraft.autofish;

import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.unladenswallow.minecraft.autofish.AutoFishEventHandler;
import net.unladenswallow.minecraft.autofish.AutoFishLogger;
import net.unladenswallow.minecraft.autofish.CommonProxy;

@Mod(modid="mod_autofish", name="AutoFish Forge Mod", version="1.8-1.1", useMetadata=true, guiFactory="net.unladenswallow.minecraft.autofish.AutoFishGuiFactory", acceptedMinecraftVersions="[1.8]")
public class ModAutoFish {
    public static final String MODID = "mod_autofish";
    public static final String MODNAME = "AutoFish Forge Mod";
    public static final String VERSION = "1.8-1.1";
    public static Configuration configFile;
    public static boolean config_autofish_enable;
    public static final boolean CONFIG_DEFAULT_AUTOFISH_ENABLE = true;
    public static boolean config_autofish_multirod;
    public static final boolean CONFIG_DEFAULT_AUTOFISH_MULTIROD = false;
    public static boolean config_autofish_preventBreak;
    public static final boolean CONFIG_DEFAULT_AUTOFISH_PREVENTBREAK = false;
    @SidedProxy(clientSide="net.unladenswallow.minecraft.autofish.ClientProxy", serverSide="net.unladenswallow.minecraft.autofish.ServerProxy")
    public static CommonProxy proxy;
    public static AutoFishEventHandler eventHandler;
    public static ModAutoFish instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent preInitEvent) {
        proxy.preInit(preInitEvent);
        configFile = new Configuration(preInitEvent.getSuggestedConfigurationFile());
        ModAutoFish.syncConfig();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        AutoFishLogger.info("Initializing AutoFish Forge Mod", new Object[0]);
        proxy.init(event);
    }

    public static void syncConfig() {
        config_autofish_enable = configFile.getBoolean("Enable AutoFish", "general", true, "Automatically reel in and re-cast when a fish nibbles the hook.");
        config_autofish_multirod = configFile.getBoolean("Enable MultiRod", "general", false, "Automatically switch to a new fishing rod when the current rod breaks, if one is available in the hotbar.");
        config_autofish_preventBreak = configFile.getBoolean("Enable Break Protection", "general", false, "Stop fishing or switch to a new rod before the current rod breaks.");
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    static {
        eventHandler = new AutoFishEventHandler();
        instance = new ModAutoFish();
    }
}

