/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.camels.entity;

import com.talhanation.camels.LootTableHandler;
import com.talhanation.camels.entity.ai.AICamelCaravan;
import com.talhanation.camels.init.SoundInit;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCamel
extends EntityLlama {
    private static final DataParameter<Integer> DATA_STRENGTH_ID = EntityDataManager.func_187226_a(EntityLlama.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_COLOR_ID = EntityDataManager.func_187226_a(EntityLlama.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> DATA_VARIANT_ID = EntityDataManager.func_187226_a(EntityLlama.class, (DataSerializer)DataSerializers.field_187192_b);
    public int field_110278_bp;
    private int eatingCounter;
    @Nullable
    private EntityCamel caravanHead;
    @Nullable
    private EntityCamel caravanTail;

    public EntityCamel(World world) {
        super(world);
    }

    private void setStrength(int x) {
        this.field_70180_af.func_187227_b(DATA_STRENGTH_ID, (Object)Math.max(1, Math.min(5, x)));
    }

    private void setRandomStrength() {
        int x = this.field_70146_Z.nextFloat() < 0.04f ? 5 : 3;
        this.setStrength(4 + this.field_70146_Z.nextInt(x));
    }

    public int func_190707_dL() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_STRENGTH_ID);
    }

    public void func_70014_b(NBTTagCompound comnbt) {
        super.func_70014_b(comnbt);
        comnbt.func_74768_a("Variant", this.func_190719_dM());
        comnbt.func_74768_a("Strength", this.func_190707_dL());
        if (!this.field_110296_bG.func_70301_a(1).func_190926_b()) {
            comnbt.func_74782_a("DecorItem", (NBTBase)this.field_110296_bG.func_70301_a(1).func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound comnbt) {
        this.setStrength(comnbt.func_74762_e("Strength"));
        super.func_70037_a(comnbt);
        this.func_190710_o(comnbt.func_74762_e("Variant"));
        if (comnbt.func_150297_b("DecorItem", 10)) {
            this.field_110296_bG.func_70299_a(1, new ItemStack(comnbt.func_74775_l("DecorItem")));
        }
        this.func_110232_cE();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRunAroundLikeCrazy((AbstractHorse)this, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AICamelCaravan(this, 2.1f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_STRENGTH_ID, (Object)0);
        this.field_70180_af.func_187214_a(DATA_COLOR_ID, (Object)-1);
        this.field_70180_af.func_187214_a(DATA_VARIANT_ID, (Object)0);
    }

    public int func_190719_dM() {
        return MathHelper.func_76125_a((int)((Integer)this.field_70180_af.func_187225_a(DATA_VARIANT_ID)), (int)0, (int)3);
    }

    public void func_190710_o(int variant) {
        this.field_70180_af.func_187227_b(DATA_VARIANT_ID, (Object)variant);
    }

    protected int func_190686_di() {
        return this.func_190695_dh() ? 2 + 3 * this.func_190696_dl() : super.func_190686_di();
    }

    @Nullable
    public void func_184232_k(Entity entity) {
        if (this.func_184196_w(entity)) {
            float x = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float y = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float z = 0.3f;
            entity.func_70107_b(this.field_70165_t + (double)(0.3f * y), this.field_70163_u + this.func_70042_X() + entity.func_70033_W(), this.field_70161_v - (double)(0.3f * x));
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * 0.78;
    }

    public boolean func_82171_bF() {
        return true;
    }

    @Nullable
    protected boolean func_190678_b(EntityPlayer player, ItemStack stack) {
        boolean flag = false;
        float f = 0.0f;
        int i = 0;
        int j = 0;
        Item item = stack.func_77973_b();
        if (item == Items.field_151015_O) {
            f = 2.0f;
            i = 20;
            j = 3;
        } else if (item == Items.field_151102_aT) {
            f = 1.0f;
            i = 30;
            j = 3;
        } else if (item == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            f = 20.0f;
            i = 180;
        } else if (item == Items.field_151034_e) {
            f = 3.0f;
            i = 60;
            j = 3;
        } else if (item == Items.field_151150_bK) {
            f = 4.0f;
            i = 60;
            j = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        } else if (item == Items.field_151153_ao) {
            f = 10.0f;
            i = 240;
            j = 10;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                flag = true;
                this.func_146082_f(player);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && f > 0.0f) {
            this.func_70691_i(f);
            flag = true;
        }
        if (this.func_70631_g_() && i > 0) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0, new int[0]);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(i);
            }
            flag = true;
        }
        if (j > 0 && (flag || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            flag = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(j);
            }
        }
        if (flag && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_191253_dD, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
        return flag;
    }

    protected boolean func_70610_aX() {
        return this.func_110143_aJ() <= 0.0f || this.func_110204_cc();
    }

    public IEntityLivingData func_180482_a(DifficultyInstance diff, @Nullable IEntityLivingData entityLivingData) {
        int lvt_3_2_;
        IEntityLivingData data = super.func_180482_a(diff, entityLivingData);
        this.setRandomStrength();
        if (data instanceof GroupData) {
            lvt_3_2_ = ((GroupData)data).variant;
        } else {
            lvt_3_2_ = this.field_70146_Z.nextInt(4);
            data = new GroupData(lvt_3_2_);
        }
        this.func_190710_o(lvt_3_2_);
        return data;
    }

    protected SoundEvent func_184785_dv() {
        return SoundInit.ENTITY_CAMEL_ANGRY;
    }

    protected SoundEvent func_184639_G() {
        return SoundInit.ENTITY_CAMEL_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return SoundInit.ENTITY_CAMEL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundInit.ENTITY_CAMEL_DEATH;
    }

    protected void func_180429_a(BlockPos blockpos, Block blockState) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    protected void func_190697_dk() {
        this.func_184185_a(SoundEvents.field_191259_dX, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }

    public void func_190687_dF() {
        SoundEvent soundevent = this.func_184785_dv();
        if (soundevent != null) {
            this.func_184185_a(soundevent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableHandler.CAMEL;
    }

    public int func_190696_dl() {
        return this.func_190707_dL();
    }

    public boolean func_190677_dK() {
        return true;
    }

    public boolean func_190682_f(ItemStack itemStack) {
        return itemStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg);
    }

    public boolean func_190685_dA() {
        return true;
    }

    public void func_76316_a(IInventory inventory) {
        EnumDyeColor dye1 = this.func_190704_dO();
        super.func_76316_a(inventory);
        EnumDyeColor dye2 = this.func_190704_dO();
        if (this.field_70173_aa > 20 && dye2 != null && dye2 != dye1) {
            this.func_184185_a(SoundEvents.field_191257_dH, 0.5f, 1.0f);
        }
    }

    protected void func_110232_cE() {
        if (!this.field_70170_p.field_72995_K) {
            super.func_110232_cE();
            this.setColorByItem(this.field_110296_bG.func_70301_a(1));
        }
    }

    private void setColor(@Nullable EnumDyeColor dye) {
        this.field_70180_af.func_187227_b(DATA_COLOR_ID, (Object)(dye == null ? -1 : dye.func_176765_a()));
    }

    private void setColorByItem(ItemStack itemStack) {
        if (this.func_190682_f(itemStack)) {
            this.setColor(EnumDyeColor.func_176764_b((int)itemStack.func_77960_j()));
        } else {
            this.setColor(null);
        }
    }

    @Nullable
    public EnumDyeColor func_190704_dO() {
        int x = (Integer)this.field_70180_af.func_187225_a(DATA_COLOR_ID);
        return x == -1 ? null : EnumDyeColor.func_176764_b((int)x);
    }

    public int func_190676_dC() {
        return 60;
    }

    public boolean func_70878_b(EntityAnimal animal) {
        return animal != this && animal instanceof EntityCamel && this.func_110200_cJ() && ((EntityCamel)animal).func_110200_cJ();
    }

    public EntityCamel createChild(EntityAgeable ageable) {
        EntityCamel entity = new EntityCamel(this.field_70170_p);
        this.func_190681_a(ageable, (AbstractHorse)entity);
        EntityCamel entity1 = (EntityCamel)ageable;
        int i = this.field_70146_Z.nextInt(Math.max(this.func_190707_dL(), entity1.func_190707_dL())) + 1;
        if (this.field_70146_Z.nextFloat() < 0.03f) {
            ++i;
        }
        entity.setStrength(i);
        entity.func_190710_o(this.field_70146_Z.nextBoolean() ? this.func_190719_dM() : entity1.func_190719_dM());
        return entity;
    }

    public void func_180430_e(float x, float y) {
        int z = MathHelper.func_76123_f((float)((x * 0.5f - 3.0f) * y));
        if (z > 0) {
            if (x >= 6.0f) {
                this.func_70097_a(DamageSource.field_76379_h, z);
                if (this.func_184207_aI()) {
                    for (Entity lvt_5_1_ : this.func_184182_bu()) {
                        lvt_5_1_.func_70097_a(DamageSource.field_76379_h, (float)z);
                    }
                }
            }
            IBlockState blockState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block lvt_5_2_ = blockState.func_177230_c();
            if (blockState.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType lvt_6_1_ = lvt_5_2_.func_185467_w();
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, lvt_6_1_.func_185844_d(), this.func_184176_by(), lvt_6_1_.func_185843_a() * 0.5f, lvt_6_1_.func_185847_b() * 0.75f);
            }
        }
    }

    public void func_70659_e(float speed) {
        if (this.func_184207_aI()) {
            super.func_70659_e(speed * 1.0f);
        } else {
            super.func_70659_e(speed);
        }
    }

    public void func_190709_dP() {
        if (this.caravanHead != null) {
            this.caravanHead.caravanTail = null;
        }
        this.caravanHead = null;
    }

    public void joinCaravan(EntityCamel camel) {
        this.caravanHead = camel;
        this.caravanHead.caravanTail = this;
    }

    public boolean func_190712_dQ() {
        return this.caravanTail != null;
    }

    public boolean func_190718_dR() {
        return this.caravanHead != null;
    }

    @Nullable
    public EntityCamel getCaravanHead() {
        return this.caravanHead;
    }

    protected double func_190634_dg() {
        return 2.0;
    }

    protected void func_190679_dD() {
        if (!this.func_190718_dR() && this.func_70631_g_()) {
            super.func_190679_dD();
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190717_dN() {
        return this.func_190704_dO() != null;
    }

    static class GroupData
    implements IEntityLivingData {
        public int variant;

        private GroupData(int x) {
            this.variant = x;
        }
    }
}

