/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.capabilities.season.ISeasonInfo;
import org.orecruncher.dsurround.capabilities.season.SeasonInfo;
import org.orecruncher.lib.capability.CapabilityProviderSerializable;
import org.orecruncher.lib.capability.CapabilityUtils;
import org.orecruncher.lib.capability.NullStorage;

public class CapabilitySeasonInfo {
    @CapabilityInject(value=ISeasonInfo.class)
    public static final Capability<ISeasonInfo> SEASON_INFO = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "seasoninfo");

    @SideOnly(value=Side.CLIENT)
    public static void register() {
        CapabilityManager.INSTANCE.register(ISeasonInfo.class, (Capability.IStorage)new NullStorage(), SeasonInfo::new);
    }

    @SideOnly(value=Side.CLIENT)
    public static ISeasonInfo getCapability(@Nonnull World world) {
        return (ISeasonInfo)CapabilityUtils.getCapability((ICapabilityProvider)world, SEASON_INFO, null);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public static ICapabilityProvider createProvider(ISeasonInfo data) {
        return new CapabilityProviderSerializable(SEASON_INFO, null, (Object)data);
    }

    @Mod.EventBusSubscriber(modid="dsurround", value={Side.CLIENT})
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(@Nonnull AttachCapabilitiesEvent<World> event) {
            World world = (World)event.getObject();
            if (world != null && world.field_72995_K) {
                SeasonInfo info = SeasonInfo.factory(world);
                event.addCapability(CAPABILITY_ID, CapabilitySeasonInfo.createProvider(info));
            }
        }
    }
}

