/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.acoustics;

import com.google.common.base.Joiner;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.acoustics.EventType;
import org.orecruncher.dsurround.registry.acoustics.IAcoustic;
import org.orecruncher.dsurround.registry.acoustics.IOptions;
import org.orecruncher.dsurround.registry.acoustics.ISoundPlayer;

@SideOnly(value=Side.CLIENT)
public class SimultaneousAcoustic
implements IAcoustic {
    protected final IAcoustic[] acoustics;

    public SimultaneousAcoustic(@Nonnull Collection<IAcoustic> acoustics) {
        this.acoustics = acoustics.toArray(new IAcoustic[acoustics.size()]);
    }

    @Override
    @Nonnull
    public String getName() {
        return "Simultaneous Acoustic";
    }

    @Override
    public void playSound(@Nonnull ISoundPlayer player2, @Nonnull Vec3d location, @Nonnull EventType event, @Nullable IOptions inputOptions) {
        for (int i = 0; i < this.acoustics.length; ++i) {
            this.acoustics[i].playSound(player2, location, event, inputOptions);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getName()).append('[');
        builder.append(Joiner.on((char)',').join((Object[])this.acoustics));
        builder.append(']');
        return builder.toString();
    }
}

